/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0014\u0010\u0019\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0082\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lgit4idea/log/GitDirectoryVirtualFile;", "Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "repo", "Lgit4idea/repo/GitRepository;", "parent", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "<init>", "(Lgit4idea/repo/GitRepository;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/VcsCommitMetadata;)V", "isDirectory", "", "contentsToByteArray", "", "cachedChildren", "", "getCachedChildren", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "cachedChildren$delegate", "Lkotlin/Lazy;", "getChildren", "getLength", "", "equals", "other", "", "hashCode", "", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDirectoryVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDirectoryVirtualFile.kt\ngit4idea/log/GitDirectoryVirtualFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,56:1\n1586#2:57\n1661#2,3:58\n37#3,2:61\n*S KotlinDebug\n*F\n+ 1 GitDirectoryVirtualFile.kt\ngit4idea/log/GitDirectoryVirtualFile\n*L\n32#1:57\n32#1:58,3\n40#1:61,2\n*E\n"})
public final class GitDirectoryVirtualFile
extends AbstractVcsVirtualFile {
    @NotNull
    private final GitRepository repo;
    @NotNull
    private final VcsCommitMetadata commit;
    @NotNull
    private final Lazy cachedChildren$delegate;

    public GitDirectoryVirtualFile(@NotNull GitRepository repo, @Nullable VirtualFile parent, @NotNull FilePath filePath, @NotNull VcsCommitMetadata commit) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        super(parent, filePath);
        this.repo = repo;
        this.commit = commit;
        this.cachedChildren$delegate = LazyKt.lazy(() -> GitDirectoryVirtualFile.cachedChildren_delegate$lambda$0(this));
    }

    public boolean isDirectory() {
        return true;
    }

    @NotNull
    public byte[] contentsToByteArray() {
        throw new UnsupportedOperationException();
    }

    private final VirtualFile[] getCachedChildren() {
        Lazy lazy = this.cachedChildren$delegate;
        return (VirtualFile[])lazy.getValue();
    }

    @NotNull
    public VirtualFile[] getChildren() {
        return this.getCachedChildren();
    }

    public long getLength() {
        return 0L;
    }

    public boolean equals(@Nullable Object other) {
        GitDirectoryVirtualFile gitDirectoryVirtualFile = other instanceof GitDirectoryVirtualFile ? (GitDirectoryVirtualFile)((Object)other) : null;
        if (gitDirectoryVirtualFile == null) {
            return false;
        }
        GitDirectoryVirtualFile otherFile = gitDirectoryVirtualFile;
        return Intrinsics.areEqual((Object)this.repo, (Object)otherFile.repo) && Intrinsics.areEqual((Object)this.getPath(), (Object)otherFile.getPath()) && Intrinsics.areEqual((Object)this.commit.getId(), (Object)otherFile.commit.getId());
    }

    public int hashCode() {
        return this.repo.hashCode() * 31 * 31 + this.getPath().hashCode() * 31 + this.commit.getId().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile[] cachedChildren_delegate$lambda$0(GitDirectoryVirtualFile this$0) {
        void $this$mapTo$iv$iv;
        GitRevisionNumber gitRevisionNumber = new GitRevisionNumber(((Hash)this$0.commit.getId()).asString());
        String string = this$0.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String dirPath = ((CharSequence)string).length() == 0 ? "." : this$0.getPath() + "/";
        List<GitIndexUtil.StagedFileOrDirectory> list = GitIndexUtil.listTreeForRawPaths(this$0.repo, CollectionsKt.listOf((Object)dirPath), (VcsRevisionNumber)gitRevisionNumber);
        Intrinsics.checkNotNullExpressionValue(list, (String)"listTreeForRawPaths(...)");
        List<GitIndexUtil.StagedFileOrDirectory> tree = list;
        Iterable $this$map$iv = tree;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AbstractVcsVirtualFile abstractVcsVirtualFile;
            void it;
            GitIndexUtil.StagedFileOrDirectory stagedFileOrDirectory = (GitIndexUtil.StagedFileOrDirectory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it instanceof GitIndexUtil.StagedDirectory) {
                GitRepository gitRepository = this$0.repo;
                VirtualFile virtualFile = (VirtualFile)this$0;
                FilePath filePath = ((GitIndexUtil.StagedDirectory)it).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getPath(...)");
                abstractVcsVirtualFile = new GitDirectoryVirtualFile(gitRepository, virtualFile, filePath, this$0.commit);
            } else {
                abstractVcsVirtualFile = (AbstractVcsVirtualFile)new VcsVirtualFile((VirtualFile)this$0, it.getPath(), (VcsFileRevision)new GitFileRevision(this$0.repo.getProject(), this$0.repo.getRoot(), it.getPath(), gitRevisionNumber));
            }
            collection.add(abstractVcsVirtualFile);
        }
        List result2 = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new VirtualFile[0]);
    }
}

