/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.openapi.project.Project;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.terminal.completion.ShellRuntimeContextProvider;
import com.intellij.terminal.completion.spec.ShellRuntimeContext;
import com.intellij.terminal.frontend.view.completion.ShellCommandExecutorReworked;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellRuntimeContextExtensionsKt;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellDataGeneratorProcessExecutorImpl;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellFileSystemSupportImpl;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellRuntimeContextImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.session.impl.TerminalState;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/terminal/frontend/view/completion/ShellRuntimeContextProviderReworkedImpl;", "Lcom/intellij/terminal/completion/ShellRuntimeContextProvider;", "project", "Lcom/intellij/openapi/project/Project;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "envVariables", "", "", "eelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Ljava/util/Map;Lcom/intellij/platform/eel/EelDescriptor;)V", "generatorProcessExecutor", "Lorg/jetbrains/plugins/terminal/block/completion/spec/impl/ShellDataGeneratorProcessExecutorImpl;", "shellCommandExecutor", "Lcom/intellij/terminal/frontend/view/completion/ShellCommandExecutorReworked;", "fileSystemSupport", "Lorg/jetbrains/plugins/terminal/block/completion/spec/impl/ShellFileSystemSupportImpl;", "getContext", "Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;", "commandTokens", "", "intellij.terminal.frontend"})
public final class ShellRuntimeContextProviderReworkedImpl
implements ShellRuntimeContextProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final Map<String, String> envVariables;
    @NotNull
    private final EelDescriptor eelDescriptor;
    @NotNull
    private final ShellDataGeneratorProcessExecutorImpl generatorProcessExecutor;
    @NotNull
    private final ShellCommandExecutorReworked shellCommandExecutor;
    @NotNull
    private final ShellFileSystemSupportImpl fileSystemSupport;

    public ShellRuntimeContextProviderReworkedImpl(@NotNull Project project, @NotNull TerminalSessionModel sessionModel, @NotNull Map<String, String> envVariables, @NotNull EelDescriptor eelDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter(envVariables, (String)"envVariables");
        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
        this.project = project;
        this.sessionModel = sessionModel;
        this.envVariables = envVariables;
        this.eelDescriptor = eelDescriptor;
        this.generatorProcessExecutor = new ShellDataGeneratorProcessExecutorImpl(this.eelDescriptor, this.envVariables);
        this.shellCommandExecutor = new ShellCommandExecutorReworked(this.generatorProcessExecutor);
        this.fileSystemSupport = new ShellFileSystemSupportImpl(this.eelDescriptor);
    }

    @Override
    @NotNull
    public ShellRuntimeContext getContext(@NotNull List<String> commandTokens) {
        ShellRuntimeContextImpl shellRuntimeContextImpl;
        Intrinsics.checkNotNullParameter(commandTokens, (String)"commandTokens");
        String string = ((TerminalState)this.sessionModel.getTerminalState().getValue()).getCurrentDirectory();
        if (string == null) {
            throw new IllegalStateException("Current directory should be set at this moment".toString());
        }
        ShellRuntimeContextImpl $this$getContext_u24lambda_u240 = shellRuntimeContextImpl = new ShellRuntimeContextImpl(string, this.envVariables, commandTokens, null, this.shellCommandExecutor, this.generatorProcessExecutor, this.fileSystemSupport, null);
        boolean bl = false;
        $this$getContext_u24lambda_u240.putUserData(ShellRuntimeContextExtensionsKt.getPROJECT_KEY(), this.project);
        $this$getContext_u24lambda_u240.putUserData(ShellRuntimeContextExtensionsKt.getIS_REWORKED_KEY(), true);
        $this$getContext_u24lambda_u240.putUserData(ShellRuntimeContextExtensionsKt.getEEL_DESCRIPTOR_KEY(), this.eelDescriptor);
        return shellRuntimeContextImpl;
    }
}

