/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.logging.highlighting;

import com.intellij.analysis.customization.console.ClassFinderConsoleColorsPage;
import com.intellij.analysis.logging.resolve.LoggingArgumentSymbolReferenceProviderKt;
import com.intellij.codeInspection.logging.PlaceholderContext;
import com.intellij.codeInspection.logging.PlaceholderRanges;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/analysis/logging/highlighting/LoggingPlaceholderAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getRanges", "", "Lcom/intellij/openapi/util/TextRange;", "uExpression", "Lorg/jetbrains/uast/UExpression;", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nLoggingPlaceholderAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingPlaceholderAnnotator.kt\ncom/intellij/analysis/logging/highlighting/LoggingPlaceholderAnnotator\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n171#2:49\n1915#3,2:50\n1391#3:52\n1480#3,2:53\n1807#3,3:55\n1482#3,3:58\n*S KotlinDebug\n*F\n+ 1 LoggingPlaceholderAnnotator.kt\ncom/intellij/analysis/logging/highlighting/LoggingPlaceholderAnnotator\n*L\n19#1:49\n24#1:50,2\n40#1:52\n40#1:53,2\n42#1:55,3\n40#1:58,3\n*E\n"})
public final class LoggingPlaceholderAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiElement $this$toUElementOfType$iv = element;
        boolean $i$f$toUElementOfType = false;
        UInjectionHost uInjectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UInjectionHost.class);
        if (uInjectionHost == null) {
            return;
        }
        UInjectionHost literalExpression = uInjectionHost;
        List<TextRange> list = this.getRanges((UExpression)literalExpression);
        if (list == null) {
            return;
        }
        List<TextRange> textRangeList = list;
        int startOffset = element.getTextRange().getStartOffset();
        int endOffset = element.getTextRange().getEndOffset();
        Iterable $this$forEach$iv = textRangeList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextRange shiftedRange;
            boolean bl;
            TextRange range = (TextRange)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)range.shiftRight(startOffset), (String)"shiftRight(...)");
            boolean bl3 = bl = startOffset <= shiftedRange.getStartOffset() && shiftedRange.getEndOffset() <= endOffset;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(shiftedRange).textAttributes(ClassFinderConsoleColorsPage.LOG_STRING_PLACEHOLDER).create();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextRange> getRanges(UExpression uExpression) {
        void $this$flatMapTo$iv$iv;
        PlaceholderContext placeholderContext = LoggingArgumentSymbolReferenceProviderKt.getContext(uExpression);
        if (placeholderContext == null) {
            return null;
        }
        PlaceholderContext context = placeholderContext;
        List list = LoggingArgumentSymbolReferenceProviderKt.getPlaceholderRanges(context);
        if (list == null) {
            return null;
        }
        List placeholderRangesList = list;
        int placeholderParametersSize = context.getPlaceholderParameters().size();
        if (placeholderParametersSize < placeholderRangesList.size()) {
            placeholderRangesList = CollectionsKt.dropLast(placeholderRangesList, (int)(placeholderRangesList.size() - placeholderParametersSize));
        }
        Iterable $this$flatMap$iv = placeholderRangesList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            boolean bl;
            List<TextRange> ranges;
            block8: {
                PlaceholderRanges it = (PlaceholderRanges)element$iv$iv;
                boolean bl2 = false;
                ranges = it.getRanges();
                Iterable $this$any$iv = ranges;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TextRange range = (TextRange)element$iv;
                        boolean bl3 = false;
                        if (!(range == null)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
            Iterable list$iv$iv = CollectionsKt.filterNotNull((Iterable)ranges);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List textRangeList = (List)destination$iv$iv;
        return LoggingArgumentSymbolReferenceProviderKt.getAdjustedPlaceholderList(textRangeList, context);
    }
}

