/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExperimentsDialog
extends DialogWrapper {
    ExperimentsDialog(@Nullable Project project2) {
        super(project2);
        this.init();
        this.setTitle(IdeBundle.message((String)"dialog.title.experimental.features", (Object[])new Object[0]));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        ExperimentalFeature[] features = (ExperimentalFeature[])Experiments.EP_NAME.getExtensions();
        JBTable table2 = new JBTable(ExperimentsDialog.createModel(features));
        table2.setShowGrid(false);
        table2.getEmptyText().setText(IdeBundle.message((String)"empty.text.no.features.available", (Object[])new Object[0]));
        table2.getColumnModel().getColumn(0).setCellRenderer(ExperimentsDialog.getIdRenderer());
        table2.getColumnModel().getColumn(1).setCellRenderer(ExperimentsDialog.getValueRenderer());
        table2.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new BooleanTableCellEditor());
        table2.getSelectionModel().setSelectionMode(0);
        JTextArea myDescription = new JTextArea(4, 50);
        myDescription.setMargin((Insets)JBUI.insets((int)2));
        myDescription.setWrapStyleWord(true);
        myDescription.setLineWrap(true);
        myDescription.setEditable(false);
        table2.getSelectionModel().addListSelectionListener(e -> myDescription.setText(features[table2.getSelectedRow()].description));
        JScrollPane label2 = ScrollPaneFactory.createScrollPane((Component)myDescription);
        BorderLayoutPanel descriptionPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)label2).withBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"border.title.description", (Object[])new Object[0]), (boolean)false));
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)ScrollPaneFactory.createScrollPane((Component)table2)).addToBottom((Component)descriptionPanel);
        if (borderLayoutPanel == null) {
            ExperimentsDialog.$$$reportNull$$$0(0);
        }
        return borderLayoutPanel;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "ExperimentsDialog";
    }

    private static TableCellRenderer getValueRenderer() {
        return new BooleanTableCellRenderer(0);
    }

    private static TableCellRenderer getIdRenderer() {
        return new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value, boolean selected, boolean hasFocus, int row2, int column) {
                if (table2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.append(String.valueOf(value));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/application/ExperimentsDialog$1", "customizeCellRenderer"));
            }
        };
    }

    private static TableModel createModel(final ExperimentalFeature[] experimentalFeatures) {
        return new AbstractTableModel(){
            final ExperimentalFeature[] features;
            {
                this.features = experimentalFeatures;
            }

            @Override
            public int getRowCount() {
                return this.features.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String id2 = this.features[rowIndex].id;
                return switch (columnIndex) {
                    case 0 -> id2;
                    case 1 -> Experiments.getInstance().isFeatureEnabled(id2);
                    default -> throw new IllegalArgumentException("Wrong column number");
                };
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public String getColumnName(int column) {
                return switch (column) {
                    case 0 -> ApplicationBundle.message((String)"column.name", (Object[])new Object[0]);
                    case 1 -> IdeBundle.message((String)"column.enabled", (Object[])new Object[0]);
                    default -> throw new IllegalArgumentException("Wrong column number");
                };
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                if (value instanceof Boolean) {
                    Experiments.getInstance().setFeatureEnabled(this.features[rowIndex].id, ((Boolean)value).booleanValue());
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/ExperimentsDialog", "createCenterPanel"));
    }
}

