/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.diagnostic.PluginException;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.diagnostic.UntraceableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThrowableDescription {
    private static final String THIRD_PARTY = "third.party";
    @NotNull
    private final Throwable myThrowable;
    private final StackTraceElement @Nullable [] myStacktrace;

    public ThrowableDescription(@NotNull Throwable throwable) {
        if (throwable == null) {
            ThrowableDescription.$$$reportNull$$$0(0);
        }
        this.myThrowable = ThrowableDescription.getCause(throwable);
        this.myStacktrace = ThrowableDescription.getStacktrace(this.myThrowable);
    }

    private static StackTraceElement @Nullable [] getStacktrace(@NotNull Throwable throwable) {
        if (throwable == null) {
            ThrowableDescription.$$$reportNull$$$0(1);
        }
        return throwable instanceof UntraceableException ? null : throwable.getStackTrace();
    }

    @NotNull
    public Class<?> getThrowableClass() {
        Class<?> clazz = this.myThrowable.getClass();
        if (clazz == null) {
            ThrowableDescription.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    public int getSize() {
        if (this.myStacktrace == null) {
            return -1;
        }
        return this.myStacktrace.length;
    }

    @NotNull
    public List<String> getLastFrames(int frameCount) {
        if (this.myStacktrace == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                ThrowableDescription.$$$reportNull$$$0(3);
            }
            return list2;
        }
        int size2 = Math.min(this.myStacktrace.length, frameCount);
        ArrayList<String> result2 = new ArrayList<String>(size2);
        HashMap<String, PluginInfo> pluginInfoCache = new HashMap<String, PluginInfo>();
        for (int i2 = 0; i2 < size2; ++i2) {
            StackTraceElement element = this.myStacktrace[i2];
            PluginInfo pluginInfo = (PluginInfo)pluginInfoCache.get(element.getClassName());
            if (pluginInfo == null) {
                pluginInfo = PluginInfoDetectorKt.getPluginInfo((String)element.getClassName());
                pluginInfoCache.put(element.getClassName(), pluginInfo);
            }
            if (pluginInfo.isSafeToReport()) {
                result2.add(element.getClassName() + "." + element.getMethodName());
                continue;
            }
            result2.add(THIRD_PARTY);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ThrowableDescription.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static Throwable getCause(@NotNull Throwable throwable) {
        if (throwable == null) {
            ThrowableDescription.$$$reportNull$$$0(5);
        }
        boolean isPluginException = throwable instanceof PluginException && throwable.getCause() != null;
        Throwable throwable2 = isPluginException ? throwable.getCause() : throwable;
        if (throwable2 == null) {
            ThrowableDescription.$$$reportNull$$$0(6);
        }
        return throwable2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/fusCollectors/ThrowableDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/fusCollectors/ThrowableDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastFrames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStacktrace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCause";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

