/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ProjectColorStorage;
import com.intellij.ide.RecentProjectColorInfo;
import com.intellij.ide.RecentProjectMetaInfo;
import com.intellij.ide.RecentProjectsManagerBase;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR(\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/RecentProjectColorStorage;", "Lcom/intellij/ide/ProjectColorStorage;", "projectPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getProjectPath", "()Ljava/nio/file/Path;", "value", "", "customColor", "getCustomColor", "()Ljava/lang/String;", "setCustomColor", "(Ljava/lang/String;)V", "", "associatedIndex", "getAssociatedIndex", "()Ljava/lang/Integer;", "setAssociatedIndex", "(Ljava/lang/Integer;)V", "update", "", "block", "Lkotlin/Function1;", "Lcom/intellij/ide/RecentProjectColorInfo;", "getInfo", "recentProjectManager", "Lcom/intellij/ide/RecentProjectsManagerBase;", "intellij.platform.ide.impl"})
final class RecentProjectColorStorage
implements ProjectColorStorage {
    @NotNull
    private final Path projectPath;

    public RecentProjectColorStorage(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.projectPath = projectPath;
    }

    @Override
    @NotNull
    public Path getProjectPath() {
        return this.projectPath;
    }

    @Override
    @Nullable
    public String getCustomColor() {
        RecentProjectColorInfo recentProjectColorInfo = this.getInfo(RecentProjectsManagerBase.Companion.getInstanceEx());
        return recentProjectColorInfo != null ? recentProjectColorInfo.getCustomColor() : null;
    }

    @Override
    public void setCustomColor(@Nullable String value) {
        this.update((Function1<? super RecentProjectColorInfo, Unit>)((Function1)arg_0 -> RecentProjectColorStorage._set_customColor_$lambda$0(value, arg_0)));
    }

    @Override
    @Nullable
    public Integer getAssociatedIndex() {
        RecentProjectColorInfo recentProjectColorInfo = this.getInfo(RecentProjectsManagerBase.Companion.getInstanceEx());
        return recentProjectColorInfo != null ? Integer.valueOf(recentProjectColorInfo.getAssociatedIndex()) : null;
    }

    @Override
    public void setAssociatedIndex(@Nullable Integer value) {
        this.update((Function1<? super RecentProjectColorInfo, Unit>)((Function1)arg_0 -> RecentProjectColorStorage._set_associatedIndex_$lambda$0(value, arg_0)));
    }

    private final void update(Function1<? super RecentProjectColorInfo, Unit> block) {
        RecentProjectsManagerBase projectsManager = RecentProjectsManagerBase.Companion.getInstanceEx();
        RecentProjectColorInfo recentProjectColorInfo = this.getInfo(projectsManager);
        if (recentProjectColorInfo == null) {
            recentProjectColorInfo = new RecentProjectColorInfo();
        }
        RecentProjectColorInfo info = recentProjectColorInfo;
        block.invoke((Object)info);
        projectsManager.updateProjectColor(PathsKt.getInvariantSeparatorsPathString((Path)this.getProjectPath()), info);
    }

    private final RecentProjectColorInfo getInfo(RecentProjectsManagerBase recentProjectManager) {
        RecentProjectMetaInfo recentProjectMetaInfo = recentProjectManager.getProjectMetaInfo(this.getProjectPath());
        return recentProjectMetaInfo != null ? recentProjectMetaInfo.getColorInfo() : null;
    }

    private static final Unit _set_customColor_$lambda$0(String $value, RecentProjectColorInfo info) {
        Intrinsics.checkNotNullParameter((Object)((Object)info), (String)"info");
        info.setCustomColor($value);
        return Unit.INSTANCE;
    }

    private static final Unit _set_associatedIndex_$lambda$0(Integer $value, RecentProjectColorInfo info) {
        Intrinsics.checkNotNullParameter((Object)((Object)info), (String)"info");
        Integer n = $value;
        info.setAssociatedIndex(n != null ? n : -1);
        return Unit.INSTANCE;
    }
}

