/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.toolWindow.ToolWindowDefaultLayoutManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/actions/DeleteNamedLayoutAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "layoutName", "", "<init>", "(Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public abstract class DeleteNamedLayoutAction
extends DumbAwareAction {
    @NotNull
    private final String layoutName;

    public DeleteNamedLayoutAction(@NlsSafe @NotNull String layoutName) {
        Intrinsics.checkNotNullParameter((Object)layoutName, (String)"layoutName");
        this.layoutName = layoutName;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        String string = IdeBundle.message((String)"title.delete", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{this.layoutName};
        String string2 = IdeBundle.message((String)"dialog.delete.window.layout.prompt", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        OkCancelDialogBuilder okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(string, string2);
        String string3 = IdeBundle.message((String)"button.delete", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        if (!((OkCancelDialogBuilder)okCancelDialogBuilder.yesText(string3)).ask(project3)) {
            return;
        }
        ToolWindowDefaultLayoutManager.Companion.getInstance().deleteLayout(this.layoutName);
    }

    public void update(@NotNull AnActionEvent e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean activeLayout = Intrinsics.areEqual((Object)this.layoutName, (Object)ToolWindowDefaultLayoutManager.Companion.getInstance().getActiveLayoutName());
        e.getPresentation().setEnabled(e.getProject() != null && !activeLayout);
        Presentation presentation2 = e.getPresentation();
        if (activeLayout) {
            Object[] objectArray = new Object[]{this.layoutName};
            string = ActionsBundle.message((String)"action.DeleteNamedLayout.current.description", (Object[])objectArray);
        } else {
            Object[] objectArray = new Object[]{this.layoutName};
            string = ActionsBundle.message((String)"action.DeleteNamedLayout.description", (Object[])objectArray);
        }
        presentation2.setDescription(string);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

