/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UndoAffectedDocuments {
    @NotNull
    private final @NotNull Collection<@NotNull DocumentReference> affected = new HashSet<DocumentReference>(1);

    UndoAffectedDocuments() {
    }

    boolean affects(@NotNull DocumentReference ref2) {
        if (ref2 == null) {
            UndoAffectedDocuments.$$$reportNull$$$0(0);
        }
        return this.affected.contains(ref2);
    }

    boolean affectsOnlyPhysical() {
        if (this.affected.isEmpty()) {
            return false;
        }
        for (DocumentReference ref2 : this.affected) {
            if (!UndoAffectedDocuments.isVirtualDocumentChange(ref2.getFile())) continue;
            return false;
        }
        return true;
    }

    boolean affectsMultiplePhysical() {
        HashSet<VirtualFile> affectedFiles = new HashSet<VirtualFile>(2);
        for (DocumentReference doc : this.affected) {
            VirtualFile file2 = doc.getFile();
            if (UndoAffectedDocuments.isVirtualDocumentChange(file2)) continue;
            affectedFiles.add(file2);
            if (affectedFiles.size() <= 1) continue;
            return true;
        }
        return false;
    }

    @Nullable
    DocumentReference firstAffected() {
        if (this.affected.isEmpty()) {
            return null;
        }
        return this.affected.iterator().next();
    }

    int size() {
        return this.affected.size();
    }

    void addAffected(DocumentReference ... refs) {
        if (refs != null) {
            for (DocumentReference ref2 : refs) {
                if (ref2 == null) continue;
                this.affected.add(ref2);
            }
        }
    }

    void addAffected(Document ... docs) {
        if (docs == null) {
            UndoAffectedDocuments.$$$reportNull$$$0(1);
        }
        DocumentReference[] refs = (DocumentReference[])Arrays.stream(docs).filter(doc -> {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(doc);
            return file2 == null || file2.isValid();
        }).map(doc -> DocumentReferenceManager.getInstance().create(doc)).toArray(DocumentReference[]::new);
        this.addAffected(refs);
    }

    void addAffected(VirtualFile ... files2) {
        if (files2 == null) {
            UndoAffectedDocuments.$$$reportNull$$$0(2);
        }
        DocumentReference[] refs = (DocumentReference[])Arrays.stream(files2).map(doc -> DocumentReferenceManager.getInstance().create(doc)).toArray(DocumentReference[]::new);
        this.addAffected(refs);
    }

    void addAffected(@NotNull UndoAffectedDocuments undoAffectedDocuments) {
        if (undoAffectedDocuments == null) {
            UndoAffectedDocuments.$$$reportNull$$$0(3);
        }
        this.affected.addAll(undoAffectedDocuments.affected);
    }

    void removeAffected(@NotNull DocumentReference ref2) {
        if (ref2 == null) {
            UndoAffectedDocuments.$$$reportNull$$$0(4);
        }
        this.affected.remove(ref2);
    }

    @NotNull
    Collection<DocumentReference> asCollection() {
        Collection<DocumentReference> collection = Collections.unmodifiableCollection(this.affected);
        if (collection == null) {
            UndoAffectedDocuments.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndoAffectedDocuments)) {
            return false;
        }
        UndoAffectedDocuments documents = (UndoAffectedDocuments)object;
        return this.affected.equals(documents.affected);
    }

    public int hashCode() {
        return this.affected.hashCode();
    }

    private static boolean isVirtualDocumentChange(@Nullable VirtualFile file2) {
        return file2 == null || file2 instanceof LightVirtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoAffectedDocuments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoAffectedDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoAffectedDocuments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "affects";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAffected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeAffected";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

