/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl.cmd;

import com.intellij.openapi.command.impl.CommandId;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CmdHistory {
    private static final int HISTORY_SIZE = 10;
    @NotNull
    private final @NotNull ArrayDeque<@NotNull CommandId> history = new ArrayDeque(10);

    CmdHistory() {
    }

    void add(@NotNull CommandId commandId) {
        if (commandId == null) {
            CmdHistory.$$$reportNull$$$0(0);
        }
        this.history.add(commandId);
        if (this.history.size() > 10) {
            this.history.removeFirst();
        }
    }

    @Nullable
    CommandId getCurrentCommandId() {
        return this.history.peekLast();
    }

    @Nullable
    CommandId getPreviousCommandId() {
        if (this.history.size() > 1) {
            Iterator<CommandId> iterator2 = this.history.descendingIterator();
            iterator2.next();
            return iterator2.next();
        }
        return null;
    }

    public String toString() {
        String historyStr = this.history.stream().map(Objects::toString).collect(Collectors.joining(", "));
        return "CommandHistory{" + historyStr + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandId", "com/intellij/openapi/command/impl/cmd/CmdHistory", "add"));
    }
}

