/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public final class DeleteAction
extends EditorAction {
    public DeleteAction() {
        super((EditorActionHandler)new Handler());
    }

    private static int getCaretLineLength(Editor editor2) {
        Document document2 = editor2.getDocument();
        if (document2.getLineCount() == 0) {
            return 0;
        }
        int lineNumber = editor2.getCaretModel().getLogicalPosition().line;
        if (lineNumber >= document2.getLineCount()) {
            return 0;
        }
        return document2.getLineEndOffset(lineNumber) - document2.getLineStartOffset(lineNumber);
    }

    private static int getCaretLineStart(Editor editor2) {
        Document document2 = editor2.getDocument();
        if (document2.getLineCount() == 0) {
            return 0;
        }
        int lineNumber = editor2.getCaretModel().getLogicalPosition().line;
        if (lineNumber >= document2.getLineCount()) {
            return document2.getLineStartOffset(document2.getLineCount() - 1);
        }
        return document2.getLineStartOffset(lineNumber);
    }

    public static void deleteCharAtCaret(Editor editor2) {
        int lineNumber = editor2.getCaretModel().getLogicalPosition().line;
        int afterLineEnd = EditorModificationUtil.calcAfterLineEnd((Editor)editor2);
        Document document2 = editor2.getDocument();
        int offset = editor2.getCaretModel().getOffset();
        if (afterLineEnd < 0 || offset < document2.getTextLength() - 1 && editor2.getSoftWrapModel().getSoftWrap(offset) != null) {
            FoldRegion region = editor2.getFoldingModel().getCollapsedRegionAtOffset(offset);
            if (region != null && region.shouldNeverExpand()) {
                document2.deleteString(region.getStartOffset(), region.getEndOffset());
                editor2.getCaretModel().moveToOffset(region.getStartOffset());
            } else {
                document2.deleteString(offset, DocumentUtil.getNextCodePointOffset((Document)document2, (int)offset));
            }
            return;
        }
        if (lineNumber + 1 >= document2.getLineCount()) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.setCurrentCommandGroupId(null);
        int nextLineStart = document2.getLineStartOffset(lineNumber + 1);
        int nextLineEnd = document2.getLineEndOffset(lineNumber + 1);
        if (nextLineEnd - nextLineStart > 0) {
            StringBuilder buf = new StringBuilder();
            StringUtil.repeatSymbol((Appendable)buf, (char)' ', (int)afterLineEnd);
            document2.insertString(DeleteAction.getCaretLineStart(editor2) + DeleteAction.getCaretLineLength(editor2), (CharSequence)buf.toString());
            nextLineStart = document2.getLineStartOffset(lineNumber + 1);
        }
        int thisLineEnd = document2.getLineEndOffset(lineNumber);
        document2.deleteString(thisLineEnd, nextLineStart);
    }

    public static final class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            EditorUIUtil.hideCursorInEditor(editor2);
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            CopyPasteManager.getInstance().stopKillRings();
            if (editor2.getInlayModel().hasInlineElementAt(editor2.getCaretModel().getVisualPosition())) {
                editor2.getCaretModel().moveCaretRelatively(1, 0, false, false, EditorUtil.isCurrentCaretPrimary(editor2));
            } else {
                DeleteAction.deleteCharAtCaret(editor2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/DeleteAction$Handler";
            objectArray[2] = "executeWriteAction";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

