/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.CutProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.actions.UndoRedoAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorPreciseContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.CaretStop;
import com.intellij.openapi.editor.actions.CaretStopOptions;
import com.intellij.openapi.editor.actions.CaretStopPolicy;
import com.intellij.openapi.editor.actions.ChangeEditorFontSizeStrategy;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorAccessibilityCaret;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.EditorsSplittersKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.Grayer;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.accessibility.AccessibleContextDelegateWithContextMenu;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.im.InputMethodRequests;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.View;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DirtyUI
public final class EditorComponentImpl
extends JTextComponent
implements Scrollable,
UiCompatibleDataProvider,
Queryable,
TypingTarget,
Accessible,
UISettingsListener,
UiInspectorPreciseContextProvider {
    private static final Logger LOG = Logger.getInstance(EditorComponentImpl.class);
    private final EditorImpl editor;
    @Nullable
    private Runnable myRepaintCallback;
    private EditorSwingCaretUpdatesCourier myEditorSwingCaretUpdatesCourier;

    public EditorComponentImpl(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            EditorComponentImpl.$$$reportNull$$$0(0);
        }
        this.myEditorSwingCaretUpdatesCourier = null;
        this.editor = editor2;
        this.enableEvents(2056L);
        this.enableInputMethods(true);
        this.setFocusCycleRoot(!ScreenReader.isActive());
        if (ScreenReader.isActive()) {
            this.setFocusable(true);
        }
        this.setOpaque(true);
        this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, new Magnificator(){

            public Point magnify(double scale, Point at) {
                if (EditorComponentImpl.this.editor.isDisposed()) {
                    return at;
                }
                VisualPosition magnificationPosition = EditorComponentImpl.this.editor.xyToVisualPosition(at);
                float currentSize = EditorComponentImpl.this.editor.getColorsScheme().getEditorFontSize2D();
                boolean isChangePersistent = EditorSettingsExternalizable.getInstance().isWheelFontChangePersistent();
                float defaultFontSize = isChangePersistent ? (float)UISettings.getInstance().getFontSize() : EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize2D();
                float size2 = Math.max((float)((double)currentSize * scale), defaultFontSize);
                ChangeEditorFontSizeStrategy strategy = (ChangeEditorFontSizeStrategy)EditorComponentImpl.this.editor.getUserData(ChangeEditorFontSizeStrategy.KEY);
                if (strategy != null) {
                    strategy.setFontSize(size2);
                    Point zoomPoint = strategy.preferredZoomPointRelative(EditorComponentImpl.this.editor);
                    Rectangle area = EditorComponentImpl.this.editor.getScrollingModel().getVisibleArea();
                    return new Point(area.x + zoomPoint.x, area.y + zoomPoint.y);
                }
                EditorComponentImpl.this.editor.setFontSize(size2);
                if (isChangePersistent) {
                    ApplicationManager.getApplication().invokeLater(() -> EditorComponentImpl.this.editor.adjustGlobalFontSize(UISettingsUtils.scaleFontSize((float)size2, (float)(1.0f / UISettingsUtils.getInstance().getCurrentIdeScale()))), ModalityState.stateForComponent((Component)EditorComponentImpl.this));
                }
                return EditorComponentImpl.this.editor.visualPositionToXY(magnificationPosition);
            }
        });
        this.putClientProperty(UndoRedoAction.IGNORE_SWING_UNDO_MANAGER, Boolean.TRUE);
        this.setupJTextComponentContext();
        for (MouseListener mouseListener2 : this.getMouseListeners()) {
            this.removeMouseListener(mouseListener2);
        }
        for (EventListener eventListener : this.getFocusListeners()) {
            this.removeFocusListener((FocusListener)eventListener);
        }
        this.setupEditorSwingCaretUpdatesCourierIfRequired();
    }

    void setRepaintCallback(@Nullable Runnable repaintCallback) {
        this.myRepaintCallback = repaintCallback;
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            EditorComponentImpl.$$$reportNull$$$0(1);
        }
        UISettingsUtils settingsUtils = UISettingsUtils.with((UISettings)uiSettings);
        if (uiSettings.getPresentationMode() && (float)this.editor.getFontSize() != settingsUtils.getPresentationModeFontSize()) {
            this.editor.setFontSize(settingsUtils.getPresentationModeFontSize());
        }
    }

    @Override
    @DirtyUI
    public void paint(@NotNull Graphics g) {
        if (g == null) {
            EditorComponentImpl.$$$reportNull$$$0(2);
        }
        if (!this.isEnabled()) {
            g = new Grayer((Graphics2D)g, this.getBackground());
        }
        super.paint(g);
    }

    @NotNull
    public EditorImpl getEditor() {
        EditorImpl editorImpl = this.editor;
        if (editorImpl == null) {
            EditorComponentImpl.$$$reportNull$$$0(3);
        }
        return editorImpl;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            EditorComponentImpl.$$$reportNull$$$0(4);
        }
        if (this.editor.isDisposed()) {
            return;
        }
        if (this.editor.isRendererMode()) {
            return;
        }
        sink.set(CommonDataKeys.EDITOR, (Object)this.editor);
        sink.set(CommonDataKeys.CARET, (Object)this.editor.getCaretModel().getCurrentCaret());
        LogicalPosition location = this.editor.myLastMousePressedLocation;
        if (location == null) {
            location = this.editor.getCaretModel().getLogicalPosition();
        }
        sink.set(CommonDataKeys.EDITOR_VIRTUAL_SPACE, (Object)EditorCoreUtil.inVirtualSpace((Editor)this.editor, (LogicalPosition)location));
    }

    @Override
    @DirtyUI
    public Color getBackground() {
        return this.editor.getBackgroundColor();
    }

    @Override
    @DirtyUI
    public Dimension getPreferredSize() {
        return this.editor.getPreferredSize();
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.editor.myCursorSetExternally = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mouse cursor set to " + String.valueOf(cursor) + " in " + String.valueOf(this.editor), new Throwable());
        }
    }

    void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        if (EditorImpl.EVENT_LOG.isDebugEnabled()) {
            EditorImpl.EVENT_LOG.debug(e.toString());
        }
        WriteIntentReadAction.run(() -> {
            if (!e.isConsumed() && !this.editor.isDisposed()) {
                InputMethodListener listener2 = this.editor.getInputMethodSupport().getListener();
                switch (e.getID()) {
                    case 1100: {
                        listener2.inputMethodTextChanged(e);
                        break;
                    }
                    case 1101: {
                        listener2.caretPositionChanged(e);
                    }
                }
            }
        });
        super.processInputMethodEvent(e);
    }

    @Override
    public boolean isEditable() {
        return !this.editor.isViewer();
    }

    public ActionCallback type(String text2) {
        ActionCallback result2 = new ActionCallback();
        EdtInvocationManager.invokeLaterIfNeeded(() -> WriteIntentReadAction.run(() -> this.editor.type(text2).notify(result2)));
        return result2;
    }

    @Override
    @Nullable
    public InputMethodRequests getInputMethodRequests() {
        return IdeEventQueue.getInstance().isInputMethodEnabled() ? this.editor.getInputMethodSupport().getInputMethodRequestsSwingWrapper() : null;
    }

    @Override
    @DirtyUI
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @Override
    @DirtyUI
    public void paintComponent(Graphics g) {
        Project project2;
        this.editor.measureTypingLatency();
        Graphics2D gg = (Graphics2D)g;
        if (this.editor.useEditorAntialiasing()) {
            EditorUIUtil.setupAntialiasing(gg);
        } else {
            UISettings.setupAntialiasing((Graphics)gg);
        }
        gg.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, UISettings.getEditorFractionalMetricsHint());
        AffineTransform origTx = PaintUtil.alignTxToInt((Graphics2D)gg, (Point2D)PaintUtil.insets2offset((Insets)this.getInsets()), (boolean)true, (boolean)false, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
        this.editor.paint(gg);
        if (origTx != null) {
            gg.setTransform(origTx);
        }
        if ((project2 = this.editor.getProject()) != null) {
            EditorsSplittersKt.stopOpenFilesActivity(project2);
        }
    }

    public void repaintEditorComponent(int x, int y, int width, int height) {
        int topOverhang = Math.max(0, this.editor.myView.getTopOverhang());
        int bottomOverhang = Math.max(0, this.editor.myView.getBottomOverhang());
        this.repaint(x, y - topOverhang, width, height + topOverhang + bottomOverhang);
        if (this.myRepaintCallback != null && this.isShowing() && width > 0 && height > 0) {
            this.myRepaintCallback.run();
        }
    }

    @Override
    @DirtyUI
    public Dimension getPreferredScrollableViewportSize() {
        return this.editor.getPreferredSize();
    }

    @Override
    @DirtyUI
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (Integer)EditorThreading.compute(() -> {
            if (orientation == 1) {
                return this.editor.getLineHeight();
            }
            return EditorUtil.getSpaceWidth(0, this.editor);
        });
    }

    @Override
    @DirtyUI
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int lineHeight = this.editor.getLineHeight();
            if (direction > 0) {
                int lineNumber = (visibleRect.y + visibleRect.height) / lineHeight;
                return lineHeight * lineNumber - visibleRect.y;
            }
            int lineNumber = (visibleRect.y - visibleRect.height) / lineHeight;
            return visibleRect.y - lineHeight * lineNumber;
        }
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && this.getParent().getWidth() > this.getPreferredSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }

    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            EditorComponentImpl.$$$reportNull$$$0(5);
        }
        this.editor.putInfo(info);
    }

    @Override
    @NonNls
    public String toString() {
        return "EditorComponent file=" + String.valueOf(this.editor.getVirtualFile());
    }

    @RequiresEdt
    private boolean setupEditorSwingCaretUpdatesCourierIfRequired() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myEditorSwingCaretUpdatesCourier != null || this.editor == null || this.editor.isDisposed()) {
            return false;
        }
        if (ArrayUtil.isEmpty((Object[])this.getCaretListeners())) {
            return false;
        }
        this.myEditorSwingCaretUpdatesCourier = EditorSwingCaretUpdatesCourier.create(this);
        return true;
    }

    @Override
    public void addCaretListener(CaretListener listener2) {
        super.addCaretListener(listener2);
        this.setupEditorSwingCaretUpdatesCourierIfRequired();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new EditorAccessibleContextDelegate();
        }
        return this.accessibleContext;
    }

    private void setupJTextComponentContext() {
        this.setDocument(new EditorAccessibilityDocument());
        this.setCaret(new EditorAccessibilityCaret(this.editor));
    }

    @Override
    @Deprecated
    public javax.swing.text.Document getDocument() {
        return super.getDocument();
    }

    @Override
    public int getCaretPosition() {
        return (Integer)EditorThreading.compute(() -> this.editor.getCaretModel().getOffset());
    }

    @Override
    @DirtyUI
    public void updateUI() {
        EditorThreading.run(() -> {
            this.setUI(new EditorAccessibilityTextUI());
            UISettings.setupEditorAntialiasing((JComponent)this);
            this.putClientProperty(RenderingHints.KEY_FRACTIONALMETRICS, UISettings.getEditorFractionalMetricsHint());
            this.invalidate();
        });
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText();
    }

    private void fireJTextComponentDocumentChange(final com.intellij.openapi.editor.event.DocumentEvent event) {
        List<javax.swing.event.DocumentListener> listeners = ((EditorAccessibilityDocument)this.getDocument()).getListeners();
        if (listeners == null) {
            return;
        }
        DocumentEvent swingEvent = new DocumentEvent(){

            @Override
            public int getOffset() {
                return event.getOffset();
            }

            @Override
            public int getLength() {
                return event.getNewLength();
            }

            @Override
            public javax.swing.text.Document getDocument() {
                return EditorComponentImpl.this.getDocument();
            }

            @Override
            public DocumentEvent.EventType getType() {
                return event.getOldLength() == 0 ? DocumentEvent.EventType.INSERT : (event.getNewLength() == 0 ? DocumentEvent.EventType.REMOVE : DocumentEvent.EventType.CHANGE);
            }

            @Override
            @Nullable
            public DocumentEvent.ElementChange getChange(Element element) {
                return null;
            }
        };
        for (javax.swing.event.DocumentListener listener2 : listeners) {
            DocumentEvent.EventType type = swingEvent.getType();
            if (type == DocumentEvent.EventType.INSERT) {
                listener2.insertUpdate(swingEvent);
                continue;
            }
            if (type == DocumentEvent.EventType.REMOVE) {
                listener2.removeUpdate(swingEvent);
                continue;
            }
            if (type != DocumentEvent.EventType.CHANGE) continue;
            listener2.changedUpdate(swingEvent);
        }
    }

    private static void notSupported() {
        throw new RuntimeException("Not supported for this text implementation");
    }

    @Override
    public String getSelectedText() {
        return this.editor.getSelectionModel().getSelectedText(true);
    }

    @Override
    public void select(int startOffset, int endOffset) {
        int caretEnd;
        int caretStart;
        String selectedText = this.editor.getDocument().getText(new TextRange(startOffset, endOffset));
        int length = endOffset - startOffset;
        int offsetRelativeToCurrentCaret = startOffset - this.editor.getCaretModel().getCurrentCaret().getOffset();
        boolean allCaretsHaveTheSameText = true;
        for (Caret caret : this.editor.getCaretModel().getAllCarets()) {
            caretStart = offsetRelativeToCurrentCaret + caret.getOffset();
            caretEnd = caretStart + length;
            String caretText = this.editor.getDocument().getText(new TextRange(caretStart, caretEnd));
            if (selectedText.equals(caretText)) continue;
            allCaretsHaveTheSameText = false;
            break;
        }
        if (allCaretsHaveTheSameText) {
            for (Caret caret : this.editor.getCaretModel().getAllCarets()) {
                caretStart = offsetRelativeToCurrentCaret + caret.getOffset();
                caretEnd = caretStart + length;
                caret.setSelection(caretStart, caretEnd);
            }
        } else {
            this.editor.getSelectionModel().setSelection(startOffset, endOffset);
        }
    }

    @Override
    @DirtyUI
    public void setText(String text2) {
        this.editDocumentSafely(0, this.editor.getDocument().getTextLength(), text2);
    }

    private void editDocumentSafely(int offset, int length, @Nullable String text2) {
        DocumentEx document2 = this.editor.getDocument();
        RangeMarker marker = document2.createRangeMarker(offset, offset + length);
        TransactionGuard.submitTransaction((Disposable)this.editor.getDisposable(), () -> this.lambda$editDocumentSafely$8(marker, (Document)document2, text2));
    }

    @Nullable
    public UiInspectorPreciseContextProvider.UiInspectorInfo getUiInspectorContext(@NotNull MouseEvent event) {
        if (event == null) {
            EditorComponentImpl.$$$reportNull$$$0(6);
        }
        Point point = event.getPoint();
        Inlay<?> inlay = this.editor.getInlayModel().getElementAt(point);
        if (inlay != null) {
            ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
            result2.add(new PropertyBean("Inlay Renderer", (Object)inlay.getRenderer(), true));
            result2.add(new PropertyBean("Inlay Renderer Class", (Object)UiInspectorUtil.getClassPresentation((Object)inlay.getRenderer()), true));
            if (inlay.getGutterIconRenderer() != null) {
                result2.add(new PropertyBean("Inlay Gutter Renderer", (Object)inlay.getGutterIconRenderer(), true));
            }
            result2.add(new PropertyBean("Inlay Properties", (Object)inlay.getProperties()));
            return new UiInspectorPreciseContextProvider.UiInspectorInfo("EditorInlay", result2, null);
        }
        return null;
    }

    private /* synthetic */ void lambda$editDocumentSafely$8(RangeMarker marker, Document document2, String text2) {
        Project project2 = this.editor.getProject();
        if (!marker.isValid() || !FileDocumentManager.getInstance().requestWriting(document2, project2)) {
            marker.dispose();
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> WriteAction.run(() -> {
            document2.startGuardedBlockChecking();
            try {
                document2.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)StringUtil.notNullize((String)text2));
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document2).handle(e);
            }
            finally {
                document2.stopGuardedBlockChecking();
                marker.dispose();
            }
        }), "", (Object)document2, UndoConfirmationPolicy.DEFAULT, document2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorComponentImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorComponentImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUiInspectorContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private final class EditorSwingCaretUpdatesCourier
    implements com.intellij.openapi.editor.event.CaretListener,
    CaretActionListener,
    BulkAwareDocumentListener.Simple {
        private boolean isInsideCaretsAction;
        private boolean isInsideBulkDocumentUpdate;
        @NotNull
        private WeakReference<Caret> myLastKnownPrimaryCaret;
        private int myPrimaryCaretLastKnownDot;
        private int myPrimaryCaretLastKnownMark;

        @RequiresEdt
        @Nullable
        private static EditorSwingCaretUpdatesCourier create(@NotNull EditorComponentImpl parent) {
            if (parent == null) {
                EditorSwingCaretUpdatesCourier.$$$reportNull$$$0(0);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (parent.editor == null || parent.editor.isDisposed()) {
                return null;
            }
            return parent.new EditorSwingCaretUpdatesCourier();
        }

        @RequiresEdt
        private EditorSwingCaretUpdatesCourier() {
            ThreadingAssertions.assertEventDispatchThread();
            this.isInsideCaretsAction = false;
            this.isInsideBulkDocumentUpdate = false;
            assert (EditorComponentImpl.this.editor != null);
            assert (!EditorComponentImpl.this.editor.isDisposed());
            CaretModelImpl caretModel = EditorComponentImpl.this.editor.getCaretModel();
            CaretImpl primaryCaret = caretModel.getPrimaryCaret();
            this.myLastKnownPrimaryCaret = new WeakReference<CaretImpl>(primaryCaret);
            EditorThreading.run(() -> {
                this.myPrimaryCaretLastKnownDot = primaryCaret.getOffset();
                this.myPrimaryCaretLastKnownMark = primaryCaret.getLeadSelectionOffset();
            });
            caretModel.addCaretActionListener(this, EditorComponentImpl.this.editor.getDisposable());
            caretModel.addCaretListener(this, EditorComponentImpl.this.editor.getDisposable());
            EditorComponentImpl.this.editor.getDocument().addDocumentListener((DocumentListener)this, EditorComponentImpl.this.editor.getDisposable());
        }

        @RequiresEdt
        public void beforeAllCaretsAction() {
            ThreadingAssertions.assertEventDispatchThread();
            this.isInsideCaretsAction = true;
        }

        @RequiresEdt
        public void afterAllCaretsAction() {
            ThreadingAssertions.assertEventDispatchThread();
            this.isInsideCaretsAction = false;
            if (this.isInsideBulkUpdate()) {
                return;
            }
            CaretImpl currentPrimaryCaret = EditorComponentImpl.this.editor.getCaretModel().getPrimaryCaret();
            this.primaryCaretPositionPossiblyChanged(currentPrimaryCaret);
        }

        @RequiresEdt
        public void caretPositionChanged(@NotNull com.intellij.openapi.editor.event.CaretEvent event) {
            CaretImpl currentPrimaryCaret;
            if (event == null) {
                EditorSwingCaretUpdatesCourier.$$$reportNull$$$0(1);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (this.isInsideBulkUpdate()) {
                return;
            }
            Caret changedCaret = event.getCaret();
            if (changedCaret != (currentPrimaryCaret = EditorComponentImpl.this.editor.getCaretModel().getPrimaryCaret())) {
                return;
            }
            this.primaryCaretPositionPossiblyChanged(currentPrimaryCaret);
        }

        @RequiresEdt
        public void caretAdded(@NotNull com.intellij.openapi.editor.event.CaretEvent event) {
            CaretImpl currentPrimaryCaret;
            if (event == null) {
                EditorSwingCaretUpdatesCourier.$$$reportNull$$$0(2);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (this.isInsideBulkUpdate()) {
                return;
            }
            Caret addedCaret = event.getCaret();
            if (addedCaret != (currentPrimaryCaret = EditorComponentImpl.this.editor.getCaretModel().getPrimaryCaret())) {
                return;
            }
            this.primaryCaretPositionPossiblyChanged(currentPrimaryCaret);
        }

        @RequiresEdt
        public void caretRemoved(@NotNull com.intellij.openapi.editor.event.CaretEvent event) {
            if (event == null) {
                EditorSwingCaretUpdatesCourier.$$$reportNull$$$0(3);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (this.isInsideBulkUpdate()) {
                return;
            }
            CaretImpl currentPrimaryCaret = EditorComponentImpl.this.editor.getCaretModel().getPrimaryCaret();
            if (this.myLastKnownPrimaryCaret.refersTo(currentPrimaryCaret)) {
                return;
            }
            this.primaryCaretPositionPossiblyChanged(currentPrimaryCaret);
        }

        @RequiresEdt
        public void beforeDocumentChange(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
            if (event == null) {
                EditorSwingCaretUpdatesCourier.$$$reportNull$$$0(4);
            }
            ThreadingAssertions.assertEventDispatchThread();
            this.isInsideBulkDocumentUpdate = true;
        }

        @RequiresEdt
        public void afterDocumentChange(@NotNull Document document2) {
            if (document2 == null) {
                EditorSwingCaretUpdatesCourier.$$$reportNull$$$0(5);
            }
            ThreadingAssertions.assertEventDispatchThread();
            this.isInsideBulkDocumentUpdate = false;
            if (this.isInsideBulkUpdate()) {
                return;
            }
            CaretImpl currentPrimaryCaret = EditorComponentImpl.this.editor.getCaretModel().getPrimaryCaret();
            this.primaryCaretPositionPossiblyChanged(currentPrimaryCaret);
        }

        @RequiresEdt
        private boolean isInsideBulkUpdate() {
            ThreadingAssertions.assertEventDispatchThread();
            return this.isInsideCaretsAction || this.isInsideBulkDocumentUpdate;
        }

        @RequiresEdt
        private void primaryCaretPositionPossiblyChanged(@NotNull Caret currentPrimaryCaret) {
            if (currentPrimaryCaret == null) {
                EditorSwingCaretUpdatesCourier.$$$reportNull$$$0(6);
            }
            ThreadingAssertions.assertEventDispatchThread();
            final int currentPrimaryCaretDot = currentPrimaryCaret.getOffset();
            final int currentPrimaryCaretMark = currentPrimaryCaret.getLeadSelectionOffset();
            if (!this.myLastKnownPrimaryCaret.refersTo(currentPrimaryCaret)) {
                this.myLastKnownPrimaryCaret.clear();
                this.myLastKnownPrimaryCaret = new WeakReference<Caret>(currentPrimaryCaret);
            }
            if (currentPrimaryCaretDot < 0) {
                LOG.error("currentPrimaryCaretDot < 0", new String[]{String.format("currentPrimaryCaretDot == %d", currentPrimaryCaretDot), String.format("currentPrimaryCaret == %s", currentPrimaryCaret)});
            } else if (currentPrimaryCaretMark < 0) {
                LOG.error("currentPrimaryCaretMark < 0", new String[]{String.format("currentPrimaryCaretMark == %d", currentPrimaryCaretMark), String.format("currentPrimaryCaret == %s", currentPrimaryCaret)});
            }
            if (this.myPrimaryCaretLastKnownDot == currentPrimaryCaretDot && this.myPrimaryCaretLastKnownMark == currentPrimaryCaretMark) {
                return;
            }
            this.myPrimaryCaretLastKnownDot = currentPrimaryCaretDot;
            this.myPrimaryCaretLastKnownMark = currentPrimaryCaretMark;
            EditorComponentImpl.this.fireCaretUpdate(new CaretEvent(EditorComponentImpl.this){

                @Override
                public int getDot() {
                    return currentPrimaryCaretDot;
                }

                @Override
                public int getMark() {
                    return currentPrimaryCaretMark;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentPrimaryCaret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorComponentImpl$EditorSwingCaretUpdatesCourier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretPositionChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretAdded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretRemoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterDocumentChange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "primaryCaretPositionPossiblyChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class EditorAccessibleContextDelegate
    extends AccessibleContextDelegateWithContextMenu
    implements AccessibleText {
        public EditorAccessibleContextDelegate() {
            super((AccessibleContext)new AccessibleEditorComponentImpl());
        }

        protected void doShowContextMenu() {
            ActionManager.getInstance().tryToExecute(ActionManager.getInstance().getAction("ShowPopupMenu"), null, (Component)EditorComponentImpl.this.getEditor().getContentComponent(), null, true);
        }

        protected Container getDelegateParent() {
            return EditorComponentImpl.this.getParent();
        }

        @Override
        public int getIndexAtPoint(Point point) {
            return ((AccessibleText)((Object)this.getDelegate())).getIndexAtPoint(point);
        }

        @Override
        public Rectangle getCharacterBounds(int i2) {
            return ((AccessibleText)((Object)this.getDelegate())).getCharacterBounds(i2);
        }

        @Override
        public int getCharCount() {
            return ((AccessibleText)((Object)this.getDelegate())).getCharCount();
        }

        @Override
        public int getCaretPosition() {
            return ((AccessibleText)((Object)this.getDelegate())).getCaretPosition();
        }

        @Override
        public String getAtIndex(int part, int index) {
            return ((AccessibleText)((Object)this.getDelegate())).getAtIndex(part, index);
        }

        @Override
        public String getAfterIndex(int part, int index) {
            return ((AccessibleText)((Object)this.getDelegate())).getAfterIndex(part, index);
        }

        @Override
        public String getBeforeIndex(int part, int index) {
            return ((AccessibleText)((Object)this.getDelegate())).getBeforeIndex(part, index);
        }

        @Override
        public AttributeSet getCharacterAttribute(int i2) {
            return ((AccessibleText)((Object)this.getDelegate())).getCharacterAttribute(i2);
        }

        @Override
        public int getSelectionStart() {
            return ((AccessibleText)((Object)this.getDelegate())).getSelectionStart();
        }

        @Override
        public int getSelectionEnd() {
            return ((AccessibleText)((Object)this.getDelegate())).getSelectionEnd();
        }

        @Override
        public String getSelectedText() {
            return ((AccessibleText)((Object)this.getDelegate())).getSelectedText();
        }
    }

    private final class EditorAccessibilityDocument
    implements javax.swing.text.Document,
    Element {
        private List<javax.swing.event.DocumentListener> myListeners;

        private EditorAccessibilityDocument() {
        }

        @Nullable
        public List<javax.swing.event.DocumentListener> getListeners() {
            return this.myListeners;
        }

        @Override
        public int getLength() {
            return EditorComponentImpl.this.editor.getDocument().getTextLength();
        }

        @Override
        public void addDocumentListener(javax.swing.event.DocumentListener documentListener2) {
            if (this.myListeners == null) {
                this.myListeners = new ArrayList<javax.swing.event.DocumentListener>(2);
            }
            this.myListeners.add(documentListener2);
        }

        @Override
        public void removeDocumentListener(javax.swing.event.DocumentListener documentListener2) {
            if (this.myListeners != null) {
                this.myListeners.remove(documentListener2);
            }
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        }

        @Override
        @Nullable
        public Object getProperty(Object o) {
            return null;
        }

        @Override
        public void putProperty(Object o, Object o1) {
        }

        @Override
        public void remove(int offset, int length) {
            EditorComponentImpl.this.editDocumentSafely(offset, length, null);
        }

        @Override
        public void insertString(int offset, String text2, AttributeSet attributeSet) {
            EditorComponentImpl.this.editDocumentSafely(offset, 0, text2);
        }

        @Override
        public String getText(int offset, int length) {
            return (String)EditorThreading.compute(() -> EditorComponentImpl.this.editor.getDocument().getText(new TextRange(offset, offset + length)));
        }

        @Override
        public void getText(int offset, int length, Segment segment) {
            char[] s = this.getText(offset, length).toCharArray();
            segment.array = s;
            segment.offset = 0;
            segment.count = s.length;
        }

        @Override
        @Nullable
        public Position getStartPosition() {
            EditorComponentImpl.notSupported();
            return null;
        }

        @Override
        @Nullable
        public Position getEndPosition() {
            EditorComponentImpl.notSupported();
            return null;
        }

        @Override
        @Nullable
        public Position createPosition(int i2) {
            EditorComponentImpl.notSupported();
            return null;
        }

        @Override
        public Element[] getRootElements() {
            return new Element[]{this};
        }

        @Override
        public Element getDefaultRootElement() {
            return this;
        }

        @Override
        public void render(Runnable runnable2) {
            ApplicationManager.getApplication().runReadAction(runnable2);
        }

        @Override
        public javax.swing.text.Document getDocument() {
            return this;
        }

        @Override
        @Nullable
        public Element getParentElement() {
            return null;
        }

        @Override
        @Nullable
        public String getName() {
            return null;
        }

        @Override
        @Nullable
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return this.getLength();
        }

        @Override
        public int getElementIndex(int i2) {
            DocumentEx document2 = EditorComponentImpl.this.editor.getDocument();
            return document2.getLineNumber(i2);
        }

        @Override
        public int getElementCount() {
            DocumentEx document2 = EditorComponentImpl.this.editor.getDocument();
            return document2.getLineCount();
        }

        @Override
        public Element getElement(final int i2) {
            return new Element(){

                @Override
                public javax.swing.text.Document getDocument() {
                    return EditorAccessibilityDocument.this;
                }

                @Override
                public Element getParentElement() {
                    return EditorAccessibilityDocument.this;
                }

                @Override
                @Nullable
                public String getName() {
                    return null;
                }

                @Override
                @Nullable
                public AttributeSet getAttributes() {
                    return null;
                }

                @Override
                public int getStartOffset() {
                    DocumentEx document2 = EditorComponentImpl.this.editor.getDocument();
                    return document2.getLineStartOffset(i2);
                }

                @Override
                public int getEndOffset() {
                    DocumentEx document2 = EditorComponentImpl.this.editor.getDocument();
                    return document2.getLineEndOffset(i2);
                }

                @Override
                public int getElementIndex(int i22) {
                    return 0;
                }

                @Override
                public int getElementCount() {
                    return 0;
                }

                @Override
                @Nullable
                public Element getElement(int i22) {
                    return null;
                }

                @Override
                public boolean isLeaf() {
                    return true;
                }
            };
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    private final class EditorAccessibilityTextUI
    extends TextUI {
        private EditorAccessibilityTextUI() {
        }

        @Override
        @NotNull
        public Rectangle modelToView(JTextComponent tc, int offset) {
            Rectangle rectangle = this.modelToView(tc, offset, Position.Bias.Forward);
            if (rectangle == null) {
                EditorAccessibilityTextUI.$$$reportNull$$$0(0);
            }
            return rectangle;
        }

        @Override
        public int viewToModel(JTextComponent tc, Point pt) {
            LogicalPosition logicalPosition = EditorComponentImpl.this.editor.xyToLogicalPosition(pt);
            return EditorComponentImpl.this.editor.logicalPositionToOffset(logicalPosition);
        }

        @Override
        @NotNull
        public Rectangle modelToView(JTextComponent tc, int offset, Position.Bias bias) {
            LogicalPosition pos = EditorComponentImpl.this.editor.offsetToLogicalPosition(offset).leanForward(bias == Position.Bias.Forward);
            LogicalPosition posNext = EditorComponentImpl.this.editor.offsetToLogicalPosition(bias == Position.Bias.Forward ? offset + 1 : offset - 1).leanForward(bias != Position.Bias.Forward);
            Point point = EditorComponentImpl.this.editor.logicalPositionToXY(pos);
            Point pointNext = EditorComponentImpl.this.editor.logicalPositionToXY(posNext);
            return point.y == pointNext.y ? new Rectangle(Math.min(point.x, pointNext.x), point.y, Math.abs(point.x - pointNext.x), EditorComponentImpl.this.editor.getLineHeight()) : new Rectangle(point.x, point.y, 0, EditorComponentImpl.this.editor.getLineHeight());
        }

        @Override
        public int viewToModel(JTextComponent tc, Point pt, Position.Bias[] ignored) {
            return this.viewToModel(tc, pt);
        }

        @Override
        public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) {
            EditorComponentImpl.notSupported();
            return 0;
        }

        @Override
        public void damageRange(JTextComponent t, int p0, int p1) {
            EditorComponentImpl.this.editor.repaint(p0, p1);
        }

        @Override
        public void damageRange(JTextComponent t, int p0, int p1, Position.Bias ignored1, Position.Bias ignored2) {
            this.damageRange(t, p0, p1);
        }

        @Override
        @NotNull
        public EditorKit getEditorKit(JTextComponent t) {
            EditorComponentImpl.notSupported();
            if (null == null) {
                EditorAccessibilityTextUI.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Override
        @NotNull
        public View getRootView(JTextComponent t) {
            EditorComponentImpl.notSupported();
            if (null == null) {
                EditorAccessibilityTextUI.$$$reportNull$$$0(2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/editor/impl/EditorComponentImpl$EditorAccessibilityTextUI";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modelToView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorKit";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootView";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private final class AccessibleEditorComponentImpl
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    AccessibleEditableText,
    AccessibleExtendedText,
    AccessibleAction,
    com.intellij.openapi.editor.event.CaretListener,
    DocumentListener {
        private int myCaretPos;
        private int myPreviousCaretPos;
        private static final int BEFORE = -1;
        private static final int HERE = 0;
        private static final int AFTER = 1;

        AccessibleEditorComponentImpl() {
            super(EditorComponentImpl.this);
            if (EditorComponentImpl.this.editor.isDisposed()) {
                return;
            }
            EditorComponentImpl.this.editor.getCaretModel().addCaretListener(this, EditorComponentImpl.this.editor.getDisposable());
            EditorComponentImpl.this.editor.getDocument().addDocumentListener((DocumentListener)this);
            Disposer.register((Disposable)EditorComponentImpl.this.editor.getDisposable(), (Disposable)new Disposable(){

                public void dispose() {
                    EditorComponentImpl.this.editor.getDocument().removeDocumentListener((DocumentListener)AccessibleEditorComponentImpl.this);
                }
            });
        }

        public void caretPositionChanged(@NotNull com.intellij.openapi.editor.event.CaretEvent e) {
            Caret caret;
            if (e == null) {
                AccessibleEditorComponentImpl.$$$reportNull$$$0(0);
            }
            if ((caret = e.getCaret()) != EditorComponentImpl.this.editor.getCaretModel().getPrimaryCaret()) {
                return;
            }
            int dot = caret.getOffset();
            int mark = caret.getLeadSelectionOffset();
            if (this.myCaretPos != dot) {
                ThreadingAssertions.assertEventDispatchThread();
                this.firePropertyChange("AccessibleCaret", this.myCaretPos, dot);
                this.myPreviousCaretPos = this.myCaretPos;
                this.myCaretPos = dot;
            }
            if (mark != dot) {
                ThreadingAssertions.assertEventDispatchThread();
                this.firePropertyChange("AccessibleSelection", null, this.getSelectedText());
            }
        }

        public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
            if (event == null) {
                AccessibleEditorComponentImpl.$$$reportNull$$$0(1);
            }
            Integer pos = event.getOffset();
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, pos);
                if (SystemInfo.isMac) {
                    EditorComponentImpl.this.fireJTextComponentDocumentChange(event);
                }
            } else {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.firePropertyChange("AccessibleText", null, pos);
                    EditorComponentImpl.this.fireJTextComponentDocumentChange(event);
                });
            }
        }

        @Override
        @Nullable
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            VirtualFile file2 = EditorComponentImpl.this.editor.getVirtualFile();
            if (file2 != null) {
                return EditorBundle.message((String)"editor.for.file.accessible.name", (Object[])new Object[]{file2.getName()});
            }
            return EditorBundle.message((String)"editor.accessible.name", (Object[])new Object[0]);
        }

        @Override
        public String getAccessibleDescription() {
            CharSequence emptyText;
            String description = super.getAccessibleDescription();
            if (description == null && StringUtil.isEmpty((String)EditorComponentImpl.this.getText()) && (emptyText = EditorComponentImpl.this.getEditor().getPlaceholder()) != null && !emptyText.isEmpty()) {
                return AccessibleContextUtil.getUniqueDescription((AccessibleContext)this, (String)emptyText.toString());
            }
            return description;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            if (SystemInfo.isMac) {
                return TextAccessibleRole.TEXT_AREA;
            }
            return AccessibleRole.TEXT;
        }

        @Override
        public AccessibleText getAccessibleText() {
            if (EditorComponentImpl.this.editor.isDisposed()) {
                return null;
            }
            return this;
        }

        @Override
        public AccessibleEditableText getAccessibleEditableText() {
            if (EditorComponentImpl.this.editor.isDisposed()) {
                return null;
            }
            return this;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (EditorComponentImpl.this.editor.getDocument().isWritable()) {
                states.add(AccessibleState.EDITABLE);
            }
            states.add(AccessibleState.MULTI_LINE);
            return states;
        }

        @Override
        public int getIndexAtPoint(Point point) {
            LogicalPosition logicalPosition = EditorComponentImpl.this.editor.xyToLogicalPosition(point);
            return EditorComponentImpl.this.editor.logicalPositionToOffset(logicalPosition);
        }

        @Override
        public Rectangle getCharacterBounds(int offset) {
            if (offset < 0 || offset > EditorComponentImpl.this.editor.getDocument().getTextLength() - 1) {
                return null;
            }
            LogicalPosition pos = EditorComponentImpl.this.editor.offsetToLogicalPosition(offset);
            Point point = EditorComponentImpl.this.editor.logicalPositionToXY(pos);
            FontMetrics fontMetrics = EditorComponentImpl.this.editor.getFontMetrics(0);
            char c = EditorComponentImpl.this.editor.getDocument().getCharsSequence().subSequence(offset, offset + 1).charAt(0);
            return new Rectangle(point.x, point.y, fontMetrics.charWidth(c), fontMetrics.getHeight());
        }

        @Override
        public int getCharCount() {
            return EditorComponentImpl.this.editor.getDocument().getTextLength();
        }

        @Override
        public int getCaretPosition() {
            return (Integer)EditorThreading.compute(() -> EditorComponentImpl.this.editor.getCaretModel().getOffset());
        }

        @Override
        @Nullable
        public String getAtIndex(int part, int index) {
            return this.getTextAtOffset(part, index, 0);
        }

        @Override
        @Nullable
        public String getAfterIndex(int part, int index) {
            return this.getTextAtOffset(part, index, 1);
        }

        @Override
        @Nullable
        public String getBeforeIndex(int part, int index) {
            return this.getTextAtOffset(part, index, -1);
        }

        @Override
        public AttributeSet getCharacterAttribute(int index) {
            return new SimpleAttributeSet();
        }

        @Override
        public int getSelectionStart() {
            return (Integer)EditorThreading.compute(() -> EditorComponentImpl.this.editor.getSelectionModel().getSelectionStart());
        }

        @Override
        public int getSelectionEnd() {
            return (Integer)EditorThreading.compute(() -> EditorComponentImpl.this.editor.getSelectionModel().getSelectionEnd());
        }

        @Override
        @Nullable
        public String getSelectedText() {
            return (String)EditorThreading.compute(() -> EditorComponentImpl.this.editor.getSelectionModel().getSelectedText());
        }

        @Override
        public void setTextContents(String s) {
            EditorComponentImpl.this.setText(s);
        }

        @Override
        public void insertTextAtIndex(int index, String s) {
            EditorComponentImpl.this.editDocumentSafely(index, 0, s);
        }

        @Override
        public String getTextRange(int startIndex, int endIndex) {
            return EditorComponentImpl.this.editor.getDocument().getCharsSequence().subSequence(startIndex, endIndex).toString();
        }

        @Override
        public void delete(int startIndex, int endIndex) {
            EditorComponentImpl.this.editDocumentSafely(startIndex, endIndex - startIndex, null);
        }

        @Override
        public void cut(int startIndex, int endIndex) {
            EditorComponentImpl.this.editor.getSelectionModel().setSelection(startIndex, endIndex);
            DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)EditorComponentImpl.this);
            CutProvider cutProvider = EditorComponentImpl.this.editor.getCutProvider();
            if (cutProvider.isCutEnabled(dataContext2)) {
                cutProvider.performCut(dataContext2);
            }
        }

        @Override
        public void paste(int startIndex) {
            EditorComponentImpl.this.editor.getCaretModel().moveToOffset(startIndex);
            DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)EditorComponentImpl.this);
            PasteProvider pasteProvider = EditorComponentImpl.this.editor.getPasteProvider();
            if (pasteProvider.isPasteEnabled(dataContext2)) {
                pasteProvider.performPaste(dataContext2);
            }
        }

        @Override
        public void replaceText(int startIndex, int endIndex, String s) {
            EditorComponentImpl.this.editDocumentSafely(startIndex, endIndex - startIndex, s);
        }

        @Override
        public void selectText(int startIndex, int endIndex) {
            EditorThreading.run(() -> {
                EditorComponentImpl.this.editor.getSelectionModel().setSelection(startIndex, endIndex);
                EditorComponentImpl.this.editor.getCaretModel().moveToOffset(endIndex);
            });
        }

        @Override
        public void setAttributes(int startIndex, int endIndex, AttributeSet as) {
        }

        @Override
        @Nullable
        public AccessibleTextSequence getTextSequenceAt(int part, int index) {
            return this.getSequenceAtIndex(part, index, 0);
        }

        @Override
        @Nullable
        public AccessibleTextSequence getTextSequenceAfter(int part, int index) {
            return this.getSequenceAtIndex(part, index, 1);
        }

        @Override
        @Nullable
        public AccessibleTextSequence getTextSequenceBefore(int part, int index) {
            return this.getSequenceAtIndex(part, index, -1);
        }

        @Override
        @Nullable
        public Rectangle getTextBounds(int startIndex, int endIndex) {
            LogicalPosition startPos = EditorComponentImpl.this.editor.offsetToLogicalPosition(startIndex);
            Point startPoint = EditorComponentImpl.this.editor.logicalPositionToXY(startPos);
            Rectangle rectangle = new Rectangle(startPoint);
            LogicalPosition endPos = EditorComponentImpl.this.editor.offsetToLogicalPosition(endIndex);
            Point endPoint = EditorComponentImpl.this.editor.logicalPositionToXY(endPos);
            FontMetrics fontMetrics = EditorComponentImpl.this.editor.getFontMetrics(0);
            char c = EditorComponentImpl.this.editor.getDocument().getCharsSequence().subSequence(endIndex - 1, endIndex).charAt(0);
            endPoint.x += fontMetrics.charWidth(c);
            endPoint.y += fontMetrics.getHeight();
            rectangle.add(endPoint);
            return rectangle;
        }

        @Override
        public int getAccessibleActionCount() {
            return 0;
        }

        @Override
        public String getAccessibleActionDescription(int i2) {
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i2) {
            return false;
        }

        @Nullable
        private String getTextAtOffset(int type, int offset, int direction) {
            DocumentEx document2 = EditorComponentImpl.this.editor.getDocument();
            if (offset < 0 || offset >= document2.getTextLength()) {
                return null;
            }
            switch (type) {
                case 1: {
                    if (offset + direction >= document2.getTextLength() || offset + direction < 0) break;
                    int startOffset = offset + direction;
                    return document2.getCharsSequence().subSequence(startOffset, startOffset + 1).toString();
                }
                case 2: {
                    AccessibleTextSequence word = this.getWordOrLexeme(offset, direction);
                    return word == null ? null : word.text;
                }
                case 3: {
                    int lineStart = this.getLineAtOffsetStart(offset, direction);
                    int lineEnd = this.getLineAtOffsetEnd(offset, direction);
                    if (lineStart == -1 || lineEnd == -1) {
                        return null;
                    }
                    return document2.getCharsSequence().subSequence(lineStart, lineEnd).toString();
                }
                case 4: 
                case 5: {
                    assert (false) : type;
                    break;
                }
            }
            return null;
        }

        @Nullable
        private AccessibleTextSequence getSequenceAtIndex(int type, int offset, int direction) {
            assert (direction == -1 || direction == 0 || direction == 1);
            DocumentEx document2 = EditorComponentImpl.this.editor.getDocument();
            if (offset < 0 || offset >= document2.getTextLength()) {
                return null;
            }
            switch (type) {
                case 1: {
                    AccessibleTextSequence charSequence = null;
                    if (offset + direction < document2.getTextLength() && offset + direction >= 0) {
                        int startOffset = offset + direction;
                        charSequence = new AccessibleTextSequence(startOffset, startOffset + 1, document2.getCharsSequence().subSequence(startOffset, startOffset + 1).toString());
                    }
                    return charSequence;
                }
                case 2: 
                case 5: {
                    return this.getWordOrLexeme(offset, direction);
                }
                case 3: 
                case 4: {
                    int lineStart = this.getLineAtOffsetStart(offset, direction);
                    int lineEnd = this.getLineAtOffsetEnd(offset, direction);
                    if (lineStart == -1 || lineEnd == -1) {
                        return null;
                    }
                    return new AccessibleTextSequence(lineStart, lineEnd, document2.getCharsSequence().subSequence(lineStart, lineEnd).toString());
                }
            }
            return null;
        }

        private int getLineAtOffsetStart(int offset) {
            DocumentEx document2 = EditorComponentImpl.this.editor.getDocument();
            if (offset == 0) {
                return 0;
            }
            int lineNumber = EditorComponentImpl.this.editor.offsetToLogicalPosition((int)offset).line;
            return document2.getLineStartOffset(lineNumber);
        }

        private int moveLineOffset(int offset, int direction) {
            if (direction == 1) {
                int lineNumber = EditorComponentImpl.this.editor.offsetToLogicalPosition((int)offset).line;
                DocumentEx document2 = EditorComponentImpl.this.editor.getDocument();
                if (++lineNumber == document2.getLineCount()) {
                    return -1;
                }
                return document2.getLineStartOffset(lineNumber);
            }
            if (direction == -1) {
                int lineNumber = EditorComponentImpl.this.editor.offsetToLogicalPosition((int)offset).line;
                if (--lineNumber < 0) {
                    return -1;
                }
                DocumentEx document3 = EditorComponentImpl.this.editor.getDocument();
                return document3.getLineStartOffset(lineNumber);
            }
            assert (direction == 0);
            return offset;
        }

        private int getLineAtOffsetStart(int offset, int direction) {
            if ((offset = this.moveLineOffset(offset, direction)) == -1) {
                return -1;
            }
            return this.getLineAtOffsetStart(offset);
        }

        private int getLineAtOffsetEnd(int offset) {
            DocumentEx document2 = EditorComponentImpl.this.editor.getDocument();
            if (offset == 0) {
                return 0;
            }
            int lineNumber = EditorComponentImpl.this.editor.offsetToLogicalPosition((int)offset).line;
            return document2.getLineEndOffset(lineNumber);
        }

        private int getLineAtOffsetEnd(int offset, int direction) {
            if ((offset = this.moveLineOffset(offset, direction)) == -1) {
                return -1;
            }
            return this.getLineAtOffsetEnd(offset);
        }

        private CaretStopPolicy resolveCaretStopPolicy(int direction) {
            CaretStopOptions caretStopOptions = EditorSettingsExternalizable.getInstance().getCaretStopOptions();
            switch (direction) {
                case 1: {
                    return caretStopOptions.getForwardPolicy();
                }
                case -1: {
                    return caretStopOptions.getBackwardPolicy();
                }
                case 0: {
                    return this.myCaretPos - this.myPreviousCaretPos >= 0 ? caretStopOptions.getForwardPolicy() : caretStopOptions.getBackwardPolicy();
                }
            }
            return caretStopOptions.getForwardPolicy();
        }

        private AccessibleTextSequence getWordOrLexeme(int offset, int direction) {
            boolean isCamel = EditorComponentImpl.this.editor.getSettings().isCamelWords();
            CaretStopPolicy caretStopPolicy = this.resolveCaretStopPolicy(direction);
            offset = this.moveWordOffset(offset, direction, caretStopPolicy, isCamel);
            CaretStop wordStop = caretStopPolicy.getWordStop();
            int wordStart = this.getWordAtOffsetStart(offset, wordStop, isCamel);
            int wordEnd = this.getWordAtOffsetEnd(offset, wordStop, isCamel);
            if (wordStart == -1 || wordEnd == -1 || wordStart > wordEnd) {
                return null;
            }
            return new AccessibleTextSequence(wordStart, wordEnd, EditorComponentImpl.this.editor.getDocument().getCharsSequence().subSequence(wordStart, wordEnd).toString());
        }

        private int moveWordOffset(int offset, int direction, CaretStopPolicy stopPolicy, boolean isCamel) {
            if (direction == 1) {
                return EditorActionUtil.getNextCaretStopOffset(EditorComponentImpl.this.editor, stopPolicy, isCamel);
            }
            if (direction == -1) {
                return EditorActionUtil.getPreviousCaretStopOffset(EditorComponentImpl.this.editor, stopPolicy, isCamel);
            }
            return offset;
        }

        private int getWordAtOffsetStart(int offset, CaretStop wordStop, boolean isCamel) {
            if (offset == 0) {
                return 0;
            }
            if (wordStop.isAtEnd() && !wordStop.isAtStart()) {
                if (EditorActionUtil.isWordOrLexemeEnd(EditorComponentImpl.this.editor, offset, isCamel)) {
                    return this.getWordAtOffsetStart(offset - 1, isCamel);
                }
                if (offset == this.getLineAtOffsetStart(offset)) {
                    return offset - 1;
                }
            }
            if (Character.isWhitespace(EditorComponentImpl.this.editor.getDocument().getText().charAt(offset))) {
                return offset;
            }
            return this.getWordAtOffsetStart(offset, isCamel);
        }

        private int getWordAtOffsetStart(int offset, boolean isCamel) {
            int newOffset;
            int minOffset;
            DocumentEx document2 = EditorComponentImpl.this.editor.getDocument();
            if (offset == 0) {
                return 0;
            }
            int lineNumber = EditorComponentImpl.this.editor.offsetToLogicalPosition((int)offset).line;
            int n = minOffset = lineNumber > 0 ? document2.getLineEndOffset(lineNumber - 1) : 0;
            for (newOffset = offset; newOffset > minOffset && !EditorActionUtil.isWordOrLexemeStart(EditorComponentImpl.this.editor, newOffset, isCamel); --newOffset) {
            }
            return newOffset;
        }

        private int getWordAtOffsetEnd(int offset, CaretStop stopWord, boolean isCamel) {
            if (stopWord.isAtStart()) {
                if (Character.isWhitespace(EditorComponentImpl.this.editor.getDocument().getText().charAt(offset))) {
                    return offset + 1;
                }
                return this.getWordAtOffsetEnd(offset + 1, isCamel);
            }
            if (offset == this.getLineAtOffsetStart(offset)) {
                return offset;
            }
            return this.getWordAtOffsetEnd(offset, isCamel);
        }

        private int getWordAtOffsetEnd(int offset, boolean isCamel) {
            DocumentEx document2 = EditorComponentImpl.this.editor.getDocument();
            if (offset >= document2.getTextLength() - 1 || document2.getLineCount() == 0) {
                return offset;
            }
            int newOffset = offset;
            int lineNumber = EditorComponentImpl.this.editor.offsetToLogicalPosition((int)offset).line;
            int maxOffset = document2.getLineEndOffset(lineNumber);
            if (newOffset > maxOffset) {
                if (lineNumber + 1 >= document2.getLineCount()) {
                    return offset;
                }
                maxOffset = document2.getLineEndOffset(lineNumber + 1);
            }
            while (newOffset < maxOffset && !EditorActionUtil.isWordOrLexemeEnd(EditorComponentImpl.this.editor, newOffset, isCamel)) {
                ++newOffset;
            }
            return newOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorComponentImpl$AccessibleEditorComponentImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretPositionChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TextAccessibleRole
    extends AccessibleRole {
        private static final AccessibleRole TEXT_AREA = new TextAccessibleRole("textarea");

        private TextAccessibleRole(@NonNls String key) {
            super(key);
        }
    }
}

