/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines.ui;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineColors;", "", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "isDarkColorScheme", "", "updateScheme", "newScheme", "borderLineColor", "Ljava/awt/Color;", "shadowColor", "shadowTransparentColor", "heightFactor", "", "isDebugEnabled", "Companion", "intellij.platform.ide.impl"})
public final class StickyLineColors {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private EditorColorsScheme scheme;
    private boolean isDarkColorScheme;
    private static final double SHADOW_HEIGHT_FACTOR_LIGHT = 0.17;
    private static final double SHADOW_HEIGHT_FACTOR_DARK = 0.25;
    private static final int SHADOW_COLOR_ALPHA_LIGHT = 8;
    private static final int SHADOW_COLOR_ALPHA_DARK = 32;
    @NotNull
    private static final Color SHADOW_COLOR_LIGHT = new Color(0, 0, 0, 8);
    @NotNull
    private static final Color SHADOW_COLOR_DARK = new Color(0, 0, 0, 32);
    @NotNull
    private static final Color SHADOW_COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    private static final Color SHADOW_COLOR_LIGHT_DEBUG = Color.GREEN;
    private static final Color SHADOW_COLOR_DARK_DEBUG = Color.BLUE;
    private static final Color SHADOW_COLOR_TRANSPARENT_DEBUG = Color.RED;
    private static final Color BORDER_LINE_COLOR_DEBUG = Color.YELLOW;

    public StickyLineColors(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        this.scheme = scheme;
        this.isDarkColorScheme = this.isDarkColorScheme();
    }

    public final boolean updateScheme(@NotNull EditorColorsScheme newScheme) {
        Intrinsics.checkNotNullParameter((Object)newScheme, (String)"newScheme");
        boolean oldIsDark = this.isDarkColorScheme;
        this.scheme = newScheme;
        this.isDarkColorScheme = this.isDarkColorScheme();
        return oldIsDark != this.isDarkColorScheme;
    }

    @NotNull
    public final Color borderLineColor() {
        Color color;
        if (this.isDebugEnabled()) {
            Color color2 = BORDER_LINE_COLOR_DEBUG;
            Intrinsics.checkNotNull((Object)color2);
            color = color2;
        } else {
            Color stickyLinesBorderColor = this.scheme.getColor(EditorColors.STICKY_LINES_BORDER_COLOR);
            color = stickyLinesBorderColor;
            if (color == null) {
                Color color3 = this.scheme.getDefaultBackground();
                color = color3;
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getDefaultBackground(...)");
            }
        }
        return color;
    }

    @NotNull
    public final Color shadowColor() {
        Color color;
        if (this.isDebugEnabled()) {
            Color color2 = this.isDarkColorScheme ? SHADOW_COLOR_DARK_DEBUG : SHADOW_COLOR_LIGHT_DEBUG;
            Intrinsics.checkNotNull((Object)color2);
            color = color2;
        } else {
            color = this.isDarkColorScheme ? SHADOW_COLOR_DARK : SHADOW_COLOR_LIGHT;
        }
        return color;
    }

    @NotNull
    public final Color shadowTransparentColor() {
        Color color;
        if (this.isDebugEnabled()) {
            Color color2 = SHADOW_COLOR_TRANSPARENT_DEBUG;
            Intrinsics.checkNotNull((Object)color2);
            color = color2;
        } else {
            color = SHADOW_COLOR_TRANSPARENT;
        }
        return color;
    }

    public final double heightFactor() {
        return this.isDarkColorScheme ? 0.25 : 0.17;
    }

    private final boolean isDarkColorScheme() {
        Color color = this.scheme.getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
        Color background = color;
        return ColorUtil.isDark((Color)background);
    }

    private final boolean isDebugEnabled() {
        return Registry.Companion.is("editor.show.sticky.lines.shadow.debug", false);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u000f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineColors$Companion;", "", "<init>", "()V", "SHADOW_HEIGHT_FACTOR_LIGHT", "", "SHADOW_HEIGHT_FACTOR_DARK", "SHADOW_COLOR_ALPHA_LIGHT", "", "SHADOW_COLOR_ALPHA_DARK", "SHADOW_COLOR_LIGHT", "Ljava/awt/Color;", "SHADOW_COLOR_DARK", "SHADOW_COLOR_TRANSPARENT", "SHADOW_COLOR_LIGHT_DEBUG", "kotlin.jvm.PlatformType", "SHADOW_COLOR_DARK_DEBUG", "SHADOW_COLOR_TRANSPARENT_DEBUG", "BORDER_LINE_COLOR_DEBUG", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

