/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.impl.FileComparator;
import com.intellij.openapi.fileChooser.impl.FileTreeStructure;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.fileChooser.tree.FileNodeVisitor;
import com.intellij.openapi.fileChooser.tree.FileRefresher;
import com.intellij.openapi.fileChooser.tree.FileRenderer;
import com.intellij.openapi.fileChooser.tree.FileTreeModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.UIBundle;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSystemTreeImpl
implements FileSystemTree {
    private final Tree myTree;
    private final Project myProject;
    private final ArrayList<Runnable> myOkActions = new ArrayList(2);
    private final FileChooserDescriptor myDescriptor;
    @NotNull
    private final AbstractTreeModel myFileTreeModel;
    @NotNull
    private final AsyncTreeModel myAsyncTreeModel;
    private final List<FileSystemTree.Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public FileSystemTreeImpl(@Nullable Project project2, FileChooserDescriptor descriptor2) {
        this(project2, descriptor2, new Tree(), null, null, null);
        this.myTree.setRootVisible(descriptor2.isTreeRootVisible());
        this.myTree.setShowsRootHandles(true);
    }

    public FileSystemTreeImpl(@Nullable Project project2, FileChooserDescriptor descriptor2, Tree tree2, @Nullable TreeCellRenderer renderer2, @Nullable Runnable onInitialized, @Nullable Convertor<? super TreePath, String> speedSearchConverter) {
        this.myProject = project2;
        if (renderer2 == null) {
            renderer2 = new FileRenderer().forTree();
            this.myFileTreeModel = this.createFileTreeModel(descriptor2, tree2);
            Object treeStructure = null;
        } else {
            FileTreeStructure treeStructure = new FileTreeStructure(project2, descriptor2);
            this.myFileTreeModel = new StructureTreeModel<FileTreeStructure>(treeStructure, this.getFileComparator(), (Disposable)this);
        }
        this.myDescriptor = descriptor2;
        this.myTree = tree2;
        this.myAsyncTreeModel = new AsyncTreeModel((TreeModel)this.myFileTreeModel, (Disposable)this);
        this.myTree.setModel((TreeModel)((Object)this.myAsyncTreeModel));
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FileSystemTreeImpl.this.processSelectionChange();
            }
        });
        if (speedSearchConverter != null) {
            TreeSpeedSearch.installOn((JTree)this.myTree, false, speedSearchConverter);
        } else {
            TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.myTree);
        }
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(descriptor2.isChooseMultiple() ? 4 : 1);
        this.registerTreeActions();
        this.myTree.setCellRenderer(renderer2);
    }

    protected Comparator<? super NodeDescriptor<?>> getFileComparator() {
        return FileComparator.getInstance();
    }

    @ApiStatus.Internal
    @NotNull
    protected FileTreeModel createFileTreeModel(@NotNull FileChooserDescriptor descriptor2, @NotNull Tree tree2) {
        if (descriptor2 == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(0);
        }
        if (tree2 == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(1);
        }
        return new FileTreeModel(descriptor2, new FileRefresher(true, 3L, (NotNullProducer<? extends ModalityState>)((NotNullProducer)() -> ModalityState.stateForComponent((Component)tree2))));
    }

    private void registerTreeActions() {
        this.myTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSystemTreeImpl.this.performEnterAction(true);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                FileSystemTreeImpl.this.performEnterAction(false);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileChooser/ex/FileSystemTreeImpl$3", "onDoubleClick"));
            }
        }.installOn((Component)this.myTree);
    }

    private void performEnterAction(boolean toggleNodeState) {
        TreePath path = this.myTree.getSelectionPath();
        if (path != null) {
            if (this.isLeaf(path)) {
                this.fireOkAction();
            } else if (toggleNodeState) {
                if (this.myTree.isExpanded(path)) {
                    this.myTree.collapsePath(path);
                } else {
                    this.myTree.expandPath(path);
                }
            }
        }
    }

    public void addOkAction(Runnable action2) {
        this.myOkActions.add(action2);
    }

    private void fireOkAction() {
        for (Runnable action2 : this.myOkActions) {
            action2.run();
        }
    }

    public void registerMouseListener(ActionGroup group2) {
        PopupHandler.installPopupMenu((JComponent)this.myTree, (ActionGroup)group2, (String)"FileSystemTreePopup");
    }

    public boolean areHiddensShown() {
        return this.myDescriptor.isShowHiddenFiles();
    }

    public void showHiddens(boolean showHidden) {
        this.myDescriptor.withShowHiddenFiles(showHidden);
        this.updateTree();
    }

    public void updateTree() {
        if (this.myFileTreeModel instanceof FileTreeModel) {
            ((FileTreeModel)this.myFileTreeModel).invalidate();
        } else {
            ((StructureTreeModel)this.myFileTreeModel).invalidateAsync();
        }
    }

    public void dispose() {
    }

    public void select(VirtualFile file2, @Nullable Runnable onDone) {
        this.select(new VirtualFile[]{file2}, onDone);
    }

    public void select(VirtualFile[] file2, @Nullable Runnable onDone) {
        switch (file2.length) {
            case 0: {
                this.myTree.clearSelection();
                if (onDone == null) break;
                onDone.run();
                break;
            }
            case 1: {
                this.myTree.clearSelection();
                TreeUtil.promiseSelect((JTree)this.myTree, (TreeVisitor)new FileNodeVisitor(file2[0])).onProcessed(path -> {
                    if (onDone != null) {
                        onDone.run();
                    }
                });
                break;
            }
            default: {
                this.myTree.clearSelection();
                TreeUtil.promiseSelect((JTree)this.myTree, Stream.of(file2).map(FileNodeVisitor::new)).onProcessed(paths -> {
                    if (onDone != null) {
                        onDone.run();
                    }
                });
            }
        }
    }

    public void expand(VirtualFile file2, @Nullable Runnable onDone) {
        TreeUtil.promiseExpand((JTree)this.myTree, (TreeVisitor)new FileNodeVisitor(file2)).onSuccess(path -> {
            if (path != null && onDone != null) {
                onDone.run();
            }
        });
    }

    public Exception createNewFolder(final VirtualFile parentDirectory, final String newFolderName) {
        final Exception[] failReason = new Exception[]{null};
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VirtualFile parent = parentDirectory;
                            for (String name2 : StringUtil.tokenize((String)newFolderName, (String)"\\/")) {
                                VirtualFile folder = parent.createChildDirectory((Object)this, name2);
                                FileSystemTreeImpl.this.updateTree();
                                FileSystemTreeImpl.this.select(folder, null);
                                parent = folder;
                            }
                        }
                        catch (IOException e) {
                            failReason[0] = e;
                        }
                    }
                });
            }
        }, UIBundle.message((String)"file.chooser.create.new.folder.command.name", (Object[])new Object[0]), null);
        return failReason[0];
    }

    public Exception createNewFile(final VirtualFile parentDirectory, final String newFileName, final FileType fileType2, final String initialContent) {
        final Exception[] failReason = new Exception[]{null};
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String newFileNameWithExtension = newFileName.endsWith("." + fileType2.getDefaultExtension()) ? newFileName : newFileName + "." + fileType2.getDefaultExtension();
                            VirtualFile file2 = parentDirectory.createChildData((Object)this, newFileNameWithExtension);
                            VfsUtil.saveText((VirtualFile)file2, (String)(initialContent != null ? initialContent : ""));
                            FileSystemTreeImpl.this.updateTree();
                            FileSystemTreeImpl.this.select(file2, null);
                        }
                        catch (IOException e) {
                            failReason[0] = e;
                        }
                    }
                });
            }
        }, UIBundle.message((String)"file.chooser.create.new.file.command.name", (Object[])new Object[0]), null);
        return failReason[0];
    }

    public JTree getTree() {
        return this.myTree;
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return FileSystemTreeImpl.getVirtualFile(path);
    }

    @Nullable
    public VirtualFile getNewFileParent() {
        VirtualFile selected = this.getSelectedFile();
        if (selected != null) {
            return selected;
        }
        List roots = this.myDescriptor.getRoots();
        return roots.size() == 1 ? (VirtualFile)roots.get(0) : null;
    }

    public <T> T getData(@NotNull DataKey<T> key) {
        if (key == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(2);
        }
        return (T)this.myDescriptor.getUserData(key);
    }

    public VirtualFile @NotNull [] getSelectedFiles() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                FileSystemTreeImpl.$$$reportNull$$$0(3);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (TreePath path : paths) {
            VirtualFile file2 = FileSystemTreeImpl.getVirtualFile(path);
            if (file2 == null || !file2.isValid()) continue;
            files2.add(file2);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files2);
        if (virtualFileArray == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    private boolean isLeaf(TreePath path) {
        Object component2 = path.getLastPathComponent();
        if (component2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)component2;
            return node.isLeaf();
        }
        return this.myAsyncTreeModel.isLeaf(component2);
    }

    public static VirtualFile getVirtualFile(TreePath path) {
        Object node;
        Object userObject;
        Object component2 = path.getLastPathComponent();
        if (component2 instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)(node = (DefaultMutableTreeNode)component2)).getUserObject()) instanceof FileNodeDescriptor) {
            FileNodeDescriptor descriptor2 = (FileNodeDescriptor)((Object)userObject);
            return descriptor2.getElement().getFile();
        }
        if (component2 instanceof FileNode) {
            node = (FileNode)component2;
            return ((FileNode)node).getFile();
        }
        return null;
    }

    public boolean selectionExists() {
        TreePath[] selectedPaths = this.myTree.getSelectionPaths();
        return selectedPaths != null && selectedPaths.length != 0;
    }

    public boolean isUnderRoots(@NotNull VirtualFile file2) {
        List roots;
        if (file2 == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(5);
        }
        if ((roots = this.myDescriptor.getRoots()).isEmpty()) {
            return true;
        }
        for (VirtualFile root : roots) {
            if (root == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void addListener(final FileSystemTree.Listener listener2, Disposable parent) {
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                FileSystemTreeImpl.this.myListeners.remove(listener2);
            }
        });
    }

    private void fireSelection(@NotNull List<? extends VirtualFile> selection) {
        if (selection == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(6);
        }
        for (FileSystemTree.Listener each : this.myListeners) {
            each.selectionChanged(selection);
        }
    }

    private void processSelectionChange() {
        if (this.myListeners.isEmpty()) {
            return;
        }
        ArrayList<VirtualFile> selection = new ArrayList<VirtualFile>();
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath each : paths) {
                VirtualFile file2 = FileSystemTreeImpl.getVirtualFile(each);
                if (file2 == null) continue;
                selection.add(file2);
            }
        }
        this.fireSelection(selection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/ex/FileSystemTreeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileSystemTreeImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFileTreeModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fireSelection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

