/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.util.SystemProperties;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface VFSAttributesStorage
extends Forceable,
Closeable {
    public static final int MAX_ATTRIBUTE_VALUE_SIZE = SystemProperties.getIntProperty((String)"vfs.file-attribute-size-max", (int)819200);
    public static final int WARN_ATTRIBUTE_VALUE_SIZE = SystemProperties.getIntProperty((String)"vfs.file-attribute-size-warn", (int)102400);
    public static final int MAX_ATTRIBUTE_ID = SystemProperties.getIntProperty((String)"vfs.file-attribute-max-id", (int)8192);
    public static final int INLINE_ATTRIBUTE_SMALLER_THAN = 64;
    public static final int NON_EXISTENT_ATTRIBUTE_RECORD_ID = 0;

    public int getVersion() throws IOException;

    public void setVersion(int var1) throws IOException;

    @Nullable
    public AttributeInputStream readAttribute(@NotNull PersistentFSConnection var1, int var2, @NotNull FileAttribute var3) throws IOException;

    public boolean hasAttributePage(@NotNull PersistentFSConnection var1, int var2, @NotNull FileAttribute var3) throws IOException;

    @NotNull
    public AttributeOutputStream writeAttribute(@NotNull PersistentFSConnection var1, int var2, @NotNull FileAttribute var3);

    public void deleteAttributes(@NotNull PersistentFSConnection var1, int var2) throws IOException;

    public boolean isEmpty() throws IOException;

    public void checkAttributeRecordSanity(int var1, int var2) throws IOException;

    public static void checkAttributeValueSize(@NotNull FileAttribute attribute, int attributeValueSize) throws FileTooBigException {
        if (attribute == null) {
            VFSAttributesStorage.$$$reportNull$$$0(0);
        }
        if (attributeValueSize > MAX_ATTRIBUTE_VALUE_SIZE) {
            String message = "Attribute " + String.valueOf(attribute) + " value is too large: " + attributeValueSize + " b > max(" + MAX_ATTRIBUTE_VALUE_SIZE + ") -> please, do not use VFS file attributes for huge blobs of data. Consider using GistManager or GistStorage.";
            FSRecords.LOG.error(message);
            throw new FileTooBigException(message);
        }
        if (attributeValueSize > WARN_ATTRIBUTE_VALUE_SIZE) {
            FSRecords.THROTTLED_LOG.warn("Attribute " + String.valueOf(attribute) + " value is quite large: " + attributeValueSize + " b > warn threshold(" + WARN_ATTRIBUTE_VALUE_SIZE + ") -> please, do not use VFS file attributes for huge blobs of data. Consider using GistManager or GistStorage.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/openapi/vfs/newvfs/persistent/VFSAttributesStorage", "checkAttributeValueSize"));
    }
}

