/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.widget.StatusBarActionManager;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.psi.codeStyle.PlatformKeyboardLayoutConverter;
import com.intellij.psi.codeStyle.WordPrefixMatcher;
import com.intellij.util.text.matching.KeyboardLayoutConverter;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsOptionProvider;", "Lcom/intellij/ide/SearchTopHitProvider;", "<init>", "()V", "consumeTopHits", "", "pattern", "", "collector", "Ljava/util/function/Consumer;", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nStatusBarWidgetsOptionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatusBarWidgetsOptionProvider.kt\ncom/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsOptionProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,38:1\n42#2,3:39\n*S KotlinDebug\n*F\n+ 1 StatusBarWidgetsOptionProvider.kt\ncom/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsOptionProvider\n*L\n33#1:39,3\n*E\n"})
public final class StatusBarWidgetsOptionProvider
implements SearchTopHitProvider {
    public void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        if (project2 == null) {
            return;
        }
        StatusBarWidgetsManager manager2 = (StatusBarWidgetsManager)((Object)project2.getService(StatusBarWidgetsManager.class));
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
        if (statusBar == null) {
            return;
        }
        WordPrefixMatcher matcher = new WordPrefixMatcher(pattern, (KeyboardLayoutConverter)PlatformKeyboardLayoutConverter.INSTANCE);
        for (StatusBarWidgetFactory factory2 : manager2.getWidgetFactories()) {
            String name2;
            if (!manager2.canBeEnabledOnStatusBar(factory2, statusBar)) continue;
            Object[] objectArray = new Object[]{factory2.getDisplayName()};
            Intrinsics.checkNotNullExpressionValue((Object)IdeBundle.message((String)"label.show.status.bar.widget", (Object[])objectArray), (String)"message(...)");
            if (!matcher.matches(name2)) continue;
            boolean $i$f$service = false;
            Class<StatusBarActionManager> serviceClass$iv = StatusBarActionManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            collector.accept(((StatusBarActionManager)object).getActionFor(factory2));
        }
    }
}

