/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.impl.toolkit;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0012\u0010\u001a\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u0016J\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0016\u00a2\u0006\u0002\u0010\u001eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/platform/impl/toolkit/IdeClipboard;", "Ljava/awt/datatransfer/Clipboard;", "<init>", "()V", "flavorListeners", "", "Ljava/awt/datatransfer/FlavorListener;", "Lcom/intellij/openapi/Disposable;", "delegateToCopyPasteManager", "", "setContents", "", "contents", "Ljava/awt/datatransfer/Transferable;", "owner", "Ljava/awt/datatransfer/ClipboardOwner;", "getContents", "requestor", "", "getAvailableDataFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorAvailable", "flavor", "getData", "addFlavorListener", "listener", "removeFlavorListener", "getFlavorListeners", "()[Ljava/awt/datatransfer/FlavorListener;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeClipboard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeClipboard.kt\ncom/intellij/platform/impl/toolkit/IdeClipboard\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,107:1\n1#2:108\n37#3,2:109\n*S KotlinDebug\n*F\n+ 1 IdeClipboard.kt\ncom/intellij/platform/impl/toolkit/IdeClipboard\n*L\n100#1:109,2\n*E\n"})
public final class IdeClipboard
extends Clipboard {
    @NotNull
    private final Map<FlavorListener, Disposable> flavorListeners = new LinkedHashMap();

    public IdeClipboard() {
        super("System");
    }

    private final boolean delegateToCopyPasteManager() {
        return ApplicationManager.getApplication() != null && !ClientId.Companion.isCurrentlyUnderLocalId();
    }

    @Override
    public void setContents(@NotNull Transferable contents, @Nullable ClipboardOwner owner) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        if (this.delegateToCopyPasteManager()) {
            CopyPasteManager copyPasteManager = CopyPasteManager.getInstance();
            copyPasteManager.setContents(contents);
            if (owner != null) {
                Disposable disposable = Disposer.newDisposable((String)"IdeClipboard.setContents");
                Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                Disposable disposable2 = disposable;
                copyPasteManager.addContentChangedListener((arg_0, arg_1) -> IdeClipboard.setContents$lambda$0(disposable2, owner, this, contents, arg_0, arg_1), disposable2);
            }
        } else {
            super.setContents(contents, owner);
        }
    }

    @Override
    @Nullable
    public Transferable getContents(@Nullable Object requestor) {
        if (this.delegateToCopyPasteManager()) {
            return CopyPasteManager.getInstance().getContents();
        }
        return super.getContents(requestor);
    }

    @Override
    @NotNull
    public DataFlavor[] getAvailableDataFlavors() {
        if (this.delegateToCopyPasteManager()) {
            DataFlavor[] dataFlavorArray = CopyPasteManager.getInstance().getContents();
            if (dataFlavorArray == null || (dataFlavorArray = dataFlavorArray.getTransferDataFlavors()) == null) {
                dataFlavorArray = new DataFlavor[]{};
            }
            return dataFlavorArray;
        }
        DataFlavor[] dataFlavorArray = super.getAvailableDataFlavors();
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getAvailableDataFlavors(...)");
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorAvailable(@NotNull DataFlavor flavor2) {
        Intrinsics.checkNotNullParameter((Object)flavor2, (String)"flavor");
        if (this.delegateToCopyPasteManager()) {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{flavor2};
            return CopyPasteManager.getInstance().areDataFlavorsAvailable(dataFlavorArray);
        }
        return super.isDataFlavorAvailable(flavor2);
    }

    @Override
    @NotNull
    public Object getData(@NotNull DataFlavor flavor2) {
        Intrinsics.checkNotNullParameter((Object)flavor2, (String)"flavor");
        if (this.delegateToCopyPasteManager()) {
            Object object = CopyPasteManager.getInstance().getContents(flavor2);
            if (object == null) {
                throw new UnsupportedFlavorException(flavor2);
            }
            return object;
        }
        Object object = super.getData(flavor2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFlavorListener(@Nullable FlavorListener listener2) {
        if (this.delegateToCopyPasteManager()) {
            Map<FlavorListener, Disposable> map2 = this.flavorListeners;
            synchronized (map2) {
                boolean bl = false;
                if (listener2 != null && !this.flavorListeners.containsKey(listener2)) {
                    Disposable disposable = Disposer.newDisposable((String)"IdeClipboard.addFlavorListener");
                    Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                    Disposable disposable2 = disposable;
                    CopyPasteManager.getInstance().addContentChangedListener((arg_0, arg_1) -> IdeClipboard.addFlavorListener$lambda$0$0(listener2, this, arg_0, arg_1), disposable2);
                    this.flavorListeners.put(listener2, disposable2);
                }
                Unit unit = Unit.INSTANCE;
            }
        } else {
            super.addFlavorListener(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFlavorListener(@Nullable FlavorListener listener2) {
        if (this.delegateToCopyPasteManager()) {
            Map<FlavorListener, Disposable> map2 = this.flavorListeners;
            synchronized (map2) {
                Unit unit;
                boolean bl = false;
                Disposable disposable = (Disposable)TypeIntrinsics.asMutableMap(this.flavorListeners).remove(listener2);
                if (disposable != null) {
                    Disposable it = disposable;
                    boolean bl2 = false;
                    Disposer.dispose((Disposable)it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
        } else {
            super.removeFlavorListener(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FlavorListener[] getFlavorListeners() {
        if (this.delegateToCopyPasteManager()) {
            Map<FlavorListener, Disposable> map2 = this.flavorListeners;
            synchronized (map2) {
                boolean bl = false;
                Collection $this$toTypedArray$iv = this.flavorListeners.keySet();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                FlavorListener[] flavorListenerArray = thisCollection$iv.toArray(new FlavorListener[0]);
                return flavorListenerArray;
            }
        }
        FlavorListener[] flavorListenerArray = super.getFlavorListeners();
        Intrinsics.checkNotNullExpressionValue((Object)flavorListenerArray, (String)"getFlavorListeners(...)");
        return flavorListenerArray;
    }

    private static final void setContents$lambda$0(Disposable $disposable, ClipboardOwner $owner, IdeClipboard this$0, Transferable $contents, Transferable transferable, Transferable transferable2) {
        Disposer.dispose((Disposable)$disposable);
        $owner.lostOwnership(this$0, $contents);
    }

    private static final void addFlavorListener$lambda$0$0(FlavorListener $listener, IdeClipboard this$0, Transferable transferable, Transferable transferable2) {
        $listener.flavorsChanged(new FlavorEvent(this$0));
    }
}

