/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.BaseCollectionBinding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.WriteContext;
import com.intellij.util.SmartList;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u0004\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u0004\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0014H\u0016J \u0010\u000b\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u000eH\u0016J\u001c\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0002R\u0017\u0010\b\u001a\u000b\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/serialization/CollectionBinding;", "Lcom/intellij/serialization/BaseCollectionBinding;", "type", "Ljava/lang/reflect/ParameterizedType;", "context", "Lcom/intellij/serialization/BindingInitializationContext;", "<init>", "(Ljava/lang/reflect/ParameterizedType;Lcom/intellij/serialization/BindingInitializationContext;)V", "collectionClass", "Ljava/lang/Class;", "Lorg/jetbrains/annotations/NotNull;", "deserialize", "", "", "Lcom/intellij/serialization/ReadContext;", "hostObject", "readEmptyCollection", "serialize", "", "obj", "Lcom/intellij/serialization/WriteContext;", "property", "Lcom/intellij/serialization/MutableAccessor;", "createCollection", "", "propertyForDebugPurposes", "intellij.platform.objectSerializer"})
@SourceDebugExtension(value={"SMAP\nCollectionBinding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionBinding.kt\ncom/intellij/serialization/CollectionBinding\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1915#2,2:123\n*S KotlinDebug\n*F\n+ 1 CollectionBinding.kt\ncom/intellij/serialization/CollectionBinding\n*L\n58#1:123,2\n*E\n"})
public final class CollectionBinding
extends BaseCollectionBinding {
    @NotNull
    private final Class<?> collectionClass;

    public CollectionBinding(@NotNull ParameterizedType type, @NotNull BindingInitializationContext context2) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Type type2 = type.getActualTypeArguments()[0];
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"get(...)");
        super(type2, context2);
        Class clazz = ClassUtil.typeToClass((Type)type);
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"typeToClass(...)");
        this.collectionClass = clazz;
    }

    @Override
    @NotNull
    public Collection<Object> deserialize(@NotNull ReadContext context2, @Nullable Object hostObject) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getReader().getType() == IonType.INT) {
            return this.readEmptyCollection(context2);
        }
        Collection result2 = CollectionBinding.createCollection$default(this, null, 1, null);
        this.readInto(hostObject, result2, context2);
        return result2;
    }

    private final Collection<Object> readEmptyCollection(ReadContext context2) {
        return switch (context2.getReader().intValue()) {
            case 1 -> {
                List v0 = Collections.EMPTY_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"EMPTY_LIST");
                yield v0;
            }
            case 3 -> CollectionsKt.emptyList();
            case 2 -> {
                Set v2 = Collections.EMPTY_SET;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"EMPTY_SET");
                yield v2;
            }
            case 4 -> SetsKt.emptySet();
            default -> Set.class.isAssignableFrom(this.collectionClass) ? (Collection)SetsKt.emptySet() : (Collection)CollectionsKt.emptyList();
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context2) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IonWriter writer = context2.writer;
        Collection collection = (Collection)obj2;
        if (context2.filter.getSkipEmptyCollection() && collection.isEmpty()) {
            writer.writeInt(0L);
            return;
        }
        if (collection == Collections.EMPTY_LIST) {
            writer.writeInt(1L);
        } else if (collection == CollectionsKt.emptyList()) {
            writer.writeInt(3L);
        } else if (collection == Collections.EMPTY_SET) {
            writer.writeInt(2L);
        } else if (collection == CollectionsKt.emptyList()) {
            writer.writeInt(4L);
        } else {
            void $this$forEach$iv;
            writer.stepIn(IonType.LIST);
            Iterable iterable = collection;
            Function1<Object, Unit> action$iv = this.createItemConsumer(context2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action$iv.invoke(element$iv);
            }
            writer.stepOut();
        }
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull ReadContext context2) {
        Object object;
        Collection result2;
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IonType type = context2.getReader().getType();
        Collection<Object> emptyResult = null;
        if (type == IonType.NULL) {
            property.set(hostObject, null);
            return;
        }
        if (type == IonType.INT) {
            emptyResult = this.readEmptyCollection(context2);
        }
        Collection collection = result2 = TypeIntrinsics.isMutableCollection((Object)(object = property.readUnsafe(hostObject))) ? (Collection)object : null;
        if (result2 != null && ClassUtil.isMutableCollection((Object)result2)) {
            result2.clear();
            if (emptyResult != null) {
                return;
            }
        } else {
            if (emptyResult != null) {
                property.set(hostObject, emptyResult);
                return;
            }
            result2 = CollectionBinding.createCollection$default(this, null, 1, null);
            property.set(hostObject, (Object)result2);
        }
        this.readInto(hostObject, result2, context2);
    }

    private final Collection<Object> createCollection(MutableAccessor propertyForDebugPurposes) {
        if (this.collectionClass.isInterface()) {
            Class<?> clazz = this.collectionClass;
            if (Intrinsics.areEqual(clazz, Set.class)) {
                return new HashSet();
            }
            if (Intrinsics.areEqual(clazz, List.class) || Intrinsics.areEqual(clazz, Collection.class)) {
                return new ArrayList();
            }
        } else {
            Collection collection;
            Class<?> clazz = this.collectionClass;
            if (Intrinsics.areEqual(clazz, HashSet.class)) {
                collection = new HashSet();
            } else if (Intrinsics.areEqual(clazz, ArrayList.class)) {
                collection = new ArrayList();
            } else if (Intrinsics.areEqual(clazz, SmartList.class)) {
                collection = (Collection)new SmartList();
            } else {
                Constructor<?> constructor = this.collectionClass.getDeclaredConstructor(new Class[0]);
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                Object obj2 = constructor.newInstance(new Object[0]);
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type kotlin.collections.MutableCollection<kotlin.Any?>");
                return TypeIntrinsics.asMutableCollection(obj2);
            }
            return collection;
        }
        ObjectSerializerKt.getLOG().warn("Unknown collection type interface: " + this.collectionClass + " (property: " + propertyForDebugPurposes + ")");
        return new ArrayList();
    }

    static /* synthetic */ Collection createCollection$default(CollectionBinding collectionBinding, MutableAccessor mutableAccessor, int n, Object object) {
        if ((n & 1) != 0) {
            mutableAccessor = null;
        }
        return collectionBinding.createCollection(mutableAccessor);
    }
}

