/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.ActionCenter;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.NotificationBalloonRoundShadowBorderProvider;
import com.intellij.ui.ShadowJava2DPainter;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u00011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J,\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J1\u0010\u0019\u001a\b\u0018\u00010\u000bR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010\u001e\u001a\u00060\u000bR\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001cH\u0002J$\u0010\u001f\u001a\u00060\u000bR\u00020\u00002\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010!\u001a\u00060\u000bR\u00020\u00002\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u001cH\u0014J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\rH\u0014J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0013\u001a\u00020\nH\u0014J&\u0010+\u001a\u00020\r2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0014R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/ui/ActionCenterBalloonLayout;", "Lcom/intellij/ui/BalloonLayoutImpl;", "parent", "Ljavax/swing/JRootPane;", "insets", "Ljava/awt/Insets;", "<init>", "(Ljavax/swing/JRootPane;Ljava/awt/Insets;)V", "collapsedData", "Ljava/util/HashMap;", "Lcom/intellij/openapi/ui/popup/Balloon;", "Lcom/intellij/ui/ActionCenterBalloonLayout$CollapseInfo;", "dispose", "", "add", "newBalloon", "layoutData", "", "addNewBalloon", "balloon", "callback", "Lkotlin/Function0;", "doCollapse", "newLayoutData", "Lcom/intellij/ui/BalloonLayoutData;", "doCollapseForNewBalloon", "useExist", "", "", "(Lcom/intellij/openapi/ui/popup/Balloon;Lcom/intellij/ui/BalloonLayoutData;[Ljava/lang/Boolean;)Lcom/intellij/ui/ActionCenterBalloonLayout$CollapseInfo;", "doCollapseForExistBalloon", "doCollapseForBalloons", "oldBalloon", "createCollapsedData", "remove", "hide", "preMerge", "Lcom/intellij/ui/BalloonLayoutData$MergeInfo;", "notification", "Lcom/intellij/notification/Notification;", "calculateSize", "getSize", "Ljava/awt/Dimension;", "setBounds", "balloons", "", "startX", "", "startY", "CollapseInfo", "intellij.platform.ide.impl"})
public final class ActionCenterBalloonLayout
extends BalloonLayoutImpl {
    @NotNull
    private final HashMap<Balloon, CollapseInfo> collapsedData;

    public ActionCenterBalloonLayout(@NotNull JRootPane parent, @NotNull Insets insets) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        super(parent, insets);
        this.collapsedData = new HashMap();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.collapsedData.clear();
    }

    @Override
    public void add(@NotNull Balloon newBalloon, @Nullable Object layoutData) {
        Intrinsics.checkNotNullParameter((Object)newBalloon, (String)"newBalloon");
        ThreadingAssertions.assertEventDispatchThread();
        if (layoutData instanceof BalloonLayoutData) {
            if (((BalloonLayoutData)layoutData).collapseType == null) {
                throw new NullPointerException();
            }
            int size2 = this.balloons.size();
            Iterator iterator2 = this.balloons.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Balloon balloon = (Balloon)e;
                if (this.getLayoutData().get(balloon) != null) continue;
                --size2;
                break;
            }
            if (size2 < 3) {
                ActionCenterBalloonLayout.addNewBalloon$default(this, newBalloon, layoutData, null, 4, null);
            } else {
                this.doCollapse(newBalloon, (BalloonLayoutData)layoutData);
            }
        } else {
            Iterator iterator4 = this.balloons.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
            Iterator iterator5 = iterator4;
            while (iterator5.hasNext()) {
                Object e = iterator5.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Balloon balloon = (Balloon)e;
                if (this.getLayoutData().get(balloon) != null) continue;
                this.remove(balloon);
                break;
            }
            ActionCenterBalloonLayout.addNewBalloon$default(this, newBalloon, null, null, 4, null);
        }
    }

    private final void addNewBalloon(Balloon balloon, Object layoutData, Function0<Unit> callback) {
        this.balloons.add(balloon);
        if (layoutData instanceof BalloonLayoutData) {
            ((BalloonLayoutData)layoutData).closeAll = this::closeAll;
            ((BalloonLayoutData)layoutData).doLayout = this.layoutRunnable;
            ((Map)this.getLayoutData()).put(balloon, layoutData);
        }
        Disposer.register((Disposable)((Disposable)balloon), () -> ActionCenterBalloonLayout.addNewBalloon$lambda$0(this, balloon));
        this.calculateSize();
        this.relayout();
        if (!balloon.isDisposed()) {
            balloon.show(this.layeredPane);
        }
        Function0<Unit> function0 = callback;
        if (function0 != null) {
            function0.invoke();
        }
        this.fireRelayout();
    }

    static /* synthetic */ void addNewBalloon$default(ActionCenterBalloonLayout actionCenterBalloonLayout, Balloon balloon, Object object, Function0 function0, int n, Object object2) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        actionCenterBalloonLayout.addNewBalloon(balloon, object, (Function0<Unit>)function0);
    }

    private final void doCollapse(Balloon newBalloon, BalloonLayoutData newLayoutData) {
        int n = 0;
        Boolean[] booleanArray = new Boolean[1];
        while (n < 1) {
            int n2 = n++;
            booleanArray[n2] = false;
        }
        Boolean[] exist = booleanArray;
        CollapseInfo collapseInfo = this.doCollapseForNewBalloon(newBalloon, newLayoutData, exist);
        if (collapseInfo == null) {
            collapseInfo = this.doCollapseForExistBalloon(newLayoutData, exist[0]);
        }
        CollapseInfo info = collapseInfo;
        info.addBalloon();
        this.addNewBalloon(newBalloon, newLayoutData, (Function0<Unit>)((Function0)() -> ActionCenterBalloonLayout.doCollapse$lambda$0(info, this)));
    }

    private final CollapseInfo doCollapseForNewBalloon(Balloon newBalloon, BalloonLayoutData newLayoutData, Boolean[] useExist) {
        Balloon balloon;
        int count = 0;
        Iterator iterator2 = this.balloons.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            balloon = (Balloon)e;
            BalloonLayoutData balloonLayoutData = this.getLayoutData().get(balloon);
            if ((balloonLayoutData != null ? balloonLayoutData.collapseType : null) != newLayoutData.collapseType || ++count <= 1) continue;
            useExist[0] = true;
            return null;
        }
        Iterator iterator4 = this.balloons.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator3 = iterator4;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            balloon = (Balloon)e;
            BalloonLayoutData balloonLayoutData = this.getLayoutData().get(balloon);
            if ((balloonLayoutData != null ? balloonLayoutData.collapseType : null) != newLayoutData.collapseType) continue;
            return this.doCollapseForBalloons(balloon, newBalloon, newLayoutData);
        }
        return null;
    }

    private final CollapseInfo doCollapseForExistBalloon(BalloonLayoutData newLayoutData, boolean useExist) {
        int size2 = this.balloons.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            Object e = this.balloons.get(i2);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            Balloon balloon = (Balloon)e;
            BalloonLayoutData layoutData = this.getLayoutData().get(balloon);
            if (layoutData == null || layoutData.collapseType == newLayoutData.collapseType != useExist) continue;
            for (int j = i2 + 1; j < size2; ++j) {
                Object e2 = this.balloons.get(j);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                Balloon nextBalloon = (Balloon)e2;
                BalloonLayoutData nextLayoutData = this.getLayoutData().get(nextBalloon);
                if (nextLayoutData == null || layoutData.collapseType != nextLayoutData.collapseType) continue;
                return this.doCollapseForBalloons(balloon, nextBalloon, newLayoutData);
            }
        }
        throw new IllegalStateException();
    }

    private final CollapseInfo doCollapseForBalloons(Balloon oldBalloon, Balloon newBalloon, BalloonLayoutData newLayoutData) {
        CollapseInfo info = this.collapsedData.get(oldBalloon);
        if (info == null) {
            this.remove(oldBalloon);
            return this.createCollapsedData(newBalloon, newLayoutData).updateHost(newBalloon);
        }
        this.collapsedData.remove(oldBalloon);
        this.remove(oldBalloon);
        ((Map)this.collapsedData).put(newBalloon, info.updateHost(newBalloon));
        return info;
    }

    private final CollapseInfo createCollapsedData(Balloon balloon, BalloonLayoutData newLayoutData) {
        String titleEnd = newLayoutData.collapseType == BalloonLayoutData.Type.Timeline ? "notifications.collapse.balloon.title.timeline" : "notifications.collapse.balloon.title.suggestion";
        CollapseInfo newCollapseInfo = new CollapseInfo(titleEnd);
        ((Map)this.collapsedData).put(balloon, newCollapseInfo);
        return newCollapseInfo;
    }

    @Override
    protected void remove(@NotNull Balloon balloon, boolean hide) {
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
        CollapseInfo collapseInfo = this.collapsedData.remove(balloon);
        if (collapseInfo != null) {
            collapseInfo.hide();
        }
        super.remove(balloon, hide);
    }

    @Override
    @Nullable
    public BalloonLayoutData.MergeInfo preMerge(@NotNull Notification notification2) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        return null;
    }

    @Override
    protected void calculateSize() {
        super.calculateSize();
        Iterator iterator2 = this.balloons.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Balloon balloon = (Balloon)e;
            CollapseInfo collapseInfo = this.collapsedData.get(balloon);
            if (collapseInfo == null) continue;
            collapseInfo.calculateSize();
        }
    }

    @Override
    @NotNull
    protected Dimension getSize(@NotNull Balloon balloon) {
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
        Dimension size2 = super.getSize(balloon);
        CollapseInfo info = this.collapsedData.get(balloon);
        if (info != null) {
            size2.height += info.getHeight();
        }
        return size2;
    }

    @Override
    protected void setBounds(@NotNull List<? extends Balloon> balloons, int startX, int startY) {
        Intrinsics.checkNotNullParameter(balloons, (String)"balloons");
        int shadowVerticalOffset = 0;
        int verticalOffset = 0;
        int startX2 = startX;
        int y = startY;
        int startOffset = JBUI.scale((int)10);
        Insets insets = ShadowJava2DPainter.Type.NOTIFICATION.getInsets();
        int rightOffset = startOffset - insets.right;
        int bottomOffset = startOffset - insets.bottom;
        if (bottomOffset > 0) {
            y -= bottomOffset;
        }
        if (rightOffset > 0) {
            startX2 -= rightOffset;
        }
        for (Balloon balloon : balloons) {
            Rectangle bounds = new Rectangle(super.getSize(balloon));
            CollapseInfo info = this.collapsedData.get(balloon);
            if (info != null) {
                int offset = shadowVerticalOffset;
                info.getBalloon().setBounds(new Rectangle(startX2 - bounds.width, y - info.getFullHeight() + offset, bounds.width, info.getFullHeight()));
                y -= info.getHeight();
            }
            verticalOffset = shadowVerticalOffset;
            bounds.setLocation(startX2 - bounds.width, y -= bounds.height - verticalOffset);
            balloon.setBounds(bounds);
        }
    }

    private static final void addNewBalloon$lambda$0(ActionCenterBalloonLayout this$0, Balloon $balloon) {
        this$0.remove($balloon, false);
        this$0.queueRelayout();
    }

    private static final Unit doCollapse$lambda$0(CollapseInfo $info, ActionCenterBalloonLayout this$0) {
        JLayeredPane jLayeredPane = this$0.layeredPane;
        Intrinsics.checkNotNull((Object)jLayeredPane);
        $info.show(jLayeredPane);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\"\u001a\u00060\u0000R\u00020#2\u0006\u0010$\u001a\u00020\u0013J\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020&J\u0006\u0010+\u001a\u00020&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000b\"\u0004\b\u001e\u0010\rR\u001a\u0010\u001f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\r\u00a8\u0006,"}, d2={"Lcom/intellij/ui/ActionCenterBalloonLayout$CollapseInfo;", "", "titleEnd", "", "<init>", "(Lcom/intellij/ui/ActionCenterBalloonLayout;Ljava/lang/String;)V", "getTitleEnd", "()Ljava/lang/String;", "collapsedBalloons", "", "getCollapsedBalloons", "()I", "setCollapsedBalloons", "(I)V", "titleLabel", "Lcom/intellij/ui/components/labels/LinkLabel;", "getTitleLabel", "()Lcom/intellij/ui/components/labels/LinkLabel;", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "getBalloon", "()Lcom/intellij/openapi/ui/popup/Balloon;", "doShow", "", "getDoShow", "()Z", "setDoShow", "(Z)V", "height", "getHeight", "setHeight", "fullHeight", "getFullHeight", "setFullHeight", "updateHost", "Lcom/intellij/ui/ActionCenterBalloonLayout;", "hostBalloon", "addBalloon", "", "show", "pane", "Ljavax/swing/JLayeredPane;", "hide", "calculateSize", "intellij.platform.ide.impl"})
    private final class CollapseInfo {
        @NotNull
        private final String titleEnd;
        private int collapsedBalloons;
        @NotNull
        private final LinkLabel<Object> titleLabel;
        @NotNull
        private final Balloon balloon;
        private boolean doShow;
        private int height;
        private int fullHeight;

        public CollapseInfo(String titleEnd) {
            Intrinsics.checkNotNullParameter((Object)titleEnd, (String)"titleEnd");
            this.titleEnd = titleEnd;
            this.doShow = true;
            this.titleLabel = (LinkLabel)new LinkLabel<Object>(){

                protected boolean isInClickableArea(Point pt) {
                    Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
                    return true;
                }

                protected Color getTextColor() {
                    Color color = NotificationsUtil.getMoreButtonForeground();
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getMoreButtonForeground(...)");
                    return color;
                }
            };
            (this.titleLabel).setPaintUnderline(false);
            (this.titleLabel).setFont((Font)JBFont.medium());
            (this.titleLabel).setHorizontalAlignment(0);
            (this.titleLabel).setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)4, (int)0));
            (this.titleLabel).setIcon(null);
            (this.titleLabel).setListener((arg_0, arg_1) -> CollapseInfo._init_$lambda$0(this, ActionCenterBalloonLayout.this, arg_0, arg_1), null);
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setOpaque(false);
            panel2.add((Component)this.titleLabel);
            BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)panel2);
            Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"createBalloonBuilder(...)");
            BalloonBuilder builder = balloonBuilder;
            builder.setFillColor(NotificationsUtil.getMoreButtonBackground()).setCloseButtonEnabled(true).setShowCallout(false).setShadow(false).setAnimationCycle(0).setHideOnClickOutside(false).setHideOnAction(false).setHideOnKeyOutside(false).setHideOnFrameResize(false).setBorderColor(NotificationsManagerImpl.BORDER_COLOR).setBorderInsets((Insets)JBInsets.emptyInsets());
            Balloon balloon = builder.createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
            this.balloon = balloon;
            if (this.balloon instanceof BalloonImpl) {
                ((BalloonImpl)this.balloon).setAnimationEnabled(false);
                ((BalloonImpl)this.balloon).setZeroPositionInLayer(false);
                Color color = NotificationsUtil.getMoreButtonBackground();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getMoreButtonBackground(...)");
                Color color2 = NotificationsManagerImpl.BORDER_COLOR;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"BORDER_COLOR");
                NotificationBalloonRoundShadowBorderProvider provider = new NotificationBalloonRoundShadowBorderProvider(color, color2);
                ((BalloonImpl)this.balloon).setShadowBorderProvider(provider);
                provider.hideSide(true, false);
                ((BalloonImpl)this.balloon).setActionProvider(new BalloonImpl.ActionProvider(){

                    @Override
                    public List<BalloonImpl.ActionButton> createActions() {
                        List<BalloonImpl.ActionButton> list2 = Collections.emptyList();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList(...)");
                        return list2;
                    }

                    @Override
                    public void layout(Rectangle bounds) {
                        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
                    }
                });
            }
        }

        @NotNull
        public final String getTitleEnd() {
            return this.titleEnd;
        }

        public final int getCollapsedBalloons() {
            return this.collapsedBalloons;
        }

        public final void setCollapsedBalloons(int n) {
            this.collapsedBalloons = n;
        }

        @NotNull
        public final LinkLabel<Object> getTitleLabel() {
            return this.titleLabel;
        }

        @NotNull
        public final Balloon getBalloon() {
            return this.balloon;
        }

        public final boolean getDoShow() {
            return this.doShow;
        }

        public final void setDoShow(boolean bl) {
            this.doShow = bl;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public final int getFullHeight() {
            return this.fullHeight;
        }

        public final void setFullHeight(int n) {
            this.fullHeight = n;
        }

        @NotNull
        public final CollapseInfo updateHost(@NotNull Balloon hostBalloon) {
            BalloonImpl.ShadowBorderProvider provider;
            Intrinsics.checkNotNullParameter((Object)hostBalloon, (String)"hostBalloon");
            if (hostBalloon instanceof BalloonImpl && (provider = ((BalloonImpl)hostBalloon).getShadowBorderProvider()) instanceof NotificationBalloonRoundShadowBorderProvider) {
                ((NotificationBalloonRoundShadowBorderProvider)provider).hideSide(false, true);
            }
            return this;
        }

        public final void addBalloon() {
            int n = this.collapsedBalloons;
            this.collapsedBalloons = n + 1;
            Object[] objectArray = new Object[2];
            objectArray[0] = this.collapsedBalloons;
            Object[] objectArray2 = new Object[]{this.collapsedBalloons};
            objectArray[1] = IdeBundle.message((String)this.titleEnd, (Object[])objectArray2);
            this.titleLabel.setText(IdeBundle.message((String)"notifications.collapse.balloon.title", (Object[])objectArray));
        }

        public final void show(@NotNull JLayeredPane pane2) {
            Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
            if (this.doShow) {
                this.doShow = false;
                this.balloon.show(pane2);
            }
        }

        public final void hide() {
            this.balloon.hide();
        }

        public final void calculateSize() {
            if (this.balloon instanceof BalloonImpl) {
                Insets insets = ((BalloonImpl)this.balloon).getShadowBorderInsets();
                Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getShadowBorderInsets(...)");
                Insets insets2 = insets;
                this.fullHeight = ((BalloonImpl)this.balloon).getPreferredSize().height;
                this.height = this.fullHeight - JBUI.scale((int)7) - insets2.top - insets2.bottom;
            }
        }

        private static final void _init_$lambda$0(CollapseInfo this$0, ActionCenterBalloonLayout this$1, LinkLabel linkLabel, Object object) {
            DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this$0.titleLabel);
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
            if (project2 != null) {
                this$1.closeAll();
                ActionCenter.showLog(project2);
            }
        }
    }
}

