/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.popup.ActionPopupStep;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.InlineActionsUtilKt;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupInlineActionsSupport;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J!\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0016J$\u0010\u0015\u001a\u00020\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0016J \u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010$\u001a\u00020\u001e2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ui/popup/list/PopupInlineActionsSupportImpl;", "Lcom/intellij/ui/popup/list/PopupInlineActionsSupport;", "myListPopup", "Lcom/intellij/ui/popup/list/ListPopupImpl;", "<init>", "(Lcom/intellij/ui/popup/list/ListPopupImpl;)V", "myStep", "Lcom/intellij/ui/popup/ActionPopupStep;", "calcExtraButtonsCount", "", "element", "", "calcButtonIndex", "point", "Ljava/awt/Point;", "(Ljava/lang/Object;Ljava/awt/Point;)Ljava/lang/Integer;", "getToolTipText", "", "index", "getKeepPopupOnPerform", "Lcom/intellij/openapi/actionSystem/KeepPopupOnPerform;", "performAction", "", "event", "Ljava/awt/event/InputEvent;", "createExtraButtons", "", "Ljavax/swing/JComponent;", "value", "isSelected", "", "activeIndex", "createActionButton", "item", "Lcom/intellij/ui/popup/PopupFactoryImpl$ActionItem;", "active", "isMoreButton", "hasMoreButton", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPopupInlineActionsSupportImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PopupInlineActionsSupportImpl.kt\ncom/intellij/ui/popup/list/PopupInlineActionsSupportImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1924#2,3:100\n*S KotlinDebug\n*F\n+ 1 PopupInlineActionsSupportImpl.kt\ncom/intellij/ui/popup/list/PopupInlineActionsSupportImpl\n*L\n66#1:100,3\n*E\n"})
public final class PopupInlineActionsSupportImpl
implements PopupInlineActionsSupport {
    @NotNull
    private final ListPopupImpl myListPopup;
    @NotNull
    private final ActionPopupStep myStep;

    public PopupInlineActionsSupportImpl(@NotNull ListPopupImpl myListPopup) {
        Intrinsics.checkNotNullParameter((Object)myListPopup, (String)"myListPopup");
        this.myListPopup = myListPopup;
        ListPopupStep<Object> listPopupStep = this.myListPopup.getListStep();
        Intrinsics.checkNotNull(listPopupStep, (String)"null cannot be cast to non-null type com.intellij.ui.popup.ActionPopupStep");
        this.myStep = (ActionPopupStep)listPopupStep;
    }

    @Override
    public int calcExtraButtonsCount(@Nullable Object element) {
        if (!ExperimentalUI.Companion.isNewUI() || !(element instanceof PopupFactoryImpl.ActionItem)) {
            return 0;
        }
        int res = 0;
        res += this.myStep.getInlineItems((PopupFactoryImpl.ActionItem)element).size();
        if (this.hasMoreButton((PopupFactoryImpl.ActionItem)element)) {
            ++res;
        }
        return res;
    }

    @Override
    @Nullable
    public Integer calcButtonIndex(@Nullable Object element, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (element == null) {
            return null;
        }
        int buttonsCount = this.calcExtraButtonsCount(element);
        if (buttonsCount <= 0) {
            return null;
        }
        JList jList = this.myListPopup.getList();
        Intrinsics.checkNotNullExpressionValue((Object)jList, (String)"getList(...)");
        return InlineActionsUtilKt.calcButtonIndex(jList, buttonsCount, point);
    }

    @Override
    @Nullable
    public String getToolTipText(@Nullable Object element, int index) {
        String string;
        if (!(element instanceof PopupFactoryImpl.ActionItem)) {
            string = null;
        } else if (this.isMoreButton(element, index)) {
            string = IdeBundle.message((String)"inline.actions.more.actions.text", (Object[])new Object[0]);
        } else {
            PopupFactoryImpl.ActionItem actionItem = this.myStep.getInlineItems((PopupFactoryImpl.ActionItem)element).get(index);
            string = actionItem != null ? actionItem.getText() : null;
        }
        return string;
    }

    @Override
    @NotNull
    public KeepPopupOnPerform getKeepPopupOnPerform(@Nullable Object element, int index) {
        KeepPopupOnPerform keepPopupOnPerform;
        if (!(element instanceof PopupFactoryImpl.ActionItem)) {
            keepPopupOnPerform = KeepPopupOnPerform.Always;
        } else if (this.isMoreButton(element, index)) {
            keepPopupOnPerform = KeepPopupOnPerform.Always;
        } else {
            KeepPopupOnPerform keepPopupOnPerform2 = this.myStep.getInlineItems((PopupFactoryImpl.ActionItem)element).get(index).getKeepPopupOnPerform();
            keepPopupOnPerform = keepPopupOnPerform2;
            Intrinsics.checkNotNullExpressionValue((Object)keepPopupOnPerform2, (String)"getKeepPopupOnPerform(...)");
        }
        return keepPopupOnPerform;
    }

    @Override
    public void performAction(@Nullable Object element, int index, @Nullable InputEvent event) {
        if (element instanceof PopupFactoryImpl.ActionItem) {
            if (this.isMoreButton(element, index)) {
                this.myListPopup.showNextStepPopup(this.myStep.onChosen((PopupFactoryImpl.ActionItem)element, false), element);
            } else {
                PopupFactoryImpl.ActionItem item = this.myStep.getInlineItems((PopupFactoryImpl.ActionItem)element).get(index);
                this.myStep.performActionItem(item, event);
                this.myStep.updateStepItems(this.myListPopup.getList());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<JComponent> createExtraButtons(@Nullable Object value, boolean isSelected, int activeIndex) {
        if (!(value instanceof PopupFactoryImpl.ActionItem)) {
            return CollectionsKt.emptyList();
        }
        List<PopupFactoryImpl.ActionItem> list2 = this.myStep.getInlineItems((PopupFactoryImpl.ActionItem)value);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getInlineItems(...)");
        List<PopupFactoryImpl.ActionItem> inlineItems = list2;
        ArrayList<JComponent> buttons = new ArrayList<JComponent>();
        Iterable $this$forEachIndexed$iv = inlineItems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PopupFactoryImpl.ActionItem actionItem = (PopupFactoryImpl.ActionItem)item$iv;
            int index = n;
            boolean bl = false;
            if (!isSelected && !Intrinsics.areEqual(item.getClientProperty(ActionUtil.ALWAYS_VISIBLE_INLINE_ACTION), (Object)true)) continue;
            Intrinsics.checkNotNull((Object)item);
            buttons.add(this.createActionButton((PopupFactoryImpl.ActionItem)item, index == activeIndex, isSelected));
        }
        if ((isSelected || !((Collection)buttons).isEmpty()) && this.hasMoreButton((PopupFactoryImpl.ActionItem)value)) {
            Icon icon2 = this.myStep.isFinal((PopupFactoryImpl.ActionItem)value) ? AllIcons.Actions.More : AllIcons.Icons.Ide.MenuArrow;
            Intrinsics.checkNotNull((Object)icon2);
            Icon icon3 = icon2;
            buttons.add(InlineActionsUtilKt.createExtraButton(icon3, buttons.size() == activeIndex));
        }
        return buttons;
    }

    private final JComponent createActionButton(PopupFactoryImpl.ActionItem item, boolean active, boolean isSelected) {
        Icon icon2 = item.getIcon(isSelected);
        if (icon2 == null) {
            throw new AssertionError((Object)("null inline item icon for action '" + item.getAction().getClass().getName() + "'"));
        }
        return InlineActionsUtilKt.createExtraButton(icon2, active);
    }

    @Override
    public boolean isMoreButton(@Nullable Object element, int index) {
        if (!(element instanceof PopupFactoryImpl.ActionItem) || !this.hasMoreButton((PopupFactoryImpl.ActionItem)element)) {
            return false;
        }
        int count = this.calcExtraButtonsCount(element);
        return count > 0 && index == count - 1;
    }

    private final boolean hasMoreButton(PopupFactoryImpl.ActionItem element) {
        return this.myStep.hasSubstep(element) && !this.myListPopup.isShowSubmenuOnHover() && this.myStep.isFinal(element);
    }
}

