/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.TreeNodePresentation;
import com.intellij.ui.treeStructure.TreeNodePresentationBuilder;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u001a\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"buildPresentation", "Lcom/intellij/ui/treeStructure/TreeNodePresentation;", "builder", "Lcom/intellij/ui/treeStructure/TreeNodePresentationBuilder;", "userObject", "", "getSimpleTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "color", "Ljava/awt/Color;", "node", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "addColorToSimpleTextAttributes", "simpleTextAttributes", "colorsScheme", "intellij.platform.ide.impl"})
public final class TreeStructureDomainModelAdapterKt {
    @NotNull
    public static final TreeNodePresentation buildPresentation(@NotNull TreeNodePresentationBuilder builder, @NotNull Object userObject) {
        Object attributes;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        if (!(userObject instanceof PresentableNodeDescriptor)) {
            builder.setMainText(userObject.toString());
            return builder.build();
        }
        ((PresentableNodeDescriptor)userObject).update();
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getSchemeForCurrentUITheme(...)");
        EditorColorsScheme colorScheme = editorColorsScheme;
        PresentationData presentationData = ((PresentableNodeDescriptor)userObject).getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentationData, (String)"getPresentation(...)");
        PresentationData presentation2 = presentationData;
        TreeNodePresentationBuilder $this$buildPresentation_u24lambda_u240 = builder;
        boolean bl = false;
        $this$buildPresentation_u24lambda_u240.setIcon(presentation2.getIcon(false));
        String string = presentation2.getPresentableText();
        if (string == null) {
            string = "";
        }
        String mainText = string;
        $this$buildPresentation_u24lambda_u240.setMainText(mainText);
        SimpleTextAttributes locationAttributes = null;
        Color forcedColor = presentation2.getForcedTextForeground();
        if (presentation2.getColoredText().isEmpty()) {
            Color color = forcedColor;
            if (color == null) {
                color = ((PresentableNodeDescriptor)userObject).getColor();
            }
            Color color2 = color;
            attributes = TreeStructureDomainModelAdapterKt.getSimpleTextAttributes(presentation2, color2, userObject, colorScheme);
            $this$buildPresentation_u24lambda_u240.appendTextFragment(mainText, (SimpleTextAttributes)attributes);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.merge((SimpleTextAttributes)attributes, (SimpleTextAttributes)SimpleTextAttributes.GRAYED_ATTRIBUTES);
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"merge(...)");
            locationAttributes = simpleTextAttributes;
        } else {
            boolean first = true;
            for (PresentableNodeDescriptor.ColoredFragment fragment : presentation2.getColoredText()) {
                SimpleTextAttributes simpleTextAttributes;
                SimpleTextAttributes attributes2;
                SimpleTextAttributes simpleTextAttributes2 = fragment.getAttributes();
                if (simpleTextAttributes2 == null) {
                    simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                }
                if ((attributes2 = simpleTextAttributes2).getFgColor() == null && forcedColor != null) {
                    simpleTextAttributes = attributes2;
                    Intrinsics.checkNotNull((Object)simpleTextAttributes);
                    attributes2 = TreeStructureDomainModelAdapterKt.addColorToSimpleTextAttributes(simpleTextAttributes, forcedColor);
                }
                if (first) {
                    TextAttributes forcedAttributes;
                    TextAttributesKey attributesKey = presentation2.getTextAttributesKey();
                    if (attributesKey != null && (forcedAttributes = colorScheme.getAttributes(attributesKey)) != null) {
                        attributes2 = SimpleTextAttributes.merge((SimpleTextAttributes)attributes2, (SimpleTextAttributes)SimpleTextAttributes.fromTextAttributes((TextAttributes)forcedAttributes));
                    }
                    first = false;
                }
                String string2 = fragment.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                simpleTextAttributes = attributes2;
                Intrinsics.checkNotNull((Object)simpleTextAttributes);
                $this$buildPresentation_u24lambda_u240.appendTextFragment(string2, simpleTextAttributes);
            }
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
            locationAttributes = simpleTextAttributes;
        }
        String location = presentation2.getLocationString();
        attributes = location;
        if (!(attributes == null || attributes.length() == 0)) {
            String prefix = presentation2.getLocationPrefix();
            String suffix = presentation2.getLocationSuffix();
            $this$buildPresentation_u24lambda_u240.appendTextFragment(prefix + location + suffix, locationAttributes);
        }
        $this$buildPresentation_u24lambda_u240.setToolTipText(presentation2.getTooltip());
        return $this$buildPresentation_u24lambda_u240.build();
    }

    private static final SimpleTextAttributes getSimpleTextAttributes(PresentationData presentation2, Color color, Object node, EditorColorsScheme scheme) {
        SimpleTextAttributes simpleTextAttributes = TreeStructureDomainModelAdapterKt.getSimpleTextAttributes(presentation2, scheme);
        return TreeStructureDomainModelAdapterKt.addColorToSimpleTextAttributes(simpleTextAttributes, color);
    }

    private static final SimpleTextAttributes addColorToSimpleTextAttributes(SimpleTextAttributes simpleTextAttributes, Color color) {
        SimpleTextAttributes simpleTextAttributes2 = simpleTextAttributes;
        Color color2 = color;
        if (color2 != null) {
            TextAttributes textAttributes = simpleTextAttributes2.toTextAttributes();
            if (simpleTextAttributes2.useFaded()) {
                color2 = ColorUtil.faded((Color)color2);
            }
            textAttributes.setForegroundColor(color2);
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"fromTextAttributes(...)");
            simpleTextAttributes2 = simpleTextAttributes3;
        }
        return simpleTextAttributes2;
    }

    private static final SimpleTextAttributes getSimpleTextAttributes(PresentationData presentation2, EditorColorsScheme colorsScheme) {
        SimpleTextAttributes simpleTextAttributes;
        TextAttributes textAttributes;
        TextAttributesKey textAttributesKey = presentation2.getTextAttributesKey();
        if (textAttributesKey == null) {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"REGULAR_ATTRIBUTES");
            return simpleTextAttributes2;
        }
        TextAttributes textAttributes2 = textAttributes = colorsScheme.getAttributes(textAttributesKey);
        if (textAttributes2 == null) {
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes3;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"REGULAR_ATTRIBUTES");
        } else {
            SimpleTextAttributes simpleTextAttributes4 = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes2);
            simpleTextAttributes = simpleTextAttributes4;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes4, (String)"fromTextAttributes(...)");
        }
        return simpleTextAttributes;
    }
}

