/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithCompletion
extends LanguageTextField {
    private final boolean myForceAutoPopup;
    private final boolean myShowHint;

    public TextFieldWithCompletion(@NotNull Project project2, @NotNull TextCompletionProvider provider, @NotNull String value, boolean oneLineMode, boolean forceAutoPopup, boolean showHint) {
        if (project2 == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(1);
        }
        if (value == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(2);
        }
        this(project2, provider, value, oneLineMode, true, forceAutoPopup, showHint);
    }

    public TextFieldWithCompletion(@Nullable Project project2, @NotNull TextCompletionProvider provider, @NotNull String value, boolean oneLineMode, boolean autoPopup, boolean forceAutoPopup, boolean showHint) {
        if (provider == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(3);
        }
        if (value == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(4);
        }
        this(project2, provider, value, oneLineMode, autoPopup, forceAutoPopup, showHint, false);
    }

    public TextFieldWithCompletion(@Nullable Project project2, @NotNull TextCompletionProvider provider, @NotNull String value, boolean oneLineMode, boolean autoPopup, boolean forceAutoPopup, boolean showHint, boolean forbidWordCompletion) {
        if (provider == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(5);
        }
        if (value == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(6);
        }
        super((Language)PlainTextLanguage.INSTANCE, project2, value, new TextCompletionUtil.DocumentWithCompletionCreator(provider, autoPopup, forbidWordCompletion), oneLineMode);
        this.myForceAutoPopup = forceAutoPopup;
        this.myShowHint = showHint;
    }

    @Override
    @NotNull
    protected EditorEx createEditor() {
        EditorEx editor2 = super.createEditor();
        ReadAction.run(() -> {
            EditorCustomization disableSpellChecking = SpellCheckingEditorCustomizationProvider.getInstance().getDisabledCustomization();
            if (disableSpellChecking != null) {
                disableSpellChecking.customize(editor2);
            }
        });
        editor2.putUserData(AutoPopupController.ALWAYS_AUTO_POPUP, this.myForceAutoPopup);
        if (this.myShowHint) {
            TextCompletionUtil.installCompletionHint(editor2);
        }
        EditorEx editorEx = editor2;
        if (editorEx == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(7);
        }
        return editorEx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/textCompletion/TextFieldWithCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/textCompletion/TextFieldWithCompletion";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

