/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.breadcrumbs.BreadcrumbListener;
import com.intellij.xml.breadcrumbs.BreadcrumbsComponent;
import com.intellij.xml.breadcrumbs.BreadcrumbsPresentationProvider;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import com.intellij.xml.breadcrumbs.PsiBreadcrumbs;
import com.intellij.xml.breadcrumbs.PsiCrumb;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BreadcrumbsPanel
extends JComponent
implements Disposable {
    private static final Logger LOG = Logger.getInstance(BreadcrumbsPanel.class);
    final PsiBreadcrumbs breadcrumbs;
    protected final Project myProject;
    protected Editor myEditor;
    private Collection<RangeHighlighter> myHighlighed;
    protected boolean myUserCaretChange;
    private final MergingUpdateQueue myQueue;
    private final List<BreadcrumbListener> myBreadcrumbListeners;
    private final Update myUpdate;
    private static final Key<BreadcrumbsPanel> BREADCRUMBS_COMPONENT_KEY = new Key("BREADCRUMBS_KEY");
    private static final Iterable<? extends Crumb> EMPTY_BREADCRUMBS = Collections.emptyList();

    public BreadcrumbsPanel(@NotNull Editor editor2) {
        if (editor2 == null) {
            BreadcrumbsPanel.$$$reportNull$$$0(0);
        }
        this.breadcrumbs = new PsiBreadcrumbs();
        this.myUserCaretChange = true;
        this.myQueue = new MergingUpdateQueue("Breadcrumbs.Queue", 200, true, (JComponent)((Object)this.breadcrumbs));
        this.myBreadcrumbListeners = new ArrayList<BreadcrumbListener>();
        this.myUpdate = new Update(this){

            public void run() {
                BreadcrumbsPanel.this.updateCrumbsAsync();
            }

            public boolean canEat(@NotNull Update update2) {
                if (update2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/intellij/xml/breadcrumbs/BreadcrumbsPanel$1", "canEat"));
            }
        };
        this.myEditor = editor2;
        BreadcrumbsPanel.putBreadcrumbsComponent(this.myEditor, this);
        Project project2 = editor2.getProject();
        assert (project2 != null);
        this.myProject = project2;
        FileStatusManager manager2 = FileStatusManager.getInstance((Project)project2);
        manager2.addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                BreadcrumbsPanel.this.queueUpdate();
            }
        }, (Disposable)this);
        if (ClientId.isLocal((ClientId)ClientEditorManager.getClientId((Editor)this.myEditor))) {
            this.attachEditorListeners(editor2);
            this.breadcrumbs.onHover(this::itemHovered);
            this.breadcrumbs.onSelect(this::itemSelected);
            this.breadcrumbs.setFont(BreadcrumbsPanel.getNewFont(this.myEditor));
            JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)((Object)this.breadcrumbs), (boolean)true);
            pane2.setVerticalScrollBarPolicy(21);
            pane2.getHorizontalScrollBar().setEnabled(false);
            this.setLayout(new BorderLayout());
            this.add("Center", pane2);
            Disposer.register((Disposable)this, (Disposable)UiNotifyConnector.installOn((Component)((Object)this.breadcrumbs), (Activatable)this.myQueue));
        }
        Disposer.register((Disposable)this, (Disposable)this.myQueue);
        BreadcrumbsProvider.EP_NAME.addChangeListener(() -> this.updateCrumbsSync(), (Disposable)this);
        BreadcrumbsPresentationProvider.EP_NAME.addChangeListener(() -> this.updateCrumbsSync(), (Disposable)this);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myQueue.setPassThrough(true);
        }
        this.queueUpdate();
    }

    private void attachEditorListeners(@NotNull Editor editor2) {
        if (editor2 == null) {
            BreadcrumbsPanel.$$$reportNull$$$0(1);
        }
        if (editor2 instanceof EditorEx) {
            ((EditorEx)editor2).addPropertyChangeListener(this::updateEditorFont, this);
        }
        CaretListener caretListener = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (BreadcrumbsPanel.this.myUserCaretChange) {
                    BreadcrumbsPanel.this.queueUpdate();
                }
                BreadcrumbsPanel.this.myUserCaretChange = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xml/breadcrumbs/BreadcrumbsPanel$3", "caretPositionChanged"));
            }
        };
        editor2.getCaretModel().addCaretListener(caretListener, (Disposable)this);
        EditorGutter gutter = editor2.getGutter();
        if (gutter instanceof EditorGutterComponentEx) {
            final EditorGutterComponentEx gutterComponent = (EditorGutterComponentEx)gutter;
            if (!(gutterComponent instanceof MouseListener)) {
                LOG.error("Can't delegate mouse events to EditorGutterComponentEx: " + String.valueOf(gutterComponent));
            }
            MouseEventAdapter<EditorGutterComponentEx> mouseListener2 = new MouseEventAdapter<EditorGutterComponentEx>(this, gutterComponent){

                @NotNull
                protected MouseEvent convert(@NotNull MouseEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    MouseEvent mouseEvent = 4.convert((MouseEvent)event, (Component)gutterComponent);
                    if (mouseEvent == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return mouseEvent;
                }

                protected MouseListener getMouseListener(@NotNull EditorGutterComponentEx adapter) {
                    if (adapter == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    if (adapter instanceof MouseListener && adapter.isShowing()) {
                        return (MouseListener)((Object)adapter);
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/xml/breadcrumbs/BreadcrumbsPanel$4";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "adapter";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsPanel$4";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "convert";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "convert";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "getMouseListener";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
            ComponentAdapter resizeListener2 = new ComponentAdapter(){

                @Override
                @DirtyUI
                public void componentResized(ComponentEvent event) {
                    BreadcrumbsPanel.this.breadcrumbs.setFont(BreadcrumbsPanel.getNewFont(BreadcrumbsPanel.this.myEditor));
                }
            };
            this.addComponentListener(resizeListener2);
            gutterComponent.addComponentListener(resizeListener2);
            this.breadcrumbs.addMouseListener((MouseListener)mouseListener2);
            Disposer.register((Disposable)this, () -> this.lambda$attachEditorListeners$2(resizeListener2, gutterComponent, (MouseEventAdapter)mouseListener2));
        }
    }

    public Breadcrumbs getBreadcrumbs() {
        return this.breadcrumbs;
    }

    protected int getLeftOffset() {
        EditorGutterComponentEx gutter = (EditorGutterComponentEx)this.myEditor.getGutter();
        return gutter.getWhitespaceSeparatorOffset();
    }

    private void updateCrumbsAsync() {
        if (this.myEditor == null || this.myEditor.isDisposed()) {
            return;
        }
        ReadAction.run(() -> ReadAction.nonBlocking(() -> this.computeCrumbs(this.myEditor.getCaretModel().getOffset())).withDocumentsCommitted(this.myProject).expireWith((Disposable)this).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.any(), crumbs -> this.applyCrumbs((Iterable<? extends Crumb>)crumbs)).submit((Executor)NonUrgentExecutor.getInstance()));
    }

    private void applyCrumbs(Iterable<? extends Crumb> _crumbs) {
        boolean areCrumbsVisible = this.breadcrumbs.isShowing() || !ClientId.isLocal((ClientId)ClientEditorManager.getClientId((Editor)this.myEditor)) || ApplicationManager.getApplication().isHeadlessEnvironment();
        Iterable<? extends Crumb> crumbs = _crumbs != null && areCrumbsVisible ? _crumbs : EMPTY_BREADCRUMBS;
        this.breadcrumbs.setFont(BreadcrumbsPanel.getNewFont(this.myEditor));
        this.breadcrumbs.setCrumbs(crumbs);
        this.notifyListeners(crumbs);
    }

    private void updateCrumbsSync() {
        if (this.myEditor == null || this.myEditor.isDisposed()) {
            return;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        Iterable<? extends Crumb> crumbs = this.computeCrumbs(offset);
        this.applyCrumbs(crumbs);
    }

    public void queueUpdate() {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue(this.myUpdate);
    }

    public void addBreadcrumbListener(BreadcrumbListener listener2, Disposable parentDisposable) {
        this.myBreadcrumbListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myBreadcrumbListeners.remove(listener2));
    }

    private void notifyListeners(@NotNull Iterable<? extends Crumb> breadcrumbs) {
        if (breadcrumbs == null) {
            BreadcrumbsPanel.$$$reportNull$$$0(2);
        }
        for (BreadcrumbListener listener2 : this.myBreadcrumbListeners) {
            listener2.breadcrumbsChanged(breadcrumbs);
        }
    }

    private void itemSelected(Crumb crumb, InputEvent event) {
        if (event == null) {
            return;
        }
        this.navigateToCrumb(crumb, event.isShiftDown() || event.isMetaDown());
    }

    private void itemHovered(Crumb crumb, InputEvent event) {
        CrumbHighlightInfo info;
        if (!Registry.is((String)"editor.breadcrumbs.highlight.on.hover")) {
            return;
        }
        HighlightManager hm = HighlightManager.getInstance((Project)this.myProject);
        if (this.myHighlighed != null) {
            for (RangeHighlighter highlighter : this.myHighlighed) {
                hm.removeSegmentHighlighter(this.myEditor, highlighter);
            }
            this.myHighlighed = null;
        }
        if ((info = this.getHighlightInfo(crumb)) != null) {
            Color background;
            Color color;
            TextRange range = info.range;
            TextAttributes attributes = new TextAttributes();
            Color color2 = color = info.presentation != null ? info.presentation.getBackgroundColor(false, false, false) : null;
            if (color == null) {
                color = BreadcrumbsComponent.ButtonSettings.getBackgroundColor(false, false, false, false);
            }
            if (color == null) {
                color = UIUtil.getLabelBackground();
            }
            attributes.setBackgroundColor(UIUtil.makeTransparent((Color)color, (Color)((background = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR)) != null ? background : Gray._200), (double)0.3));
            this.myHighlighed = new ArrayList<RangeHighlighter>(1);
            int flags = 7;
            hm.addOccurrenceHighlight(this.myEditor, range.getStartOffset(), range.getEndOffset(), attributes, flags, this.myHighlighed, null);
        }
    }

    @Nullable
    protected abstract Iterable<? extends Crumb> computeCrumbs(int var1);

    protected void navigateToCrumb(Crumb crumb, boolean withSelection) {
        if (crumb instanceof NavigatableCrumb) {
            NavigatableCrumb navigatableCrumb = (NavigatableCrumb)crumb;
            this.myUserCaretChange = false;
            WriteIntentReadAction.run(() -> navigatableCrumb.navigate(this.myEditor, withSelection));
        }
    }

    @Nullable
    protected CrumbHighlightInfo getHighlightInfo(Crumb crumb) {
        if (crumb instanceof NavigatableCrumb) {
            TextRange range = ((NavigatableCrumb)crumb).getHighlightRange();
            if (range == null) {
                return null;
            }
            CrumbPresentation p = PsiCrumb.getPresentation(crumb);
            return new CrumbHighlightInfo(range, p);
        }
        return null;
    }

    private static void putBreadcrumbsComponent(@NotNull Editor editor2, @NotNull BreadcrumbsPanel panel2) {
        BreadcrumbsPanel oldPanel;
        if (editor2 == null) {
            BreadcrumbsPanel.$$$reportNull$$$0(3);
        }
        if (panel2 == null) {
            BreadcrumbsPanel.$$$reportNull$$$0(4);
        }
        if ((oldPanel = (BreadcrumbsPanel)editor2.getUserData(BREADCRUMBS_COMPONENT_KEY)) != null) {
            LOG.error("Multiple breadcrumbs panels registered for the same Editor, old panel: " + String.valueOf(oldPanel), new Throwable());
        }
        editor2.putUserData(BREADCRUMBS_COMPONENT_KEY, (Object)panel2);
    }

    @Nullable
    public static BreadcrumbsPanel getBreadcrumbsComponent(@NotNull Editor editor2) {
        if (editor2 == null) {
            BreadcrumbsPanel.$$$reportNull$$$0(5);
        }
        return (BreadcrumbsPanel)editor2.getUserData(BREADCRUMBS_COMPONENT_KEY);
    }

    public void dispose() {
        if (this.myEditor != null) {
            this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, null);
        }
        this.myEditor = null;
        this.breadcrumbs.setCrumbs(EMPTY_BREADCRUMBS);
        this.notifyListeners(EMPTY_BREADCRUMBS);
    }

    private void updateEditorFont(PropertyChangeEvent event) {
        if ("fontSize".equals(event.getPropertyName())) {
            this.queueUpdate();
        }
    }

    private static Font getNewFont(Editor editor2) {
        Font font = editor2 == null || Registry.is((String)"editor.breadcrumbs.system.font") ? StartupUiUtil.getLabelFont() : BreadcrumbsPanel.getEditorFont(editor2);
        return UISettings.getInstance().getUseSmallLabelsOnTabs() && !ExperimentalUI.isNewUI() ? RelativeFont.SMALL.derive(font) : font;
    }

    private static Font getEditorFont(Editor editor2) {
        return ComplementaryFontsRegistry.getFontAbleToDisplay(97, 0, editor2.getColorsScheme().getFontPreferences(), null).getFont();
    }

    private /* synthetic */ void lambda$attachEditorListeners$2(ComponentAdapter resizeListener2, EditorGutterComponentEx gutterComponent, MouseEventAdapter mouseListener2) {
        this.removeComponentListener(resizeListener2);
        gutterComponent.removeComponentListener(resizeListener2);
        this.breadcrumbs.removeMouseListener((MouseListener)mouseListener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breadcrumbs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "attachEditorListeners";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyListeners";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "putBreadcrumbsComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getBreadcrumbsComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static final class CrumbHighlightInfo {
        @NotNull
        public final TextRange range;
        @Nullable
        public final CrumbPresentation presentation;

        public CrumbHighlightInfo(@NotNull TextRange range, @Nullable CrumbPresentation presentation2) {
            if (range == null) {
                CrumbHighlightInfo.$$$reportNull$$$0(0);
            }
            this.range = range;
            this.presentation = presentation2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/xml/breadcrumbs/BreadcrumbsPanel$CrumbHighlightInfo", "<init>"));
        }
    }
}

