/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SymbolPresentationUtil {
    private SymbolPresentationUtil() {
    }

    @NlsSafe
    public static String getSymbolPresentableText(@NotNull PsiElement element) {
        ItemPresentation presentation;
        if (element == null) {
            SymbolPresentationUtil.$$$reportNull$$$0(0);
        }
        if (element instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            return presentation.getPresentableText();
        }
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        return element.getText();
    }

    @Nullable
    @NlsSafe
    public static String getSymbolContainerText(PsiElement element) {
        if (element instanceof NavigationItem) {
            VirtualFile virtualFile;
            ItemPresentation presentation = ((NavigationItem)element).getPresentation();
            if (presentation != null) {
                return presentation.getLocationString();
            }
            PsiFile file = element.getContainingFile();
            if (file != null && (virtualFile = file.getVirtualFile()) != null) {
                return virtualFile.getPath();
            }
        }
        return null;
    }

    @NlsSafe
    public static String getFilePathPresentation(PsiFile psiFile) {
        return SymbolPresentationUtil.getFilePathPresentation((PsiFileSystemItem)psiFile);
    }

    @NlsSafe
    public static String getFilePathPresentation(PsiFileSystemItem item) {
        String relativePath;
        VirtualFile rootForFile;
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)item.getProject()).getFileIndex();
        VirtualFile file = (item instanceof PsiFile ? ((PsiFile)item).getOriginalFile() : item).getVirtualFile();
        VirtualFile virtualFile = rootForFile = file != null ? index.getContentRootForFile(file) : null;
        if (rootForFile != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)rootForFile, (char)File.separatorChar)) != null) {
            return relativePath;
        }
        return item.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/presentation/java/SymbolPresentationUtil", "getSymbolPresentableText"));
    }
}

