/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.ColorGenerator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorPalette;
import com.intellij.openapi.editor.colors.EditorColorPaletteFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.MathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.UnmodifiableView;

public class RainbowHighlighter {
    private static final JBColor[] RAINBOW_JB_COLORS_DEFAULT = new JBColor[]{new JBColor(10173290, 5414226), new JBColor(1133943, 12480624), new JBColor(12355152, 4028022), new JBColor(22800, 12491120), new JBColor(12341584, 10310268)};
    public static final TextAttributesKey[] RAINBOW_COLOR_KEYS = new TextAttributesKey[RAINBOW_JB_COLORS_DEFAULT.length];
    private static final int RAINBOW_COLORS_BETWEEN = 4;
    private static final String UNIT_TEST_COLORS = "#000001,#000002,#000003,#000004";
    private static final String INHERITED = "inherited";
    private static final Set<TextAttributesKey> CODE_INSIGHT_CONFLICT_KEYS = Set.of(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES, CodeInsightColors.ERRORS_ATTRIBUTES, CodeInsightColors.WARNINGS_ATTRIBUTES, CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING, CodeInsightColors.DUPLICATE_FROM_SERVER, CodeInsightColors.WEAK_WARNING_ATTRIBUTES, CodeInsightColors.INFORMATION_ATTRIBUTES, CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES, CodeInsightColors.DEPRECATED_ATTRIBUTES, CodeInsightColors.MATCHED_BRACE_ATTRIBUTES, CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES, CodeInsightColors.JOIN_POINT, CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES, CodeInsightColors.HYPERLINK_ATTRIBUTES, CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES, CodeInsightColors.TODO_DEFAULT_ATTRIBUTES, CodeInsightColors.BOOKMARKS_ATTRIBUTES);
    private static final TextAttributesKey[] RAINBOW_TEMP_KEYS;
    private static final Map<String, TextAttributesKey> RAINBOW_TEMP_TAG_TO_KEY_MAP;
    public static final String RAINBOW_TYPE = "rainbow";
    private static final String RAINBOW_TEMP_PREF = "RAINBOW_TEMP_";
    public static final TextAttributesKey RAINBOW_ANCHOR;
    public static final TextAttributesKey RAINBOW_GRADIENT_DEMO;
    public static final Boolean DEFAULT_RAINBOW_ON;
    @NotNull
    private final TextAttributesScheme myColorsScheme;
    private final Color @NotNull [] myRainbowColors;
    public static final HighlightInfoType RAINBOW_ELEMENT;

    public RainbowHighlighter(@NotNull TextAttributesScheme colorsScheme) {
        if (colorsScheme == null) {
            RainbowHighlighter.$$$reportNull$$$0(0);
        }
        this.myColorsScheme = colorsScheme;
        this.myRainbowColors = RainbowHighlighter.generateColorSequence(this.myColorsScheme);
    }

    @Contract(value="_, null -> !null")
    @Nullable
    public static Boolean isRainbowEnabled(@Nullable TextAttributesScheme colorsScheme, @Nullable Language language) {
        if (colorsScheme instanceof SchemeMetaInfo) {
            SchemeMetaInfo metaInfo = (SchemeMetaInfo)colorsScheme;
            do {
                String value = metaInfo.getMetaProperties().getProperty(RainbowHighlighter.getKey(language), INHERITED);
                if (String.valueOf(true).equals(value)) {
                    return Boolean.TRUE;
                }
                if (String.valueOf(false).equals(value)) {
                    return Boolean.FALSE;
                }
                if (language != null) continue;
                return DEFAULT_RAINBOW_ON;
            } while ((language = language.getBaseLanguage()) != null);
            return null;
        }
        return false;
    }

    public static boolean isRainbowEnabledWithInheritance(@Nullable TextAttributesScheme colorsScheme, @Nullable Language language) {
        Boolean rainbowEnabled = RainbowHighlighter.isRainbowEnabled(colorsScheme, language);
        return rainbowEnabled != null ? rainbowEnabled : RainbowHighlighter.isRainbowEnabled(colorsScheme, null);
    }

    public static void setRainbowEnabled(@NotNull SchemeMetaInfo colorsScheme, @Nullable Language language, @Nullable Boolean enabled) {
        if (colorsScheme == null) {
            RainbowHighlighter.$$$reportNull$$$0(1);
        }
        Properties properties = colorsScheme.getMetaProperties();
        String key = RainbowHighlighter.getKey(language);
        if (enabled == null || language == null && enabled == DEFAULT_RAINBOW_ON) {
            properties.remove(key);
        } else {
            properties.setProperty(key, String.valueOf(enabled));
        }
    }

    @NotNull
    private static String getKey(@Nullable Language language) {
        String string = "rainbow " + (language == null ? AnalysisBundle.message((String)"color.settings.common.default.language", (Object[])new Object[0]) : language.getID());
        if (string == null) {
            RainbowHighlighter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isRainbowKey(@Nullable Object key) {
        String string;
        return key instanceof String && (string = (String)key).startsWith(RAINBOW_TYPE);
    }

    public static void transferRainbowState(@NotNull SchemeMetaInfo dst, @NotNull SchemeMetaInfo src) {
        if (dst == null) {
            RainbowHighlighter.$$$reportNull$$$0(3);
        }
        if (src == null) {
            RainbowHighlighter.$$$reportNull$$$0(4);
        }
        Properties dstProps = dst.getMetaProperties();
        dstProps.entrySet().removeIf(entry -> RainbowHighlighter.isRainbowKey(entry.getKey()));
        src.getMetaProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (RainbowHighlighter.isRainbowKey(key) && value instanceof String) {
                String string = (String)value;
                dstProps.setProperty((String)key, string);
            }
        }));
    }

    @NotNull
    public static String generatePaletteExample(@NotNull String indent) {
        if (indent == null) {
            RainbowHighlighter.$$$reportNull$$$0(5);
        }
        int stopCount = RAINBOW_COLOR_KEYS.length;
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append(AnalysisBundle.message((String)"color.settings.rainbow.demo.header.1", (Object[])new Object[0])).append(indent).append(AnalysisBundle.message((String)"color.settings.rainbow.demo.header.2", (Object[])new Object[0])).append(indent);
        String tagRainbow = RAINBOW_GRADIENT_DEMO.getExternalName();
        boolean needLineBreak = true;
        for (int i = 0; i < RAINBOW_TEMP_KEYS.length; ++i) {
            sb.append(" ");
            sb.append("<").append(tagRainbow).append(">");
            String anchor = String.valueOf(i / stopCount + 1);
            String minor = String.valueOf(i % stopCount);
            sb.append(i % stopCount == 0 ? "Color#" + anchor : "SC" + anchor + "." + minor);
            sb.append("</").append(tagRainbow).append(">");
            if (!needLineBreak || i != RAINBOW_TEMP_KEYS.length / 2) continue;
            sb.append(indent);
            needLineBreak = false;
            --i;
        }
        String string = sb.toString();
        if (string == null) {
            RainbowHighlighter.$$$reportNull$$$0(6);
        }
        return string;
    }

    public int getColorsCount() {
        return this.myRainbowColors.length;
    }

    private static Color @NotNull [] generateColorSequence(@NotNull TextAttributesScheme colorsScheme) {
        String colorDump;
        List registryColors;
        if (colorsScheme == null) {
            RainbowHighlighter.$$$reportNull$$$0(7);
        }
        if (!(registryColors = StringUtil.split((String)(colorDump = ApplicationManager.getApplication().isUnitTestMode() ? UNIT_TEST_COLORS : Registry.get((String)"rainbow.highlighter.colors").asString()), (String)",")).isEmpty()) {
            Color[] colorArray = (Color[])registryColors.stream().map(s -> ColorUtil.fromHex((String)s.trim())).toArray(Color[]::new);
            if (colorArray == null) {
                RainbowHighlighter.$$$reportNull$$$0(8);
            }
            return colorArray;
        }
        Color[] colors = RainbowHighlighter.getColorsFromCache(colorsScheme);
        if (colors != null) {
            if (colors == null) {
                RainbowHighlighter.$$$reportNull$$$0(9);
            }
            return colors;
        }
        return RainbowHighlighter.generateColors(colorsScheme);
    }

    @Contract(pure=true)
    @NotNull
    public static TextAttributesKey getRainbowAttrWithLazyCreation(@NotNull TextAttributesScheme colorsScheme, int colorIndex) {
        TextAttributesKey rainbowTempKey;
        if (colorsScheme == null) {
            RainbowHighlighter.$$$reportNull$$$0(10);
        }
        if (colorsScheme.getAttributes(rainbowTempKey = RAINBOW_TEMP_KEYS[colorIndex % RAINBOW_TEMP_KEYS.length]) == null) {
            RainbowHighlighter.resetRainbowGeneratedColors(colorsScheme);
        }
        TextAttributesKey textAttributesKey = rainbowTempKey;
        if (textAttributesKey == null) {
            RainbowHighlighter.$$$reportNull$$$0(11);
        }
        return textAttributesKey;
    }

    public static void resetRainbowGeneratedColors(@NotNull TextAttributesScheme colorsScheme) {
        if (colorsScheme == null) {
            RainbowHighlighter.$$$reportNull$$$0(12);
        }
        RainbowHighlighter.generateColors(colorsScheme);
    }

    @TestOnly
    public static Color @NotNull [] testRainbowGenerateColors(@NotNull TextAttributesScheme colorsScheme) {
        if (colorsScheme == null) {
            RainbowHighlighter.$$$reportNull$$$0(13);
        }
        return RainbowHighlighter.generateColors(colorsScheme);
    }

    private static Color @NotNull [] generateColors(@NotNull TextAttributesScheme colorsScheme) {
        if (colorsScheme == null) {
            RainbowHighlighter.$$$reportNull$$$0(14);
        }
        List stopRainbowColors = ContainerUtil.map((Object[])RAINBOW_COLOR_KEYS, key -> RainbowHighlighter.getRainbowColorFromAttribute(colorsScheme.getAttributes(key)));
        List rainbowColors = ColorGenerator.generateLinearColorSequence(stopRainbowColors, 4);
        if (colorsScheme instanceof EditorColorsScheme) {
            EditorColorsScheme editorColorsScheme = (EditorColorsScheme)colorsScheme;
            EditorColorPalette palette = EditorColorPaletteFactory.getInstance().getPalette(editorColorsScheme, Language.ANY).collectColorsWithFilter(attr -> RainbowHighlighter.getRainbowColorFromAttribute(attr), true);
            ArrayList<Pair> colorCircles = new ArrayList<Pair>();
            Color background = editorColorsScheme.getDefaultBackground();
            boolean schemeIsDark = ColorUtil.isDark((Color)background);
            double minDistanceWithOrdinal = schemeIsDark ? 0.06 : 0.1;
            double minDistanceWithDiagnostic = schemeIsDark ? 0.12 : 0.2;
            colorCircles.add(Pair.create((Object)background, (Object)0.24));
            palette.getEntries().forEach(entry -> colorCircles.add(Pair.create((Object)((Color)entry.getKey()), (Object)(Collections.disjoint(CODE_INSIGHT_CONFLICT_KEYS, (Collection)entry.getValue()) ? minDistanceWithOrdinal : minDistanceWithDiagnostic))));
            rainbowColors = ContainerUtil.map(rainbowColors, rainbowColor -> RainbowHighlighter.resolveConflict(colorCircles, rainbowColor, 0));
            for (int i = 0; i < RAINBOW_TEMP_KEYS.length; ++i) {
                TextAttributesKey key2 = RAINBOW_TEMP_KEYS[i];
                TextAttributes attributes = RainbowHighlighter.createRainbowAttribute((Color)rainbowColors.get(i));
                editorColorsScheme.setAttributes(key2, attributes);
            }
        }
        Color[] colorArray = rainbowColors.toArray(new Color[0]);
        if (colorArray == null) {
            RainbowHighlighter.$$$reportNull$$$0(15);
        }
        return colorArray;
    }

    private static Color resolveConflict(@NotNull List<? extends Pair<Color, Double>> colorCircles, @NotNull Color sampleColor, int nestLevel) {
        if (colorCircles == null) {
            RainbowHighlighter.$$$reportNull$$$0(16);
        }
        if (sampleColor == null) {
            RainbowHighlighter.$$$reportNull$$$0(17);
        }
        if (nestLevel > 4) {
            return sampleColor;
        }
        for (Pair<Color, Double> pair : colorCircles) {
            Color paletteColor = (Color)pair.first;
            double distance = RainbowHighlighter.colorDistance01(sampleColor, paletteColor);
            if (!(distance < (Double)pair.second)) continue;
            float[] rgb = RainbowHighlighter.rgbDiffColor(sampleColor, paletteColor);
            double factor = 256.0 * (Double)pair.second / RainbowHighlighter.getLength(rgb);
            int mod = nestLevel % 4;
            int r = RainbowHighlighter.normalize((double)sampleColor.getRed() + (double)rgb[0] * factor * (double)(mod == 3 ? 2 : 1));
            int g = RainbowHighlighter.normalize((double)sampleColor.getGreen() + (double)rgb[1] * factor * (double)(mod == 1 ? 2 : 1));
            int b = RainbowHighlighter.normalize((double)sampleColor.getBlue() + (double)rgb[2] * factor * (double)(mod == 2 ? 2 : 1));
            float[] hsbNew = Color.RGBtoHSB(r, g, b, null);
            float[] hsbOrig = Color.RGBtoHSB(sampleColor.getRed(), sampleColor.getGreen(), sampleColor.getBlue(), null);
            return RainbowHighlighter.resolveConflict(colorCircles, Color.getHSBColor(hsbNew[0], hsbNew[1], (hsbOrig[2] + hsbNew[2]) / 2.0f), ++nestLevel);
        }
        return sampleColor;
    }

    private static int normalize(double b) {
        return MathUtil.clamp((int)((int)b), (int)1, (int)254);
    }

    public static double colorDistance01(@NotNull Color c1, @NotNull Color c2) {
        if (c1 == null) {
            RainbowHighlighter.$$$reportNull$$$0(18);
        }
        if (c2 == null) {
            RainbowHighlighter.$$$reportNull$$$0(19);
        }
        return RainbowHighlighter.getLength(RainbowHighlighter.YPbPr01(RainbowHighlighter.rgbDiffColor(c1, c2)));
    }

    private static double getLength(float @NotNull [] components) {
        if (components == null) {
            RainbowHighlighter.$$$reportNull$$$0(20);
        }
        return Math.sqrt(components[0] * components[0] + components[1] * components[1] + components[2] * components[2]);
    }

    private static float @NotNull [] rgbDiffColor(@NotNull Color c1, @NotNull Color c2) {
        if (c1 == null) {
            RainbowHighlighter.$$$reportNull$$$0(21);
        }
        if (c2 == null) {
            RainbowHighlighter.$$$reportNull$$$0(22);
        }
        float[] fArray = new float[]{c1.getRed() - c2.getRed(), c1.getGreen() - c2.getGreen(), c1.getBlue() - c2.getBlue()};
        if (fArray == null) {
            RainbowHighlighter.$$$reportNull$$$0(23);
        }
        return fArray;
    }

    @Contract(pure=true)
    private static float @NotNull [] YPbPr01(float @NotNull [] rgb) {
        if (rgb == null) {
            RainbowHighlighter.$$$reportNull$$$0(24);
        }
        float[] fArray = new float[]{(float)((0.299 * (double)rgb[0] + 0.587 * (double)rgb[1] + 0.114 * (double)rgb[2]) / 256.0), (float)((-0.169 * (double)rgb[0] - 0.331 * (double)rgb[1] + 0.5 * (double)rgb[2]) / 256.0), (float)((0.5 * (double)rgb[0] - 0.419 * (double)rgb[1] - 0.081 * (double)rgb[2]) / 256.0)};
        if (fArray == null) {
            RainbowHighlighter.$$$reportNull$$$0(25);
        }
        return fArray;
    }

    private static Color @Nullable [] getColorsFromCache(@NotNull TextAttributesScheme colorsScheme) {
        if (colorsScheme == null) {
            RainbowHighlighter.$$$reportNull$$$0(26);
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        boolean validCache = true;
        for (TextAttributesKey tempKey : RAINBOW_TEMP_KEYS) {
            TextAttributes attributes = colorsScheme.getAttributes(tempKey);
            if (attributes == null) {
                validCache = false;
                break;
            }
            colors.add(RainbowHighlighter.getRainbowColorFromAttribute(attributes));
        }
        if (!validCache) {
            return null;
        }
        return colors.toArray(new Color[0]);
    }

    @Nullable
    private static Color getRainbowColorFromAttribute(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            RainbowHighlighter.$$$reportNull$$$0(27);
        }
        return attributes.getForegroundColor();
    }

    private static void setRainbowColorToAttribute(@NotNull TextAttributes attributes, @Nullable Color rainbowColor) {
        if (attributes == null) {
            RainbowHighlighter.$$$reportNull$$$0(28);
        }
        attributes.setForegroundColor(rainbowColor);
    }

    public static TextAttributesKey @NotNull [] getRainbowTempKeys(@NotNull TextAttributesScheme colorsScheme) {
        if (colorsScheme == null) {
            RainbowHighlighter.$$$reportNull$$$0(29);
        }
        RainbowHighlighter.generateColors(colorsScheme);
        if (RAINBOW_TEMP_KEYS == null) {
            RainbowHighlighter.$$$reportNull$$$0(30);
        }
        return RAINBOW_TEMP_KEYS;
    }

    @Contract(pure=true)
    @NotNull
    public static @UnmodifiableView Map<String, TextAttributesKey> getRainbowRegereratedKeyMap() {
        Map<String, TextAttributesKey> map = Collections.unmodifiableMap(RAINBOW_TEMP_TAG_TO_KEY_MAP);
        if (map == null) {
            RainbowHighlighter.$$$reportNull$$$0(31);
        }
        return map;
    }

    public static void createLazyRainbowKeyIfNeed(@Nullable TextAttributesKey maybeRegeneratedRainbowKey, @NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            RainbowHighlighter.$$$reportNull$$$0(32);
        }
        if (maybeRegeneratedRainbowKey != null && RainbowHighlighter.getRainbowRegereratedKeyMap().containsKey(maybeRegeneratedRainbowKey.getExternalName()) && scheme.getAttributes(maybeRegeneratedRainbowKey) == null) {
            RainbowHighlighter.resetRainbowGeneratedColors((TextAttributesScheme)scheme);
        }
    }

    public static boolean isRainbowTempKey(@NotNull TextAttributesKey key) {
        if (key == null) {
            RainbowHighlighter.$$$reportNull$$$0(33);
        }
        return key.getExternalName().startsWith(RAINBOW_TEMP_PREF);
    }

    public HighlightInfo getInfo(int colorIndex, @Nullable PsiElement id, @Nullable TextAttributesKey colorKey) {
        return id == null ? null : this.getInfoBuilder(colorIndex, colorKey).range(id).create();
    }

    public HighlightInfo getInfo(int colorIndex, int start, int end, @Nullable TextAttributesKey colorKey) {
        return this.getInfoBuilder(colorIndex, colorKey).range(start, end).create();
    }

    @NotNull
    private HighlightInfo.Builder getInfoBuilder(int colorIndex, @Nullable TextAttributesKey originalEntityTagKey) {
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(RAINBOW_ELEMENT).textAttributes(RainbowHighlighter.getRainbowAttrWithLazyCreation(this.myColorsScheme, colorIndex));
        if (builder == null) {
            RainbowHighlighter.$$$reportNull$$$0(34);
        }
        return builder;
    }

    @NotNull
    public static TextAttributes createRainbowAttribute(@Nullable Color color) {
        TextAttributes ret = new TextAttributes();
        RainbowHighlighter.setRainbowColorToAttribute(ret, color);
        TextAttributes textAttributes = ret;
        if (textAttributes == null) {
            RainbowHighlighter.$$$reportNull$$$0(35);
        }
        return textAttributes;
    }

    @NotNull
    public static Map<String, TextAttributesKey> createRainbowHLM() {
        HashMap<String, TextAttributesKey> hashMap = new HashMap<String, TextAttributesKey>();
        hashMap.put(RAINBOW_ANCHOR.getExternalName(), RAINBOW_ANCHOR);
        hashMap.put(RAINBOW_GRADIENT_DEMO.getExternalName(), RAINBOW_GRADIENT_DEMO);
        hashMap.putAll(RAINBOW_TEMP_TAG_TO_KEY_MAP);
        HashMap<String, TextAttributesKey> hashMap2 = hashMap;
        if (hashMap2 == null) {
            RainbowHighlighter.$$$reportNull$$$0(36);
        }
        return hashMap2;
    }

    static {
        for (int i = 0; i < RAINBOW_JB_COLORS_DEFAULT.length; ++i) {
            RainbowHighlighter.RAINBOW_COLOR_KEYS[i] = TextAttributesKey.createTextAttributesKey((String)("RAINBOW_COLOR" + i), (TextAttributes)RainbowHighlighter.createRainbowAttribute((Color)RAINBOW_JB_COLORS_DEFAULT[i]));
        }
        List<Color> stopRainbowColors = Collections.nCopies(RAINBOW_COLOR_KEYS.length, Color.red);
        List<Color> rainbowColors = ColorGenerator.generateLinearColorSequence(stopRainbowColors, 4);
        TextAttributesKey[] keys = new TextAttributesKey[rainbowColors.size()];
        HashMap<String, TextAttributesKey> map = new HashMap<String, TextAttributesKey>();
        for (int i = 0; i < keys.length; ++i) {
            TextAttributesKey key;
            keys[i] = key = TextAttributesKey.createTempTextAttributesKey((String)(RAINBOW_TEMP_PREF + i), null);
            map.put(key.getExternalName(), key);
        }
        RAINBOW_TEMP_KEYS = keys;
        RAINBOW_TEMP_TAG_TO_KEY_MAP = map;
        RAINBOW_ANCHOR = TextAttributesKey.createTextAttributesKey((String)RAINBOW_TYPE);
        RAINBOW_GRADIENT_DEMO = TextAttributesKey.createTextAttributesKey((String)"rainbow_demo");
        DEFAULT_RAINBOW_ON = Boolean.FALSE;
        RAINBOW_ELEMENT = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, DefaultLanguageHighlighterColors.CONSTANT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 8, 9, 11, 15, 23, 25, 30, 31, 34, 35, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 23: 
            case 25: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeHighlighting/RainbowHighlighter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorCircles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleColor";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rgb";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeHighlighting/RainbowHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePaletteExample";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateColorSequence";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRainbowAttrWithLazyCreation";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "generateColors";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "rgbDiffColor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "YPbPr01";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRainbowTempKeys";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getRainbowRegereratedKeyMap";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoBuilder";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createRainbowAttribute";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createRainbowHLM";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRainbowEnabled";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 23: 
            case 25: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "transferRainbowState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePaletteExample";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateColorSequence";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRainbowAttrWithLazyCreation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resetRainbowGeneratedColors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "testRainbowGenerateColors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateColors";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveConflict";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "colorDistance01";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "rgbDiffColor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "YPbPr01";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getColorsFromCache";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRainbowColorFromAttribute";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setRainbowColorToAttribute";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRainbowTempKeys";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createLazyRainbowKeyIfNeed";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isRainbowTempKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 8, 9, 11, 15, 23, 25, 30, 31, 34, 35, 36 -> new IllegalStateException(string);
        };
    }
}

