/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.io.DataExternalizer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u000bJ5\u0010\r\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t2\b\u0010\u000e\u001a\u0004\u0018\u0001H\u00072\b\u0010\u000f\u001a\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0002R\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/indexing/IndexDataComparer;", "", "<init>", "()V", "areIndexedDataOfFileTheSame", "", "K", "V", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "expectedData", "", "actualData", "areValuesTheSame", "expectedValue", "actualValue", "(Lcom/intellij/util/indexing/FileBasedIndexExtension;Ljava/lang/Object;Ljava/lang/Object;)Z", "areStubTreesTheSame", "expectedTree", "Lcom/intellij/psi/stubs/SerializedStubTree;", "actualTree", "elementType", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/psi/stubs/Stub;", "getElementType", "(Lcom/intellij/psi/stubs/Stub;)Lcom/intellij/psi/tree/IElementType;", "areStubsTheSame", "expectedStub", "actualStub", "intellij.platform.indexing.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIndexDataComparer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexDataComparer.kt\ncom/intellij/util/indexing/IndexDataComparer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class IndexDataComparer {
    @NotNull
    public static final IndexDataComparer INSTANCE = new IndexDataComparer();

    private IndexDataComparer() {
    }

    public final <K, V> boolean areIndexedDataOfFileTheSame(@NotNull FileBasedIndexExtension<K, V> extension, @NotNull Map<K, ? extends V> expectedData, @NotNull Map<K, ? extends V> actualData) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        Intrinsics.checkNotNullParameter(expectedData, (String)"expectedData");
        Intrinsics.checkNotNullParameter(actualData, (String)"actualData");
        if (expectedData.isEmpty() && actualData.isEmpty()) {
            return true;
        }
        if (expectedData.size() != actualData.size()) {
            return false;
        }
        if (extension instanceof SingleEntryFileBasedIndexExtension) {
            Object expectedValue = CollectionsKt.first((Iterable)expectedData.values());
            Object actualValue = CollectionsKt.first((Iterable)actualData.values());
            return this.areValuesTheSame(extension, expectedValue, actualValue);
        }
        for (Map.Entry<K, V> entry : expectedData.entrySet()) {
            K expectedKey = entry.getKey();
            V expectedValue = entry.getValue();
            if (!actualData.containsKey(expectedKey)) {
                return false;
            }
            V actualValue = actualData.get(expectedKey);
            if (this.areValuesTheSame(extension, expectedValue, actualValue)) continue;
            return false;
        }
        return true;
    }

    public final <V> boolean areValuesTheSame(@NotNull FileBasedIndexExtension<?, ?> extension, @Nullable V expectedValue, @Nullable V actualValue) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        if (expectedValue == null || actualValue == null) {
            return expectedValue == null && actualValue == null;
        }
        if (expectedValue instanceof SerializedStubTree) {
            Object object;
            Object object2;
            if (!(actualValue instanceof SerializedStubTree)) {
                return false;
            }
            Object object3 = this;
            try {
                IndexDataComparer $this$areValuesTheSame_u24lambda_u240 = object3;
                boolean bl = false;
                ((SerializedStubTree)expectedValue).getStubIndicesValueMap();
                object2 = Result.constructor-impl(expectedValue);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object3 = object2;
            Object object4 = Result.isFailure-impl((Object)object3) ? null : object3;
            SerializedStubTree serializedStubTree = object4 instanceof SerializedStubTree ? (SerializedStubTree)object4 : null;
            if (serializedStubTree == null) {
                return false;
            }
            SerializedStubTree currentStubTree = serializedStubTree;
            object2 = this;
            try {
                IndexDataComparer $this$areValuesTheSame_u24lambda_u241 = (IndexDataComparer)object2;
                boolean bl = false;
                ((SerializedStubTree)actualValue).getStubIndicesValueMap();
                object = Result.constructor-impl(actualValue);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            object3 = Result.isFailure-impl((Object)object2) ? null : object2;
            SerializedStubTree serializedStubTree2 = object3 instanceof SerializedStubTree ? (SerializedStubTree)object3 : null;
            if (serializedStubTree2 == null) {
                return false;
            }
            SerializedStubTree actualStubTree = serializedStubTree2;
            return this.areStubTreesTheSame(currentStubTree, actualStubTree);
        }
        DataExternalizer dataExternalizer = extension.getValueExternalizer();
        Intrinsics.checkNotNullExpressionValue((Object)dataExternalizer, (String)"getValueExternalizer(...)");
        DataExternalizer valueExternalizer = dataExternalizer;
        return valueExternalizer instanceof EqualityPolicy ? ((EqualityPolicy)valueExternalizer).isEqual(expectedValue, actualValue) : Intrinsics.areEqual(expectedValue, actualValue);
    }

    public final boolean areStubTreesTheSame(@NotNull SerializedStubTree expectedTree, @NotNull SerializedStubTree actualTree) {
        Intrinsics.checkNotNullParameter((Object)expectedTree, (String)"expectedTree");
        Intrinsics.checkNotNullParameter((Object)actualTree, (String)"actualTree");
        Stub stub = expectedTree.getStub();
        Intrinsics.checkNotNullExpressionValue((Object)stub, (String)"getStub(...)");
        Stub expectedStub = stub;
        Stub stub2 = actualTree.getStub();
        Intrinsics.checkNotNullExpressionValue((Object)stub2, (String)"getStub(...)");
        Stub actualStub = stub2;
        if (!this.areStubsTheSame(expectedStub, actualStub)) {
            return false;
        }
        return Intrinsics.areEqual(expectedTree.getStubIndicesValueMap(), actualTree.getStubIndicesValueMap());
    }

    private final IElementType getElementType(Stub $this$elementType) {
        StubElement stubElement = $this$elementType instanceof StubElement ? (StubElement)$this$elementType : null;
        return stubElement != null ? stubElement.getElementType() : null;
    }

    private final boolean areStubsTheSame(Stub expectedStub, Stub actualStub) {
        if (!Intrinsics.areEqual((Object)expectedStub.getStubSerializer(), (Object)actualStub.getStubSerializer())) {
            ObjectStubSerializer objectStubSerializer = expectedStub.getStubSerializer();
            ObjectStubSerializer objectStubSerializer2 = actualStub.getStubSerializer();
            if (!Intrinsics.areEqual((Object)(objectStubSerializer != null ? objectStubSerializer.toString() : null), (Object)(objectStubSerializer2 != null ? objectStubSerializer2.toString() : null)) && !Intrinsics.areEqual((Object)this.getElementType(expectedStub), (Object)this.getElementType(actualStub))) {
                return false;
            }
        }
        if (!Intrinsics.areEqual((Object)expectedStub, (Object)actualStub) && !Intrinsics.areEqual((Object)expectedStub.getClass().getName(), (Object)actualStub.getClass().getName())) {
            return false;
        }
        if (expectedStub instanceof ObjectStubBase) {
            if (!(actualStub instanceof ObjectStubBase)) {
                return false;
            }
            if (((ObjectStubBase)expectedStub).getStubId() != ((ObjectStubBase)actualStub).getStubId()) {
                return false;
            }
        }
        List list = expectedStub.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenStubs(...)");
        List expectedChildren = list;
        List list2 = actualStub.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenStubs(...)");
        List actualChildren = list2;
        if (expectedChildren.size() != actualChildren.size()) {
            return false;
        }
        int n = ((Collection)expectedChildren).size();
        for (int index = 0; index < n; ++index) {
            Stub actualChild;
            Stub expectedChild = (Stub)expectedChildren.get(index);
            if (this.areStubsTheSame(expectedChild, actualChild = (Stub)actualChildren.get(index))) continue;
            return false;
        }
        return true;
    }
}

