/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.FileItem;
import com.intellij.util.lang.ZipEntryResolverPool;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u00020\u0019H\u0096\u0080\u0004R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/plugins/MixedDirAndJarDataLoader;", "Lcom/intellij/ide/plugins/DataLoader;", "Ljava/io/Closeable;", "files", "", "Lcom/intellij/ide/plugins/FileItem;", "pool", "Lcom/intellij/util/lang/ZipEntryResolverPool;", "jarOnly", "", "<init>", "([Lcom/intellij/ide/plugins/FileItem;Lcom/intellij/util/lang/ZipEntryResolverPool;Z)V", "[Lcom/intellij/ide/plugins/FileItem;", "resolvers", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "Lcom/intellij/util/lang/ZipEntryResolverPool$EntryResolver;", "isExcludedFromSubSearch", "jarFile", "Ljava/nio/file/Path;", "emptyDescriptorIfCannotResolve", "getEmptyDescriptorIfCannotResolve", "()Z", "load", "", "path", "", "pluginDescriptorSourceOnly", "close", "", "toString", "intellij.platform.core.impl"})
final class MixedDirAndJarDataLoader
implements DataLoader,
Closeable {
    @NotNull
    private final FileItem[] files;
    @NotNull
    private final ZipEntryResolverPool pool;
    private final boolean jarOnly;
    @NotNull
    private final AtomicReferenceArray<ZipEntryResolverPool.EntryResolver> resolvers;

    public MixedDirAndJarDataLoader(@NotNull FileItem[] files, @NotNull ZipEntryResolverPool pool, boolean jarOnly) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.files = files;
        this.pool = pool;
        this.jarOnly = jarOnly;
        this.resolvers = new AtomicReferenceArray(this.files.length);
    }

    @Override
    public boolean isExcludedFromSubSearch(@NotNull Path jarFile) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        return true;
    }

    @Override
    public boolean getEmptyDescriptorIfCannotResolve() {
        return true;
    }

    @Override
    @Nullable
    public byte[] load(@NotNull String path, boolean pluginDescriptorSourceOnly) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.charAt(0) == '/') {
            String string2 = path.substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = path;
        }
        String effectivePath = string;
        FileItem[] fileItemArray = this.files;
        int n = fileItemArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            FileItem item = fileItemArray[i];
            if (this.jarOnly || StringsKt.endsWith$default((String)item.path, (String)".jar", (boolean)false, (int)2, null)) {
                ZipEntryResolverPool.EntryResolver resolver;
                if (this.resolvers.get(index) == null) {
                    this.resolvers.set(index, this.pool.load(item.file));
                }
                Intrinsics.checkNotNull((Object)this.resolvers.get(index));
                byte[] result = resolver.loadZipEntry(effectivePath);
                if (result != null) {
                    return result;
                }
            } else {
                try {
                    return Files.readAllBytes(item.file.resolve(effectivePath));
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
            if (this.jarOnly && pluginDescriptorSourceOnly) break;
        }
        return null;
    }

    @Override
    public void close() {
        int n = this.files.length;
        for (int index = 0; index < n; ++index) {
            ZipEntryResolverPool.EntryResolver entryResolver = this.resolvers.getAndSet(index, null);
            if (entryResolver == null) continue;
            entryResolver.close();
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "plugin-classpath.txt based data loader";
    }
}

