/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.codeInsight.multiverse.CodeInsightContextUtil;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerEx;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.file.PsiLargeBinaryFileImpl;
import com.intellij.psi.impl.file.PsiLargeTextFileImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractFileViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private static final Logger LOG = Logger.getInstance(AbstractFileViewProvider.class);
    public static final Key<Object> FREE_THREADED = Key.create((String)"FREE_THREADED");
    private static final Key<Set<AbstractFileViewProvider>> KNOWN_COPIES = Key.create((String)"KNOWN_COPIES");
    @NotNull
    private final PsiManagerEx myManager;
    @NotNull
    private final VirtualFile myVirtualFile;
    private final boolean myEventSystemEnabled;
    private final boolean myPhysical;
    private volatile Content myContent;
    private volatile Reference<Document> myDocument;
    private final PsiLock myPsiLock;

    protected AbstractFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(1);
        }
        this.myPsiLock = new PsiLock();
        this.myManager = (PsiManagerEx)manager;
        this.myVirtualFile = virtualFile;
        this.myEventSystemEnabled = eventSystemEnabled;
        this.setContent(new VirtualFileContent());
        this.myPhysical = this.isEventSystemEnabled() && !(virtualFile instanceof LightVirtualFile) && !(virtualFile.getFileSystem() instanceof NonPhysicalFileSystem);
        virtualFile.putUserData(FREE_THREADED, (Object)AbstractFileViewProvider.isFreeThreaded(this));
        if (virtualFile instanceof VirtualFileWindow && !(this instanceof FreeThreadedFileViewProvider) && !AbstractFileViewProvider.isFreeThreaded(this)) {
            throw new IllegalArgumentException("Must not create " + ((Object)((Object)this)).getClass() + " for injected file " + virtualFile + "; InjectedFileViewProvider must be used instead");
        }
    }

    protected boolean shouldCreatePsi() {
        if (this.isIgnored()) {
            return false;
        }
        VirtualFile vFile = this.getVirtualFile();
        if (this.isPhysical() && vFile.isInLocalFileSystem()) {
            FileIndexFacade indexFacade;
            VirtualFile parent = vFile.getParent();
            if (parent == null) {
                return false;
            }
            PsiDirectory psiDir = this.getManager().findDirectory(parent);
            if (psiDir == null && !(indexFacade = FileIndexFacade.getInstance((Project)this.getManager().getProject())).isInLibrarySource(vFile) && !indexFacade.isInLibraryClasses(vFile)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isFreeThreaded(@NotNull FileViewProvider provider) {
        if (provider == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(2);
        }
        return provider.getVirtualFile() instanceof LightVirtualFile && !provider.isEventSystemEnabled();
    }

    @NotNull
    public PsiLock getFilePsiLock() {
        PsiLock psiLock = this.myPsiLock;
        if (psiLock == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(3);
        }
        return psiLock;
    }

    protected final boolean isIgnored() {
        VirtualFile file = this.getVirtualFile();
        return !(file instanceof LightVirtualFile) && FileTypeRegistry.getInstance().isFileIgnored(file);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileType fileType) {
        if (project == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(6);
        }
        return this.createFile(file, fileType, this.getBaseLanguage());
    }

    @NotNull
    protected PsiFile createFile(@NotNull VirtualFile file, @NotNull FileType fileType, @NotNull Language language) {
        PsiFile psiFile;
        if (file == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(7);
        }
        if (fileType == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(8);
        }
        if (language == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(9);
        }
        if (fileType.isBinary() || file.is(VFileProperty.SPECIAL)) {
            return SingleRootFileViewProvider.isTooLargeForContentLoading(file) ? new PsiLargeBinaryFileImpl(this.getManager(), (FileViewProvider)this) : new PsiBinaryFileImpl(this.getManager(), (FileViewProvider)this);
        }
        if (!SingleRootFileViewProvider.isTooLargeForIntelligence(file) && (psiFile = this.createFile(language)) != null) {
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) {
                AbstractFileViewProvider.$$$reportNull$$$0(10);
            }
            return psiFile2;
        }
        if (SingleRootFileViewProvider.isTooLargeForContentLoading(file)) {
            return new PsiLargeTextFileImpl(this);
        }
        return new PsiPlainTextFileImpl(this);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(11);
        }
        if (lang != this.getBaseLanguage()) {
            return null;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createFile((FileViewProvider)this);
        }
        return null;
    }

    @NotNull
    public final PsiManagerEx getManager() {
        PsiManagerEx psiManagerEx = this.myManager;
        if (psiManagerEx == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(12);
        }
        return psiManagerEx;
    }

    @NotNull
    public CharSequence getContents() {
        CharSequence charSequence = this.getContent().getText();
        if (charSequence == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(13);
        }
        return charSequence;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(14);
        }
        return virtualFile;
    }

    @Nullable
    Document getCachedDocument() {
        Document document = (Document)SoftReference.dereference(this.myDocument);
        if (document != null) {
            return document;
        }
        return FileDocumentManager.getInstance().getCachedDocument(this.getVirtualFile());
    }

    public Document getDocument() {
        Document document = (Document)SoftReference.dereference(this.myDocument);
        if (document == null) {
            VirtualFile file = this.getVirtualFile();
            document = FileDocumentManager.getInstance().getDocument(file, this.myManager.getProject());
            this.myDocument = document == null ? null : new java.lang.ref.SoftReference<Document>(document);
        }
        return document;
    }

    @Nullable
    public final PsiFile getPsi(@NotNull Language target) {
        VirtualFile virtualFile;
        FileManager fileManager;
        if (target == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(15);
        }
        if (!this.isPhysical() && (fileManager = this.getManager().getFileManager()).findCachedViewProvider(virtualFile = this.getVirtualFile()) == null && this.getCachedPsiFiles().isEmpty()) {
            fileManager.setViewProvider(virtualFile, this);
        }
        return this.getPsiInner(target);
    }

    @Nullable
    protected abstract PsiFile getPsiInner(@NotNull Language var1);

    public FileViewProvider clone() {
        VirtualFile origFile = this.getVirtualFile();
        LightVirtualFile copy = new LightVirtualFile(origFile.getName(), origFile.getFileType(), this.getContents(), origFile.getCharset(), this.getModificationStamp());
        origFile.copyCopyableDataTo((UserDataHolderBase)copy);
        copy.setOriginalFile(origFile);
        UndoUtil.disableUndoFor((VirtualFile)copy);
        copy.setCharset(origFile.getCharset());
        return this.createCopy((VirtualFile)copy);
    }

    public PsiElement findElementAt(int offset, @NotNull Language language) {
        PsiFile psiFile;
        if (language == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(16);
        }
        return (psiFile = this.getPsi(language)) != null ? AbstractFileViewProvider.findElementAt((PsiElement)psiFile, offset) : null;
    }

    @Nullable
    public PsiReference findReferenceAt(int offset, @NotNull Language language) {
        PsiFile psiFile;
        if (language == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(17);
        }
        return (psiFile = this.getPsi(language)) != null ? AbstractFileViewProvider.findReferenceAt(psiFile, offset) : null;
    }

    @Nullable
    protected static PsiReference findReferenceAt(@Nullable PsiFile psiFile, int offset) {
        if (psiFile == null) {
            return null;
        }
        int offsetInElement = offset;
        for (PsiElement child = psiFile.getFirstChild(); child != null; child = child.getNextSibling()) {
            int length = child.getTextLength();
            if (length <= offsetInElement) {
                offsetInElement -= length;
                continue;
            }
            return child.findReferenceAt(offsetInElement);
        }
        return null;
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiElement psiFile, int offset) {
        ASTNode node = psiFile == null ? null : psiFile.getNode();
        return node == null ? null : SourceTreeToPsiMap.treeElementToPsi(node.findLeafElementAt(offset));
    }

    public void beforeContentsSynchronized() {
    }

    public void contentsSynchronized() {
        if (this.myContent instanceof PsiFileContent) {
            this.setContent(new VirtualFileContent());
        }
        this.checkLengthConsistency();
    }

    public final void onContentReload() {
        List<PsiFile> psiFiles = this.getCachedPsiFiles();
        ArrayList<PsiTreeChangeEventImpl> events = new ArrayList<PsiTreeChangeEventImpl>(psiFiles.size());
        ArrayList<PsiTreeChangeEventImpl> genericEvents = new ArrayList<PsiTreeChangeEventImpl>(psiFiles.size());
        for (PsiFile psiFile : psiFiles) {
            genericEvents.add(this.createChildrenChangeEvent(psiFile, true));
            events.add(this.createChildrenChangeEvent(psiFile, false));
        }
        this.beforeContentsSynchronized();
        for (PsiTreeChangeEventImpl event : genericEvents) {
            this.getManager().beforeChildrenChange(event);
        }
        for (PsiTreeChangeEventImpl event : events) {
            this.getManager().beforeChildrenChange(event);
        }
        for (PsiFile psiFile : psiFiles) {
            if (!(psiFile instanceof PsiFileEx)) continue;
            ((PsiFileEx)psiFile).onContentReload();
        }
        this.contentsSynchronized();
        for (PsiTreeChangeEventImpl event : events) {
            this.getManager().childrenChanged(event);
        }
        for (PsiTreeChangeEventImpl event : genericEvents) {
            this.getManager().childrenChanged(event);
        }
    }

    @NotNull
    private PsiTreeChangeEventImpl createChildrenChangeEvent(@NotNull PsiFile psiFile, boolean generic) {
        if (psiFile == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(18);
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        event.setParent((PsiElement)psiFile);
        event.setFile(psiFile);
        event.setGenericChange(generic);
        if (psiFile instanceof PsiFileImpl && ((PsiFileImpl)psiFile).isContentsLoaded()) {
            event.setOffset(0);
            event.setOldLength(psiFile.getTextLength());
        }
        PsiTreeChangeEventImpl psiTreeChangeEventImpl = event;
        if (psiTreeChangeEventImpl == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(19);
        }
        return psiTreeChangeEventImpl;
    }

    public void rootChanged(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(20);
        }
        if (psiFile instanceof PsiFileImpl && ((PsiFileImpl)psiFile).isContentsLoaded() && psiFile.isValid()) {
            this.setContent(new PsiFileContent(((PsiFileImpl)psiFile).calcTreeElement(), LocalTimeCounter.currentTime()));
        }
    }

    public boolean isEventSystemEnabled() {
        return this.myEventSystemEnabled;
    }

    public boolean isPhysical() {
        return this.myPhysical;
    }

    public long getModificationStamp() {
        return this.getContent().getModificationStamp();
    }

    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(21);
        }
        return true;
    }

    @NotNull
    private Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(22);
        }
        return content;
    }

    private void setContent(@NotNull Content content) {
        if (content == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(23);
        }
        this.myContent = content;
    }

    private void checkLengthConsistency() {
        Document document = this.getCachedDocument();
        if (document instanceof DocumentWindow) {
            return;
        }
        if (document != null && ((PsiDocumentManagerEx)PsiDocumentManager.getInstance((Project)this.myManager.getProject())).getSynchronizer().isInSynchronization(document)) {
            return;
        }
        List<FileASTNode> knownTreeRoots = this.getKnownTreeRoots();
        if (knownTreeRoots.isEmpty()) {
            return;
        }
        int fileLength = this.myContent.getTextLength();
        for (FileASTNode fileElement : knownTreeRoots) {
            Attachment[] attachmentArray;
            int nodeLength;
            if (this.isDocumentConsistentWithPsi(fileLength, fileElement, nodeLength = fileElement.getTextLength())) continue;
            PsiUtilCore.ensureValid((PsiElement)fileElement.getPsi());
            Attachment vfContent = new Attachment(this.myVirtualFile.getName(), this.myContent.getText().toString());
            Attachment astContent = new Attachment(this.myVirtualFile.getNameWithoutExtension() + ".tree.txt", fileElement.getText());
            if (document == null) {
                Attachment[] attachmentArray2 = new Attachment[2];
                attachmentArray2[0] = vfContent;
                attachmentArray = attachmentArray2;
                attachmentArray2[1] = astContent;
            } else {
                Attachment[] attachmentArray3 = new Attachment[3];
                attachmentArray3[0] = vfContent;
                attachmentArray3[1] = astContent;
                attachmentArray = attachmentArray3;
                attachmentArray3[2] = new Attachment(this.myVirtualFile.getNameWithoutExtension() + ".document.txt", document.getText());
            }
            Attachment[] attachments = attachmentArray;
            String message = "Inconsistent " + fileElement.getElementType() + " tree in " + (Object)((Object)this) + "; nodeLength=" + nodeLength + "; fileLength=" + fileLength;
            if (CodeInsightContexts.isSharedSourceSupportEnabled((Project)this.getManager().getProject())) {
                message = message + "; context: " + CodeInsightContextUtil.getCodeInsightContext((FileViewProvider)this);
                FileManager fileManager = PsiManagerEx.getInstanceEx(this.getManager().getProject()).getFileManager();
                List<FileViewProvider> providers = fileManager.findCachedViewProviders(this.myVirtualFile);
                message = message + "; known view providers: " + providers.size();
            }
            LOG.error(message, attachments);
        }
    }

    private boolean isDocumentConsistentWithPsi(int fileLength, @NotNull FileASTNode fileElement, int nodeLength) {
        if (fileElement == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(24);
        }
        if (nodeLength != fileLength) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManagerEx.isInStressTest()) {
            return fileElement.getPsi().textMatches(this.myContent.getText());
        }
        return true;
    }

    @NonNls
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "{vFile=" + this.myVirtualFile + (this.myVirtualFile instanceof VirtualFileWithId ? ", vFileId=" + ((VirtualFileWithId)this.myVirtualFile).getId() : "") + ", content=" + this.getContent() + ", eventSystemEnabled=" + this.isEventSystemEnabled() + '}';
    }

    @Nullable
    public abstract PsiFile getCachedPsi(@NotNull Language var1);

    public abstract @Unmodifiable @NotNull List<PsiFile> getCachedPsiFiles();

    public abstract @Unmodifiable @NotNull List<FileASTNode> getKnownTreeRoots();

    public final void markInvalidated() {
        this.invalidateCachedPsi();
        for (AbstractFileViewProvider copy : this.getKnownCopies()) {
            this.myManager.getFileManager().setViewProvider(copy.getVirtualFile(), null);
        }
    }

    public final void markPossiblyInvalidated() {
        this.invalidateCachedPsi();
        for (AbstractFileViewProvider copy : this.getKnownCopies()) {
            FileManagerImpl.markPossiblyInvalidated(copy);
        }
    }

    private void invalidateCachedPsi() {
        for (PsiFile file : this.getCachedPsiFiles()) {
            if (!(file instanceof PsiFileEx)) continue;
            ((PsiFileEx)file).markInvalidated();
        }
    }

    @NotNull
    private @Unmodifiable Iterable<AbstractFileViewProvider> getKnownCopies() {
        Set copies = (Set)this.getUserData(KNOWN_COPIES);
        if (copies != null) {
            List list = ContainerUtil.filter((Collection)copies, copy -> ContainerUtil.exists(copy.getCachedPsiFiles(), f -> f.getOriginalFile().getViewProvider() == this));
            if (list == null) {
                AbstractFileViewProvider.$$$reportNull$$$0(25);
            }
            return list;
        }
        Set<AbstractFileViewProvider> set = Collections.emptySet();
        if (set == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(26);
        }
        return set;
    }

    public final void registerAsCopy(@NotNull AbstractFileViewProvider copy) {
        List derivations;
        if (copy == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(27);
        }
        if (copy instanceof FreeThreadedFileViewProvider) {
            LOG.assertTrue(this instanceof FreeThreadedFileViewProvider, (Object)"Injected file can't have non-injected original file");
        }
        Set copies = (Set)ConcurrencyUtil.computeIfAbsent((UserDataHolder)this, KNOWN_COPIES, () -> Collections.newSetFromMap(CollectionFactory.createConcurrentWeakMap()));
        if (copy.getUserData(KNOWN_COPIES) != null && (derivations = ((JBTreeTraverser)JBTreeTraverser.from(AbstractFileViewProvider::getKnownCopies).withRoot((Object)copy)).toList()).contains((Object)this)) {
            throw new IllegalStateException("An attempted cycle in view provider copy graph involving " + (Object)((Object)this) + " and " + (Object)((Object)copy));
        }
        copies.add(copy);
    }

    @NotNull
    private CharSequence getLastCommittedText(@NotNull Document document) {
        if (document == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(28);
        }
        CharSequence charSequence = PsiDocumentManager.getInstance((Project)this.myManager.getProject()).getLastCommittedText(document);
        if (charSequence == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(29);
        }
        return charSequence;
    }

    private long getLastCommittedStamp(@NotNull Document document) {
        if (document == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(30);
        }
        return PsiDocumentManager.getInstance((Project)this.myManager.getProject()).getLastCommittedStamp(document);
    }

    @NotNull
    public PsiFile getStubBindingRoot() {
        PsiFile psi = this.getPsi(this.getBaseLanguage());
        assert (psi != null);
        PsiFile psiFile = psi;
        if (psiFile == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(31);
        }
        return psiFile;
    }

    @NotNull
    public final FileType getFileType() {
        FileType fileType = this.myVirtualFile.getFileType();
        if (fileType == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(32);
        }
        return fileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/AbstractFileViewProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 9: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootLanguage";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/AbstractFileViewProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePsiLock";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildrenChangeEvent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownCopies";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommittedText";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubBindingRoot";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFreeThreaded";
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 32: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPsi";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceAt";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createChildrenChangeEvent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "rootChanged";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "supportsIncrementalReparse";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentConsistentWithPsi";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerAsCopy";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedText";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedStamp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class VirtualFileContent
    implements Content {
        private VirtualFileContent() {
        }

        @Override
        @NotNull
        public CharSequence getText() {
            VirtualFile virtualFile = AbstractFileViewProvider.this.getVirtualFile();
            if (virtualFile instanceof LightVirtualFile) {
                Document doc = AbstractFileViewProvider.this.getCachedDocument();
                if (doc != null) {
                    CharSequence charSequence = AbstractFileViewProvider.this.getLastCommittedText(doc);
                    if (charSequence == null) {
                        VirtualFileContent.$$$reportNull$$$0(0);
                    }
                    return charSequence;
                }
                CharSequence charSequence = ((LightVirtualFile)virtualFile).getContent();
                if (charSequence == null) {
                    VirtualFileContent.$$$reportNull$$$0(1);
                }
                return charSequence;
            }
            Document document = AbstractFileViewProvider.this.getDocument();
            if (document == null) {
                CharSequence charSequence = LoadTextUtil.loadText(virtualFile);
                if (charSequence == null) {
                    VirtualFileContent.$$$reportNull$$$0(2);
                }
                return charSequence;
            }
            CharSequence charSequence = AbstractFileViewProvider.this.getLastCommittedText(document);
            if (charSequence == null) {
                VirtualFileContent.$$$reportNull$$$0(3);
            }
            return charSequence;
        }

        @Override
        public int getTextLength() {
            return this.getText().length();
        }

        @Override
        public long getModificationStamp() {
            Document document = AbstractFileViewProvider.this.getCachedDocument();
            if (document == null) {
                return AbstractFileViewProvider.this.getVirtualFile().getModificationStamp();
            }
            return AbstractFileViewProvider.this.getLastCommittedStamp(document);
        }

        @NonNls
        public String toString() {
            return "VirtualFileContent{size=" + AbstractFileViewProvider.this.getVirtualFile().getLength() + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/AbstractFileViewProvider$VirtualFileContent", "getText"));
        }
    }

    private static interface Content {
        @NotNull
        public CharSequence getText();

        public int getTextLength();

        public long getModificationStamp();
    }

    private static class PsiFileContent
    implements Content {
        private final long myModificationStamp;
        private final FileElement myFileElement;

        PsiFileContent(@NotNull FileElement fileElement, long modificationStamp) {
            if (fileElement == null) {
                PsiFileContent.$$$reportNull$$$0(0);
            }
            this.myModificationStamp = modificationStamp;
            this.myFileElement = fileElement;
        }

        @Override
        @NotNull
        public CharSequence getText() {
            String string = this.myFileElement.getText();
            if (string == null) {
                PsiFileContent.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public int getTextLength() {
            return this.myFileElement.getTextLength();
        }

        @Override
        public long getModificationStamp() {
            return this.myModificationStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/AbstractFileViewProvider$PsiFileContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/AbstractFileViewProvider$PsiFileContent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

