/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.LanguageStubDescriptor;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TemplateLanguageStubBaseVersion;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StubBuilderType {
    private static final Logger LOG = Logger.getInstance(StubBuilderType.class);
    private final LanguageStubDescriptor myStubDescriptor;
    private final List<String> myProperties;
    private final BinaryFileStubBuilder myBinaryFileStubBuilder;
    private final Object myBinarySubBuilder;

    StubBuilderType(@NotNull LanguageStubDescriptor stubDescriptor, @NotNull List<String> properties) {
        if (stubDescriptor == null) {
            StubBuilderType.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            StubBuilderType.$$$reportNull$$$0(1);
        }
        this.myStubDescriptor = stubDescriptor;
        this.myProperties = properties;
        this.myBinaryFileStubBuilder = null;
        this.myBinarySubBuilder = null;
    }

    StubBuilderType(@NotNull BinaryFileStubBuilder binaryFileStubBuilder) {
        if (binaryFileStubBuilder == null) {
            StubBuilderType.$$$reportNull$$$0(2);
        }
        this.myStubDescriptor = null;
        this.myBinaryFileStubBuilder = binaryFileStubBuilder;
        this.myBinarySubBuilder = null;
        this.myProperties = Collections.emptyList();
    }

    StubBuilderType(@NotNull BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<?> binaryFileStubBuilder, @Nullable Object binarySubBuilder) {
        if (binaryFileStubBuilder == null) {
            StubBuilderType.$$$reportNull$$$0(3);
        }
        this.myStubDescriptor = null;
        this.myBinaryFileStubBuilder = binaryFileStubBuilder;
        this.myBinarySubBuilder = binarySubBuilder;
        this.myProperties = Collections.emptyList();
    }

    @NotNull
    public Class<?> getClassToBlameInCaseOfException() {
        if (this.myStubDescriptor != null) {
            Class<?> clazz = this.myStubDescriptor.getFileElementType().getClass();
            if (clazz == null) {
                StubBuilderType.$$$reportNull$$$0(4);
            }
            return clazz;
        }
        if (this.myBinarySubBuilder == null) {
            Class clazz = this.myBinaryFileStubBuilder.getClass();
            if (clazz == null) {
                StubBuilderType.$$$reportNull$$$0(5);
            }
            return clazz;
        }
        Class<?> clazz = this.myBinarySubBuilder.getClass();
        if (clazz == null) {
            StubBuilderType.$$$reportNull$$$0(6);
        }
        return clazz;
    }

    BinaryFileStubBuilder getBinaryFileStubBuilder() {
        return this.myBinaryFileStubBuilder;
    }

    public IFileElementType getFileElementType() {
        return this.myStubDescriptor != null ? this.myStubDescriptor.getFileElementType() : null;
    }

    public String getVersion() {
        if (this.myStubDescriptor != null) {
            int templateStubBaseVersion;
            int elementTypeStubVersion = this.myStubDescriptor.getStubDefinition().getStubVersion();
            if (this.myStubDescriptor.getLanguage() instanceof TemplateLanguage && elementTypeStubVersion < (templateStubBaseVersion = TemplateLanguageStubBaseVersion.getVersion())) {
                PluginException.logPluginError((Logger)LOG, (String)(this.myStubDescriptor.getFileElementType().getClass() + " " + this.myStubDescriptor.getLanguage() + " version=" + elementTypeStubVersion + "  stub version should call super.getStubVersion()  template stub version=" + templateStubBaseVersion), null, this.myStubDescriptor.getFileElementType().getClass());
            }
            String baseVersion = this.myStubDescriptor.getFileElementSerializer().getExternalId() + ":" + elementTypeStubVersion + ":" + this.myStubDescriptor.getFileElementType().getDebugName();
            return this.myProperties.isEmpty() ? baseVersion : baseVersion + ":" + StringUtil.join(this.myProperties, (String)",");
        }
        assert (this.myBinaryFileStubBuilder != null);
        String baseVersion = this.myBinaryFileStubBuilder.getClass().getName() + ":" + this.myBinaryFileStubBuilder.getStubVersion();
        if (this.myBinaryFileStubBuilder instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder) {
            return baseVersion + ":" + ((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)this.myBinaryFileStubBuilder).getSubBuilderVersion(this.myBinarySubBuilder);
        }
        return baseVersion;
    }

    @NotNull
    public static List<IFileElementType> getStubFileElementTypeFromVersion(@NotNull String version) {
        int externalIdDelimPos;
        if (version == null) {
            StubBuilderType.$$$reportNull$$$0(7);
        }
        if ((externalIdDelimPos = version.indexOf(58)) == -1) {
            LOG.error("Version info is incomplete: " + version);
            externalIdDelimPos = version.length();
        }
        String externalId = version.substring(0, externalIdDelimPos);
        StubElementRegistryService stubElementRegistryService = StubElementRegistryService.getInstance();
        List matches = IElementType.mapNotNull(type -> {
            if (!(type instanceof IFileElementType)) {
                return null;
            }
            @NotNull ObjectStubSerializer serializer = stubElementRegistryService.getStubSerializer(type);
            if (serializer == null || !serializer.getExternalId().equals(externalId)) {
                return null;
            }
            return (IFileElementType)type;
        });
        if (matches.size() > 1) {
            int stubVersionDelimPos = version.indexOf(58, externalIdDelimPos + 1);
            if (stubVersionDelimPos == -1) {
                LOG.error("Version info is incomplete: " + version);
                List list = matches;
                if (list == null) {
                    StubBuilderType.$$$reportNull$$$0(8);
                }
                return list;
            }
            int debugNameDelimPos = version.indexOf(58, stubVersionDelimPos + 1);
            if (debugNameDelimPos == -1) {
                debugNameDelimPos = version.length();
            }
            String debugName = version.substring(stubVersionDelimPos + 1, debugNameDelimPos);
            matches = ContainerUtil.filter((Collection)matches, p -> p.getDebugName().equals(debugName));
        }
        List list = matches;
        if (list == null) {
            StubBuilderType.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StubBuilderType type = (StubBuilderType)o;
        return Objects.equals(this.myStubDescriptor.getFileElementType(), type.myStubDescriptor.getFileElementType()) && Objects.equals(this.myBinaryFileStubBuilder, type.myBinaryFileStubBuilder) && Objects.equals(this.myProperties, type.myProperties) && Objects.equals(this.myBinarySubBuilder, type.myBinarySubBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.getFileElementType(), this.myBinaryFileStubBuilder, this.myBinarySubBuilder, this.myProperties);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFileStubBuilder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubBuilderType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubBuilderType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassToBlameInCaseOfException";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubFileElementTypeFromVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStubFileElementTypeFromVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

