/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ*\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0001H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\n\u0010 \u001a\u00020!H\u0096\u0080\u0004J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c2\u0003J\t\u0010$\u001a\u00020\u0007H\u00c2\u0003J'\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0083\u0004J\n\u0010)\u001a\u00020\u0007H\u00d6\u0081\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\f\u00a8\u0006*"}, d2={"Lcom/intellij/util/ui/JBHiDpiScalableIcon;", "Ljavax/swing/Icon;", "Lcom/intellij/ui/icons/CopyableIcon;", "Lcom/intellij/openapi/util/ScalableIcon;", "source", "Ljava/awt/Image;", "height", "", "width", "<init>", "(Ljava/awt/Image;II)V", "getSource", "()Ljava/awt/Image;", "scaledImage", "getScaledImage", "scaledImage$delegate", "Lkotlin/Lazy;", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "getIconWidth", "getIconHeight", "copy", "getScale", "", "scale", "scaleFactor", "toString", "", "component1", "component2", "component3", "equals", "", "other", "", "hashCode", "intellij.platform.util.ui"})
public final class JBHiDpiScalableIcon
implements Icon,
CopyableIcon,
ScalableIcon {
    @NotNull
    private final Image source;
    private final int height;
    private final int width;
    @NotNull
    private final Lazy scaledImage$delegate;

    public JBHiDpiScalableIcon(@NotNull Image source, int height, int width) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.height = height;
        this.width = width;
        this.scaledImage$delegate = LazyKt.lazy(() -> JBHiDpiScalableIcon.scaledImage_delegate$lambda$0(this));
    }

    public /* synthetic */ JBHiDpiScalableIcon(Image image, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = image.getHeight(null);
        }
        if ((n3 & 4) != 0) {
            n2 = image.getWidth(null);
        }
        this(image, n, n2);
    }

    @NotNull
    public final Image getSource() {
        return this.source;
    }

    @NotNull
    public final Image getScaledImage() {
        Lazy lazy = this.scaledImage$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Image)object;
    }

    @Override
    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        StartupUiUtil.drawImage(g, this.getScaledImage(), x, y, (ImageObserver)c);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public Icon copy() {
        return new JBHiDpiScalableIcon(this.source, this.height, this.width);
    }

    public float getScale() {
        return (float)this.height / (float)this.source.getWidth(null);
    }

    @NotNull
    public Icon scale(float scaleFactor) {
        return new JBHiDpiScalableIcon(this.source, MathKt.roundToInt((float)((float)this.height * scaleFactor)), MathKt.roundToInt((float)((float)this.width * scaleFactor)));
    }

    @NotNull
    public String toString() {
        return "HiDpiScaledIcon for " + this.source;
    }

    @NotNull
    public final Image component1() {
        return this.source;
    }

    private final int component2() {
        return this.height;
    }

    private final int component3() {
        return this.width;
    }

    @NotNull
    public final JBHiDpiScalableIcon copy(@NotNull Image source, int height, int width) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new JBHiDpiScalableIcon(source, height, width);
    }

    public static /* synthetic */ JBHiDpiScalableIcon copy$default(JBHiDpiScalableIcon jBHiDpiScalableIcon, Image image, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            image = jBHiDpiScalableIcon.source;
        }
        if ((n3 & 2) != 0) {
            n = jBHiDpiScalableIcon.height;
        }
        if ((n3 & 4) != 0) {
            n2 = jBHiDpiScalableIcon.width;
        }
        return jBHiDpiScalableIcon.copy(image, n, n2);
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = result * 31 + Integer.hashCode(this.height);
        result = result * 31 + Integer.hashCode(this.width);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JBHiDpiScalableIcon)) {
            return false;
        }
        JBHiDpiScalableIcon jBHiDpiScalableIcon = (JBHiDpiScalableIcon)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)jBHiDpiScalableIcon.source)) {
            return false;
        }
        if (this.height != jBHiDpiScalableIcon.height) {
            return false;
        }
        return this.width == jBHiDpiScalableIcon.width;
    }

    private static final Image scaledImage_delegate$lambda$0(JBHiDpiScalableIcon this$0) {
        Image hiDpi = ImageUtil.ensureHiDPI(this$0.source, ScaleContext.Companion.create());
        return ImageUtil.scaleImage(hiDpi, this$0.height, this$0.width);
    }
}

