/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.groovy;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.impl.NegatingComparable;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenVersionComparable;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.plugins.groovy.MavenGroovyPomUtil;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public final class MavenGroovyPomCompletionContributor
extends CompletionContributor {
    public static final Key<VirtualFile> ORIGINAL_POM_FILE = Key.create((String)"ORIGINAL_POM_FILE");

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiElement position;
        if (parameters == null) {
            MavenGroovyPomCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            MavenGroovyPomCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!((position = parameters.getPosition()) instanceof LeafElement)) {
            return;
        }
        Project project = position.getProject();
        VirtualFile virtualFile = parameters.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        MavenProject mavenProject = MavenProjectsManager.getInstance(project).findProject(virtualFile);
        if (mavenProject == null) {
            return;
        }
        List<String> methodCallInfo = MavenGroovyPomUtil.getGroovyMethodCalls(position);
        if (methodCallInfo.isEmpty()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (String s : methodCallInfo) {
            buf.append('<').append(s).append('>');
        }
        for (String s : ContainerUtil.reverse(methodCallInfo)) {
            buf.append('<').append(s).append("/>");
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("pom.xml", (Language)XMLLanguage.INSTANCE, (CharSequence)buf);
        psiFile.putUserData(ORIGINAL_POM_FILE, (Object)virtualFile);
        final ArrayList variants = new ArrayList();
        final String lastMethodCall = (String)ContainerUtil.getLastItem(methodCallInfo);
        final Ref completeDependency = Ref.create((Object)false);
        final Ref completeVersion = Ref.create((Object)false);
        psiFile.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(this, true){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                if (!((Boolean)completeDependency.get()).booleanValue() && element.getParent() instanceof XmlTag && "dependency".equals(((XmlTag)element.getParent()).getName())) {
                    if ("artifactId".equals(lastMethodCall) || "groupId".equals(lastMethodCall)) {
                        completeDependency.set((Object)true);
                    } else if ("version".equals(lastMethodCall) || "dependency".equals(lastMethodCall)) {
                        completeVersion.set((Object)true);
                    }
                }
                if (!((Boolean)completeDependency.get()).booleanValue() && !((Boolean)completeVersion.get()).booleanValue()) {
                    PsiReference[] references;
                    for (PsiReference each : references = MavenGroovyPomCompletionContributor.getReferences(element)) {
                        if (!(each instanceof GenericDomValueReference)) continue;
                        Collections.addAll(variants, each.getVariants());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/plugins/groovy/MavenGroovyPomCompletionContributor$1", "visitElement"));
            }
        });
        for (Object variant : variants) {
            if (variant instanceof LookupElement) {
                result.addElement((LookupElement)variant);
                continue;
            }
            result.addElement((LookupElement)LookupElementBuilder.create(variant));
        }
        if (((Boolean)completeDependency.get()).booleanValue()) {
            DependencySearchService searchService = DependencySearchService.getInstance((Project)project);
            for (String groupId : searchService.getGroupIds("")) {
                for (String artifactId : searchService.getArtifactIds(groupId)) {
                    LookupElementBuilder builder2 = LookupElementBuilder.create((String)(groupId + ":" + artifactId)).withIcon(AllIcons.Nodes.PpLib).withInsertHandler(MavenDependencyInsertHandler.INSTANCE);
                    result.addElement((LookupElement)builder2);
                }
            }
        }
        if (((Boolean)completeVersion.get()).booleanValue()) {
            MavenGroovyPomCompletionContributor.consumeDependencyElement(position, (Consumer<GrClosableBlock>)((Consumer)closableBlock -> {
                String groupId = null;
                String artifactId = null;
                for (GrMethodCall methodCall : PsiTreeUtil.findChildrenOfType((PsiElement)closableBlock, GrMethodCall.class)) {
                    PsiReference reference;
                    GroovyPsiElement[] arguments = methodCall.getArgumentList().getAllArguments();
                    if (arguments.length != 1 || (reference = arguments[0].getReference()) == null) continue;
                    String callExpression = methodCall.getInvokedExpression().getText();
                    String argumentValue = reference.getCanonicalText();
                    if ("groupId".equals(callExpression)) {
                        groupId = argumentValue;
                        continue;
                    }
                    if (!"artifactId".equals(callExpression)) continue;
                    artifactId = argumentValue;
                }
                MavenGroovyPomCompletionContributor.completeVersions(result, project, groupId, artifactId, "");
            }), (Consumer<PsiElement>)((Consumer)element -> {
                if (element.getParent() instanceof PsiLiteral) {
                    Object value = ((PsiLiteral)element.getParent()).getValue();
                    if (value == null) {
                        return;
                    }
                    String[] mavenCoordinates = value.toString().split(":");
                    if (mavenCoordinates.length < 3) {
                        return;
                    }
                    String prefix = mavenCoordinates[0] + ":" + mavenCoordinates[1] + ":";
                    MavenGroovyPomCompletionContributor.completeVersions(result, project, mavenCoordinates[0], mavenCoordinates[1], prefix);
                }
            }));
        }
    }

    private static void completeVersions(@NotNull CompletionResultSet completionResultSet, @NotNull Project project, @Nullable String groupId, @Nullable String artifactId, final @NotNull String prefix) {
        if (completionResultSet == null) {
            MavenGroovyPomCompletionContributor.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MavenGroovyPomCompletionContributor.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            MavenGroovyPomCompletionContributor.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)artifactId)) {
            return;
        }
        CompletionResultSet newResultSet = completionResultSet.withRelevanceSorter(CompletionService.getCompletionService().emptySorter().weigh(new LookupElementWeigher("mavenVersionWeigher"){

            @Nullable
            public Comparable weigh(@NotNull LookupElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new NegatingComparable((Comparable)new MavenVersionComparable(StringUtil.trimStart((String)element.getLookupString(), (String)prefix)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/plugins/groovy/MavenGroovyPomCompletionContributor$2", "weigh"));
            }
        }));
        Set versions = StringUtil.isEmptyOrSpaces((String)groupId) ? Collections.emptySet() : DependencySearchService.getInstance((Project)project).getVersions(groupId, artifactId);
        for (String version : versions) {
            newResultSet.addElement((LookupElement)LookupElementBuilder.create((String)(prefix + version)));
        }
        newResultSet.addElement((LookupElement)LookupElementBuilder.create((String)(prefix + "RELEASE")));
        newResultSet.addElement((LookupElement)LookupElementBuilder.create((String)(prefix + "LATEST")));
    }

    private static PsiReference @NotNull [] getReferences(PsiElement psiElement) {
        PsiReference[] psiReferenceArray = psiElement instanceof XmlText ? psiElement.getParent().getReferences() : psiElement.getReferences();
        if (psiReferenceArray == null) {
            MavenGroovyPomCompletionContributor.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    private static void consumeDependencyElement(PsiElement psiElement, Consumer<GrClosableBlock> closureNotationConsumer, Consumer<PsiElement> stringNotationConsumer) {
        GrClosableBlock owner = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)psiElement, GrClosableBlock.class);
        if (owner != null && owner.getParent() instanceof GrMethodCallExpression) {
            GrMethodCall methodCall;
            String invokedExpressionText = ((GrMethodCallExpression)owner.getParent()).getInvokedExpression().getText();
            if ("dependency".equals(invokedExpressionText)) {
                closureNotationConsumer.consume((Object)owner);
            }
            if ("dependencies".equals(invokedExpressionText) && (methodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)psiElement, GrMethodCall.class)) != null && "dependency".equals(methodCall.getInvokedExpression().getText())) {
                stringNotationConsumer.consume((Object)psiElement);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResultSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/plugins/groovy/MavenGroovyPomCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/plugins/groovy/MavenGroovyPomCompletionContributor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "completeVersions";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class MavenDependencyInsertHandler
    implements InsertHandler<LookupElement> {
        private static final InsertHandler<LookupElement> INSTANCE = new MavenDependencyInsertHandler();

        private MavenDependencyInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            if (context2 == null) {
                MavenDependencyInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                MavenDependencyInsertHandler.$$$reportNull$$$0(1);
            }
            String s = item.getLookupString();
            int idx = s.indexOf(58);
            String groupId = s.substring(0, idx);
            String artifactId = s.substring(idx + 1);
            int startOffset = context2.getStartOffset();
            PsiFile psiFile = context2.getFile();
            PsiElement psiElement = psiFile.findElementAt(startOffset);
            MavenGroovyPomCompletionContributor.consumeDependencyElement(psiElement, (Consumer<GrClosableBlock>)((Consumer)closableBlock -> {
                int textOffset = closableBlock.getTextOffset();
                String value = "{groupId '" + groupId + "'\nartifactId '" + artifactId + "'\nversion ''}";
                context2.getDocument().replaceString(textOffset, textOffset + closableBlock.getTextLength(), (CharSequence)value);
                context2.getEditor().getCaretModel().moveToOffset(textOffset + value.length() - 2);
                context2.commitDocument();
                new ReformatCodeProcessor(psiFile.getProject(), psiFile, closableBlock.getTextRange(), false).run();
                MavenDependencyCompletionUtil.invokeCompletion(context2, CompletionType.BASIC);
            }), (Consumer<PsiElement>)((Consumer)element -> {
                int textOffset = element.getTextOffset();
                String value = "'" + groupId + ":" + artifactId + ":'";
                context2.getDocument().replaceString(textOffset, textOffset + element.getTextLength(), (CharSequence)value);
                context2.getEditor().getCaretModel().moveToOffset(textOffset + value.length() - 1);
                MavenDependencyCompletionUtil.invokeCompletion(context2, CompletionType.BASIC);
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/plugins/groovy/MavenGroovyPomCompletionContributor$MavenDependencyInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

