/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references.paths.github;

import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.lang.references.ReferenceUtil;
import org.intellij.plugins.markdown.lang.references.headers.HeaderAnchorPathReferenceProvider;
import org.intellij.plugins.markdown.lang.references.paths.ContentRootRelatedFileWithoutExtensionReference;
import org.intellij.plugins.markdown.lang.references.paths.github.GithubWikiLocalFileReference;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/lang/references/paths/github/GithubWikiLocalFileReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "anchorReferenceProvider", "Lorg/intellij/plugins/markdown/lang/references/headers/HeaderAnchorPathReferenceProvider;", "staticPathProvider", "Lcom/intellij/openapi/paths/StaticPathReferenceProvider;", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "findPathRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "text", "", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nGithubWikiLocalFileReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubWikiLocalFileReferenceProvider.kt\norg/intellij/plugins/markdown/lang/references/paths/github/GithubWikiLocalFileReferenceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,57:1\n1586#2:58\n1661#2,3:59\n37#3,2:62\n*S KotlinDebug\n*F\n+ 1 GithubWikiLocalFileReferenceProvider.kt\norg/intellij/plugins/markdown/lang/references/paths/github/GithubWikiLocalFileReferenceProvider\n*L\n37#1:58\n37#1:59,3\n37#1:62,2\n*E\n"})
public final class GithubWikiLocalFileReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HeaderAnchorPathReferenceProvider anchorReferenceProvider = new HeaderAnchorPathReferenceProvider();
    @NotNull
    private final StaticPathReferenceProvider staticPathProvider = new StaticPathReferenceProvider(null);
    private static final Pattern linkPattern = Pattern.compile("^https://github.com/[^/]*/[^/]*/wiki/");
    private static final boolean ARE_REFERENCES_SOFT = false;

    public GithubWikiLocalFileReferenceProvider() {
        StaticPathReferenceProvider staticPathReferenceProvider;
        StaticPathReferenceProvider $this$_init__u24lambda_u240 = staticPathReferenceProvider = this.staticPathProvider;
        boolean bl = false;
        $this$_init__u24lambda_u240.setEndingSlashNotAllowed(true);
        $this$_init__u24lambda_u240.setRelativePathsAllowed(false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String text2 = element2.getText();
        Intrinsics.checkNotNull((Object)text2);
        TextRange textRange = this.findPathRangeInElement(text2);
        if (textRange == null) {
            return new PsiReference[0];
        }
        TextRange pathRange = textRange;
        String string = pathRange.substring(text2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String path = string;
        List references = new ArrayList();
        this.staticPathProvider.createReferences(element2, pathRange.getStartOffset(), path, references, false);
        FileReference fileReferences = ReferenceUtil.findFileReference(references);
        if (fileReferences != null) {
            references.add(new ContentRootRelatedFileWithoutExtensionReference(element2, fileReferences, false));
        }
        this.anchorReferenceProvider.createReferences(element2, references, false);
        Iterable $this$map$iv = references;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiReference psiReference = (PsiReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new GithubWikiLocalFileReference((PsiReference)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    private final TextRange findPathRangeInElement(String text2) {
        Matcher matcher = linkPattern.matcher(text2);
        if (!matcher.find()) {
            return null;
        }
        int start = matcher.end();
        int end = PathReferenceProviderBase.getLastPosOfURL((int)start, (String)text2);
        return end == -1 ? new TextRange(start, text2.length()) : new TextRange(start, end);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/lang/references/paths/github/GithubWikiLocalFileReferenceProvider$Companion;", "", "<init>", "()V", "linkPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ARE_REFERENCES_SOFT", "", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

