/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRefsKt;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogDataKt;
import com.intellij.vcs.log.data.VcsLogGraphData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.future.FutureKt;
import kotlinx.coroutines.guava.ListenableFutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J$\u0010\u0011\u001a\u00020\b*\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\bH\u0007J*\u0010\u0014\u001a\u00020\b*\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\bH\u0087@\u00a2\u0006\u0002\u0010\u0015J(\u0010\u0016\u001a\u00020\u0017*\u00020\u00122\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0007J$\u0010\u001d\u001a\u00020\u0017*\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0007J.\u0010\u001d\u001a\u00020\u0017*\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0007J4\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"*\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0007J*\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"*\u00020\u00122\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0007J*\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\"*\u00020\u00122\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0007J2\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\"*\u00020\u00122\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0007J,\u0010'\u001a\u00020(*\u00020\u00122\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0003J2\u0010)\u001a\b\u0012\u0004\u0012\u00020(0\"*\u00020\u00122\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J.\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\"*\u00020\u00122\n\u0010*\u001a\u00060\u0019j\u0002`+2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0007J.\u0010,\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\fH\u0002J$\u00102\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00103\u001a\u00020\u001fH\u0002J,\u00102\u001a\u00060\u0019j\u0002`\u001a2\u0006\u00104\u001a\u0002052\u0006\u0010/\u001a\u0002002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u00102\u001a\u00060\u0019j\u0002`\u001a*\u0002002\n\u0010*\u001a\u00060\u0019j\u0002`+H\u0002J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\b0\"2\f\u00107\u001a\b\u0012\u0004\u0012\u00020(0\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogNavigationUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "jumpToRevisionAsync", "Ljava/util/concurrent/CompletableFuture;", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "showCommitSync", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "requestFocus", "showCommit", "(Lcom/intellij/vcs/log/ui/VcsLogUiEx;Lcom/intellij/vcs/log/Hash;Lcom/intellij/openapi/vfs/VirtualFile;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "jumpToGraphRow", "", "row", "", "Lcom/intellij/vcs/log/graph/VcsLogVisibleGraphIndex;", "silently", "focus", "jumpToBranch", "branchName", "", "repositoryRoot", "jumpToRefOrHash", "Lcom/google/common/util/concurrent/ListenableFuture;", "reference", "jumpToHash", "commitHash", "jumpToCommit", "jumpToCommitSyncInternal", "Lcom/intellij/vcs/log/ui/VcsLogUiEx$JumpResult;", "jumpToCommitInternal", "commitIndex", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "getBranchRow", "vcsLogData", "Lcom/intellij/vcs/log/data/VcsLogData;", "visiblePack", "Lcom/intellij/vcs/log/visible/VisiblePack;", "referenceName", "getCommitRow", "partialHash", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "mapToJumpSuccess", "future", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogNavigationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogNavigationUtil.kt\ncom/intellij/vcs/log/impl/VcsLogNavigationUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,268:1\n777#2:269\n873#2,2:270\n13#3:272\n*S KotlinDebug\n*F\n+ 1 VcsLogNavigationUtil.kt\ncom/intellij/vcs/log/impl/VcsLogNavigationUtil\n*L\n212#1:269\n212#1:270,2\n32#1:272\n*E\n"})
public final class VcsLogNavigationUtil {
    @NotNull
    public static final VcsLogNavigationUtil INSTANCE = new VcsLogNavigationUtil();
    @NotNull
    private static final Logger LOG;

    private VcsLogNavigationUtil() {
    }

    @JvmStatic
    @NotNull
    public static final CompletableFuture<Boolean> jumpToRevisionAsync(@NotNull Project project, @NotNull VirtualFile root, @NotNull Hash hash, @Nullable FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return FutureKt.asCompletableFuture(VcsProjectLog.Companion.getInstance(project).showRevisionAsync(root, hash, filePath));
    }

    public static /* synthetic */ CompletableFuture jumpToRevisionAsync$default(Project project, VirtualFile virtualFile, Hash hash, FilePath filePath, int n, Object object) {
        if ((n & 8) != 0) {
            filePath = null;
        }
        return VcsLogNavigationUtil.jumpToRevisionAsync(project, virtualFile, hash, filePath);
    }

    @ApiStatus.Internal
    public final boolean showCommitSync(@NotNull VcsLogUiEx $this$showCommitSync, @NotNull Hash hash, @NotNull VirtualFile root, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$showCommitSync, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return switch (WhenMappings.$EnumSwitchMapping$0[VcsLogNavigationUtil.jumpToCommitSyncInternal($this$showCommitSync, hash, root, true, requestFocus).ordinal()]) {
            case 1 -> true;
            case 2 -> {
                LOG.warn("Commit " + hash + " for " + root + " not found in " + $this$showCommitSync);
                yield false;
            }
            case 3 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * Unable to fully structure code
     */
    @ApiStatus.Internal
    @Nullable
    public final Object showCommit(@NotNull VcsLogUiEx $this$showCommit, @NotNull Hash hash, @NotNull VirtualFile root, boolean requestFocus, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof showCommit.1)) ** GOTO lbl-1000
        var7_6 = $completion;
        if ((var7_6.label & -2147483648) != 0) {
            var7_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ VcsLogNavigationUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.showCommit(null, null, null, false, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this$showCommit;
                $continuation.L$1 = hash;
                $continuation.L$2 = root;
                $continuation.Z$0 = requestFocus;
                $continuation.label = 1;
                v0 = ListenableFutureKt.await(this.jumpToCommitInternal($this$showCommit, hash, root, true, requestFocus != false), (Continuation)$continuation);
                if (v0 == var8_8) {
                    return var8_8;
                }
                ** GOTO lbl28
            }
            case 1: {
                requestFocus = $continuation.Z$0;
                root = (VirtualFile)$continuation.L$2;
                hash = (Hash)$continuation.L$1;
                $this$showCommit = (VcsLogUiEx)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                switch (WhenMappings.$EnumSwitchMapping$0[((VcsLogUiEx.JumpResult)v0).ordinal()]) {
                    case 1: {
                        v1 = true;
                        break;
                    }
                    case 2: {
                        VcsLogNavigationUtil.LOG.warn("Commit " + hash + " for " + root + " not found in " + $this$showCommit);
                        v1 = false;
                        break;
                    }
                    case 3: {
                        v1 = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return Boxing.boxBoolean((boolean)v1);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @JvmStatic
    public static final void jumpToGraphRow(@NotNull VcsLogUiEx $this$jumpToGraphRow, int row, boolean silently, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)$this$jumpToGraphRow, (String)"<this>");
        $this$jumpToGraphRow.jumpTo(row, (arg_0, arg_1) -> VcsLogNavigationUtil.jumpToGraphRow$lambda$1(VcsLogNavigationUtil::jumpToGraphRow$lambda$0, arg_0, arg_1), (SettableFuture<VcsLogUiEx.JumpResult>)SettableFuture.create(), silently, focus);
    }

    @Deprecated(message="Prefer using jumpToBranch(repositoryRoot: VirtualFile?, branchName: String, silently: Boolean, focus: Boolean)")
    @JvmStatic
    public static final void jumpToBranch(@NotNull VcsLogUiEx $this$jumpToBranch, @NotNull String branchName, boolean silently, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)$this$jumpToBranch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        VcsLogNavigationUtil.jumpToBranch($this$jumpToBranch, null, branchName, silently, focus);
    }

    @JvmStatic
    public static final void jumpToBranch(@NotNull VcsLogUiEx $this$jumpToBranch, @Nullable VirtualFile repositoryRoot, @NotNull String branchName, boolean silently, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)$this$jumpToBranch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        $this$jumpToBranch.jumpTo(branchName, (arg_0, arg_1) -> VcsLogNavigationUtil.jumpToBranch$lambda$1((arg_0, arg_1) -> VcsLogNavigationUtil.jumpToBranch$lambda$0($this$jumpToBranch, repositoryRoot, arg_0, arg_1), arg_0, arg_1), (SettableFuture<VcsLogUiEx.JumpResult>)SettableFuture.create(), silently, focus);
    }

    @JvmStatic
    @NotNull
    public static final ListenableFuture<Boolean> jumpToRefOrHash(@NotNull VcsLogUiEx $this$jumpToRefOrHash, @Nullable VirtualFile repositoryRoot, @NotNull String reference, boolean silently, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)$this$jumpToRefOrHash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        if (StringsKt.isBlank((CharSequence)reference)) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        SettableFuture settableFuture = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"create(...)");
        SettableFuture future = settableFuture;
        VcsLogRefs refs = $this$jumpToRefOrHash.getDataPack().getRefs();
        ApplicationManager.getApplication().executeOnPooledThread(() -> VcsLogNavigationUtil.jumpToRefOrHash$lambda$0(refs, reference, repositoryRoot, $this$jumpToRefOrHash, future, silently, focus));
        return (ListenableFuture)future;
    }

    @Deprecated(message="Prefer using jumpToRefOrHash(repositoryRoot: VirtualFile?, reference: String, silently: Boolean, focus: Boolean)")
    @JvmStatic
    @NotNull
    public static final ListenableFuture<Boolean> jumpToRefOrHash(@NotNull VcsLogUiEx $this$jumpToRefOrHash, @NotNull String reference, boolean silently, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)$this$jumpToRefOrHash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return VcsLogNavigationUtil.jumpToRefOrHash($this$jumpToRefOrHash, null, reference, silently, focus);
    }

    @JvmStatic
    @NotNull
    public static final ListenableFuture<Boolean> jumpToHash(@NotNull VcsLogUiEx $this$jumpToHash, @NotNull String commitHash, boolean silently, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)$this$jumpToHash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
        String string = StringUtil.trim((String)commitHash, VcsLogNavigationUtil::jumpToHash$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trim(...)");
        String trimmedHash = string;
        if (!VcsLogUtil.HASH_PREFIX_REGEX.matcher(trimmedHash).matches()) {
            if (!silently) {
                Object[] objectArray = new Object[]{commitHash};
                VcsNotifier.getInstance((Project)$this$jumpToHash.getLogData().getProject()).notifyWarning("vcs.log.navigation.error", "", VcsLogBundle.message("vcs.log.string.is.not.a.hash", objectArray));
            }
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        SettableFuture settableFuture = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"create(...)");
        SettableFuture future = settableFuture;
        $this$jumpToHash.jumpTo(trimmedHash, (arg_0, arg_1) -> VcsLogNavigationUtil.jumpToHash$lambda$2((arg_0, arg_1) -> VcsLogNavigationUtil.jumpToHash$lambda$1($this$jumpToHash, arg_0, arg_1), arg_0, arg_1), (SettableFuture<VcsLogUiEx.JumpResult>)future, silently, focus);
        return INSTANCE.mapToJumpSuccess((ListenableFuture<VcsLogUiEx.JumpResult>)((ListenableFuture)future));
    }

    @JvmStatic
    @NotNull
    public static final ListenableFuture<Boolean> jumpToCommit(@NotNull VcsLogUiEx $this$jumpToCommit, @NotNull Hash commitHash, @NotNull VirtualFile root, boolean silently, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)$this$jumpToCommit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return INSTANCE.mapToJumpSuccess(INSTANCE.jumpToCommitInternal($this$jumpToCommit, commitHash, root, silently, focus));
    }

    @JvmStatic
    private static final VcsLogUiEx.JumpResult jumpToCommitSyncInternal(VcsLogUiEx $this$jumpToCommitSyncInternal, Hash commitHash, VirtualFile root, boolean silently, boolean focus) {
        VcsLogUiEx.JumpResult jumpResult = $this$jumpToCommitSyncInternal.jumpToSync(commitHash, (arg_0, arg_1) -> VcsLogNavigationUtil.jumpToCommitSyncInternal$lambda$1((arg_0, arg_1) -> VcsLogNavigationUtil.jumpToCommitSyncInternal$lambda$0($this$jumpToCommitSyncInternal, root, arg_0, arg_1), arg_0, arg_1), silently, focus);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jumpResult), (String)"jumpToSync(...)");
        return jumpResult;
    }

    private final ListenableFuture<VcsLogUiEx.JumpResult> jumpToCommitInternal(VcsLogUiEx $this$jumpToCommitInternal, Hash commitHash, VirtualFile root, boolean silently, boolean focus) {
        SettableFuture settableFuture = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"create(...)");
        SettableFuture future = settableFuture;
        $this$jumpToCommitInternal.jumpTo(commitHash, (arg_0, arg_1) -> VcsLogNavigationUtil.jumpToCommitInternal$lambda$1((arg_0, arg_1) -> VcsLogNavigationUtil.jumpToCommitInternal$lambda$0($this$jumpToCommitInternal, root, arg_0, arg_1), arg_0, arg_1), (SettableFuture<VcsLogUiEx.JumpResult>)future, silently, focus);
        return (ListenableFuture)future;
    }

    @JvmStatic
    @Deprecated(message="Reports cryptic message if 'silently == false'. Prefer using jumpToCommit(Hash, VirtualFile, ...)")
    @NotNull
    public static final ListenableFuture<Boolean> jumpToCommit(@NotNull VcsLogUiEx $this$jumpToCommit, int commitIndex, boolean silently, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)$this$jumpToCommit, (String)"<this>");
        SettableFuture settableFuture = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"create(...)");
        SettableFuture future = settableFuture;
        $this$jumpToCommit.jumpTo(commitIndex, (arg_0, arg_1) -> VcsLogNavigationUtil.jumpToCommit$lambda$1(VcsLogNavigationUtil::jumpToCommit$lambda$0, arg_0, arg_1), (SettableFuture<VcsLogUiEx.JumpResult>)future, silently, focus);
        return INSTANCE.mapToJumpSuccess((ListenableFuture<VcsLogUiEx.JumpResult>)((ListenableFuture)future));
    }

    /*
     * WARNING - void declaration
     */
    private final int getBranchRow(VcsLogData vcsLogData, VisiblePack visiblePack, String referenceName, VirtualFile repositoryRoot) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = VcsLogRefsKt.getBranches((VcsLogRefs)visiblePack.getRefs());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsRef ref = (VcsRef)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)ref.getName(), (Object)referenceName) && (repositoryRoot == null || Intrinsics.areEqual((Object)ref.getRoot(), (Object)repositoryRoot)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchingRefs = (List)destination$iv$iv;
        if (matchingRefs.isEmpty()) {
            return -1;
        }
        List sortedRefs = CollectionsKt.sortedWith((Iterable)matchingRefs, (Comparator)new VcsGoToRefComparator(visiblePack.getLogProviders()));
        for (VcsRef ref : sortedRefs) {
            VcsLogStorage vcsLogStorage = vcsLogData.getStorage();
            Hash hash = ref.getCommitHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getCommitHash(...)");
            VirtualFile virtualFile = ref.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            int branchRow = this.getCommitRow(vcsLogStorage, visiblePack, hash, virtualFile);
            if (branchRow < 0) continue;
            return branchRow;
        }
        return -2;
    }

    private final int getCommitRow(VcsLogData vcsLogData, VisiblePack visiblePack, String partialHash) {
        if (partialHash.length() == 40) {
            int row = -1;
            Hash hash = HashImpl.build((String)partialHash);
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"build(...)");
            Hash candidateHash = hash;
            for (VirtualFile candidateRoot : VcsLogDataKt.getRoots(vcsLogData)) {
                if (!vcsLogData.getStorage().containsCommit(new CommitId(candidateHash, candidateRoot))) continue;
                int candidateRow = this.getCommitRow(vcsLogData.getStorage(), visiblePack, candidateHash, candidateRoot);
                if (candidateRow >= 0) {
                    return candidateRow;
                }
                if (row != -1) continue;
                row = candidateRow;
            }
            return row;
        }
        IntRef row = new IntRef(-1);
        vcsLogData.getStorage().iterateCommits(arg_0 -> VcsLogNavigationUtil.getCommitRow$lambda$1(arg_0 -> VcsLogNavigationUtil.getCommitRow$lambda$0(partialHash, vcsLogData, visiblePack, row, arg_0), arg_0));
        return row.get();
    }

    private final int getCommitRow(VcsLogStorage storage, VisiblePack visiblePack, Hash hash, VirtualFile root) {
        if (visiblePack.getDataPack() instanceof VcsLogGraphData.Error) {
            return -1;
        }
        if (visiblePack instanceof VisiblePack.ErrorVisiblePack) {
            return -2;
        }
        return this.getCommitRow(visiblePack, storage.getCommitIndex(hash, root));
    }

    private final int getCommitRow(VisiblePack $this$getCommitRow, int commitIndex) {
        VisibleGraph<Integer> visibleGraph = $this$getCommitRow.getVisibleGraph();
        VisibleGraphImpl visibleGraphImpl = visibleGraph instanceof VisibleGraphImpl ? (VisibleGraphImpl)visibleGraph : null;
        if (visibleGraphImpl == null) {
            Integer n = $this$getCommitRow.getVisibleGraph().getVisibleRowIndex((Object)commitIndex);
            return n != null ? n : -2;
        }
        VisibleGraphImpl visibleGraphImpl2 = visibleGraphImpl;
        int nodeId = visibleGraphImpl2.getPermanentGraph().getPermanentCommitsInfo().getNodeId((Object)commitIndex);
        if (nodeId == -1) {
            return -1;
        }
        if (nodeId < 0) {
            return -2;
        }
        Integer n = visibleGraphImpl2.getLinearGraph().getNodeIndex(nodeId);
        return n != null ? n : -2;
    }

    private final ListenableFuture<Boolean> mapToJumpSuccess(ListenableFuture<VcsLogUiEx.JumpResult> future) {
        ListenableFuture listenableFuture = Futures.transform(future, arg_0 -> VcsLogNavigationUtil.mapToJumpSuccess$lambda$1(VcsLogNavigationUtil::mapToJumpSuccess$lambda$0, arg_0), (Executor)MoreExecutors.directExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"transform(...)");
        return listenableFuture;
    }

    private static final Integer jumpToGraphRow$lambda$0(VisiblePack visiblePack, Integer r) {
        if (visiblePack.getVisibleGraph().getVisibleCommitCount() <= r) {
            return -1;
        }
        return r;
    }

    private static final Integer jumpToGraphRow$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final Integer jumpToBranch$lambda$0(VcsLogUiEx $this_jumpToBranch, VirtualFile $repositoryRoot, VisiblePack visiblePack, String branch) {
        VcsLogData vcsLogData = $this_jumpToBranch.getLogData();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"getLogData(...)");
        Intrinsics.checkNotNull((Object)visiblePack);
        Intrinsics.checkNotNull((Object)branch);
        return INSTANCE.getBranchRow(vcsLogData, visiblePack, branch, $repositoryRoot);
    }

    private static final Integer jumpToBranch$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final boolean jumpToRefOrHash$lambda$0$0(String $reference, VirtualFile $repositoryRoot, VcsRef ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        String string = ref.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)$reference, (boolean)false, (int)2, null) && ($repositoryRoot == null || Intrinsics.areEqual((Object)ref.getRoot(), (Object)$repositoryRoot));
    }

    private static final void jumpToRefOrHash$lambda$0$1(List $matchingRefs, VcsLogUiEx $this_jumpToRefOrHash, SettableFuture $future, boolean $silently, boolean $focus, String $reference) {
        if (!((Collection)$matchingRefs).isEmpty()) {
            VcsRef ref = (VcsRef)CollectionsKt.minWithOrThrow((Iterable)$matchingRefs, (Comparator)new VcsGoToRefComparator($this_jumpToRefOrHash.getDataPack().getLogProviders()));
            Hash hash = ref.getCommitHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getCommitHash(...)");
            VirtualFile virtualFile = ref.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            $future.setFuture(VcsLogNavigationUtil.jumpToCommit($this_jumpToRefOrHash, hash, virtualFile, $silently, $focus));
            return;
        }
        $future.setFuture(VcsLogNavigationUtil.jumpToHash($this_jumpToRefOrHash, $reference, $silently, $focus));
    }

    private static final void jumpToRefOrHash$lambda$0(VcsLogRefs $refs, String $reference, VirtualFile $repositoryRoot, VcsLogUiEx $this_jumpToRefOrHash, SettableFuture $future, boolean $silently, boolean $focus) {
        List matchingRefs = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)VcsLogRefsKt.getAllRefs((VcsLogRefs)$refs), arg_0 -> VcsLogNavigationUtil.jumpToRefOrHash$lambda$0$0($reference, $repositoryRoot, arg_0)));
        ApplicationManager.getApplication().invokeLater(() -> VcsLogNavigationUtil.jumpToRefOrHash$lambda$0$1(matchingRefs, $this_jumpToRefOrHash, $future, $silently, $focus, $reference));
    }

    private static final boolean jumpToHash$lambda$0(char ch) {
        return !StringUtil.containsChar((String)"()'\"`", (char)ch);
    }

    private static final Integer jumpToHash$lambda$1(VcsLogUiEx $this_jumpToHash, VisiblePack visiblePack, String partialHash) {
        VcsLogData vcsLogData = $this_jumpToHash.getLogData();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"getLogData(...)");
        Intrinsics.checkNotNull((Object)visiblePack);
        Intrinsics.checkNotNull((Object)partialHash);
        return INSTANCE.getCommitRow(vcsLogData, visiblePack, partialHash);
    }

    private static final Integer jumpToHash$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final Integer jumpToCommitSyncInternal$lambda$0(VcsLogUiEx $this_jumpToCommitSyncInternal, VirtualFile $root, VisiblePack visiblePack, Hash hash) {
        if (!$this_jumpToCommitSyncInternal.getLogData().getStorage().containsCommit(new CommitId(hash, $root))) {
            return -1;
        }
        VcsLogStorage vcsLogStorage = $this_jumpToCommitSyncInternal.getLogData().getStorage();
        Intrinsics.checkNotNull((Object)visiblePack);
        Intrinsics.checkNotNull((Object)hash);
        return INSTANCE.getCommitRow(vcsLogStorage, visiblePack, hash, $root);
    }

    private static final Integer jumpToCommitSyncInternal$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final Integer jumpToCommitInternal$lambda$0(VcsLogUiEx $this_jumpToCommitInternal, VirtualFile $root, VisiblePack visiblePack, Hash hash) {
        if (!$this_jumpToCommitInternal.getLogData().getStorage().containsCommit(new CommitId(hash, $root))) {
            return -1;
        }
        VcsLogStorage vcsLogStorage = $this_jumpToCommitInternal.getLogData().getStorage();
        Intrinsics.checkNotNull((Object)visiblePack);
        Intrinsics.checkNotNull((Object)hash);
        return INSTANCE.getCommitRow(vcsLogStorage, visiblePack, hash, $root);
    }

    private static final Integer jumpToCommitInternal$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final Integer jumpToCommit$lambda$0(VisiblePack visiblePack, Integer id) {
        if (visiblePack.getDataPack() instanceof VcsLogGraphData.Empty) {
            return -1;
        }
        if (visiblePack instanceof VisiblePack.ErrorVisiblePack) {
            return -2;
        }
        Intrinsics.checkNotNull((Object)visiblePack);
        Intrinsics.checkNotNull((Object)id);
        return INSTANCE.getCommitRow(visiblePack, id);
    }

    private static final Integer jumpToCommit$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final boolean getCommitRow$lambda$0(String $partialHash, VcsLogData $vcsLogData, VisiblePack $visiblePack, IntRef $row, CommitId candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        if (CommitIdByStringCondition.matches(candidate, $partialHash)) {
            VcsLogStorage vcsLogStorage = $vcsLogData.getStorage();
            Hash hash = candidate.getHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
            VirtualFile virtualFile = candidate.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            int candidateRow = INSTANCE.getCommitRow(vcsLogStorage, $visiblePack, hash, virtualFile);
            if ($row.get() == -1) {
                $row.set(candidateRow);
            }
            return candidateRow < 0;
        }
        return true;
    }

    private static final boolean getCommitRow$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean mapToJumpSuccess$lambda$0(VcsLogUiEx.JumpResult it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it == VcsLogUiEx.JumpResult.SUCCESS;
    }

    private static final Boolean mapToJumpSuccess$lambda$1(Function1 $tmp0, Object input) {
        return (Boolean)$tmp0.invoke(input);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VcsLogNavigationUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VcsLogUiEx.JumpResult.values().length];
            try {
                nArray[VcsLogUiEx.JumpResult.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VcsLogUiEx.JumpResult.COMMIT_NOT_FOUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VcsLogUiEx.JumpResult.COMMIT_DOES_NOT_MATCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

