/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.components;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.internal.InternalActionsBundle;
import com.intellij.internal.inspector.ComponentPropertiesCollector;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorCustomComponentChildProvider;
import com.intellij.internal.inspector.UiInspectorImpl;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.internal.inspector.accessibilityAudit.UiInspectorAccessibilityInspection;
import com.intellij.internal.inspector.components.DimensionsComponent;
import com.intellij.internal.inspector.components.ValueCellRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorChooserService;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.picker.ColorListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InspectorTable
extends JBSplitter
implements UiDataProvider,
Disposable {
    @Nullable
    private final Project myProject;
    private final MyModel myModel;
    private StripeTable myTable;
    private ConsoleView myPreviewComponent;
    private JBTabbedPane myAccessibilityInspectionTabs;
    private List<UiInspectorAccessibilityInspection> myFailedInspections;

    InspectorTable(@NotNull List<? extends PropertyBean> clickInfo, @Nullable Project project) {
        if (clickInfo == null) {
            InspectorTable.$$$reportNull$$$0(0);
        }
        super(true, 0.75f);
        this.myProject = project;
        this.myModel = new MyModel(clickInfo);
        this.init(null);
    }

    InspectorTable(@NotNull Component component, @Nullable Project project) {
        if (component == null) {
            InspectorTable.$$$reportNull$$$0(1);
        }
        super(true, 0.75f);
        this.myProject = project;
        this.myModel = new MyModel(component);
        this.init(component);
    }

    InspectorTable(@NotNull UiInspectorCustomComponentChildProvider provider, @Nullable Project project) {
        if (provider == null) {
            InspectorTable.$$$reportNull$$$0(2);
        }
        super(true, 0.75f);
        this.myProject = project;
        this.myModel = new MyModel(provider);
        this.init(null);
    }

    InspectorTable(@NotNull Accessible accessible, @Nullable Project project) {
        if (accessible == null) {
            InspectorTable.$$$reportNull$$$0(3);
        }
        super(true, 0.75f);
        this.myProject = project;
        this.myModel = new MyModel(accessible);
        this.init(null);
    }

    InspectorTable(@NotNull Component component, @Nullable Project project, List<UiInspectorAccessibilityInspection> failedInspections) {
        if (component == null) {
            InspectorTable.$$$reportNull$$$0(4);
        }
        super(true, 0.75f);
        this.myProject = project;
        this.myModel = new MyModel(component);
        this.myFailedInspections = failedInspections;
        this.init(component);
    }

    InspectorTable(@NotNull List<? extends PropertyBean> clickInfo, @Nullable Project project, List<UiInspectorAccessibilityInspection> failedInspections) {
        if (clickInfo == null) {
            InspectorTable.$$$reportNull$$$0(5);
        }
        super(true, 0.75f);
        this.myProject = project;
        this.myModel = new MyModel(clickInfo);
        this.myFailedInspections = failedInspections;
        this.init(null);
    }

    private void init(final @Nullable Component component) {
        this.setSplitterProportionKey("UiInspector.table.splitter.proportion");
        this.myTable = new StripeTable((TableModel)this.myModel);
        TableSpeedSearch.installOn((JTable)this.myTable);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn propertyColumn = columnModel.getColumn(0);
        propertyColumn.setMinWidth(JBUIScale.scale((int)220));
        propertyColumn.setMaxWidth(JBUIScale.scale((int)220));
        propertyColumn.setResizable(false);
        propertyColumn.setCellRenderer(new PropertyNameRenderer());
        TableColumn valueColumn = columnModel.getColumn(1);
        valueColumn.setMinWidth(JBUIScale.scale((int)200));
        valueColumn.setResizable(false);
        valueColumn.setCellRenderer(new ValueCellRenderer());
        valueColumn.setCellEditor(new DefaultCellEditor((JTextField)new JBTextField()){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, final int row, int column) {
                Component comp = table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, false, false, row, column);
                Object realValue = table.getModel().getValueAt(row, column);
                if (comp instanceof JLabel) {
                    value = ((JLabel)comp).getText();
                }
                if (realValue instanceof Color) {
                    Rectangle cellRect = table.getCellRect(row, column, true);
                    ColorChooserService.getInstance().showPopup(null, (Color)realValue, new ColorListener(){

                        public void colorChanged(Color color, Object source) {
                            if (component != null) {
                                component.setBackground(color);
                                String name = InspectorTable.this.myModel.myProperties.get(row).getPropertyName();
                                InspectorTable.this.myModel.myProperties.set(row, new PropertyBean(name, (Object)color));
                            }
                        }
                    }, new RelativePoint((Component)table, new Point(cellRect.x + JBUI.scale((int)6), cellRect.y + cellRect.height)));
                    return null;
                }
                Component result2 = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                ((JComponent)result2).setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY, 1));
                return result2;
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Component renderer;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                int row = InspectorTable.this.myTable.rowAtPoint(event.getPoint());
                int column = 1;
                if (row >= 0 && row < InspectorTable.this.myTable.getRowCount() && column < InspectorTable.this.myTable.getColumnCount() && (renderer = InspectorTable.this.myTable.getCellRenderer(row, column).getTableCellRendererComponent((JTable)InspectorTable.this.myTable, InspectorTable.this.myModel.getValueAt(row, column), false, false, row, column)) instanceof JLabel) {
                    StringBuilder sb = new StringBuilder();
                    if (component != null) {
                        sb.append(UiInspectorUtil.getComponentName((Component)component)).append(" ");
                    }
                    String value = StringUtil.trimStart((String)((JLabel)renderer).getText().replace("\r", "").replace("\tat", "\n\tat"), (String)"at ");
                    sb.append("'").append(InspectorTable.this.myModel.getValueAt(row, 0)).append("':");
                    sb.append(value.contains("\n") || value.length() > 100 ? "\n" : " ");
                    sb.append(value);
                    System.out.println(sb);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/internal/inspector/components/InspectorTable$2", "onDoubleClick"));
            }
        }.installOn((Component)this.myTable);
        MyCellSelectionListener selectionListener = new MyCellSelectionListener();
        this.myTable.getSelectionModel().addListSelectionListener(selectionListener);
        this.myTable.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.setAutoResizeMode(3);
        this.myAccessibilityInspectionTabs = new JBTabbedPane();
        this.myAccessibilityInspectionTabs.setTabComponentInsets((Insets)JBUI.emptyInsets());
        this.setFirstComponent((JComponent)new JBScrollPane((Component)this.myTable));
        if (component != null) {
            this.setSecondComponent(InspectorTable.createDimensionsComponent(component));
        }
    }

    @NotNull
    private static DimensionsComponent createDimensionsComponent(@NotNull Component component) {
        if (component == null) {
            InspectorTable.$$$reportNull$$$0(6);
        }
        DimensionsComponent result2 = new DimensionsComponent(component);
        result2.setBorder(JBUI.Borders.customLine((Color)JBColor.border()));
        DimensionsComponent dimensionsComponent = result2;
        if (dimensionsComponent == null) {
            InspectorTable.$$$reportNull$$$0(7);
        }
        return dimensionsComponent;
    }

    public void refresh() {
        this.myModel.refresh();
        if (this.myModel.myComponent != null) {
            this.setSecondComponent(InspectorTable.createDimensionsComponent(this.myModel.myComponent));
        }
    }

    public void dispose() {
        if (this.myPreviewComponent != null) {
            Disposer.dispose((Disposable)this.myPreviewComponent);
        }
    }

    @NotNull
    public String getCellTextValue(int row, int col) {
        Object value = this.myTable.getValueAt(row, col);
        if (value instanceof String) {
            String string = (String)value;
            if (string == null) {
                InspectorTable.$$$reportNull$$$0(8);
            }
            return string;
        }
        TableColumn tableColumn = this.myTable.getColumnModel().getColumn(col);
        Component component = tableColumn.getCellRenderer().getTableCellRendererComponent((JTable)this.myTable, value, false, false, row, col);
        if (component instanceof JLabel) {
            String string = ((JLabel)component).getText();
            if (string == null) {
                InspectorTable.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = String.valueOf(value);
        if (string == null) {
            InspectorTable.$$$reportNull$$$0(10);
        }
        return string;
    }

    public JTable getTable() {
        return this.myTable;
    }

    public TableModel getModel() {
        return this.myModel;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            InspectorTable.$$$reportNull$$$0(11);
        }
        sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)new MyInspectorTableCopyProvider());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clickInfo";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessible";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/inspector/components/InspectorTable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/inspector/components/InspectorTable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDimensionsComponent";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellTextValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDimensionsComponent";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    private static final class MyModel
    extends AbstractTableModel {
        final Component myComponent;
        final List<PropertyBean> myProperties;

        MyModel(@NotNull List<? extends PropertyBean> clickInfo) {
            if (clickInfo == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            this.myProperties = new ArrayList<PropertyBean>();
            this.myComponent = null;
            this.myProperties.addAll(clickInfo);
        }

        MyModel(@NotNull Component c) {
            if (c == null) {
                MyModel.$$$reportNull$$$0(1);
            }
            this.myProperties = new ArrayList<PropertyBean>();
            this.myComponent = c;
            this.myProperties.addAll(ComponentPropertiesCollector.collect(c));
        }

        MyModel(@NotNull Accessible a) {
            if (a == null) {
                MyModel.$$$reportNull$$$0(2);
            }
            this.myProperties = new ArrayList<PropertyBean>();
            this.myComponent = null;
            this.myProperties.addAll(ComponentPropertiesCollector.collect(a));
        }

        MyModel(@NotNull UiInspectorCustomComponentChildProvider provider) {
            if (provider == null) {
                MyModel.$$$reportNull$$$0(3);
            }
            this.myProperties = new ArrayList<PropertyBean>();
            this.myComponent = null;
            Object propertiesHolder = provider.getObjectForProperties();
            if (propertiesHolder != null) {
                this.myProperties.addAll(ComponentPropertiesCollector.collect(propertiesHolder, provider.getPropertiesMethodList()));
            }
            this.myProperties.addAll(provider.getUiInspectorContext());
        }

        @Override
        @Nullable
        public Object getValueAt(int row, int column) {
            PropertyBean bean = this.myProperties.get(row);
            if (bean != null) {
                return column == 0 ? bean.getPropertyName() : bean.getPropertyValue();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1 && this.updater(this.myProperties.get(row)) != null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            PropertyBean bean = this.myProperties.get(row);
            try {
                this.myProperties.set(row, new PropertyBean(bean.getPropertyName(), Objects.requireNonNull(this.updater(bean)).fun(value)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Nullable
        public Function<Object, Object> updater(PropertyBean bean) {
            if (this.myComponent == null) {
                return null;
            }
            String name = bean.getPropertyName().trim();
            try {
                Method getter;
                try {
                    getter = this.myComponent.getClass().getMethod("get" + StringUtil.capitalize((String)name), new Class[0]);
                }
                catch (Exception e) {
                    getter = this.myComponent.getClass().getMethod("is" + StringUtil.capitalize((String)name), new Class[0]);
                }
                Method finalGetter = getter;
                Method setter = this.myComponent.getClass().getMethod("set" + StringUtil.capitalize((String)name), getter.getReturnType());
                setter.setAccessible(true);
                return o -> {
                    try {
                        setter.invoke((Object)this.myComponent, MyModel.fromObject(o, finalGetter.getReturnType()));
                        return finalGetter.invoke((Object)this.myComponent, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (Exception e) {
                try {
                    Field field = ReflectionUtil.findField(this.myComponent.getClass(), null, (String)name);
                    if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                        return null;
                    }
                    return o -> {
                        try {
                            field.set(this.myComponent, MyModel.fromObject(o, field.getType()));
                            return field.get(this.myComponent);
                        }
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                    };
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }

        private static Object fromObject(Object o, Class<?> type) {
            if (o == null) {
                return null;
            }
            if (type.isAssignableFrom(o.getClass())) {
                return o;
            }
            if ("null".equals(o)) {
                return null;
            }
            String value = String.valueOf(o).trim();
            if (type == Integer.TYPE) {
                return Integer.parseInt(value);
            }
            if (type == Boolean.TYPE) {
                return "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
            }
            if (type == Byte.TYPE) {
                return Byte.parseByte(value);
            }
            if (type == Short.TYPE) {
                return Short.parseShort(value);
            }
            if (type == Double.TYPE) {
                return Double.parseDouble(value);
            }
            if (type == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(value));
            }
            String[] s = value.split("(?i)\\s*(?:[x@:]|[a-z]+:)\\s*", 6);
            if (type == Dimension.class) {
                if (s.length == 2) {
                    return new Dimension(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
                }
            } else if (type == Point.class) {
                if (s.length == 2) {
                    return new Point(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
                }
            } else if (type == Rectangle.class) {
                if (s.length >= 5) {
                    return new Rectangle(Integer.parseInt(s[3]), Integer.parseInt(s[4]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
                }
            } else if (type == Insets.class) {
                if (s.length >= 5) {
                    return new Insets(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[4]), Integer.parseInt(s[4]));
                }
            } else if (type == Color.class) {
                if (s.length >= 5) {
                    return new ColorUIResource(new Color(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[3]), Integer.parseInt(s[4])));
                }
            } else if (type.getSimpleName().contains("ArrayTable")) {
                return "ArrayTable!";
            }
            throw new UnsupportedOperationException(type.toString());
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myProperties.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Property" : "Value";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : Object.class;
        }

        public void refresh() {
            this.myProperties.clear();
            this.myProperties.addAll(ComponentPropertiesCollector.collect(this.myComponent));
            this.fireTableDataChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clickInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "a";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/inspector/components/InspectorTable$MyModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class PropertyNameRenderer
    extends DefaultTableCellRenderer {
        private PropertyNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TableModel model2 = table.getModel();
            boolean changed = false;
            if (model2 instanceof MyModel) {
                changed = ((MyModel)model2).myProperties.get(row).getChanged();
            }
            if (InspectorTable.this.myFailedInspections != null && value != null) {
                String propertyName = value.toString();
                for (UiInspectorAccessibilityInspection failedInspection : InspectorTable.this.myFailedInspections) {
                    if (failedInspection.getPropertyName().equalsIgnoreCase(propertyName.trim())) {
                        this.setIcon(failedInspection.getIcon());
                        this.setHorizontalTextPosition(2);
                        this.setToolTipText(InternalActionsBundle.message((String)"ui.inspector.accessibility.audit.table.property.name.tooltip", (Object[])new Object[0]));
                        break;
                    }
                    this.setToolTipText(null);
                    this.setIcon(null);
                }
            }
            Color fg = isSelected ? table.getSelectionForeground() : (changed ? JBUI.CurrentTheme.Link.Foreground.ENABLED : table.getForeground());
            JBFont font = JBFont.label();
            this.setFont((Font)(changed ? font.asBold() : font));
            this.setForeground(fg);
            this.setBorder((Border)new JBEmptyBorder(2, 3, 2, 3));
            return this;
        }
    }

    private final class MyCellSelectionListener
    implements ListSelectionListener {
        private String selectedProperty = null;
        private ProgressIndicator previewUpdateIndicator = null;

        private MyCellSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = InspectorTable.this.myTable.getSelectedRow();
            int column = InspectorTable.this.myTable.getSelectedColumn();
            if (row < 0 || column != 1) {
                return;
            }
            final String property = InspectorTable.this.myTable.getValueAt(row, 0).toString();
            final @Nullable Object value = InspectorTable.this.myTable.getValueAt(row, 1);
            if (property.equals(this.selectedProperty)) {
                return;
            }
            this.selectedProperty = property;
            if (value instanceof Dimension || value instanceof Rectangle || value instanceof Border || value instanceof Insets) {
                if (InspectorTable.this.myModel.myComponent != null) {
                    InspectorTable.this.setSecondComponent(InspectorTable.createDimensionsComponent(InspectorTable.this.myModel.myComponent));
                }
            } else if (InspectorTable.this.myProject != null) {
                if (InspectorTable.this.myPreviewComponent == null) {
                    TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(InspectorTable.this.myProject);
                    builder.setUseOwnModalityStateForUpdates(true);
                    InspectorTable.this.myPreviewComponent = builder.getConsole();
                    JComponent consoleComponent = InspectorTable.this.myPreviewComponent.getComponent();
                    consoleComponent.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)1, (int)1));
                }
                final String renderedValue = InspectorTable.this.getCellTextValue(row, column);
                if (this.previewUpdateIndicator != null) {
                    this.previewUpdateIndicator.cancel();
                }
                this.previewUpdateIndicator = new EmptyProgressIndicator(ModalityState.stateForComponent((Component)((Object)InspectorTable.this)));
                InspectorTable.this.myPreviewComponent.clear();
                Task.Backgroundable task2 = new Task.Backgroundable(InspectorTable.this.myProject, "Invisible title", false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        MyCellSelectionListener.this.fillPreviewComponent(property, value, renderedValue);
                        indicator.checkCanceled();
                        InspectorTable.this.myPreviewComponent.scrollTo(0);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/inspector/components/InspectorTable$MyCellSelectionListener$1", "run"));
                    }
                };
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, this.previewUpdateIndicator);
                InspectorTable.this.setSecondComponent(InspectorTable.this.myPreviewComponent.getComponent());
                if (InspectorTable.this.myFailedInspections != null && !InspectorTable.this.myFailedInspections.isEmpty()) {
                    InspectorTable.this.myAccessibilityInspectionTabs.removeAll();
                    int inspectionCount = 0;
                    for (UiInspectorAccessibilityInspection failedInspection : InspectorTable.this.myFailedInspections) {
                        if (!failedInspection.getPropertyName().equalsIgnoreCase(this.selectedProperty.trim())) continue;
                        ++inspectionCount;
                        JTextArea textArea = new JTextArea(failedInspection.getDescription());
                        textArea.setEditable(false);
                        textArea.setLineWrap(true);
                        textArea.setWrapStyleWord(true);
                        textArea.setBorder((Border)new JBEmptyBorder(4, 10, 4, 4));
                        textArea.setMinimumSize((Dimension)JBUI.size((int)20, (int)10));
                        textArea.setOpaque(true);
                        textArea.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY));
                        JBScrollPane scrollPane = new JBScrollPane((Component)textArea);
                        scrollPane.setBorder(BorderFactory.createLineBorder(JBColor.border()));
                        scrollPane.setHorizontalScrollBarPolicy(31);
                        InspectorTable.this.myAccessibilityInspectionTabs.addTab(InternalActionsBundle.message((String)"ui.inspector.accessibility.audit.inspection.tab.text", (Object[])new Object[]{inspectionCount}), (Component)scrollPane);
                    }
                    if (inspectionCount > 0) {
                        InspectorTable.this.myAccessibilityInspectionTabs.insertTab(InternalActionsBundle.message((String)"ui.inspector.accessibility.audit.preview.tab.text", (Object[])new Object[0]), null, (Component)InspectorTable.this.myPreviewComponent.getComponent(), null, 0);
                        InspectorTable.this.myAccessibilityInspectionTabs.setSelectedIndex(0);
                        InspectorTable.this.setSecondComponent((JComponent)InspectorTable.this.myAccessibilityInspectionTabs);
                    }
                }
            }
        }

        private void fillPreviewComponent(String property, Object value, String renderedValue) {
            String strValue = String.valueOf(value);
            if (property.equals("added-at")) {
                if (value == null) {
                    this.printToPreview("Stacktrace is not available. There are two options:\n1. ", ConsoleViewContentType.NORMAL_OUTPUT);
                    this.printHyperlinkToPreview("Click", project -> {
                        UiInspectorUtil.INSTANCE.enableStacktraceSaving();
                        this.showHintInPreview("Enabled, please reopen the UI needed to inspect");
                    });
                    this.printToPreview(" to enable stacktraces saving until IDE restart.\n2. ", ConsoleViewContentType.NORMAL_OUTPUT);
                    this.printHyperlinkToPreview("Click", project -> {
                        Registry.get((String)"ui.inspector.save.stacktraces").setValue(true);
                        RegistryBooleanOptionDescriptor.suggestRestart((JComponent)InspectorTable.this.getRootPane());
                        if (ModalityState.current() != ModalityState.nonModal()) {
                            this.showHintInPreview("Close all active dialogs to perform restart");
                        }
                    });
                    this.printToPreview(" to enable stacktraces saving by default. Requires restart.\n   Will enable 'ui.inspector.save.stacktraces' Registry property.\n", ConsoleViewContentType.NORMAL_OUTPUT);
                    this.printToPreview("Note that saving stacktraces for each UI component can consume significant amount of memory.", ConsoleViewContentType.NORMAL_OUTPUT);
                } else {
                    this.printToPreview(strValue, ConsoleViewContentType.ERROR_OUTPUT);
                }
            } else if (property.equals("text")) {
                this.printToPreview(strValue, ConsoleViewContentType.NORMAL_OUTPUT);
            } else if (property.trim().equals("hierarchy")) {
                String[] classNames = strValue.split(" *\u2192 *");
                this.printClassNamesToConsole(classNames, true);
            } else if (property.equals("toString")) {
                this.printToStringProperty(strValue);
            } else if (property.contains("Listeners") && value != null) {
                String listeners = ValueCellRenderer.getToStringValue(value);
                String[] classNames = listeners.split(" *, *");
                this.printClassNamesToConsole(classNames, false);
            } else if (property.equals("clientProperties") && value != null) {
                Map<Object, Object> properties = ValueCellRenderer.parseClientProperties(value);
                if (properties != null) {
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        if (entry.getKey().equals(UiInspectorUtil.ADDED_AT_STACKTRACE)) continue;
                        this.printToPreview(String.valueOf(entry.getKey()) + " -> ", ConsoleViewContentType.NORMAL_OUTPUT);
                        this.printClassName(String.valueOf(entry.getValue()));
                        this.printToPreview("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                }
            } else if (value instanceof CachedImageIcon) {
                CachedImageIcon cachedImage = (CachedImageIcon)value;
                this.printToPreview("Icon path: ", ConsoleViewContentType.NORMAL_OUTPUT);
                this.printIconPath(cachedImage);
                Double ojbScale = cachedImage.getObjScale();
                if (ojbScale != null && ojbScale != 1.0) {
                    this.printToPreview("\nObj scale: ", ConsoleViewContentType.NORMAL_OUTPUT);
                    this.printToPreview(ojbScale.toString(), ConsoleViewContentType.NORMAL_OUTPUT);
                }
                this.printToPreview("\nIcon size: ", ConsoleViewContentType.NORMAL_OUTPUT);
                this.printToPreview("\nIcon size: ", ConsoleViewContentType.NORMAL_OUTPUT);
                this.printToPreview(cachedImage.getIconWidth() + "x" + cachedImage.getIconHeight(), ConsoleViewContentType.NORMAL_OUTPUT);
                this.printToPreview("\ntoString: ", ConsoleViewContentType.NORMAL_OUTPUT);
                this.printToPreview(cachedImage.toString(), ConsoleViewContentType.NORMAL_OUTPUT);
            } else {
                this.printClassName(renderedValue);
            }
        }

        private void printClassNamesToConsole(String[] classNames, boolean withIndent) {
            for (int idx = 0; idx < classNames.length; ++idx) {
                if (withIndent) {
                    this.printToPreview("\t".repeat(idx), ConsoleViewContentType.NORMAL_OUTPUT);
                }
                String className = classNames[idx];
                this.printClassName(className);
                this.printToPreview("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
        }

        private void printClassName(String className) {
            String[] parts = className.split("@");
            String classFqn = parts[0];
            PsiElement classElement = (PsiElement)ReadAction.compute(() -> UiInspectorImpl.findClassByFqn(InspectorTable.this.myProject, classFqn));
            if (classElement != null) {
                this.printHyperlinkToPreview(classFqn, project -> UiInspectorImpl.openClassByFqn(project, classFqn, true));
                if (parts.length > 1) {
                    this.printToPreview("@" + parts[1], ConsoleViewContentType.NORMAL_OUTPUT);
                }
            } else {
                this.printToPreview(className, ConsoleViewContentType.NORMAL_OUTPUT);
            }
        }

        private void printToStringProperty(Object value) {
            String strValue = value.toString();
            int classNameEnd = strValue.indexOf("[");
            if (classNameEnd == -1) {
                return;
            }
            String className = strValue.substring(0, classNameEnd);
            String content = strValue.substring(classNameEnd + 1, strValue.length() - 1);
            String[] properties = content.split(" *, *");
            this.printClassName(className);
            this.printToPreview(" " + strValue.charAt(classNameEnd) + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
            for (String prop : properties) {
                if (prop.isEmpty()) continue;
                this.printToPreview("\t", ConsoleViewContentType.NORMAL_OUTPUT);
                String[] keyValuePair = prop.split("=");
                if (keyValuePair.length == 1) {
                    this.printToPreview(keyValuePair[0], ConsoleViewContentType.NORMAL_OUTPUT);
                    if (prop.contains("=")) {
                        this.printToPreview("=", ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                } else {
                    String key = keyValuePair[0];
                    this.printToPreview(key + "=", ConsoleViewContentType.NORMAL_OUTPUT);
                    this.printClassName(keyValuePair[1]);
                }
                this.printToPreview("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
            this.printToPreview("]", ConsoleViewContentType.NORMAL_OUTPUT);
        }

        private void printIconPath(CachedImageIcon icon) {
            URL iconUrl = icon.getUrl();
            if (iconUrl != null) {
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(iconUrl.getPath());
                if (file != null && InspectorTable.this.myProject != null) {
                    Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(InspectorTable.this.myProject, file, 0);
                    this.printHyperlinkToPreview(file.getPath(), project -> navigatable.navigate(true));
                } else {
                    this.printToPreview(iconUrl.toString(), ConsoleViewContentType.NORMAL_OUTPUT);
                }
            } else {
                this.printToPreview(String.valueOf(icon.getOriginalPath()), ConsoleViewContentType.NORMAL_OUTPUT);
            }
        }

        private void printToPreview(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
            if (text2 == null) {
                MyCellSelectionListener.$$$reportNull$$$0(0);
            }
            if (contentType == null) {
                MyCellSelectionListener.$$$reportNull$$$0(1);
            }
            ProgressManager.checkCanceled();
            InspectorTable.this.myPreviewComponent.print(text2, contentType);
        }

        private void printHyperlinkToPreview(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
            if (hyperlinkText == null) {
                MyCellSelectionListener.$$$reportNull$$$0(2);
            }
            ProgressManager.checkCanceled();
            InspectorTable.this.myPreviewComponent.printHyperlink(hyperlinkText, info);
        }

        private void showHintInPreview(@NotNull String text2) {
            EditorImpl editor;
            JComponent jComponent;
            if (text2 == null) {
                MyCellSelectionListener.$$$reportNull$$$0(3);
            }
            if ((jComponent = InspectorTable.this.myPreviewComponent.getPreferredFocusableComponent()) instanceof EditorComponentImpl) {
                EditorComponentImpl editorComponent = (EditorComponentImpl)jComponent;
                v0 = editorComponent.getEditor();
            } else {
                v0 = editor = null;
            }
            if (editor != null) {
                HintManager.getInstance().showInformationHint((Editor)editor, text2, (short)1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hyperlinkText";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/inspector/components/InspectorTable$MyCellSelectionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "printToPreview";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "printHyperlinkToPreview";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showHintInPreview";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyInspectorTableCopyProvider
    implements CopyProvider {
        private MyInspectorTableCopyProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyInspectorTableCopyProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyInspectorTableCopyProvider.$$$reportNull$$$0(1);
            }
            int[] rows = InspectorTable.this.myTable.getSelectedRows();
            int[] columns = InspectorTable.this.myTable.getSelectedColumns();
            StringBuilder builder = new StringBuilder();
            for (int row : rows) {
                if (!builder.isEmpty()) {
                    builder.append('\n');
                }
                for (int col : columns) {
                    builder.append(InspectorTable.this.getCellTextValue(row, col));
                    if (col >= InspectorTable.this.myTable.getColumnCount() - 1) continue;
                    builder.append("\t");
                }
            }
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(builder.toString()));
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyInspectorTableCopyProvider.$$$reportNull$$$0(2);
            }
            return true;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyInspectorTableCopyProvider.$$$reportNull$$$0(3);
            }
            return InspectorTable.this.myTable.getSelectedRowCount() > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/InspectorTable$MyInspectorTableCopyProvider";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/InspectorTable$MyInspectorTableCopyProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "performCopy";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isCopyEnabled";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isCopyVisible";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

