/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.SchemeState;
import java.awt.Color;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultColorsScheme
extends AbstractColorsScheme {
    private String myName;

    public DefaultColorsScheme() {
        super(null);
    }

    @Nullable
    public TextAttributes getAttributes(TextAttributesKey key) {
        return key == null ? null : this.getAttributes(key, true);
    }

    @Override
    @Nullable
    public TextAttributes getAttributes(TextAttributesKey key, boolean useDefaults) {
        TextAttributes fallback;
        if (key == null) {
            return null;
        }
        TextAttributes attrs = (TextAttributes)this.attributesMap.get(key.getExternalName());
        if (attrs != null) {
            return attrs;
        }
        TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
        TextAttributes textAttributes = fallback = fallbackKey == null ? null : this.getFallbackAttributes(fallbackKey);
        if (fallback != null && fallback != AbstractColorsScheme.INHERITED_ATTRS_MARKER) {
            return fallback;
        }
        if (!useDefaults) {
            return null;
        }
        TextAttributes keyDefaults = this.getKeyDefaults(key);
        if (keyDefaults != null) {
            return keyDefaults;
        }
        return fallbackKey == null ? null : this.getKeyDefaults(fallbackKey);
    }

    @Nullable
    protected TextAttributes getKeyDefaults(@NotNull TextAttributesKey key) {
        if (key == null) {
            DefaultColorsScheme.$$$reportNull$$$0(0);
        }
        return key.getDefaultAttributes();
    }

    @Override
    @Nullable
    public Color getColor(@Nullable ColorKey key) {
        return key == null ? null : this.getColor(key, true);
    }

    @Nullable
    public Color getColor(@NotNull ColorKey key, boolean useDefaults) {
        Color fallback;
        Color color;
        if (key == null) {
            DefaultColorsScheme.$$$reportNull$$$0(1);
        }
        if ((color = (Color)this.colorMap.get(key)) != null) {
            return color == NULL_COLOR_MARKER ? null : color;
        }
        ColorKey fallbackKey = key.getFallbackColorKey();
        Color color2 = fallback = fallbackKey == null ? null : this.getFallbackColor(fallbackKey);
        if (fallback != null && fallback != AbstractColorsScheme.INHERITED_COLOR_MARKER) {
            return fallback;
        }
        if (!useDefaults) {
            return null;
        }
        Color keyDefaults = key.getDefaultColor();
        if (keyDefaults != null) {
            return keyDefaults;
        }
        return fallbackKey == null ? null : fallbackKey.getDefaultColor();
    }

    @Override
    public void readExternal(@NotNull Element parentNode) {
        if (parentNode == null) {
            DefaultColorsScheme.$$$reportNull$$$0(2);
        }
        super.readExternal(parentNode);
        this.myName = parentNode.getAttributeValue("name");
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DefaultColorsScheme.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void setAttributes(@NotNull TextAttributesKey key, TextAttributes attributes) {
        if (key == null) {
            DefaultColorsScheme.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void setColor(ColorKey key, Color color) {
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this);
        this.copyTo(newScheme);
        newScheme.setName(EditorColorsScheme.getDefaultSchemeName());
        newScheme.setDefaultMetaInfo(this);
        return newScheme;
    }

    public boolean hasEditableCopy() {
        return true;
    }

    @NonNls
    public String getEditableCopyName() {
        return "_@user_" + this.myName;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    @NotNull
    public SchemeState getSchemeState() {
        SchemeState schemeState = SchemeState.NON_PERSISTENT;
        if (schemeState == null) {
            DefaultColorsScheme.$$$reportNull$$$0(5);
        }
        return schemeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/DefaultColorsScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/DefaultColorsScheme";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getKeyDefaults";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAttributes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

