/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;

public class LimitedRangeHighlighterIterator
extends HighlighterIteratorWrapper {
    private final int myStartOffset;
    private final int myEndOffset;

    LimitedRangeHighlighterIterator(HighlighterIterator original, int startOffset, int endOffset) {
        super(original);
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
    }

    @Override
    public int getStart() {
        return Math.max(super.getStart(), this.myStartOffset);
    }

    @Override
    public int getEnd() {
        return Math.min(super.getEnd(), this.myEndOffset);
    }

    @Override
    public boolean atEnd() {
        return super.atEnd() || super.getStart() >= this.myEndOffset || super.getEnd() <= this.myStartOffset;
    }
}

