/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.DefaultFileStatusManager;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileStatusManager {
    protected static final Logger LOG = Logger.getInstance(FileStatusManager.class);

    public static FileStatusManager getInstance(@NotNull Project project) {
        if (project == null) {
            FileStatusManager.$$$reportNull$$$0(0);
        }
        if (project.isDefault()) {
            LOG.error("Can't create FileStatusManager for default project");
            return new DefaultFileStatusManager();
        }
        return (FileStatusManager)project.getService(FileStatusManager.class);
    }

    @ApiStatus.Internal
    protected FileStatusManager() {
    }

    @NotNull
    public abstract FileStatus getStatus(@NotNull VirtualFile var1);

    public abstract void fileStatusesChanged();

    public abstract void fileStatusChanged(@Nullable VirtualFile var1);

    public void addFileStatusListener(@NotNull FileStatusListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FileStatusManager.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            FileStatusManager.$$$reportNull$$$0(2);
        }
    }

    @Nullable
    public Color getNotChangedDirectoryColor(@NotNull VirtualFile file) {
        if (file == null) {
            FileStatusManager.$$$reportNull$$$0(3);
        }
        return this.getRecursiveStatus(file).getColor();
    }

    @NotNull
    public abstract FileStatus getRecursiveStatus(@NotNull VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/FileStatusManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileStatusListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNotChangedDirectoryColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

