/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.session;

import com.intellij.platform.ml.session.LevelData;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u0004:\t\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016J3\u0010\t\u001a\u0002H\n\"\u0004\b\u0003\u0010\n2\u001e\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u0002H\n0\fH&\u00a2\u0006\u0002\u0010\rR\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0005\u0017\u0018\u0019\u001a\u001b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001c\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/session/SessionTree;", "RootT", "MainT", "PredictionT", "", "levelData", "Lcom/intellij/platform/ml/session/LevelData;", "getLevelData", "()Lcom/intellij/platform/ml/session/LevelData;", "accept", "T", "visitor", "Lcom/intellij/platform/ml/session/SessionTree$Visitor;", "(Lcom/intellij/platform/ml/session/SessionTree$Visitor;)Ljava/lang/Object;", "RootContainer", "ChildrenContainer", "PredictionContainer", "SolitaryLeaf", "ComplexRoot", "Branching", "Leaf", "Visitor", "LevelVisitor", "Lcom/intellij/platform/ml/session/SessionTree$Branching;", "Lcom/intellij/platform/ml/session/SessionTree$ChildrenContainer;", "Lcom/intellij/platform/ml/session/SessionTree$Leaf;", "Lcom/intellij/platform/ml/session/SessionTree$PredictionContainer;", "Lcom/intellij/platform/ml/session/SessionTree$RootContainer;", "intellij.platform.ml"})
@ApiStatus.Internal
public sealed interface SessionTree<RootT, MainT, PredictionT> {
    @NotNull
    public LevelData<MainT> getLevelData();

    public <T> T accept(@NotNull Visitor<RootT, MainT, PredictionT, ? extends T> var1);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005B5\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00040\u0007\u0012\u001e\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00040\t\u00a2\u0006\u0004\b\n\u0010\u000bJ3\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0006\u0010\u00112\u001e\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00040\u0007H\u00c6\u0003J!\u0010\u0016\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00040\tH\u00c6\u0003JM\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00040\u00072 \b\u0002\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00040\tH\u00c6\u0001J\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0083\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u00d6\u0081\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00040\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR,\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00040\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/platform/ml/session/SessionTree$Branching;", "RootT", "MainT", "PredictionT", "Lcom/intellij/platform/ml/session/SessionTree;", "Lcom/intellij/platform/ml/session/SessionTree$ChildrenContainer;", "levelData", "Lcom/intellij/platform/ml/session/LevelData;", "children", "", "<init>", "(Lcom/intellij/platform/ml/session/LevelData;Ljava/util/List;)V", "getLevelData", "()Lcom/intellij/platform/ml/session/LevelData;", "getChildren", "()Ljava/util/List;", "accept", "T", "visitor", "Lcom/intellij/platform/ml/session/SessionTree$Visitor;", "(Lcom/intellij/platform/ml/session/SessionTree$Visitor;)Ljava/lang/Object;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ml"})
    public static final class Branching<RootT, MainT, PredictionT>
    implements SessionTree<RootT, MainT, PredictionT>,
    ChildrenContainer<RootT, MainT, PredictionT> {
        @NotNull
        private final LevelData<MainT> levelData;
        @NotNull
        private final List<SessionTree<RootT, MainT, PredictionT>> children;

        public Branching(@NotNull LevelData<MainT> levelData, @NotNull List<? extends SessionTree<RootT, MainT, PredictionT>> children) {
            Intrinsics.checkNotNullParameter(levelData, (String)"levelData");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.levelData = levelData;
            this.children = children;
        }

        @Override
        @NotNull
        public LevelData<MainT> getLevelData() {
            return this.levelData;
        }

        @Override
        @NotNull
        public List<SessionTree<RootT, MainT, PredictionT>> getChildren() {
            return this.children;
        }

        @Override
        public <T> T accept(@NotNull Visitor<RootT, MainT, PredictionT, ? extends T> visitor) {
            Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
            return visitor.acceptBranching(this);
        }

        @NotNull
        public final LevelData<MainT> component1() {
            return this.levelData;
        }

        @NotNull
        public final List<SessionTree<RootT, MainT, PredictionT>> component2() {
            return this.children;
        }

        @NotNull
        public final Branching<RootT, MainT, PredictionT> copy(@NotNull LevelData<MainT> levelData, @NotNull List<? extends SessionTree<RootT, MainT, PredictionT>> children) {
            Intrinsics.checkNotNullParameter(levelData, (String)"levelData");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            return new Branching<RootT, MainT, PredictionT>(levelData, children);
        }

        public static /* synthetic */ Branching copy$default(Branching branching, LevelData levelData, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                levelData = branching.levelData;
            }
            if ((n & 2) != 0) {
                list2 = branching.children;
            }
            return branching.copy(levelData, list2);
        }

        @NotNull
        public String toString() {
            return "Branching(levelData=" + this.levelData + ", children=" + this.children + ")";
        }

        public int hashCode() {
            int result2 = this.levelData.hashCode();
            result2 = result2 * 31 + ((Object)this.children).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Branching)) {
                return false;
            }
            Branching branching = (Branching)other;
            if (!Intrinsics.areEqual(this.levelData, branching.levelData)) {
                return false;
            }
            return Intrinsics.areEqual(this.children, branching.children);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004R*\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00040\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\t\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/session/SessionTree$ChildrenContainer;", "RootT", "MainT", "PredictionT", "Lcom/intellij/platform/ml/session/SessionTree;", "children", "", "getChildren", "()Ljava/util/List;", "Lcom/intellij/platform/ml/session/SessionTree$Branching;", "Lcom/intellij/platform/ml/session/SessionTree$ComplexRoot;", "intellij.platform.ml"})
    public static sealed interface ChildrenContainer<RootT, MainT, PredictionT>
    extends SessionTree<RootT, MainT, PredictionT>
    permits Branching, ComplexRoot {
        @NotNull
        public List<SessionTree<RootT, MainT, PredictionT>> getChildren();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005B=\u0012\u0006\u0010\u0006\u001a\u00028\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00040\b\u0012\u001e\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ3\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0006\u0010\u00162\u001e\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u0002H\u00160\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00040\bH\u00c6\u0003J!\u0010\u001c\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000b0\nH\u00c6\u0003J\\\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00040\b2 \b\u0002\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000b0\nH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0083\u0004J\n\u0010#\u001a\u00020$H\u00d6\u0081\u0004J\n\u0010%\u001a\u00020&H\u00d6\u0081\u0004R\u0016\u0010\u0006\u001a\u00028\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R,\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lcom/intellij/platform/ml/session/SessionTree$ComplexRoot;", "RootT", "MainT", "PredictionT", "Lcom/intellij/platform/ml/session/SessionTree$RootContainer;", "Lcom/intellij/platform/ml/session/SessionTree$ChildrenContainer;", "rootData", "levelData", "Lcom/intellij/platform/ml/session/LevelData;", "children", "", "Lcom/intellij/platform/ml/session/SessionTree;", "<init>", "(Ljava/lang/Object;Lcom/intellij/platform/ml/session/LevelData;Ljava/util/List;)V", "getRootData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getLevelData", "()Lcom/intellij/platform/ml/session/LevelData;", "getChildren", "()Ljava/util/List;", "accept", "T", "visitor", "Lcom/intellij/platform/ml/session/SessionTree$Visitor;", "(Lcom/intellij/platform/ml/session/SessionTree$Visitor;)Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;Lcom/intellij/platform/ml/session/LevelData;Ljava/util/List;)Lcom/intellij/platform/ml/session/SessionTree$ComplexRoot;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ml"})
    public static final class ComplexRoot<RootT, MainT, PredictionT>
    implements RootContainer<RootT, MainT, PredictionT>,
    ChildrenContainer<RootT, MainT, PredictionT> {
        private final RootT rootData;
        @NotNull
        private final LevelData<MainT> levelData;
        @NotNull
        private final List<SessionTree<RootT, MainT, PredictionT>> children;

        public ComplexRoot(RootT rootData, @NotNull LevelData<MainT> levelData, @NotNull List<? extends SessionTree<RootT, MainT, PredictionT>> children) {
            Intrinsics.checkNotNullParameter(levelData, (String)"levelData");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.rootData = rootData;
            this.levelData = levelData;
            this.children = children;
        }

        @Override
        public RootT getRootData() {
            return this.rootData;
        }

        @Override
        @NotNull
        public LevelData<MainT> getLevelData() {
            return this.levelData;
        }

        @Override
        @NotNull
        public List<SessionTree<RootT, MainT, PredictionT>> getChildren() {
            return this.children;
        }

        @Override
        public <T> T accept(@NotNull Visitor<RootT, MainT, PredictionT, ? extends T> visitor) {
            Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
            return visitor.acceptComplexRoot(this);
        }

        public final RootT component1() {
            return this.rootData;
        }

        @NotNull
        public final LevelData<MainT> component2() {
            return this.levelData;
        }

        @NotNull
        public final List<SessionTree<RootT, MainT, PredictionT>> component3() {
            return this.children;
        }

        @NotNull
        public final ComplexRoot<RootT, MainT, PredictionT> copy(RootT rootData, @NotNull LevelData<MainT> levelData, @NotNull List<? extends SessionTree<RootT, MainT, PredictionT>> children) {
            Intrinsics.checkNotNullParameter(levelData, (String)"levelData");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            return new ComplexRoot<RootT, MainT, PredictionT>(rootData, levelData, children);
        }

        public static /* synthetic */ ComplexRoot copy$default(ComplexRoot complexRoot, Object object, LevelData levelData, List list2, int n, Object object2) {
            if ((n & 1) != 0) {
                object = complexRoot.rootData;
            }
            if ((n & 2) != 0) {
                levelData = complexRoot.levelData;
            }
            if ((n & 4) != 0) {
                list2 = complexRoot.children;
            }
            return complexRoot.copy(object, levelData, list2);
        }

        @NotNull
        public String toString() {
            return "ComplexRoot(rootData=" + this.rootData + ", levelData=" + this.levelData + ", children=" + this.children + ")";
        }

        public int hashCode() {
            int result2 = this.rootData == null ? 0 : this.rootData.hashCode();
            result2 = result2 * 31 + this.levelData.hashCode();
            result2 = result2 * 31 + ((Object)this.children).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComplexRoot)) {
                return false;
            }
            ComplexRoot complexRoot = (ComplexRoot)other;
            if (!Intrinsics.areEqual(this.rootData, complexRoot.rootData)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.levelData, complexRoot.levelData)) {
                return false;
            }
            return Intrinsics.areEqual(this.children, complexRoot.children);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005B\u001f\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00040\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00018\u0005\u00a2\u0006\u0004\b\t\u0010\nJ3\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0006\u0010\u00112\u001e\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00040\u0007H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00018\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ<\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00040\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00018\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020 H\u00d6\u0081\u0004R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00040\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\b\u001a\u0004\u0018\u00018\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/intellij/platform/ml/session/SessionTree$Leaf;", "RootT", "MainT", "PredictionT", "Lcom/intellij/platform/ml/session/SessionTree;", "Lcom/intellij/platform/ml/session/SessionTree$PredictionContainer;", "levelData", "Lcom/intellij/platform/ml/session/LevelData;", "prediction", "<init>", "(Lcom/intellij/platform/ml/session/LevelData;Ljava/lang/Object;)V", "getLevelData", "()Lcom/intellij/platform/ml/session/LevelData;", "getPrediction", "()Ljava/lang/Object;", "Ljava/lang/Object;", "accept", "T", "visitor", "Lcom/intellij/platform/ml/session/SessionTree$Visitor;", "(Lcom/intellij/platform/ml/session/SessionTree$Visitor;)Ljava/lang/Object;", "component1", "component2", "copy", "(Lcom/intellij/platform/ml/session/LevelData;Ljava/lang/Object;)Lcom/intellij/platform/ml/session/SessionTree$Leaf;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ml"})
    public static final class Leaf<RootT, MainT, PredictionT>
    implements SessionTree<RootT, MainT, PredictionT>,
    PredictionContainer<RootT, MainT, PredictionT> {
        @NotNull
        private final LevelData<MainT> levelData;
        @Nullable
        private final PredictionT prediction;

        public Leaf(@NotNull LevelData<MainT> levelData, @Nullable PredictionT prediction) {
            Intrinsics.checkNotNullParameter(levelData, (String)"levelData");
            this.levelData = levelData;
            this.prediction = prediction;
        }

        @Override
        @NotNull
        public LevelData<MainT> getLevelData() {
            return this.levelData;
        }

        @Override
        @Nullable
        public PredictionT getPrediction() {
            return this.prediction;
        }

        @Override
        public <T> T accept(@NotNull Visitor<RootT, MainT, PredictionT, ? extends T> visitor) {
            Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
            return visitor.acceptLeaf(this);
        }

        @NotNull
        public final LevelData<MainT> component1() {
            return this.levelData;
        }

        @Nullable
        public final PredictionT component2() {
            return this.prediction;
        }

        @NotNull
        public final Leaf<RootT, MainT, PredictionT> copy(@NotNull LevelData<MainT> levelData, @Nullable PredictionT prediction) {
            Intrinsics.checkNotNullParameter(levelData, (String)"levelData");
            return new Leaf<RootT, MainT, PredictionT>(levelData, prediction);
        }

        public static /* synthetic */ Leaf copy$default(Leaf leaf, LevelData levelData, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                levelData = leaf.levelData;
            }
            if ((n & 2) != 0) {
                object = leaf.prediction;
            }
            return leaf.copy(levelData, object);
        }

        @NotNull
        public String toString() {
            return "Leaf(levelData=" + this.levelData + ", prediction=" + this.prediction + ")";
        }

        public int hashCode() {
            int result2 = this.levelData.hashCode();
            result2 = result2 * 31 + (this.prediction == null ? 0 : this.prediction.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Leaf)) {
                return false;
            }
            Leaf leaf = (Leaf)other;
            if (!Intrinsics.areEqual(this.levelData, leaf.levelData)) {
                return false;
            }
            return Intrinsics.areEqual(this.prediction, leaf.prediction);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\b\b\u0005\u0010\u0003*\u00020\u00042\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00060\u0005:\u0001 B\u0019\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\fJ0\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00040\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0012H\u0002J \u0010\u0013\u001a\u00020\u00062\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0015J \u0010\u0016\u001a\u00020\u00062\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0018J \u0010\u0019\u001a\u00020\u00062\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u001bJ \u0010\u001c\u001a\u00020\u00062\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u001eJ0\u0010\u001f\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00040\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0012H&R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/platform/ml/session/SessionTree$LevelVisitor;", "RootT", "MainT", "PredictionT", "", "Lcom/intellij/platform/ml/session/SessionTree$Visitor;", "", "levelIndex", "", "thisVisitorLevel", "<init>", "(II)V", "(I)V", "maybeVisitLevel", "", "level", "Lcom/intellij/platform/ml/session/LevelData;", "levelRoot", "Lcom/intellij/platform/ml/session/SessionTree;", "acceptBranching", "branching", "Lcom/intellij/platform/ml/session/SessionTree$Branching;", "acceptLeaf", "leaf", "Lcom/intellij/platform/ml/session/SessionTree$Leaf;", "acceptComplexRoot", "root", "Lcom/intellij/platform/ml/session/SessionTree$ComplexRoot;", "acceptSolitaryLeaf", "solitaryLeaf", "Lcom/intellij/platform/ml/session/SessionTree$SolitaryLeaf;", "visitLevel", "DeeperLevelVisitor", "intellij.platform.ml"})
    public static abstract class LevelVisitor<RootT, MainT, PredictionT>
    implements Visitor<RootT, MainT, PredictionT, Unit> {
        private final int levelIndex;
        private final int thisVisitorLevel;

        private LevelVisitor(int levelIndex, int thisVisitorLevel) {
            this.levelIndex = levelIndex;
            this.thisVisitorLevel = thisVisitorLevel;
        }

        public LevelVisitor(int levelIndex) {
            this(levelIndex, 0);
        }

        private final boolean maybeVisitLevel(LevelData<MainT> level, SessionTree<RootT, MainT, PredictionT> levelRoot) {
            boolean bl;
            if (this.levelIndex == this.thisVisitorLevel) {
                this.visitLevel(level, levelRoot);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public final void acceptBranching(@NotNull Branching<RootT, MainT, PredictionT> branching) {
            Intrinsics.checkNotNullParameter(branching, (String)"branching");
            if (this.maybeVisitLevel(branching.getLevelData(), branching)) {
                return;
            }
            for (SessionTree<RootT, MainT, PredictionT> child : branching.getChildren()) {
                child.accept(new DeeperLevelVisitor());
            }
        }

        @Override
        public final void acceptLeaf(@NotNull Leaf<RootT, MainT, PredictionT> leaf) {
            Intrinsics.checkNotNullParameter(leaf, (String)"leaf");
            if (!this.maybeVisitLevel(leaf.getLevelData(), leaf)) {
                boolean bl = false;
                String string = "The deepest level in the session tree is " + this.thisVisitorLevel + ", given level " + this.levelIndex + " does not exist";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        public final void acceptComplexRoot(@NotNull ComplexRoot<RootT, MainT, PredictionT> root) {
            Intrinsics.checkNotNullParameter(root, (String)"root");
            if (this.maybeVisitLevel(root.getLevelData(), root)) {
                return;
            }
            for (SessionTree<RootT, MainT, PredictionT> child : root.getChildren()) {
                child.accept(new DeeperLevelVisitor());
            }
        }

        @Override
        public final void acceptSolitaryLeaf(@NotNull SolitaryLeaf<RootT, MainT, PredictionT> solitaryLeaf) {
            Intrinsics.checkNotNullParameter(solitaryLeaf, (String)"solitaryLeaf");
            if (!this.maybeVisitLevel(solitaryLeaf.getLevelData(), solitaryLeaf)) {
                boolean bl = false;
                String string = "The only level in the session tree is " + this.thisVisitorLevel + ", given level " + this.levelIndex + " does not exist";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public abstract void visitLevel(@NotNull LevelData<MainT> var1, @NotNull SessionTree<RootT, MainT, PredictionT> var2);

        public /* synthetic */ LevelVisitor(int levelIndex, int thisVisitorLevel, DefaultConstructorMarker $constructor_marker) {
            this(levelIndex, thisVisitorLevel);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00040\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/ml/session/SessionTree$LevelVisitor$DeeperLevelVisitor;", "Lcom/intellij/platform/ml/session/SessionTree$LevelVisitor;", "<init>", "(Lcom/intellij/platform/ml/session/SessionTree$LevelVisitor;)V", "visitLevel", "", "level", "Lcom/intellij/platform/ml/session/LevelData;", "levelRoot", "Lcom/intellij/platform/ml/session/SessionTree;", "intellij.platform.ml"})
        private final class DeeperLevelVisitor
        extends LevelVisitor<RootT, MainT, PredictionT> {
            public DeeperLevelVisitor() {
                super(LevelVisitor.this.levelIndex, LevelVisitor.this.thisVisitorLevel + 1, null);
            }

            @Override
            public void visitLevel(@NotNull LevelData<MainT> level, @NotNull SessionTree<RootT, MainT, PredictionT> levelRoot) {
                Intrinsics.checkNotNullParameter(level, (String)"level");
                Intrinsics.checkNotNullParameter(levelRoot, (String)"levelRoot");
                LevelVisitor.this.visitLevel(level, levelRoot);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004R\u0014\u0010\u0005\u001a\u0004\u0018\u00018\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/session/SessionTree$PredictionContainer;", "RootT", "MainT", "PredictionT", "Lcom/intellij/platform/ml/session/SessionTree;", "prediction", "getPrediction", "()Ljava/lang/Object;", "Lcom/intellij/platform/ml/session/SessionTree$Leaf;", "Lcom/intellij/platform/ml/session/SessionTree$SolitaryLeaf;", "intellij.platform.ml"})
    public static sealed interface PredictionContainer<RootT, MainT, PredictionT>
    extends SessionTree<RootT, MainT, PredictionT>
    permits Leaf, SolitaryLeaf {
        @Nullable
        public PredictionT getPrediction();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004R\u0012\u0010\u0005\u001a\u00028\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/session/SessionTree$RootContainer;", "RootT", "MainT", "PredictionT", "Lcom/intellij/platform/ml/session/SessionTree;", "rootData", "getRootData", "()Ljava/lang/Object;", "Lcom/intellij/platform/ml/session/SessionTree$ComplexRoot;", "Lcom/intellij/platform/ml/session/SessionTree$SolitaryLeaf;", "intellij.platform.ml"})
    public static sealed interface RootContainer<RootT, MainT, PredictionT>
    extends SessionTree<RootT, MainT, PredictionT>
    permits ComplexRoot, SolitaryLeaf {
        public RootT getRootData();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005B'\u0012\u0006\u0010\u0006\u001a\u00028\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00040\b\u0012\b\u0010\t\u001a\u0004\u0018\u00018\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ3\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0006\u0010\u00132\u001e\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u0002H\u00130\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00040\bH\u00c6\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00018\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJF\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00040\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00018\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0083\u0004J\n\u0010 \u001a\u00020!H\u00d6\u0081\u0004J\n\u0010\"\u001a\u00020#H\u00d6\u0081\u0004R\u0016\u0010\u0006\u001a\u00028\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\t\u001a\u0004\u0018\u00018\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\r\u00a8\u0006$"}, d2={"Lcom/intellij/platform/ml/session/SessionTree$SolitaryLeaf;", "RootT", "MainT", "PredictionT", "Lcom/intellij/platform/ml/session/SessionTree$RootContainer;", "Lcom/intellij/platform/ml/session/SessionTree$PredictionContainer;", "rootData", "levelData", "Lcom/intellij/platform/ml/session/LevelData;", "prediction", "<init>", "(Ljava/lang/Object;Lcom/intellij/platform/ml/session/LevelData;Ljava/lang/Object;)V", "getRootData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getLevelData", "()Lcom/intellij/platform/ml/session/LevelData;", "getPrediction", "accept", "T", "visitor", "Lcom/intellij/platform/ml/session/SessionTree$Visitor;", "(Lcom/intellij/platform/ml/session/SessionTree$Visitor;)Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;Lcom/intellij/platform/ml/session/LevelData;Ljava/lang/Object;)Lcom/intellij/platform/ml/session/SessionTree$SolitaryLeaf;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ml"})
    public static final class SolitaryLeaf<RootT, MainT, PredictionT>
    implements RootContainer<RootT, MainT, PredictionT>,
    PredictionContainer<RootT, MainT, PredictionT> {
        private final RootT rootData;
        @NotNull
        private final LevelData<MainT> levelData;
        @Nullable
        private final PredictionT prediction;

        public SolitaryLeaf(RootT rootData, @NotNull LevelData<MainT> levelData, @Nullable PredictionT prediction) {
            Intrinsics.checkNotNullParameter(levelData, (String)"levelData");
            this.rootData = rootData;
            this.levelData = levelData;
            this.prediction = prediction;
        }

        @Override
        public RootT getRootData() {
            return this.rootData;
        }

        @Override
        @NotNull
        public LevelData<MainT> getLevelData() {
            return this.levelData;
        }

        @Override
        @Nullable
        public PredictionT getPrediction() {
            return this.prediction;
        }

        @Override
        public <T> T accept(@NotNull Visitor<RootT, MainT, PredictionT, ? extends T> visitor) {
            Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
            return visitor.acceptSolitaryLeaf(this);
        }

        public final RootT component1() {
            return this.rootData;
        }

        @NotNull
        public final LevelData<MainT> component2() {
            return this.levelData;
        }

        @Nullable
        public final PredictionT component3() {
            return this.prediction;
        }

        @NotNull
        public final SolitaryLeaf<RootT, MainT, PredictionT> copy(RootT rootData, @NotNull LevelData<MainT> levelData, @Nullable PredictionT prediction) {
            Intrinsics.checkNotNullParameter(levelData, (String)"levelData");
            return new SolitaryLeaf<RootT, MainT, PredictionT>(rootData, levelData, prediction);
        }

        public static /* synthetic */ SolitaryLeaf copy$default(SolitaryLeaf solitaryLeaf, Object object, LevelData levelData, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = solitaryLeaf.rootData;
            }
            if ((n & 2) != 0) {
                levelData = solitaryLeaf.levelData;
            }
            if ((n & 4) != 0) {
                object2 = solitaryLeaf.prediction;
            }
            return solitaryLeaf.copy(object, levelData, object2);
        }

        @NotNull
        public String toString() {
            return "SolitaryLeaf(rootData=" + this.rootData + ", levelData=" + this.levelData + ", prediction=" + this.prediction + ")";
        }

        public int hashCode() {
            int result2 = this.rootData == null ? 0 : this.rootData.hashCode();
            result2 = result2 * 31 + this.levelData.hashCode();
            result2 = result2 * 31 + (this.prediction == null ? 0 : this.prediction.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SolitaryLeaf)) {
                return false;
            }
            SolitaryLeaf solitaryLeaf = (SolitaryLeaf)other;
            if (!Intrinsics.areEqual(this.rootData, solitaryLeaf.rootData)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.levelData, solitaryLeaf.levelData)) {
                return false;
            }
            return Intrinsics.areEqual(this.prediction, solitaryLeaf.prediction);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u0003*\u0006\b\u0006\u0010\u0004 \u00012\u00020\u0005:\u0001\u0016J'\u0010\u0006\u001a\u00028\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\bH&\u00a2\u0006\u0002\u0010\tJ'\u0010\n\u001a\u00028\u00062\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\fH&\u00a2\u0006\u0002\u0010\rJ'\u0010\u000e\u001a\u00028\u00062\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0010H&\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\u00028\u00062\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0014H&\u00a2\u0006\u0002\u0010\u0015\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/session/SessionTree$Visitor;", "RootT", "MainT", "PredictionT", "T", "", "acceptBranching", "branching", "Lcom/intellij/platform/ml/session/SessionTree$Branching;", "(Lcom/intellij/platform/ml/session/SessionTree$Branching;)Ljava/lang/Object;", "acceptLeaf", "leaf", "Lcom/intellij/platform/ml/session/SessionTree$Leaf;", "(Lcom/intellij/platform/ml/session/SessionTree$Leaf;)Ljava/lang/Object;", "acceptComplexRoot", "root", "Lcom/intellij/platform/ml/session/SessionTree$ComplexRoot;", "(Lcom/intellij/platform/ml/session/SessionTree$ComplexRoot;)Ljava/lang/Object;", "acceptSolitaryLeaf", "solitaryLeaf", "Lcom/intellij/platform/ml/session/SessionTree$SolitaryLeaf;", "(Lcom/intellij/platform/ml/session/SessionTree$SolitaryLeaf;)Ljava/lang/Object;", "Default", "intellij.platform.ml"})
    public static interface Visitor<RootT, MainT, PredictionT, T> {
        public T acceptBranching(@NotNull Branching<RootT, MainT, PredictionT> var1);

        public T acceptLeaf(@NotNull Leaf<RootT, MainT, PredictionT> var1);

        public T acceptComplexRoot(@NotNull ComplexRoot<RootT, MainT, PredictionT> var1);

        public T acceptSolitaryLeaf(@NotNull SolitaryLeaf<RootT, MainT, PredictionT> var1);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0004\b\u0007\u0010\u0001*\u0004\b\b\u0010\u0002*\u0004\b\t\u0010\u00032\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00050\u0004J\"\u0010\u0006\u001a\u00020\u00052\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0007\u0012\u0004\u0012\u00028\b\u0012\u0004\u0012\u00028\t0\bH\u0016J\"\u0010\t\u001a\u00020\u00052\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0007\u0012\u0004\u0012\u00028\b\u0012\u0004\u0012\u00028\t0\u000bH\u0016J\"\u0010\f\u001a\u00020\u00052\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00028\u0007\u0012\u0004\u0012\u00028\b\u0012\u0004\u0012\u00028\t0\u000eH\u0016J\"\u0010\u000f\u001a\u00020\u00052\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00028\u0007\u0012\u0004\u0012\u00028\b\u0012\u0004\u0012\u00028\t0\u0011H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/session/SessionTree$Visitor$Default;", "ModelT", "MainT", "PredictionT", "Lcom/intellij/platform/ml/session/SessionTree$Visitor;", "", "acceptBranching", "branching", "Lcom/intellij/platform/ml/session/SessionTree$Branching;", "acceptLeaf", "leaf", "Lcom/intellij/platform/ml/session/SessionTree$Leaf;", "acceptComplexRoot", "root", "Lcom/intellij/platform/ml/session/SessionTree$ComplexRoot;", "acceptSolitaryLeaf", "solitaryLeaf", "Lcom/intellij/platform/ml/session/SessionTree$SolitaryLeaf;", "intellij.platform.ml"})
        public static interface Default<ModelT, MainT, PredictionT>
        extends Visitor<ModelT, MainT, PredictionT, Unit> {
            @Override
            default public void acceptBranching(@NotNull Branching<ModelT, MainT, PredictionT> branching) {
                Intrinsics.checkNotNullParameter(branching, (String)"branching");
            }

            @Override
            default public void acceptLeaf(@NotNull Leaf<ModelT, MainT, PredictionT> leaf) {
                Intrinsics.checkNotNullParameter(leaf, (String)"leaf");
            }

            @Override
            default public void acceptComplexRoot(@NotNull ComplexRoot<ModelT, MainT, PredictionT> root) {
                Intrinsics.checkNotNullParameter(root, (String)"root");
            }

            @Override
            default public void acceptSolitaryLeaf(@NotNull SolitaryLeaf<ModelT, MainT, PredictionT> solitaryLeaf) {
                Intrinsics.checkNotNullParameter(solitaryLeaf, (String)"solitaryLeaf");
            }
        }
    }
}

