/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tJ\u001a\u0010\n\u001a\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u001c\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tH\u0002J\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/remoteDev/util/RemoteDevProtocolUtil;", "", "<init>", "()V", "gatewayPrefix", "", "httpPrefix", "createGatewayUrl", "parameters", "", "createHttpUrl", "urlEncode", "value", "urlDecode", "buildParamsString", "params", "parseParamsString", "intellij.remoteDev.util"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nProtocolUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolUtils.kt\ncom/intellij/remoteDev/util/RemoteDevProtocolUtil\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,47:1\n129#2:48\n158#2,3:49\n*S KotlinDebug\n*F\n+ 1 ProtocolUtils.kt\ncom/intellij/remoteDev/util/RemoteDevProtocolUtil\n*L\n34#1:48\n34#1:49,3\n*E\n"})
public final class RemoteDevProtocolUtil {
    @NotNull
    public static final RemoteDevProtocolUtil INSTANCE = new RemoteDevProtocolUtil();
    @NotNull
    public static final String gatewayPrefix = "jetbrains-gateway://connect";
    @NotNull
    public static final String httpPrefix = "https://code-with-me.jetbrains.com/remoteDev";

    private RemoteDevProtocolUtil() {
    }

    @NotNull
    public final String createGatewayUrl(@NotNull Map<String, String> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return "jetbrains-gateway://connect#" + this.buildParamsString(parameters);
    }

    @NotNull
    public final String createHttpUrl(@NotNull Map<String, String> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return "https://code-with-me.jetbrains.com/remoteDev#" + this.buildParamsString(parameters);
    }

    private final String urlEncode(String value) {
        String string = URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return string;
    }

    private final String urlDecode(String value) {
        String string = URLDecoder.decode(value, StandardCharsets.UTF_8.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String buildParamsString(Map<String, String> params) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = params;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey() + "=" + INSTANCE.urlEncode((String)it.getValue()));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final Map<String, String> parseParamsString(@NotNull String params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Map parameters = new LinkedHashMap();
        String[] stringArray = new String[]{"&"};
        for (String parameterPair : StringsKt.split$default((CharSequence)params, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            int index = StringsKt.indexOf$default((CharSequence)parameterPair, (String)"=", (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                parameters.put(parameterPair, "");
                continue;
            }
            String string = parameterPair.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = parameterPair.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            parameters.put(string, this.urlDecode(string2));
        }
        return parameters;
    }
}

