/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.SyntheticConfigurationTypeProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

@Service
public final class DeployToServerConfigurationTypesRegistrar
implements Disposable {
    @NotNull
    private static final Logger LOG = Logger.getInstance(DeployToServerConfigurationTypesRegistrar.class);
    private final ConcurrentMap<ServerType<?>, DeployToServerConfigurationType<?>> myConfigurationTypes = new ConcurrentHashMap();

    @NotNull
    public static DeployToServerConfigurationTypesRegistrar getInstance() {
        DeployToServerConfigurationTypesRegistrar deployToServerConfigurationTypesRegistrar = (DeployToServerConfigurationTypesRegistrar)ApplicationManager.getApplication().getService(DeployToServerConfigurationTypesRegistrar.class);
        if (deployToServerConfigurationTypesRegistrar == null) {
            DeployToServerConfigurationTypesRegistrar.$$$reportNull$$$0(0);
        }
        return deployToServerConfigurationTypesRegistrar;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static DeployToServerConfigurationType<?> getDeployConfigurationType(@NotNull ServerType<?> serverType) {
        if (serverType == null) {
            DeployToServerConfigurationTypesRegistrar.$$$reportNull$$$0(1);
        }
        DeployToServerConfigurationType<?> deployToServerConfigurationType = DeployToServerConfigurationTypesRegistrar.getInstance().getConfigurationType(serverType);
        if (deployToServerConfigurationType == null) {
            DeployToServerConfigurationTypesRegistrar.$$$reportNull$$$0(2);
        }
        return deployToServerConfigurationType;
    }

    private DeployToServerConfigurationTypesRegistrar() {
        ServerType.EP_NAME.getPoint().addExtensionPointListener(new ExtensionPointListener<ServerType<?>>(){

            public void extensionAdded(@NotNull ServerType<?> serverType, @NotNull PluginDescriptor pluginDescriptor) {
                if (serverType == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                DeployToServerConfigurationTypesRegistrar.this.registerConfigurationType(serverType);
            }

            public void extensionRemoved(@NotNull ServerType<?> serverType, @NotNull PluginDescriptor pluginDescriptor) {
                if (serverType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                DeployToServerConfigurationTypesRegistrar.this.unregisterConfigurationType(serverType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverType";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationTypesRegistrar$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, (Disposable)this);
    }

    @NotNull
    public <C extends ServerConfiguration> DeployToServerConfigurationType<C> getConfigurationType(@NotNull ServerType<C> serverType) {
        DeployToServerConfigurationType result2;
        if (serverType == null) {
            DeployToServerConfigurationTypesRegistrar.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((result2 = (DeployToServerConfigurationType)this.myConfigurationTypes.get(serverType)) != null, (Object)("Cannot find run configuration type for server: " + serverType.getId()));
        DeployToServerConfigurationType deployToServerConfigurationType = result2;
        if (deployToServerConfigurationType == null) {
            DeployToServerConfigurationTypesRegistrar.$$$reportNull$$$0(4);
        }
        return deployToServerConfigurationType;
    }

    private void registerConfigurationType(@NotNull ServerType<?> serverType) {
        if (serverType == null) {
            DeployToServerConfigurationTypesRegistrar.$$$reportNull$$$0(5);
        }
        DeployToServerConfigurationType configurationType = new DeployToServerConfigurationType(serverType);
        try {
            DeployToServerConfigurationTypesRegistrar.getConfigurationTypeEP().registerExtension(configurationType);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        this.myConfigurationTypes.put(serverType, configurationType);
    }

    private void unregisterConfigurationType(@NotNull ServerType<?> serverType) {
        DeployToServerConfigurationType configurationType;
        if (serverType == null) {
            DeployToServerConfigurationTypesRegistrar.$$$reportNull$$$0(6);
        }
        LOG.assertTrue((configurationType = (DeployToServerConfigurationType)this.myConfigurationTypes.remove(serverType)) != null, (Object)("Run configuration has not been registered for server: " + serverType.getId()));
        try {
            DeployToServerConfigurationTypesRegistrar.getConfigurationTypeEP().unregisterExtension((Object)configurationType);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void dispose() {
        this.myConfigurationTypes.clear();
    }

    @NotNull
    private static @NotNull ExtensionPointImpl<@NotNull ConfigurationType> getConfigurationTypeEP() {
        ExtensionPointImpl extensionPointImpl = (ExtensionPointImpl)ConfigurationType.CONFIGURATION_TYPE_EP.getPoint();
        if (extensionPointImpl == null) {
            DeployToServerConfigurationTypesRegistrar.$$$reportNull$$$0(7);
        }
        return extensionPointImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationTypesRegistrar";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationTypesRegistrar";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployConfigurationType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationTypeEP";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDeployConfigurationType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerConfigurationType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unregisterConfigurationType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    static final class Provider
    implements SyntheticConfigurationTypeProvider {
        Provider() {
        }

        @NotNull
        public Collection<? extends DeployToServerConfigurationType<?>> getConfigurationTypes() {
            Collection collection = DeployToServerConfigurationTypesRegistrar.getInstance().myConfigurationTypes.values();
            if (collection == null) {
                Provider.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationTypesRegistrar$Provider", "getConfigurationTypes"));
        }
    }
}

