/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserDescriptor
implements Cloneable {
    @ApiStatus.Internal
    public static final DataKey<String> FILTER_TYPE = DataKey.create((String)"file.chooser.filter.kind");
    private final boolean myChooseFiles;
    private final boolean myChooseFolders;
    private final boolean myChooseJarContents;
    private final boolean myChooseMultiple;
    @Nullable
    private final FileChooserDescriptor myBaseDescriptor;
    @NlsContexts.DialogTitle
    private String myTitle;
    private @NlsContexts.Label String myDescription;
    private boolean myHideIgnored;
    private final List<VirtualFile> myRoots;
    private boolean myShowFileSystemRoots;
    private boolean myTreeRootVisible;
    private boolean myShowHiddenFiles;
    private @Nullable Pair<@Nls String, List<String>> myExtensionFilter;
    @Nullable
    private List<FileType> myFileTypeFilter;
    @Nullable
    private Predicate<? super VirtualFile> myFileFilter;
    private boolean myForcedToUseIdeaFileChooser;
    private final Map<String, Object> myUserData;

    @ApiStatus.Obsolete
    public FileChooserDescriptor(boolean chooseFiles, boolean chooseFolders, boolean chooseJars, boolean chooseJarsAsFiles, boolean chooseJarContents, boolean chooseMultiple) {
        this(chooseFiles || chooseJars && !chooseJarContents || chooseJarsAsFiles, chooseFolders, chooseJarContents, chooseMultiple);
    }

    @ApiStatus.Internal
    public FileChooserDescriptor(boolean chooseFiles, boolean chooseFolders, boolean chooseJarContents, boolean chooseMultiple) {
        this(chooseFiles, chooseFolders, chooseJarContents, chooseMultiple, null);
    }

    private FileChooserDescriptor(boolean chooseFiles, boolean chooseFolders, boolean chooseJarContents, boolean chooseMultiple, @Nullable FileChooserDescriptor baseDescriptor) {
        this.myTitle = IdeCoreBundle.message("file.chooser.default.title", new Object[0]);
        this.myHideIgnored = true;
        this.myRoots = new ArrayList<VirtualFile>();
        this.myShowFileSystemRoots = true;
        this.myTreeRootVisible = false;
        this.myShowHiddenFiles = false;
        this.myExtensionFilter = null;
        this.myFileTypeFilter = null;
        this.myFileFilter = null;
        this.myForcedToUseIdeaFileChooser = false;
        this.myUserData = new HashMap<String, Object>();
        this.myChooseFiles = chooseFiles;
        this.myChooseFolders = chooseFolders;
        this.myChooseJarContents = chooseJarContents;
        this.myChooseMultiple = chooseMultiple;
        this.myBaseDescriptor = baseDescriptor;
    }

    public FileChooserDescriptor(@NotNull FileChooserDescriptor d) {
        if (d == null) {
            FileChooserDescriptor.$$$reportNull$$$0(0);
        }
        this(d.isChooseFiles(), d.isChooseFolders(), d.isChooseJarContents(), d.isChooseMultiple(), d);
        this.myTitle = d.getTitle();
        this.myDescription = d.getDescription();
        this.myHideIgnored = d.isHideIgnored();
        this.myRoots.addAll(d.getRoots());
        this.myShowFileSystemRoots = d.isShowFileSystemRoots();
        this.myTreeRootVisible = d.isTreeRootVisible();
        this.myShowHiddenFiles = d.isShowHiddenFiles();
        this.myExtensionFilter = d.myExtensionFilter;
        this.myFileTypeFilter = d.myFileTypeFilter;
        this.myFileFilter = d.myFileFilter;
        this.myForcedToUseIdeaFileChooser = false;
        this.myUserData.putAll(d.myUserData);
    }

    public boolean isChooseFiles() {
        return this.myChooseFiles;
    }

    public boolean isChooseFolders() {
        return this.myChooseFolders;
    }

    public boolean isChooseJarContents() {
        return this.myChooseJarContents;
    }

    public boolean isChooseMultiple() {
        return this.myChooseMultiple;
    }

    @NlsContexts.DialogTitle
    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(@NlsContexts.DialogTitle String title) {
        this.withTitle(title);
    }

    public FileChooserDescriptor withTitle(@NlsContexts.DialogTitle String title) {
        this.myTitle = title;
        return this;
    }

    @NlsContexts.Label
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@NlsContexts.Label String description) {
        this.withDescription(description);
    }

    public FileChooserDescriptor withDescription(@NlsContexts.Label String description) {
        this.myDescription = description;
        return this;
    }

    public boolean isHideIgnored() {
        return this.myHideIgnored;
    }

    public void setHideIgnored(boolean hideIgnored) {
        this.withHideIgnored(hideIgnored);
    }

    public FileChooserDescriptor withHideIgnored(boolean hideIgnored) {
        this.myHideIgnored = hideIgnored;
        return this;
    }

    public List<VirtualFile> getRoots() {
        return Collections.unmodifiableList(this.myRoots);
    }

    public void setRoots(VirtualFile ... roots) {
        if (roots == null) {
            FileChooserDescriptor.$$$reportNull$$$0(1);
        }
        this.withRoots(roots);
    }

    public void setRoots(@NotNull List<? extends VirtualFile> roots) {
        if (roots == null) {
            FileChooserDescriptor.$$$reportNull$$$0(2);
        }
        this.withRoots(roots);
    }

    public FileChooserDescriptor withRoots(VirtualFile ... roots) {
        return this.withRoots(Arrays.asList(roots));
    }

    public FileChooserDescriptor withRoots(@NotNull List<? extends VirtualFile> roots) {
        if (roots == null) {
            FileChooserDescriptor.$$$reportNull$$$0(3);
        }
        if (roots.contains(null)) {
            throw new IllegalArgumentException("'null' in roots: " + String.valueOf(roots));
        }
        this.myRoots.clear();
        this.myRoots.addAll(roots);
        return this;
    }

    public boolean isShowFileSystemRoots() {
        return this.myShowFileSystemRoots;
    }

    public void setShowFileSystemRoots(boolean showFileSystemRoots) {
        this.withShowFileSystemRoots(showFileSystemRoots);
    }

    public FileChooserDescriptor withShowFileSystemRoots(boolean showFileSystemRoots) {
        this.myShowFileSystemRoots = showFileSystemRoots;
        return this;
    }

    public boolean isTreeRootVisible() {
        return this.myTreeRootVisible;
    }

    public FileChooserDescriptor withTreeRootVisible(boolean isTreeRootVisible) {
        this.myTreeRootVisible = isTreeRootVisible;
        return this;
    }

    public boolean isShowHiddenFiles() {
        return this.myShowHiddenFiles;
    }

    public FileChooserDescriptor withShowHiddenFiles(boolean showHiddenFiles) {
        this.myShowHiddenFiles = showHiddenFiles;
        return this;
    }

    public FileChooserDescriptor withFileFilter(@Nullable Condition<? super VirtualFile> filter) {
        this.myFileFilter = filter;
        return this;
    }

    public FileChooserDescriptor withExtensionFilter(@NotNull FileType type) {
        if (type == null) {
            FileChooserDescriptor.$$$reportNull$$$0(4);
        }
        return this.withExtensionFilter(IdeCoreBundle.message("file.chooser.files.label", type.getName()), type);
    }

    public FileChooserDescriptor withExtensionFilter(@NlsContexts.Label @NotNull String label, FileType ... types) {
        if (label == null) {
            FileChooserDescriptor.$$$reportNull$$$0(5);
        }
        if (types == null) {
            FileChooserDescriptor.$$$reportNull$$$0(6);
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("The list must not be empty");
        }
        String[] extensions = (String[])Stream.of(types).flatMap(type -> FileTypeManager.getInstance().getAssociations((FileType)type).stream()).map(matcher -> {
            String string;
            if (matcher instanceof ExtensionFileNameMatcher) {
                ExtensionFileNameMatcher em = (ExtensionFileNameMatcher)matcher;
                string = em.getExtension();
            } else {
                string = null;
            }
            return string;
        }).filter(Objects::nonNull).toArray(String[]::new);
        this.myFileTypeFilter = List.of(types);
        return this.withExtensionFilter(label, extensions);
    }

    public FileChooserDescriptor withExtensionFilter(@NotNull String extension) {
        if (extension == null) {
            FileChooserDescriptor.$$$reportNull$$$0(7);
        }
        return this.withExtensionFilter(IdeCoreBundle.message("file.chooser.files.label", extension.toUpperCase(Locale.ROOT)), extension);
    }

    public FileChooserDescriptor withExtensionFilter(@NlsContexts.Label @NotNull String label, String ... extensions) {
        if (label == null) {
            FileChooserDescriptor.$$$reportNull$$$0(8);
        }
        if (extensions == null) {
            FileChooserDescriptor.$$$reportNull$$$0(9);
        }
        if (extensions.length == 0) {
            throw new IllegalArgumentException("The list must not be empty");
        }
        this.myExtensionFilter = new Pair((Object)label, List.of(extensions));
        return this;
    }

    public FileChooserDescriptor withoutExtensionFilter() {
        this.myExtensionFilter = null;
        this.myFileTypeFilter = null;
        return this;
    }

    @Deprecated
    @ApiStatus.NonExtendable
    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        if (file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null) {
            return false;
        }
        if (!file.isDirectory()) {
            if (!(this.myChooseFiles || this.myChooseJarContents && FileChooserDescriptor.isArchive(file))) {
                return false;
            }
            if (!this.matchesFilters(file)) {
                return false;
            }
        }
        if (this.isHideIgnored() && FileTypeManager.getInstance().isFileIgnored(file)) {
            return false;
        }
        return showHiddenFiles || !FileElement.isFileHidden(file);
    }

    @Deprecated
    @Contract(value="null -> false")
    @ApiStatus.NonExtendable
    public boolean isFileSelectable(@Nullable VirtualFile file) {
        if (file == null || file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null) {
            return false;
        }
        if (file.isDirectory()) {
            return this.myChooseFolders;
        }
        if (!this.matchesFilters(file)) {
            return false;
        }
        return this.myChooseFiles || this.myChooseJarContents && FileChooserDescriptor.isArchive(file);
    }

    @ApiStatus.Internal
    public final boolean isHidden(@NotNull VirtualFile file) {
        if (file == null) {
            FileChooserDescriptor.$$$reportNull$$$0(10);
        }
        return file.is(VFileProperty.HIDDEN) || file.getName().startsWith(".") || FileTypeManager.getInstance().isFileIgnored(file);
    }

    @ApiStatus.Internal
    public final boolean isSelectable(@NotNull VirtualFile file) {
        if (file == null) {
            FileChooserDescriptor.$$$reportNull$$$0(11);
        }
        if (file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null) {
            return false;
        }
        if (file.isDirectory()) {
            return this.myChooseFolders;
        }
        if (!this.matchesFilters(file)) {
            return false;
        }
        return this.myChooseFiles || this.myChooseJarContents && FileChooserDescriptor.isArchive(file);
    }

    protected boolean matchesFilters(VirtualFile file) {
        return !(this.myExtensionFilter != null && !ContainerUtil.exists((Iterable)((Iterable)this.myExtensionFilter.second), ext -> Strings.endsWithIgnoreCase((CharSequence)file.getName(), (String)("." + ext))) || this.myFileTypeFilter != null && !ContainerUtil.exists(this.myFileTypeFilter, type -> FileTypeRegistry.getInstance().isFileOfType(file, type)) || this.myFileFilter != null && !this.myFileFilter.test((VirtualFile)file));
    }

    private static boolean isArchive(VirtualFile file) {
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)ArchiveFileType.INSTANCE);
    }

    public void validateSelectedFiles(@NotNull @NotNull VirtualFile @NotNull [] files) throws Exception {
        if (files == null) {
            FileChooserDescriptor.$$$reportNull$$$0(12);
        }
        if (this.myBaseDescriptor != null) {
            this.myBaseDescriptor.validateSelectedFiles(files);
        }
    }

    public Icon getIcon(VirtualFile file) {
        return FileChooserDescriptor.dressIcon(file, IconUtil.getIcon((VirtualFile)file, (int)2, null));
    }

    protected static Icon dressIcon(VirtualFile file, Icon baseIcon) {
        return file.isValid() && file.is(VFileProperty.SYMLINK) ? LayeredIcon.layeredIcon((Icon[])new Icon[]{baseIcon, PlatformIcons.SYMLINK_ICON}) : baseIcon;
    }

    public String getName(VirtualFile file) {
        return file.getPresentableName();
    }

    @NlsSafe
    @Nullable
    public String getComment(VirtualFile file) {
        return null;
    }

    public boolean isForcedToUseIdeaFileChooser() {
        return this.myForcedToUseIdeaFileChooser;
    }

    public void setForcedToUseIdeaFileChooser(boolean forcedToUseIdeaFileChooser) {
        this.myForcedToUseIdeaFileChooser = forcedToUseIdeaFileChooser;
    }

    @ApiStatus.Internal
    @Nullable
    public final VirtualFile getFileToSelect(@NotNull VirtualFile file) {
        if (file == null) {
            FileChooserDescriptor.$$$reportNull$$$0(13);
        }
        if (this.isFileSelectable(file)) {
            if (!file.isDirectory() && this.myChooseJarContents && FileChooserDescriptor.isArchive(file)) {
                String path = file.getPath();
                return JarFileSystem.getInstance().findFileByPath(path + "!/");
            }
            if (file.isDirectory() || this.myChooseFiles) {
                return file;
            }
        }
        return null;
    }

    @ApiStatus.Internal
    public @Nullable Pair<@Nls String, List<@NlsSafe String>> getExtensionFilter() {
        return this.myExtensionFilter;
    }

    @Deprecated(forRemoval=true)
    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Object getUserData(@NotNull String dataId) {
        if (dataId == null) {
            FileChooserDescriptor.$$$reportNull$$$0(14);
        }
        return this.myUserData.get(dataId);
    }

    @Nullable
    public <T> T getUserData(@NotNull DataKey<T> key) {
        if (key == null) {
            FileChooserDescriptor.$$$reportNull$$$0(15);
        }
        if (key == FILTER_TYPE) {
            Object result = "";
            if (this.myExtensionFilter != null) {
                result = (String)result + "e";
            }
            if (this.myFileFilter != null) {
                result = (String)result + "f";
            }
            Object t = result;
            return (T)t;
        }
        Object t = this.myUserData.get(key.getName());
        return (T)t;
    }

    public <T> void putUserData(@NotNull DataKey<T> key, @Nullable T data) {
        if (key == null) {
            FileChooserDescriptor.$$$reportNull$$$0(16);
        }
        this.myUserData.put(key.getName(), data);
    }

    public String toString() {
        return "FileChooserDescriptor [" + this.myTitle + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileChooser/FileChooserDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withRoots";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "withExtensionFilter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isHidden";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelectable";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "validateSelectedFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileToSelect";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserData";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "putUserData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

