/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.DynamicStats;
import org.jetbrains.kotlin.util.GarbageCollectionStats;
import org.jetbrains.kotlin.util.PerformanceManager;
import org.jetbrains.kotlin.util.PhaseSideType;
import org.jetbrains.kotlin.util.PhaseType;
import org.jetbrains.kotlin.util.SideStats;
import org.jetbrains.kotlin.util.Time;
import org.jetbrains.kotlin.util.UnitStats;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00010\u0004\u001a&\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00010\u0004\u001a\u001e\u0010\u0011\u001a\u00020\u0001*\u00020\u00122\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u0013\u001a\u0012\u0010\u0018\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0006\"\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"forEachPhaseMeasurement", "", "Lorg/jetbrains/kotlin/util/UnitStats;", "action", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/util/PhaseType;", "Lorg/jetbrains/kotlin/util/Time;", "forEachPhaseSideMeasurement", "Lorg/jetbrains/kotlin/util/PhaseSideType;", "Lorg/jetbrains/kotlin/util/SideStats;", "phaseTypeName", "", "", "getPhaseTypeName", "()Ljava/util/Map;", "phaseSideTypeName", "getPhaseSideTypeName", "forEachStringMeasurement", "Lorg/jetbrains/kotlin/util/PerformanceManager;", "Lkotlin/Function1;", "nanosInSecond", "", "getNanosInSecond", "()J", "getLinesPerSecond", "", "time", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nUnitStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitStats.kt\norg/jetbrains/kotlin/util/UnitStatsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,299:1\n1915#2,2:300\n1915#2,2:302\n777#2:304\n873#2,2:305\n1915#2,2:307\n1915#2,2:309\n*S KotlinDebug\n*F\n+ 1 UnitStats.kt\norg/jetbrains/kotlin/util/UnitStatsKt\n*L\n282#1:300,2\n291#1:302,2\n247#1:304\n247#1:305,2\n249#1:307,2\n262#1:309,2\n*E\n"})
public final class UnitStatsKt {
    @NotNull
    private static final Map<PhaseType, String> phaseTypeName;
    @NotNull
    private static final Map<PhaseSideType, String> phaseSideTypeName;
    private static final long nanosInSecond;

    public static final void forEachPhaseMeasurement(@NotNull UnitStats $this$forEachPhaseMeasurement, @NotNull Function2<? super PhaseType, ? super Time, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachPhaseMeasurement, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke((Object)PhaseType.Initialization, (Object)$this$forEachPhaseMeasurement.getInitStats());
        action.invoke((Object)PhaseType.Analysis, (Object)$this$forEachPhaseMeasurement.getAnalysisStats());
        action.invoke((Object)PhaseType.TranslationToIr, (Object)$this$forEachPhaseMeasurement.getTranslationToIrStats());
        action.invoke((Object)PhaseType.IrPreLowering, (Object)$this$forEachPhaseMeasurement.getIrPreLoweringStats());
        action.invoke((Object)PhaseType.IrSerialization, (Object)$this$forEachPhaseMeasurement.getIrSerializationStats());
        action.invoke((Object)PhaseType.KlibWriting, (Object)$this$forEachPhaseMeasurement.getKlibWritingStats());
        action.invoke((Object)PhaseType.IrLowering, (Object)$this$forEachPhaseMeasurement.getIrLoweringStats());
        action.invoke((Object)PhaseType.Backend, (Object)$this$forEachPhaseMeasurement.getBackendStats());
    }

    public static final void forEachPhaseSideMeasurement(@NotNull UnitStats $this$forEachPhaseSideMeasurement, @NotNull Function2<? super PhaseSideType, ? super SideStats, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachPhaseSideMeasurement, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke((Object)PhaseSideType.FindJavaClass, (Object)$this$forEachPhaseSideMeasurement.getFindJavaClassStats());
        action.invoke((Object)PhaseSideType.BinaryClassFromKotlinFile, (Object)$this$forEachPhaseSideMeasurement.getFindKotlinClassStats());
    }

    @NotNull
    public static final Map<PhaseType, String> getPhaseTypeName() {
        return phaseTypeName;
    }

    @NotNull
    public static final Map<PhaseSideType, String> getPhaseSideTypeName() {
        return phaseSideTypeName;
    }

    public static final void forEachStringMeasurement(@NotNull PerformanceManager $this$forEachStringMeasurement, @NotNull Function1<? super String, Unit> action) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$forEachStringMeasurement, (String)"<this>");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            UnitStats $this$forEachStringMeasurement_u24lambda_u240 = $this$forEachStringMeasurement.getUnitStats();
            boolean bl = false;
            UnitStatsKt.forEachPhaseMeasurement($this$forEachStringMeasurement_u24lambda_u240, (Function2<? super PhaseType, ? super Time, Unit>)((Function2)(arg_0, arg_1) -> UnitStatsKt.forEachStringMeasurement$lambda$0$0(action, $this$forEachStringMeasurement_u24lambda_u240, $this$forEachStringMeasurement, arg_0, arg_1)));
            UnitStatsKt.forEachPhaseSideMeasurement($this$forEachStringMeasurement_u24lambda_u240, (Function2<? super PhaseSideType, ? super SideStats, Unit>)((Function2)(arg_0, arg_1) -> UnitStatsKt.forEachStringMeasurement$lambda$0$1(action, arg_0, arg_1)));
            Iterable $this$forEach$iv = $this$forEachStringMeasurement_u24lambda_u240.getGcStats();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GarbageCollectionStats it = (GarbageCollectionStats)element$iv;
                boolean bl2 = false;
                action.invoke((Object)("GC time for " + it.getKind() + " is " + it.getMillis() + " ms, " + it.getCount() + " collections"));
            }
            Long l = $this$forEachStringMeasurement_u24lambda_u240.getJitTimeMillis();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl3 = false;
                action.invoke((Object)("JIT time is " + it + " ms"));
            }
            List<String> list = $this$forEachStringMeasurement_u24lambda_u240.getExtendedStats();
            if (list == null) break block3;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String it = (String)element$iv;
                boolean bl4 = false;
                action.invoke((Object)it);
            }
        }
    }

    public static final long getNanosInSecond() {
        return nanosInSecond;
    }

    public static final double getLinesPerSecond(@NotNull UnitStats $this$getLinesPerSecond, @NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)$this$getLinesPerSecond, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return (double)$this$getLinesPerSecond.getLinesCount() / (double)time.getNanos() * (double)nanosInSecond;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit forEachStringMeasurement$lambda$0$0(Function1 $action, UnitStats $this_with, PerformanceManager $this_forEachStringMeasurement, PhaseType phaseType, Time time) {
        block10: {
            String string;
            List filteredDynamicStats;
            block11: {
                DynamicStats it;
                void $this$filterTo$iv$iv;
                String string2;
                Intrinsics.checkNotNullParameter((Object)((Object)phaseType), (String)"phaseType");
                if (time == null) {
                    return Unit.INSTANCE;
                }
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = "%20s%8s ms";
                Object object = new Object[]{MapsKt.getValue(phaseTypeName, (Object)((Object)phaseType)), time.getMillis()};
                String string4 = String.format(string3, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                StringBuilder stringBuilder2 = stringBuilder.append(string4);
                if (phaseType != PhaseType.Initialization && $this_with.getLinesCount() != 0) {
                    string3 = "%12.3f loc/s";
                    object = Locale.ENGLISH;
                    Object[] objectArray = new Object[]{UnitStatsKt.getLinesPerSecond($this_with, time)};
                    String string5 = String.format((Locale)object, string3, Arrays.copyOf(objectArray, objectArray.length));
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                } else {
                    string2 = "";
                }
                $action.invoke((Object)stringBuilder2.append(string2).toString());
                List<DynamicStats> list = $this_with.getDynamicStats();
                if (list == null) break block10;
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (DynamicStats)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getParentPhaseType() == phaseType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                filteredDynamicStats = (List)destination$iv$iv;
                boolean bl = false;
                if (!$this_forEachStringMeasurement.getDetailedPerf()) break block11;
                Iterable $this$forEach$iv = filteredDynamicStats;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String string6;
                    it = (DynamicStats)element$iv;
                    boolean bl2 = false;
                    String dynamicName = it.component2();
                    Time dynamicTime = it.component3();
                    StringBuilder stringBuilder3 = new StringBuilder();
                    String string7 = "%20s%8s ms";
                    Object object2 = new Object[]{"DYNAMIC PHASE", dynamicTime.getMillis()};
                    String string8 = String.format(string7, Arrays.copyOf(object2, ((Object[])object2).length));
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
                    StringBuilder stringBuilder4 = stringBuilder3.append(string8);
                    if ($this_with.getLinesCount() != 0) {
                        string7 = "%12.3f loc/s (" + dynamicName + ')';
                        object2 = Locale.ENGLISH;
                        Object[] objectArray = new Object[]{UnitStatsKt.getLinesPerSecond($this_with, dynamicTime)};
                        String string9 = String.format((Locale)object2, string7, Arrays.copyOf(objectArray, objectArray.length));
                        string6 = string9;
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
                    } else {
                        string6 = " (" + dynamicName + ')';
                    }
                    $action.invoke((Object)stringBuilder4.append(string6).toString());
                }
                break block10;
            }
            if (!(!((Collection)filteredDynamicStats).isEmpty())) break block10;
            Time totTime = null;
            totTime = Time.Companion.getZERO();
            Iterable $this$forEach$iv = filteredDynamicStats;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DynamicStats it = (DynamicStats)element$iv;
                boolean bl = false;
                totTime = totTime.plus(it.getTime());
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string10 = "%20s%8s ms";
            Object object = new Object[]{"DYNAMIC PHASES", totTime.getMillis()};
            String string11 = String.format(string10, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(...)");
            StringBuilder stringBuilder5 = stringBuilder.append(string11);
            if ($this_with.getLinesCount() != 0) {
                string10 = "%12.3f loc/s";
                object = Locale.ENGLISH;
                Object[] objectArray = new Object[]{UnitStatsKt.getLinesPerSecond($this_with, totTime)};
                String string12 = String.format((Locale)object, string10, Arrays.copyOf(objectArray, objectArray.length));
                string = string12;
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"format(...)");
            } else {
                string = "";
            }
            $action.invoke((Object)stringBuilder5.append(string).toString());
        }
        return Unit.INSTANCE;
    }

    private static final Unit forEachStringMeasurement$lambda$0$1(Function1 $action, PhaseSideType phaseSideType, SideStats sideStats) {
        Intrinsics.checkNotNullParameter((Object)((Object)phaseSideType), (String)"phaseSideType");
        if (sideStats == null) {
            return Unit.INSTANCE;
        }
        String description2 = (String)MapsKt.getValue(phaseSideTypeName, (Object)((Object)phaseSideType));
        $action.invoke((Object)(description2 + " performed " + sideStats.getCount() + " times, total time " + sideStats.getTime().getMillis() + " ms"));
        return Unit.INSTANCE;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)PhaseType.Initialization), (Object)"INIT"), TuplesKt.to((Object)((Object)PhaseType.Analysis), (Object)"ANALYZE"), TuplesKt.to((Object)((Object)PhaseType.TranslationToIr), (Object)"TRANSLATION to IR"), TuplesKt.to((Object)((Object)PhaseType.IrPreLowering), (Object)"IR PRE-LOWERING"), TuplesKt.to((Object)((Object)PhaseType.IrSerialization), (Object)"IR SERIALIZATION"), TuplesKt.to((Object)((Object)PhaseType.KlibWriting), (Object)"KLIB WRITING"), TuplesKt.to((Object)((Object)PhaseType.IrLowering), (Object)"IR LOWERING"), TuplesKt.to((Object)((Object)PhaseType.Backend), (Object)"BACKEND")};
        phaseTypeName = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)PhaseSideType.FindJavaClass), (Object)"Find Java class"), TuplesKt.to((Object)((Object)PhaseSideType.BinaryClassFromKotlinFile), (Object)"Binary class from Kotlin file")};
        phaseSideTypeName = MapsKt.mapOf((Pair[])pairArray);
        nanosInSecond = TimeUnit.SECONDS.toNanos(1L);
    }
}

