/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver.dataextractor;

import com.intellij.driver.model.TextData;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.ExtractorGraphics2d;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.GlyphVector;
import java.text.AttributedCharacterIterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\"\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u000b\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\"\u0010\u000b\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J \u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0017H\u0016J \u0010\u001b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/CellReaderGraphics2d;", "Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/ExtractorGraphics2d;", "g", "Ljava/awt/Graphics2D;", "extractionData", "", "Lcom/intellij/driver/model/TextData;", "<init>", "(Ljava/awt/Graphics2D;Ljava/util/List;)V", "create", "Ljava/awt/Graphics;", "drawString", "", "str", "", "x", "", "y", "", "iterator", "Ljava/text/AttributedCharacterIterator;", "translate", "tx", "", "ty", "rotate", "theta", "drawGlyphVector", "Ljava/awt/font/GlyphVector;", "addTextData", "text", "intellij.performanceTesting.remoteDriver"})
public final class CellReaderGraphics2d
extends ExtractorGraphics2d {
    @NotNull
    private final Graphics2D g;
    @NotNull
    private final List<TextData> extractionData;

    public CellReaderGraphics2d(@NotNull Graphics2D g, @NotNull List<TextData> extractionData) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(extractionData, (String)"extractionData");
        super(g);
        this.g = g;
        this.extractionData = extractionData;
    }

    @Override
    @NotNull
    public Graphics create() {
        Graphics graphics = this.g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        return new CellReaderGraphics2d((Graphics2D)graphics, this.extractionData);
    }

    @Override
    public void drawString(@Nullable String str, int x, int y) {
        if (str != null) {
            this.addTextData(str, x, y);
        }
        this.g.drawString(str, x, y);
    }

    @Override
    public void drawString(@Nullable String str, float x, float y) {
        if (str != null) {
            this.addTextData(str, (int)x, (int)y);
        }
        this.g.drawString(str, x, y);
    }

    @Override
    public void drawString(@Nullable AttributedCharacterIterator iterator2, int x, int y) {
        if (iterator2 != null) {
            this.addTextData(iterator2.toString(), x, y);
        }
        this.g.drawString(iterator2, x, y);
    }

    @Override
    public void drawString(@Nullable AttributedCharacterIterator iterator2, float x, float y) {
        if (iterator2 != null) {
            this.addTextData(iterator2.toString(), (int)x, (int)y);
        }
        this.g.drawString(iterator2, x, y);
    }

    @Override
    public void translate(int x, int y) {
        this.g.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.g.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.g.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.g.rotate(theta, x, y);
    }

    @Override
    public void drawGlyphVector(@NotNull GlyphVector g, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.addTextData(this.getTextByGlyphVector(g), (int)x, (int)y);
    }

    private final void addTextData(String text, int x, int y) {
        this.extractionData.add(new TextData(text, new Point(x, y), null));
    }
}

