/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.openapi.util.Ref;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.jetbrains.performancePlugin.utils.DaemonCodeAnalyzerResult;
import io.opentelemetry.api.trace.Span;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\rJ)\u0010\u0019\u001a\u00020\r2!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\r0\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/performancePlugin/utils/DaemonCodeAnalyzerResult;", "", "connection", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "spanRef", "Lcom/intellij/openapi/util/Ref;", "Lio/opentelemetry/api/trace/Span;", "timeoutInSeconds", "", "<init>", "(Lcom/intellij/util/messages/SimpleMessageBusConnection;Lcom/intellij/openapi/util/Ref;J)V", "job", "Ljava/util/concurrent/CompletableFuture;", "", "suppressErrors", "", "errorMessage", "", "isDone", "withErrorMessage", "message", "blockingWaitForComplete", "waitForComplete", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "release", "onError", "action", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "e", "intellij.performanceTesting"})
public final class DaemonCodeAnalyzerResult {
    @NotNull
    private final SimpleMessageBusConnection connection;
    @NotNull
    private final Ref<Span> spanRef;
    @NotNull
    private final CompletableFuture<Unit> job;
    private boolean suppressErrors;
    @NotNull
    private String errorMessage;

    public DaemonCodeAnalyzerResult(@NotNull SimpleMessageBusConnection connection, @NotNull Ref<Span> spanRef, long timeoutInSeconds) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter(spanRef, (String)"spanRef");
        this.connection = connection;
        this.spanRef = spanRef;
        this.job = new CompletableFuture();
        this.errorMessage = "Timeout on waiting for demon code analyzer complete for " + timeoutInSeconds + " seconds";
        if (timeoutInSeconds > 0L) {
            this.job.orTimeout(timeoutInSeconds, TimeUnit.SECONDS);
        }
        this.job.exceptionally(arg_0 -> DaemonCodeAnalyzerResult._init_$lambda$0(this, arg_0));
    }

    public /* synthetic */ DaemonCodeAnalyzerResult(SimpleMessageBusConnection simpleMessageBusConnection, Ref ref, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l2 = 0L;
        }
        this(simpleMessageBusConnection, (Ref<Span>)ref, l2);
    }

    public final boolean isDone() {
        return this.job.isDone();
    }

    public final void suppressErrors() {
        this.suppressErrors = true;
    }

    public final void withErrorMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.errorMessage = message;
    }

    public final void blockingWaitForComplete() {
        block3: {
            try {
                this.job.join();
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.suppressErrors) break block3;
                throw new IllegalStateException(this.errorMessage, e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object waitForComplete(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof waitForComplete.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DaemonCodeAnalyzerResult this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.waitForComplete((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = FutureKt.asDeferred((CompletionStage)this.job).join((Continuation)$continuation);
                ** if (v0 != var5_4) goto lbl18
lbl17:
                // 1 sources

                return var5_4;
lbl18:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Exception e) {
                    if (this.suppressErrors) ** GOTO lbl28
                    throw new IllegalStateException(this.errorMessage, e);
                }
lbl28:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        try {
            this.connection.disconnect();
        }
        finally {
            Span span = (Span)this.spanRef.get();
            if (span != null) {
                span.end();
            }
            if (!this.job.isDone() && !this.job.isCancelled()) {
                this.job.complete(Unit.INSTANCE);
            }
        }
    }

    public final void onError(@NotNull Function1<? super Throwable, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.job.exceptionally(arg_0 -> action.invoke(arg_0));
    }

    private static final Unit _init_$lambda$0(DaemonCodeAnalyzerResult this$0, Throwable it) {
        this$0.release();
        return Unit.INSTANCE;
    }
}

