/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5;

import com.intellij.junit5.report.AbstractTestReporter;
import com.intellij.junit5.report.ExecutionState;
import com.intellij.junit5.report.TeamCityTestReporter;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class JUnit5TestExecutionListener
implements TestExecutionListener {
    private final ExecutionState myState;

    public JUnit5TestExecutionListener() {
        this(System.out);
    }

    public JUnit5TestExecutionListener(PrintStream printStream) {
        this.myState = new ExecutionState(printStream);
        this.myState.print("##teamcity[enteredTheMatrix]");
    }

    public boolean wasSuccessful() {
        return this.myState.wasSuccessful();
    }

    public void initializeIdSuffix(boolean forked) {
        this.myState.initializeIdSuffix(forked);
    }

    public void initializeIdSuffix(int i) {
        this.myState.initializeIdSuffix(i);
    }

    public void setRootName(String rootName) {
        this.myState.setRootName(rootName);
    }

    public void setPresentableName(String presentableName) {
        this.myState.setPresentableName(presentableName);
    }

    public void setSendTree() {
        this.myState.setSendTree(true);
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.myState.setPlan(testPlan);
        if (this.myState.isSendTree()) {
            for (TestIdentifier root : testPlan.getRoots()) {
                assert (root.isContainer());
                for (TestIdentifier testIdentifier : testPlan.getChildren(root)) {
                    String legacyReportingName = testIdentifier.getLegacyReportingName();
                    if (legacyReportingName != null && legacyReportingName.equals(this.myState.getRootName())) {
                        this.myState.setPresentableName(testIdentifier.getDisplayName());
                    }
                    this.sendTreeUnderRoot(testIdentifier, new HashSet<TestIdentifier>());
                }
            }
            this.myState.print("##teamcity[treeEnded]");
        }
        this.myState.printRootNameIfNeeded();
    }

    public void sendTreeUnderRoot(TestIdentifier root, Set<TestIdentifier> visited) {
        AbstractTestReporter reporter = TeamCityTestReporter.get(root, this.myState);
        reporter.treeStarted().forEach(this.myState::print);
        for (TestIdentifier child : this.myState.plan().getChildren(root)) {
            if (visited.add(child)) {
                this.sendTreeUnderRoot(child, visited);
                continue;
            }
            System.err.println("Identifier '" + child.getUniqueId() + "' is reused");
        }
        reporter.treeFinished().forEach(this.myState::print);
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        TeamCityTestReporter.get(testIdentifier, this.myState).output(entry).forEach(this.myState::print);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.executionStarted(testIdentifier);
        TeamCityTestReporter.get(testIdentifier, this.myState).skip(reason).forEach(this.myState::print);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        TeamCityTestReporter.get(testIdentifier, this.myState).start().forEach(this.myState::print);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        TeamCityTestReporter.get(testIdentifier, this.myState).finish(testExecutionResult).forEach(this.myState::print);
        this.myState.updateSuccessful(testExecutionResult.getStatus());
    }

    public static String getClassName(TestIdentifier description) {
        return description.getSource().map(source -> {
            if (source instanceof MethodSource) {
                return ((MethodSource)source).getClassName();
            }
            if (source instanceof ClassSource) {
                return ((ClassSource)source).getClassName();
            }
            return null;
        }).orElse(null);
    }

    public static String getMethodName(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().map(source -> {
            if (source instanceof MethodSource) {
                return ((MethodSource)source).getMethodName();
            }
            return null;
        }).orElse(null);
    }

    static String getMethodSignature(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().map(source -> {
            if (source instanceof MethodSource) {
                String parameterTypes = ((MethodSource)source).getMethodParameterTypes();
                return ((MethodSource)source).getMethodName() + (parameterTypes != null ? "(" + parameterTypes + ")" : "");
            }
            return null;
        }).orElse(null);
    }
}

