/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.Commas;
import ai.grazie.rules.en.EnglishDateChecker;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.RelativeClauses;
import ai.grazie.rules.en.SemCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import java.util.Collection;
import java.util.Objects;
import one.util.streamex.StreamEx;

class ExcessiveComma {
    private static final String COMMA_THAT_MSG = "Don\u2019t put a comma before 'that'";
    private static final String COMMA_ET_AL_MSG = "Don\u2019t put a comma before 'et al.'";
    private static final String COMMA_NOT_ONLY_BUT_ALSO_MSG = "Short 'not only... but also...' phrases usually don\u2019t need a comma";

    ExcessiveComma() {
    }

    static NodePattern pattern() {
        return NodePattern.or(CommonPatterns.comma.markAs("Comma").andOr(ExcessiveComma.inCorrelativeConjunction(), ExcessiveComma.beforeConj(), ExcessiveComma.afterSubj(), ExcessiveComma.beforeThat(), ExcessiveComma.beforeEtAl(), ExcessiveComma.beforeYear(), ExcessiveComma.afterAmod()).and(PunctuationRules.removeUnmandatedComma), ExcessiveComma.aroundParticipialClause().and(PunctuationRules.removeSurroundingCommas));
    }

    private static NodePattern afterAmod() {
        NodePattern allowedNext = NodePattern.N.withHeadRelation("compound").pos("NNP");
        return NodePattern.N.directlyAfter(NodePattern.N.beforeHead().markAs("Adj").noDependents(NodePattern.N.afterHead()).withHead("amod", NodePattern.N.noDependents("amod", NodePattern.N.after("Adj"))).andOr(NodePattern.not(NodePattern.N.withNextSibling(NodePattern.N)), NodePattern.N.withNextSibling(NodePattern.or(allowedNext, CommonPatterns.comma.withNextSibling(allowedNext))))).message("Don\u2019t put a comma between adjective and noun");
    }

    private static NodePattern betweenSubjAndVerb() {
        NodePattern possiblyMisparsedSubj = NodePattern.N.withDependent("advmod", CommonPatterns.capitalizedMiddle.noPos());
        return NodePattern.N.withHead("cc", NodePattern.N.pos("VB[ZPDN]?").withHead("conj", NodePattern.ROOT.and(EnglishTreePatterns.clause).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl").and((node, match) -> node.phraseStart().nextUntil(match.getMarkedNode("Comma")).count() < 4L ? match : null).noDependents("advcl", NodePattern.N.beforeHead()).andNot(CommonPatterns.severalDependents("conj"))).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl|advcl").andNot(EnglishTreePatterns.withToMark).andNot(possiblyMisparsedSubj).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("conj|advcl"))).andNot(NodePattern.N.form("let").directlyBefore(NodePattern.N.lemma("we")))).message("Don\u2019t separate a verb from its subject by a comma before '$_'");
    }

    private static NodePattern inSimpleCoordination() {
        NodePattern withComplexCompound = NodePattern.N.withDependent("compound", NodePattern.N.withDependent("advmod|punct|conj"));
        NodePattern misparsedIndependentConj = NodePattern.N.andOr(NodePattern.not(CommonPatterns.capitalizedMiddle).potentialPos("VBZ").withDependent("compound", NodePattern.or(NodePattern.N.pos("NNP"), CommonPatterns.capitalizedMiddle.noPos())), NodePattern.N.withDependent("nmod|obj", NodePattern.N.withDependent("det")), NodePattern.N.pos("NNP").withDependent("case|flat", NodePattern.N.afterHead()), NodePattern.N.withDependent("advmod", NodePattern.N.form("otherwise")));
        NodePattern frontedAmodNoun = NodePattern.N.pos("JJ").withHead("conj", NodePattern.N.onlyPos("NN.*").withDependent("amod", NodePattern.N.pos("JJ")));
        NodePattern predicateCoordination = NodePattern.N.pos("NN.*|JJ").andOr(NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.pos(".*")), NodePattern.N.withDependent("advmod", NodePattern.or(NodePattern.N.form("maybe"), Semantics.frequencyAdverb)), NodePattern.N.noPos("NN.*").noDependents("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").withHead(NodePattern.N.pos("JJ"))).withHead("conj", NodePattern.N.anyPos().noHeadRelation("advcl|acl(:relcl)?").and(CommonPatterns.skipUp("xcomp", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")))).andNot(NodePattern.N.potentialPos("VBG").withDependent("case"));
        NodePattern withComplexDependentsBeforeConj = NodePattern.N.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|conj", NodePattern.N.afterHead().before("Conj"));
        NodePattern headClause = EnglishTreePatterns.clause.and(CommonPatterns.possiblySkipUp("[xc]comp|advcl", NodePattern.N.withHeadRelation("root|parataxis").andNot(EnglishTreePatterns.imperativeVB)));
        NodePattern nominalCoordination = NodePattern.N.pos("NN.*|JJ").noPos("RP").noPotentialPos("VBN").noDependents("amod", NodePattern.N.onlyPos("VBP?")).noDependents("cop|aux|aux:pass").withHead("conj", NodePattern.N.anyPos().noDependents("aux:pass").andOr(NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod", NodePattern.N.andOr(CommonPatterns.skipUp("obj", headClause), headClause).andNot(CommonPatterns.severalDependents("obl")).noDependents("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|conj", NodePattern.N.after("Conj"))).noDependents("flat").andNot(CommonPatterns.phraseStartsWithComma).andNot(CommonPatterns.possiblySkipDown("amod|nmod", withComplexDependentsBeforeConj)), NodePattern.ROOT.withDependent("case").withDependent("cop"))).andNot(Semantics.uomPattern).andNot(CommonPatterns.possiblyConj(withComplexCompound)).andNot(frontedAmodNoun).andNot(misparsedIndependentConj);
        NodePattern causalAdverbs = NodePattern.N.form("thus|therefore");
        NodePattern allowedBeforeBut = NodePattern.or(NodePattern.N.inFormSequence(0, "but", "not|also"), NodePattern.N.form("but").withHead("cc", NodePattern.N.withHead("conj", NodePattern.N.withDependent("cc:preconj", NodePattern.N.inFormSequence(1, "not", "just|only")))));
        return NodePattern.N.markAs("Cc").withHead("cc", NodePattern.N.markAs("Conj").andOr(predicateCoordination.trace("comma before cc, predicate coordination"), nominalCoordination.trace("comma before cc, nominal coordination")).noDependents("advmod", NodePattern.or(causalAdverbs, NodePattern.N.form("nor"))).noDependents("punct", NodePattern.not(CommonPatterns.noSpaceHyphen).between("Cc", "Conj")).and((conj, match) -> PunctuationRules.wordsBetween(Objects.requireNonNull(conj.head()), conj) < 10L ? match : null).andNot(NodePattern.or(NodePattern.N.directlyAfter(CommonPatterns.comma), CommonPatterns.phraseEndsWithComma)).andNot(CommonPatterns.skipConjUp(NodePattern.or(withComplexDependentsBeforeConj, CommonPatterns.severalDependents("nmod|conj")))).andNot(CommonPatterns.possiblyConj(NodePattern.or(EnglishTreePatterns.abbreviation, CommonPatterns.severalDependents("conj")))).andNot(CommonPatterns.possiblySkipDown("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|nummod", NodePattern.or(NodePattern.N.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"), CommonPatterns.severalDependents("conj")))).andNot(NodePattern.N.inPhrase(NodePattern.ROOT.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.after("Conj"))))).andNot(allowedBeforeBut).message("In simple coordination, a comma before '$Cc' is usually unnecessary");
    }

    private static NodePattern beforeConj() {
        return NodePattern.N.directlyBefore(Commas.basicCoordinatingConjunction.reportRangeTo("Comma", ReportingKind.Hover).andOr(ExcessiveComma.betweenSubjAndVerb(), ExcessiveComma.inSimpleCoordination()));
    }

    private static NodePattern afterSubj() {
        NodePattern subjAsClause = NodePattern.N.withDependent("det", NodePattern.N.form("no")).withHead(EnglishTreePatterns.negated);
        NodePattern withNumberInParentheses = NodePattern.N.withDependent("appos|nmod:tmod", CommonPatterns.withNumberLikeForm.and(CommonPatterns.parenthesizedPhrase));
        NodePattern vocativeImperative = NodePattern.N.form("be").withHead(NodePattern.ROOT);
        return NodePattern.N.directlyBefore(NodePattern.N.includeIntoReport().andOr(NodePattern.N.withHead("cop|aux|aux:pass", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.before("Comma").markAs("Subject").andNot(CommonPatterns.letterWord.noPos()).andNot(CommonPatterns.possiblySkipDown("nmod", NodePattern.N.withDependent("acl").and(CommonPatterns.possiblySkipDown("acl", NodePattern.N.withDependent("punct", CommonPatterns.comma.before("Comma")))))))).andNot(vocativeImperative), NodePattern.ROOT.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", CommonPatterns.possiblySkipDown("conj", withNumberInParentheses.before("Comma").markAs("Subject")))).andOptionally(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.N.lemma("not").includeIntoReport()))).directlyAfter(NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Subject").andNot(subjAsClause).andNot(NodePattern.N.withHead(EnglishTreePatterns.severalSubjects)).andNot(NodePattern.not(RelativeClauses.requiresRestrictiveRel()).withDependent("acl:relcl")))).message("Don\u2019t separate subject and predicate with a comma");
    }

    private static NodePattern beforeThat() {
        return NodePattern.N.directlyBefore(NodePattern.N.form("that").withHead("mark", NodePattern.N.withHeadRelation("ccomp|acl")).reportRangeTo("Comma", ReportingKind.Hover)).message(COMMA_THAT_MSG);
    }

    private static NodePattern beforeEtAl() {
        return NodePattern.N.directlyBefore(CommonPatterns.etAl.directlyBefore(NodePattern.N.reportRangeTo("Comma", ReportingKind.Hover))).message(COMMA_ET_AL_MSG);
    }

    private static NodePattern beforeYear() {
        NodePattern betweenMonthAndYear = NodePattern.N.directlyBefore(EnglishDateChecker.year.markAs("Year")).directlyAfter(NodePattern.N.form(StreamEx.of((Collection)EnglishDateChecker.INSTANCE.monthNames).joining((CharSequence)"|")).noDependents("nummod", NodePattern.N.after("Year")).andNot(NodePattern.N.withHead("nmod", NodePattern.N.form("\\d+(st|nd|rd|th)")))).andNot(NodePattern.N.withHead(NodePattern.N.label("PERSON"))).andNot(CommonPatterns.inParentheses).message("Do not put a comma between the month and the year");
        NodePattern beforeYearInParentheses = NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "\\(", "[123][0-9]{3}", "\\)")).andNot(NodePattern.N.directlyAfter(CommonPatterns.upperCase)).message("Do not use comma before year in parentheses");
        return NodePattern.or(betweenMonthAndYear, beforeYearInParentheses);
    }

    private static NodePattern inCorrelativeConjunction() {
        NodePattern noComplexDependentsAfter = NodePattern.N.noDependents("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.afterHead());
        NodePattern notOnlyButAlso = NodePattern.N.inFormSequence(0, "but", "also").withHead("cc", NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl").withHead("conj", NodePattern.N.withDependent("cc:preconj", NodePattern.N.inFormSequence(1, "not", "only").reportEverythingTouched(ReportingKind.Hover)).andOr(NodePattern.N.withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", noComplexDependentsAfter).and(noComplexDependentsAfter), NodePattern.ROOT).andNot(CommonPatterns.severalDependents("conj"))).and(noComplexDependentsAfter).and((node, match) -> match.getMarkedNode("Comma").nextUntil(node.phraseEnd()).count() < 7L ? match : null)).message(COMMA_NOT_ONLY_BUT_ALSO_MSG);
        NodePattern eitherWhetherOr = NodePattern.N.form("n?or").markAs("SecondCc").withHead("cc", NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl").markAs("CcHead").withHead("conj", NodePattern.or(CommonPatterns.possiblySkipDown("nsubj", NodePattern.N.withDependent("cc:preconj|det", NodePattern.N.form("n?either").markAs("FirstCc"))), NodePattern.N.inPhrase(NodePattern.N.withHeadRelation("ccomp").withDependent("mark", NodePattern.N.form("whether").markAs("FirstCc")).noDependents("conj", NodePattern.N.after("CcHead")))).noDependents("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.before("Comma")).andNot(CommonPatterns.severalDependents("conj")).andNot(NodePattern.N.withDependent("punct", CommonPatterns.comma.between("FirstCc", "Comma"))))).andOr(NodePattern.N.form("or").and(NodePattern.markedNodeMatches("FirstCc", NodePattern.N.form("whether|either").includeIntoReport(ReportingKind.Hover))), NodePattern.N.form("nor").and(NodePattern.markedNodeMatches("FirstCc", NodePattern.N.form("neither").includeIntoReport(ReportingKind.Hover)))).includeIntoReport(ReportingKind.Hover).message("'$FirstCc... $SecondCc...' phrases usually don\u2019t need a comma");
        return NodePattern.N.directlyBefore(NodePattern.or(notOnlyButAlso, eitherWhetherOr));
    }

    private static NodePattern aroundParticipialClause() {
        return NodePattern.N.pos("VBG").markAs("Acl").directlyAfter(CommonPatterns.comma.markAs("Comma")).withHead("acl", NodePattern.N.pos("NNS?").markAs("Noun").andNot(RelativeClauses.possiblyHeadOfNonRestrictiveClause).and(CommonPatterns.possiblySkipDown("nmod", NodePattern.N.directlyBefore("Comma")))).andOr(NodePattern.markedNodeMatches("Noun", NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.or(NodePattern.N.withDependent("cop", NodePattern.N.after("Comma")), NodePattern.N.withDependent("aux", NodePattern.N.pos("MD").noLemma("will").after("Comma")))).noDependents("conj")), NodePattern.N.inPhrase(NodePattern.ROOT.andOr(EnglishTreePatterns.imperativeVB.and(NodePattern.markedNodeMatches("Acl", SemCompatibility.needsInanimateSubject)), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", SemCompatibility.Unlikely.between(SemCompatibility.Relation.Subject, NodePointer.marked("Acl"), NodePointer.anchor()))))).andNot(SemCompatibility.Unlikely.between(SemCompatibility.Relation.Subject, NodePointer.anchor(), NodePointer.marked("Noun"))).message("If introducing essential information about '$Noun', remove surrounding commas");
    }
}

