/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommaLicense;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.common.FormattingIssues;
import ai.grazie.rules.common.PairedPunctuation;
import ai.grazie.rules.common.PhraseCommaChange;
import ai.grazie.rules.common.Valence;
import ai.grazie.rules.common.ZeroWidthSpaceRule;
import ai.grazie.rules.ru.AgreementSet;
import ai.grazie.rules.ru.Case;
import ai.grazie.rules.ru.ComplexConjunctions;
import ai.grazie.rules.ru.GrammarRules;
import ai.grazie.rules.ru.IntroductoryConstructions;
import ai.grazie.rules.ru.ParticleSeparation;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.ru.RussianValences;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.TreeCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PunctuationRules {
    private static final TreeCache<List<CommaLicense>> licenseCache = new TreeCache<List>("licenses", tree -> StreamEx.of(tree.nodes()).toFlatList(PunctuationRules::licensedCommas));
    private static final Pattern abbrPattern = AbbreviationPatterns.withPunctCaseSensitive((Language)Language.RUSSIAN);
    static final NodePattern sentenceBoundary = NodePattern.N.spaceAfter().directlyBefore(CommonPatterns.capitalized).andOr(CommonPatterns.closingParen.directlyAfter(NodePattern.N.form("[.!?]").noSpaceAfter()), CommonPatterns.arrow, NodePattern.N.form(".*\\."));
    static final NodePattern commaOrOpening = NodePattern.or(RussianTreePatterns.commaOrStronger.andNot(FormattingIssues.abbrOrNameDot(abbrPattern).spaceAfter().directlyBefore(CommonPatterns.lowerCase)), RussianTreePatterns.openingQuotations, NodePattern.N.form("[(<\\[]"), RussianTreePatterns.dashes, sentenceBoundary);
    static final NodePattern commaOrClosing = NodePattern.or(RussianTreePatterns.commaOrStronger, RussianTreePatterns.closingQuotations, NodePattern.N.form("[)>\\]]"), sentenceBoundary);
    private static final String prichem = "\u043f\u0440\u0438\u0447[\u0435\u0451]\u043c";
    private static final NodePattern odnakoStart = CommonPatterns.firstChildPhrase.andNot(NodePattern.N.inPhrase(NodePattern.N.withDependent("punct", NodePattern.N.form("!")))).andNot(NodePattern.N.directlyBefore(CommonPatterns.comma.directlyBefore(NodePattern.N.withHeadRelation("parataxis"))));
    private static final NodePattern startAdjoiningConjunction = NodePattern.N.form("\u0438|\u0430|\u043d\u043e").and(CommonPatterns.firstPhrase);
    private static final NodePattern fixedDptPhrase = NodePattern.or(NodePattern.N.inFormSequence(0, "\u0440\u0430\u0441\u043a\u0440\u044b\u0432", "\u0440\u043e\u0442"), NodePattern.N.inFormSequence(0, "\u043e\u0447\u0435\u0440\u0442\u044f|\u0441\u043b\u043e\u043c\u044f", "\u0433\u043e\u043b\u043e\u0432\u0443"), NodePattern.N.inFormSequence(0, "\u0441\u043a\u0440\u0435\u043f\u044f", "\u0441\u0435\u0440\u0434\u0446\u0435"), NodePattern.N.inFormSequence(0, "\u0437\u0430\u0441\u0443\u0447\u0438\u0432", "\u0440\u0443\u043a\u0430\u0432\u0430"), NodePattern.N.inFormSequence(0, "\u0441\u043f\u0443\u0441\u0442\u044f", "\u0440\u0443\u043a\u0430\u0432\u0430"), NodePattern.N.inFormSequence(0, "\u0441\u043b\u043e\u0436\u0430", "\u0440\u0443\u043a\u0438"), NodePattern.N.inFormSequence(0, "\u0437\u0430\u0442\u0430\u0438\u0432", "\u0434\u044b\u0445\u0430\u043d\u0438\u0435"), NodePattern.N.inFormSequence(0, "\u043f\u043e\u0432\u0435\u0441\u0438\u0432", "\u043d\u043e\u0441"), NodePattern.N.inFormSequence(0, "\u0432\u044b\u0441\u0443\u043d\u0443\u0432", "\u044f\u0437\u044b\u043a"), NodePattern.N.inFormSequence(0, "\u0440\u0430\u0437\u0432\u0435\u0441\u0438\u0432", "\u0443\u0448\u0438"), NodePattern.N.inFormSequence(1, "\u043d\u0435", "\u0440\u0430\u0437\u0433\u0438\u0431\u0430\u044f", "\u0441\u043f\u0438\u043d\u044b"), NodePattern.N.inFormSequence(1, "\u043d\u0435", "\u043c\u043e\u0440\u0433\u043d\u0443\u0432", "\u0433\u043b\u0430\u0437\u043e\u043c"), NodePattern.N.inFormSequence(1, "\u043d\u0435", "\u0441\u043c\u044b\u043a\u0430\u044f", "\u0433\u043b\u0430\u0437"), NodePattern.N.inFormSequence(1, "\u043d\u0435", "\u043f\u043e\u043a\u043b\u0430\u0434\u0430\u044f", "\u0440\u0443\u043a"), NodePattern.N.inFormSequence(0, "\u043f\u043e\u043b\u043e\u0436\u0430", "\u0440\u0443\u043a\u0443", "\u043d\u0430", "\u0441\u0435\u0440\u0434\u0446\u0435"));
    private static final NodePattern noCommaDptPhrase = NodePattern.or(NodePattern.N.inFormSequence(0, "\u0445\u043e\u0442\u044f", "\u0431\u044b"), fixedDptPhrase);
    static final NodePattern unmandatedComma = CommonPatterns.comma.and(node -> {
        List<CommaLicense> licenses = node.tree().getCached(licenseCache);
        return licenses.stream().noneMatch(c -> c.allows((Node)node));
    });
    private static final NodePattern allowedBeforeConj = NodePattern.N.form("\u043e\u043f\u0430");
    private static final NodePattern bareWh = NodePattern.or(RussianTreePatterns.whWord, NodePattern.N.form("\u043a\u0430\u043a")).markAs("Wh");
    private static final NodePattern kakPopalo = NodePattern.N.form("\u043f\u043e\u043f\u0430\u043b\u043e|\u0443\u0433\u043e\u0434\u043d\u043e").markAs("Head").directlyAfter(bareWh);
    private static final NodePattern whatsNeeded = NodePattern.N.form("\u043d\u0443\u0436\u043d\u043e").includeIntoReport().noDependents(NodePattern.N.afterHead()).directlyAfter(bareWh.includeIntoReport().directlyAfter(CommonPatterns.comma.directlyAfter(NodePattern.N.pos("VB:.*:TRANS.*"))));
    private static final NodePattern whatWillBeVerb1 = NodePattern.or(NodePattern.N.pos("VB:(IMP|INF):TRANS.*"), NodePattern.N.lemma("\u0431\u044b\u0442\u044c"));
    private static final NodePattern whatWillBeVerb2 = NodePattern.N.inFormSequence(1, "\u0447\u0442\u043e", "\u0431\u0443\u0434\u0435\u0442|\u0434\u043e\u043b\u0436\u0435\u043d|\u0434\u0430\u044e\u0442|\u0445\u043e\u0447\u0435\u0448\u044c|\u043d\u0440\u0430\u0432\u0438\u0442\u0441\u044f|\u0432\u0437\u0434\u0443\u043c\u0430\u0435\u0442\u0441\u044f|\u043d\u0443\u0436\u043d\u043e|\u043d\u0430\u0434\u043e").noDependents("nsubj.*|csubj.*", NodePattern.N.afterHead());
    private static final NodePattern whatWillBe = whatWillBeVerb2.withNeighbor(-2, CommonPatterns.comma).withNeighbor(-3, whatWillBeVerb1);
    private static final NodePattern misparsedDetPtNoun = NodePattern.N.afterHead().pos("PT:.*").markAs("PT").withHead("conj", NodePattern.N.withHead("det", NodePattern.N.pos("NN.*").after("PT")));
    private static final NodePattern ptPhraseNeedingNoCommas = NodePattern.or(NodePattern.N.beforeHead().withHeadRelation("amod|acl").withPrevSibling(NodePattern.N.withHeadRelation("det")), misparsedDetPtNoun);
    private static final String DOUBLE_PUNCTUATION = "\u041b\u0438\u0448\u043d\u0438\u0439 \u0437\u043d\u0430\u043a \u043f\u0440\u0435\u043f\u0438\u043d\u0430\u043d\u0438\u044f?";
    private static final String FIX_SPACES = "\u0418\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u043e\u0431\u0435\u043b\u044b?";
    private static final String EXTRA_HYPHEN = "\u041b\u0438\u0448\u043d\u0438\u0439 \u0434\u0435\u0444\u0438\u0441?";
    private static final NodePattern misparsedAdverbWh = NodePattern.N.withHead("acl:relcl", NodePattern.N.form("\u043c\u0430\u043b\u043e|\u043c\u043d\u043e\u0433\u043e").noHeadRelation("nsubj")).and(cl -> {
        Node wh = RussianTreePatterns.findWh(cl);
        return wh != null && wh.hasForm("\u043a\u0442\u043e|\u0447\u0442\u043e|\u0433\u0434\u0435|\u043a\u0443\u0434\u0430|\u0437\u0430\u0447\u0435\u043c");
    });
    private static final String BEFORE_SUBORDINATE_MSG = "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u043f\u0440\u0438\u0434\u0430\u0442\u043e\u0447\u043d\u044b\u043c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u043c?";
    private static final String AFTER_SUBORDINATE_MSG = "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u043f\u0440\u0438\u0434\u0430\u0442\u043e\u0447\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f?";
    private static final String AROUND_SUBORDINATE_MSG = "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u044b \u0437\u0430\u043f\u044f\u0442\u044b\u0435 \u0432\u043e\u043a\u0440\u0443\u0433 \u043f\u0440\u0438\u0434\u0430\u0442\u043e\u0447\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f?";
    private static final NodePattern comparativeSubordinateClause = NodePattern.N.withHead("advcl", NodePattern.N.withDependent("mark", NodePattern.N.form("\u0447\u0435\u043c"))).withDependent("mark", NodePattern.N.form("\u0442\u0435\u043c"));
    private static final NodePattern andOr = NodePattern.N.form("\u0438|\u0438\u043b\u0438");
    private static final NodePattern withSameCcAsFirst = NodePattern.N.after("Phrase2").withDependent("cc", NodePattern.N.sameWordAs("FirstConj").directlyAfter(CommonPatterns.comma));
    private static final NodePattern hasSameCaseAsHead = NodePattern.custom(n -> PunctuationRules.casesOn(n).stream().anyMatch(PunctuationRules.casesOn(n.head())::contains));
    private static final NodePattern nestedCoordinatedPhrase = NodePattern.N.markAs("Phrase2").withDependent("cc", andOr.markAs("FirstConj").beforeHead()).withHead("conj", NodePattern.N.withHeadRelation("ccomp|xcomp|obl|csubj|obj|acl|nmod").markAs("Phrase1").withPhraseStart(NodePattern.not(andOr)).noDependents("cc", andOr).andNot(NodePattern.N.withHead("nmod", NodePattern.N.withDependent("cc", andOr)).noDependents("conj", NodePattern.not(NodePattern.N.alreadyMarkedAs("Phrase2")))).noDependents("conj", NodePattern.N.before("Phrase2").withDependent("cc")).noDependents("advmod", NodePattern.N.afterHead().before("Phrase2").withDependent("nsubj").and(RussianTreePatterns.whPhrase).trace("misparsed wh-clause")).noDependents("appos", NodePattern.N.before("FirstConj")).noDependents("conj", withSameCcAsFirst).andNot(NodePattern.N.sameWordAs("Phrase2").withOnlyDependents(NodePattern.N.withHeadRelation("conj").andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("conj")))))).noDependents("conj", withSameCcAsFirst).andOr(RussianTreePatterns.infinitive.withHead(RussianTreePatterns.infinitive), NodePattern.N.withDependent("case").withHead(NodePattern.N.withDependent("case")), NodePattern.N.pos("NN.*").noDependents("case").and(hasSameCaseAsHead).withHead(NodePattern.N.pos("NN.*")).andNot(NodePattern.N.withDependent("cc").and(NodePattern.markedNodeMatches("Phrase1", NodePattern.N.withDependent("cc")))), NodePattern.N.pos("PT.*"), RussianTreePatterns.clause.withDependent("nsubj.*").withHead(NodePattern.N.withDependent("nsubj.*").andNot(NodePattern.N.inPhrase(NodePattern.N.pos("ADV|ADJ.*")))).noDependents("cc")).andOr(NodePattern.N.withDependent(".*", RussianTreePatterns.whWord.markAs("Wh2")).withHead(NodePattern.N.withDependent(".*", NodePattern.custom((n, match) -> n.lowForm().equals(match.getMarkedNode("Wh2").lowForm()) ? match : null))), NodePattern.N.noDependents(RussianTreePatterns.whWord));
    private static final NodePattern withKakMark = NodePattern.N.withDependent("case|mark|cc", NodePattern.N.form("\u043a\u0430\u043a").beforeHead().markAs("Kak"));
    private static final NodePattern withTakLike = NodePattern.N.withDependent("det|advmod", NodePattern.N.lemma("\u0442\u043e\u0442|\u0442\u0430\u043a|\u0442\u0430\u043a\u043e\u0439"));
    private static final NodePattern qualityKak = withKakMark.afterHead().pos("NN.*").and(Case.V.posPattern).withHead("obl|advcl", NodePattern.N.pos("VB.*").andNot(withTakLike).withDependent("obj", NodePattern.not(withTakLike))).noDependents("advmod|cc", NodePattern.N.form("\u0438")).noDependents("nsubj");
    private static final NodePattern kakTakI = withKakMark.afterHead().pos("NN.*").withHead("obl|advcl", NodePattern.N.pos("VB.*")).withDependent("conj", NodePattern.N.withDependent("cc", NodePattern.N.inFormSequence(0, "\u0442\u0430\u043a", "\u0438")));
    private static final String SUBJ_PRED_COMMA_MSG = "\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043c\u0435\u0436\u0434\u0443 \u043f\u043e\u0434\u043b\u0435\u0436\u0430\u0449\u0438\u043c \u0438 \u0441\u043a\u0430\u0437\u0443\u0435\u043c\u044b\u043c \u043d\u0435 \u043d\u0443\u0436\u043d\u0430";
    private static final String SUBJ_KAK_PRED_MSG = "\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043c\u0435\u0436\u0434\u0443 \u043f\u043e\u0434\u043b\u0435\u0436\u0430\u0449\u0438\u043c \u0438 \u0441\u043a\u0430\u0437\u0443\u0435\u043c\u044b\u043c \u043d\u0435 \u043d\u0443\u0436\u043d\u0430; \u0434\u043b\u044f \u0430\u043a\u0446\u0435\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u043a\u0430\u0437\u0443\u0435\u043c\u043e\u0433\u043e \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u0438\u0440\u0435";
    private static final String KAK_QUALITY_MSG = "\u041e\u0431\u043e\u0440\u043e\u0442\u044b \u0441 \u0441\u043e\u044e\u0437\u043e\u043c \u00ab\u043a\u0430\u043a\u00bb \u0432 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0438 \u00ab\u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u00bb \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u044e\u0442\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438";
    private static final NodePattern modifiedKak = NodePattern.N.form("\u043a\u0430\u043a").withNeighbor(-1, CommonPatterns.comma).andOr(NodePattern.N.withNeighbor(-2, NodePattern.N.markAs("Prev").form("\u043d\u0435|\u0441\u043e\u0432\u0441\u0435\u043c|\u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u043e|\u043f\u043e\u0447\u0442\u0438|\u0432\u0440\u043e\u0434\u0435|\u0438\u043c\u0435\u043d\u043d\u043e|\u043f\u0440\u043e\u0441\u0442\u043e").withHeadRelation("advmod")), NodePattern.N.withNeighbor(-6, NodePattern.N.inFormSequence(0, "\u0442\u043e\u0447\u044c", "-", "\u0432", "-", "\u0442\u043e\u0447\u044c").markAs("Prev")));
    private static final NodePattern kakIdiom = NodePattern.N.andOr(NodePattern.N.withHead(NodePattern.N.lemma("\u0434\u0440\u043e\u0436\u0430\u0442\u044c")).inFormSequence(2, "\u043a\u0430\u043a", "\u043e\u0441\u0438\u043d\u043e\u0432\u044b\u0439", "\u043b\u0438\u0441\u0442"), NodePattern.N.withHead(NodePattern.N.lemma("\u0441\u0435\u0434\u043e\u0439")).inFormSequence(1, "\u043a\u0430\u043a", "\u043b\u0443\u043d\u044c"), NodePattern.N.withHead(NodePattern.N.lemma("\u0443\u043f\u0430\u0441\u0442\u044c")).inFormSequence(1, "\u043a\u0430\u043a", "\u043f\u043e\u0434\u043a\u043e\u0448\u0435\u043d\u043d\u044b\u0439"), NodePattern.N.withHead(NodePattern.N.lemma("\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u0441\u044f")).inFormSequence(1, "\u043a\u0430\u043a", "\u0432\u043a\u043e\u043f\u0430\u043d\u043d\u044b\u0439"), NodePattern.N.withHead(NodePattern.N.lemma("\u0433\u043e\u043b\u043e\u0434\u043d\u044b\u0439")).inFormSequence(1, "\u043a\u0430\u043a", "\u0432\u043e\u043b\u043a"), NodePattern.N.withHead(NodePattern.N.lemma("\u0443\u043f\u0440\u044f\u043c\u044b\u0439")).inFormSequence(1, "\u043a\u0430\u043a", "\u043e\u0441[\u0435\u0451]\u043b"), NodePattern.N.withHead(NodePattern.N.lemma("\u0433\u043e\u043b")).inFormSequence(1, "\u043a\u0430\u043a", "\u0441\u043e\u043a\u043e\u043b"), NodePattern.N.withHead(NodePattern.N.lemma("\u0440\u0430\u0437\u0432\u0435\u044f\u0442\u044c\u0441\u044f|\u0440\u0430\u0441\u0441\u0435\u044f\u0442\u044c\u0441\u044f")).inFormSequence(1, "\u043a\u0430\u043a", "\u0434\u044b\u043c"), NodePattern.N.withHead(NodePattern.N.lemma("\u043d\u0443\u0436\u043d\u044b\u0439")).inFormSequence(1, "\u043a\u0430\u043a", "\u0432\u043e\u0437\u0434\u0443\u0445"), NodePattern.N.withHead(NodePattern.N.lemma("\u043b\u0435\u0442\u0435\u0442\u044c")).inFormSequence(1, "\u043a\u0430\u043a", "\u0441\u0442\u0440\u0435\u043b\u0430"), NodePattern.N.withHead(NodePattern.N.lemma("\u043a\u0440\u0430\u0441\u043d\u044b\u0439|\u043f\u043e\u043a\u0440\u0430\u0441\u043d\u0435\u0442\u044c")).inFormSequence(1, "\u043a\u0430\u043a", "\u0440\u0430\u043a"), NodePattern.N.withHead(NodePattern.N.lemma("\u043f\u043e\u0431\u043b\u0435\u0434\u043d\u0435\u0442\u044c")).inFormSequence(1, "\u043a\u0430\u043a", "\u043f\u043e\u043b\u043e\u0442\u043d\u043e"), NodePattern.N.withHead(NodePattern.N.lemma("\u0438\u0434\u0442\u0438")).inFormSequence(2, "\u043a\u0430\u043a", "\u043d\u0430", "\u043a\u0430\u0437\u043d\u044c"), NodePattern.N.withHead(NodePattern.N.lemma("\u0441\u0438\u0434\u0435\u0442\u044c")).inFormSequence(2, "\u043a\u0430\u043a", "\u043d\u0430", "\u0438\u0433\u043e\u043b\u043a\u0430\u0445"), NodePattern.N.withHead(NodePattern.N.lemma("\u043b\u0438\u0442\u044c")).inFormSequence(2, "\u043a\u0430\u043a", "\u0438\u0437", "\u0432\u0435\u0434\u0440\u0430"), NodePattern.N.withHead(NodePattern.N.lemma("\u0432\u0435\u0440\u0442\u0435\u0442\u044c\u0441\u044f|\u043a\u0440\u0443\u0442\u0438\u0442\u044c\u0441\u044f|\u043a\u0440\u0443\u0436\u0438\u0442\u044c\u0441\u044f")).inFormSequence(1, "\u043a\u0430\u043a", "\u0431\u0435\u043b\u043a\u0430", "\u0432", "\u043a\u043e\u043b\u0435\u0441\u0435"), NodePattern.N.withHead(NodePattern.N.lemma("\u043f\u0440\u0438\u0441\u0442\u0430\u0442\u044c")).inFormSequence(2, "\u043a\u0430\u043a", "\u0441", "\u043d\u043e\u0436\u043e\u043c", "\u043a", "\u0433\u043e\u0440\u043b\u0443"), NodePattern.N.withHead(NodePattern.N.lemma("\u043a\u0430\u0442\u0430\u0442\u044c\u0441\u044f")).inFormSequence(1, "\u043a\u0430\u043a", "\u0441\u044b\u0440", "\u0432", "\u043c\u0430\u0441\u043b\u0435"), NodePattern.N.withHead(NodePattern.N.lemma("\u0443\u043f\u0430\u0441\u0442\u044c")).inFormSequence(1, "\u043a\u0430\u043a", "\u0441\u043d\u0435\u0433", "\u043d\u0430", "\u0433\u043e\u043b\u043e\u0432\u0443"), NodePattern.N.withHead(NodePattern.N.lemma("\u0443\u0434\u0430\u0440\u0438\u0442\u044c")).inFormSequence(1, "\u043a\u0430\u043a", "\u043e\u0431\u0443\u0445\u043e\u043c", "\u043f\u043e", "\u0433\u043e\u043b\u043e\u0432\u0435"), NodePattern.N.withHead(NodePattern.N.lemma("\u0445\u043e\u0434\u0438\u0442\u044c")).inFormSequence(3, "\u043a\u0430\u043a", "\u0432", "\u0432\u043e\u0434\u0443", "\u043e\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0439"), NodePattern.N.withHead(NodePattern.N.lemma("\u0437\u043d\u0430\u0442\u044c")).inFormSequence(3, "\u043a\u0430\u043a", "\u0441\u0432\u043e\u0438", "\u043f\u044f\u0442\u044c", "\u043f\u0430\u043b\u044c\u0446\u0435\u0432"), NodePattern.N.withHead(NodePattern.N.lemma("\u0431\u043b\u0435\u0441\u0442\u0435\u0442\u044c")).inFormSequence(1, "\u043a\u0430\u043a", "\u0437\u0435\u0440\u043a\u0430\u043b\u043e"));
    static final NodePattern xcompLike = NodePattern.N.pos("VB:INF.*").beforeHead().withHead("csubj.*|xcomp", NodePattern.N.withDependent("nsubj.*", NodePattern.N.afterHead()));
    private static final NodePattern toJest = NodePattern.N.inFormSequence(1, "\u0442\u043e", "\u0435\u0441\u0442\u044c");
    private static final NodePattern conjAmbiguityAtEnd = NodePattern.N.markAs("Head").withNextSibling(NodePattern.N.withHeadRelation("conj").withDependent("cc", NodePattern.N.markAs("CC"))).withPhraseEnd(NodePattern.N.inPhrase(NodePattern.N.between("Head", "CC").withHeadRelation("conj")));
    private static final NodePattern splitComplexConjStart = NodePattern.or((NodePattern[])ComplexConjunctions.allComplexConjunctions().map(words -> NodePattern.N.withNeighbor(((String[])words).length - 1, ComplexConjunctions.withComma(words))).toArray(NodePattern[]::new));
    private static final String HYPHEN_TO_DASH_MSG = "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0442\u0438\u0440\u0435 \u043c\u0435\u0436\u0434\u0443 \u0447\u043b\u0435\u043d\u0430\u043c\u0438 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    private static final String MISSING_COORDINATION_COMMA = "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043c\u0435\u0436\u0434\u0443 \u0447\u0430\u0441\u0442\u044f\u043c\u0438 \u0441\u043b\u043e\u0436\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f?";
    private static final String EXTRA_SUBORDINATE_COORDINATION_COMMA = "\u041b\u0438\u0448\u043d\u044f\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043c\u0435\u0436\u0434\u0443 \u043e\u0434\u043d\u043e\u0440\u043e\u0434\u043d\u044b\u043c\u0438 \u043f\u043e\u0434\u0447\u0438\u043d\u0451\u043d\u043d\u044b\u043c\u0438 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u043c\u0438?";
    private static final String BEFORE_VOCATIVE_COMMA = "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435\u043c?";
    private static final String AFTER_VOCATIVE_COMMA = "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f?";
    private static final String AROUND_VOCATIVE_COMMAS = "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u044b \u0437\u0430\u043f\u044f\u0442\u044b\u0435 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0438?";
    static final String EXCESSIVE_INSIDE_COMPLEX_CONJ_COMMA = "\u041b\u0438\u0448\u043d\u044f\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u0432\u043d\u0443\u0442\u0440\u0438 \u0441\u043b\u043e\u0436\u043d\u043e\u0433\u043e \u0441\u043e\u044e\u0437\u0430?";
    static final String MISSING_COMPLEX_CONJ_COMMA_NEGATION = "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u0432 \u0441\u043b\u043e\u0436\u043d\u043e\u043c \u0441\u043e\u044e\u0437\u0435 \u043f\u043e\u0441\u043b\u0435 \u043e\u0442\u0440\u0438\u0446\u0430\u043d\u0438\u044f?";
    static final String EXCESSIVE_AFTER_COMPLEX_CONJ_COMMA = "\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u0441\u043b\u043e\u0436\u043d\u043e\u0433\u043e \u0441\u043e\u044e\u0437\u0430 \u043d\u0435 \u043d\u0443\u0436\u043d\u0430";
    private static final String HYPHEN_IN_COMPOUND_MESSAGE = "\u0414\u0435\u0444\u0438\u0441 \u0432 \u0441\u043b\u043e\u0436\u043d\u044b\u0445 \u0441\u043b\u043e\u0432\u0430\u0445 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u0435\u0437 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432";
    private static final String DASH_SPACES = "\u0412\u043e\u043a\u0440\u0443\u0433 \u0442\u0438\u0440\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0431\u0435\u043b\u044b";
    private static final String COMMA_BEFORE_DASH = "\u0421\u0442\u0430\u0432\u044c\u0442\u0435 \u0437\u0430\u043f\u044f\u0442\u0443\u044e \u043f\u0435\u0440\u0435\u0434 \u0442\u0438\u0440\u0435";
    private static final NodePattern emphasizingConj = NodePattern.or(NodePattern.N.form("\u0438").withHeadRelation("advmod"), NodePattern.N.form("\u043d\u0438").withHeadRelation("cc"));
    private static final NodePattern compHyphen = NodePattern.N.markAs("Dash").andOr(NodePattern.N.inFormSequence(1, "\u0438\u0437", ".*", "\u0437\u0430|\u043f\u043e\u0434"), NodePattern.N.directlyAfter(NodePattern.N.withHead("compound", NodePattern.N.directlyAfter("Dash")).noForm("\u043f\u0430\u043f\u0443\u0430")).directlyBefore(NodePattern.N.withHeadRelation("amod|xcomp")), NodePattern.N.directlyAfter(CommonPatterns.withNumberLikeForm).directlyBefore(NodePattern.N.formCaseSensitive("[\u044b\u0438]?\u0439|\u0430?\u044f|\u0435|[\u0435\u0451]?\u0445|\u043c\u044f|\u0443?\u044e|\u0442\u0438|\u043c\u0438|[\u043e\u0435]?\u0433\u043e|[\u0438\u044b]?\u043c|[\u043e\u0435]?\u043c\u0443")), NodePattern.N.directlyAfter(NodePattern.N.lemma("\u043a\u0442\u043e|\u043a\u0430\u043a\u043e\u0439|\u0447\u0442\u043e|\u0433\u0434\u0435|\u043a\u043e\u0433\u0434\u0430|\u043a\u043e\u0439|\u0447\u0435\u0439|\u0441\u043a\u043e\u043b\u044c\u043a\u043e|(\u043e\u0442)?\u043a\u0443\u0434\u0430")).directlyBefore(NodePattern.N.form("\u0442\u043e|\u043b\u0438\u0431\u043e|\u043d\u0438\u0431\u0443\u0434\u044c|\u043a\u0442\u043e|\u043a\u0430\u043a\u043e\u0439|\u0447\u0442\u043e|\u0433\u0434\u0435|\u043a\u043e\u0433\u0434\u0430|\u0447\u0435\u0439|\u0441\u043a\u043e\u043b\u044c\u043a\u043e")));
    private static final String RANGE_MSG = "\u041c\u0435\u0436\u0434\u0443 \u0446\u0438\u0444\u0440\u0430\u043c\u0438 \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0442\u0438\u0440\u0435 \u0431\u0435\u0437 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432";
    private static final NodePattern numberOrCount = NodePattern.N.form("\\d+.*").andNot(NodePattern.N.form("(.*[=x\u00d7].*|1\u0421)"));
    private static final NodePattern notRangeHead = NodePattern.or(NodePattern.N.lemma("ISO|\u0441\u0430\u043c\u043e\u043b[\u0435\u0451]\u0442|\u0431\u043e\u0440\u0442|Boeing|Airbus|Bombardier|\u0441\u0435\u0441\u0441\u0438\u044f|\u0437\u0432\u043e\u043d\u043e\u043a|\u0437\u0430\u043a\u043e\u043d|\u0437\u0430\u043a\u043e\u043d\u043e\u043f\u0440\u043e\u0435\u043a\u0442|\u0441\u0442\u0430\u0442\u044c\u044f"), NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION|ORGANIZATION|NICKNAME|EVENT"), NodePattern.N.withHeadRelation("flat.*"), CommonPatterns.capitalizedMiddle);
    private static final NodePattern seemsMinus = NodePattern.or(CommonPatterns.afterSkipping(CommonPatterns.closingParen, CommonPatterns.afterSkipping(CommonPatterns.openingParen, CommonPatterns.arithmetics)), CommonPatterns.beforeSkipping(CommonPatterns.openingParen, CommonPatterns.beforeSkipping(CommonPatterns.closingParen, CommonPatterns.arithmetics)));
    private static final NodePattern ulitsaDom = NodePattern.N.form("\u043f\u0440.?|\u0443\u043b.?|\u043f\u0435\u0440.?|\u0434.?");
    private static final NodePattern postalHyphen = CommonPatterns.HYPHEN_NODE.andOr(NodePattern.N.directlyAfter(NodePattern.N.andOr(NodePattern.N.withHead("appos|list", NodePattern.or(NodePattern.ROOT, ulitsaDom, RussianTreePatterns.foreignWord)), NodePattern.N.withPrevSibling(NodePattern.or(ulitsaDom, RussianTreePatterns.foreignWord)), NodePattern.N.withHeadRelation("appos").directlyAfter(NodePattern.N.withHeadRelation("appos")))), NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.withHeadRelation("appos"), NodePattern.N.directlyBefore(CommonPatterns.latin.and(CommonPatterns.capitalizedMiddle)))));
    private static final NodePattern pageOrArticle = NodePattern.N.withHead(NodePattern.N.form("\u0441\u0442?\u0440?\\.?"));
    private static final NodePattern separatesRange = NodePattern.not(postalHyphen).andNot(seemsMinus).andOr(NodePattern.N.directlyBefore(numberOrCount.andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE)).noHeadRelation("flat:title").andNot(NodePattern.N.inFormSequence(0, "\\d\\d?", ",", "\\d+", "(KO|\u041a\u041e)"))).directlyAfter(numberOrCount.noHeadRelation("nsubj").andNot(CommonPatterns.skipUp("conj", NodePattern.N.withHead("nummod|compound|flat:title|list", notRangeHead))).andNot(NodePattern.N.directlyAfter(notRangeHead)).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE.noSpaceAfter())).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("[)(]"))).andNot(pageOrArticle.andNot(CommonPatterns.ascendingRange))), NodePattern.N.directlyBefore(CommonPatterns.romanNumeral).directlyAfter(CommonPatterns.romanNumeral));
    private static final NodePattern toDashInRange = CommonPatterns.reportWithNext.directlyAfter(NodePattern.N.includeIntoReport()).and((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, "\u2013"))).message("\u041c\u0435\u0436\u0434\u0443 \u0446\u0438\u0444\u0440\u0430\u043c\u0438 \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0442\u0438\u0440\u0435 \u0431\u0435\u0437 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432");
    private static final NodePattern withHowMark = NodePattern.N.withDependent("mark", NodePattern.N.form("\u043a\u0430\u043a"));
    private static final NodePattern uomLike = NodePattern.N.form("\\p{L}{1,3}");
    static final NodePattern removeSurroundingCommas = NodePattern.custom((node, match) -> PunctuationRules.removeCommas(match, PunctuationRules.surroundingPhraseStart(node), node.phraseEnd()));
    private static final NodePattern clarifyingPhrase = NodePattern.or(NodePattern.N.withHeadRelation("obl").andNot(withKakMark).withPrevSibling(NodePattern.N.withHeadRelation("obl")).withPhraseEnd(CommonPatterns.comma).andOr(NodePattern.N.beforeHead().withPrevSibling(NodePattern.N.beforeHead()), NodePattern.N.afterHead().withPrevSibling(NodePattern.N.afterHead())), NodePattern.N.afterHead().withHead("obl", NodePattern.N.withDependent("advmod")).and(CommonPatterns.phraseStartsWithComma).andNot(withKakMark).noDependents(NodePattern.or(andOr, NodePattern.N.form("\u0442\u0430\u043a\u0436\u0435"))), NodePattern.N.afterHead().withHeadRelation("advmod").withDependent("obl"), NodePattern.N.afterHead().withHeadRelation("parataxis").withDependent("mark", NodePattern.N.inFormSequence(0, "\u0442\u043e", "\u0435\u0441\u0442\u044c")));
    private static final NodePattern licenseCommasAround = NodePattern.or(NodePattern.N.pos("DPT:.*").andNot(noCommaDptPhrase), NodePattern.N.withDependent("cop", NodePattern.N.pos("DPT:.*")), clarifyingPhrase, NodePattern.N.withDependent("case", NodePattern.N.form("\u043d\u0435\u0441\u043c\u043e\u0442\u0440\u044f|\u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e|\u0432\u043e\u043f\u0440\u0435\u043a\u0438|\u043f\u043e\u043c\u0438\u043c\u043e|\u043a\u0440\u043e\u043c\u0435|\u043f\u043e\u0434\u043e\u0431\u043d\u043e")), NodePattern.N.withDependent("cc", NodePattern.N.form("\u043f\u0440\u0438\u0447[\u0435\u0451]\u043c")), NodePattern.N.withHeadRelation("advmod").andOr(NodePattern.N.withDependent("advmod", NodePattern.N.form("\u0445\u043e\u0442\u044c")), NodePattern.N.withNextSibling(withKakMark.withHeadRelation("obl"))), NodePattern.N.inFormSequence(0, "\u0432\u043a\u0443\u043f\u0435", "\u0441"), NodePattern.N.form("\u0441\u043b\u0443\u0447\u0430(\u0435|\u044f\u0445)").withDependent("case", NodePattern.N.form("\u0432")).withDependent("nmod", Case.R.posPattern).andNot(CommonPatterns.firstPhrase), NodePattern.N.form("\u0441\u0442\u043e\u0440\u043e\u043d\u044b").withDependent("case", NodePattern.N.form("\u0441")).withDependent("amod|nummod", NodePattern.or(NodePattern.N.form("\u043e\u0434\u043d\u043e\u0439|\u0434\u0440\u0443\u0433\u043e\u0439"), NodePattern.N.pos("Ord.*"))), NodePattern.N.withDependent("case", NodePattern.N.form("\u043a\u0440\u043e\u043c\u0435")).withHead("nmod", NodePattern.N.lemma("\u043d\u0438\u043a\u0442\u043e|\u043d\u0438\u0447\u0442\u043e")), NodePattern.N.form("\u0432\u0434\u043e\u0431\u0430\u0432\u043e\u043a").withDependent("obl"), NodePattern.N.form("\u043e\u0434\u043d\u0430\u043a\u043e").andNot(odnakoStart), NodePattern.N.withDependent("parataxis", NodePattern.N.form("\u0432\u0435\u0440\u043d\u0435\u0435")), NodePattern.N.withHeadRelation("parataxis").andOr(RussianTreePatterns.clause, NodePattern.N.pos("PRDC"), NodePattern.N.withDependent("case", NodePattern.N.inFormSequence(0, "\u0432", "\u043e\u0442\u043b\u0438\u0447\u0438\u0435", "\u043e\u0442")), NodePattern.N.withDependent("obl", NodePattern.N.form("\u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e")), NodePattern.N.withDependent("parataxis|advmod", NodePattern.N.form("\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440")), NodePattern.N.lemma("\u0443\u0432\u0435\u0440[\u0438\u044f]\u0442\u044c"), NodePattern.N.form("\u043f\u0440\u0435\u0436\u0434\u0435|\u0440\u0430\u043d\u044c\u0448\u0435").withDependent("mark", NodePattern.N.form("\u043a\u0430\u043a"))), RussianTreePatterns.whPhrase.withHeadRelation("csubj|obl").andNot(qualityKak).andNot(kakIdiom).andNot(kakTakI).noDependents(modifiedKak), NodePattern.N.pos("NN.*").withHead("appos", NodePattern.N.pos("NN.*")).withDependent(".*"), NodePattern.N.pos("ADJ:Posit.*").markAs("Adj").withDependent(".*").withHead("amod", NodePattern.N.before("Adj")), NodePattern.N.withHeadRelation("advcl|acl.*|ccomp|flat:foreign").andNot(whatWillBe).andNot(whatsNeeded).andNot(misparsedAdverbWh).andNot(fixedDptPhrase).andNot(ptPhraseNeedingNoCommas).andNot(qualityKak).andNot(kakIdiom).andNot(kakTakI).andNot(kakPopalo).andNot(comparativeSubordinateClause), NodePattern.N.withHeadRelation("nmod").withDependent("advmod", NodePattern.N.form("\u0434\u0430\u0436\u0435")), NodePattern.N.withHeadRelation("det").lemma("\u0442\u0430\u043a\u043e\u0439").directlyBefore(NodePattern.N.form("\u043a\u0430\u043a")), NodePattern.N.withHeadRelation("conj").andOr(NodePattern.N.withDependent("nmod", NodePattern.N.inFormSequence(2, "\u0432", "\u0442\u043e\u043c", "\u0447\u0438\u0441\u043b\u0435")), CommonPatterns.possiblySkipDown("obl", NodePattern.N.withDependent("advmod", NodePattern.N.form("\u0442\u043e\u043b\u044c\u043a\u043e"))), NodePattern.N.withHead(NodePattern.N.pos("ADV")), NodePattern.N.pos("ADJ:Short:Neut").withOnlyDependents(NodePattern.or(NodePattern.PUNCT, NodePattern.N.form("\u043d\u043e"))), NodePattern.N.withDependent("advmod", NodePattern.N.inFormSequence(1, "\u043d\u043e|\u0430", "\u043d\u0435"))), NodePattern.N.withHeadRelation("amod").andOr(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("det")), NodePattern.N.pos("PT.*").afterHead()), NodePattern.N.withHeadRelation("discourse").andOr(NodePattern.N.form("\u043d\u0435\u0442?"), NodePattern.N.noPos()), NodePattern.N.inFormSequence(0, "\u043d\u0430\u043a\u043e\u043d\u0435\u0446", "-", "\u0442\u043e"), NodePattern.N.inFormSequence(1, "\u043f\u043e", "\u0441\u0443\u0442\u0438"));
    private static final NodePattern licenseCommasBefore = NodePattern.or(RussianTreePatterns.aNo, NodePattern.N.afterHead().withHeadRelation("conj|parataxis").andNot(NodePattern.N.withHead("conj", NodePattern.ROOT.inFormSequence(2, "\u043a\u0430\u043a", "\u043d\u0430", "\u043f\u043e\u0434\u0431\u043e\u0440")).withOnlyDependents(NodePattern.PUNCT)).andNot(whatsNeeded).andNot(whatWillBe).andNot(misparsedDetPtNoun).andNot(nestedCoordinatedPhrase).andNot(noCommaDptPhrase));

    PunctuationRules() {
    }

    private static Set<Case> casesOn(Node n) {
        return ((StreamEx)StreamEx.of((Object[])Case.values()).filter(c -> c.isPresentOn(n))).toSet();
    }

    static List<Rule> highestPriorityRules() {
        return List.of(new ZeroWidthSpaceRule("\u041f\u0440\u043e\u0431\u0435\u043b\u044b \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0448\u0438\u0440\u0438\u043d\u044b", "\u041f\u043e\u0438\u0441\u043a \u0438 \u0437\u0430\u043c\u0435\u043d\u0430 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432 \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0448\u0438\u0440\u0438\u043d\u044b Unicode \u0432 \u0441\u043b\u043e\u0432\u0430\u0445.", "https://ru.wikipedia.org/wiki/%D0%9F%D1%80%D0%BE%D0%B1%D0%B5%D0%BB_%D0%BD%D1%83%D0%BB%D0%B5%D0%B2%D0%BE%D0%B9_%D1%88%D0%B8%D1%80%D0%B8%D0%BD%D1%8B", "\u042d\u0442\u043e \u0441\u043b\u043e\u0432\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0432\u0438\u0434\u0438\u043c\u044b\u0435 \u043f\u0440\u043e\u0431\u0435\u043b\u044b \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0448\u0438\u0440\u0438\u043d\u044b, \u0443\u0434\u0430\u043b\u0438\u0442\u044c?", "\u041e\u0447\u0435\u043d\u044c <b>\u043f\u0440\u043e\u200b\u0441\u0442\u043e</b>."));
    }

    static List<Rule> priorityRules() {
        return List.of(new Rule.PatternRule("Punctuation.INTRODUCTORY_COMMAS", "\u0417\u0430\u043f\u044f\u0442\u044b\u0435 \u0432\u043e\u043a\u0440\u0443\u0433 \u0432\u0432\u043e\u0434\u043d\u044b\u0445 \u0441\u043b\u043e\u0432 \u0438 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0439", "\u0412\u0432\u043e\u0434\u043d\u044b\u0435 \u0441\u043b\u043e\u0432\u0430 \u0438 \u0441\u043b\u043e\u0432\u043e\u0441\u043e\u0447\u0435\u0442\u0430\u043d\u0438\u044f \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u044b\u0434\u0435\u043b\u044f\u0442\u044c\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u0441 \u043e\u0431\u0435\u0438\u0445 \u0441\u0442\u043e\u0440\u043e\u043d.", "https://russkiiyazyk.ru/sintaksis/vvodnye-slova-primery-predlozheniii.html", () -> PunctuationRules.introductoryComma(), new Example("<i>\u041a\u0440\u043e\u043c\u0435 </i><b>\u0442\u043e\u0433\u043e</b> \u043d\u0443\u0436\u043d\u043e \u043b\u044e\u0431\u0438\u0442\u044c \u0441\u0432\u043e\u0451 \u0434\u0435\u043b\u043e", "<b>\u041a\u0440\u043e\u043c\u0435 \u0442\u043e\u0433\u043e,</b> \u043d\u0443\u0436\u043d\u043e \u043b\u044e\u0431\u0438\u0442\u044c \u0441\u0432\u043e\u0451 \u0434\u0435\u043b\u043e")));
    }

    static List<Rule> rules() {
        return List.of(new Rule.PatternRule("Punctuation.FORMATTING_ISSUES", "\u041f\u0440\u043e\u0431\u0435\u043b\u044b \u0438 \u0437\u043d\u0430\u043a\u0438 \u043f\u0440\u0435\u043f\u0438\u043d\u0430\u043d\u0438\u044f", "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0439 \u0440\u0430\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u0439 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432 \u0438 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u0441\u043e\u0447\u0435\u0442\u0430\u043d\u0438\u044f \u0437\u043d\u0430\u043a\u043e\u0432 \u043f\u0440\u0435\u043f\u0438\u043d\u0430\u043d\u0438\u044f.", null, () -> PunctuationRules.formattingIssues(), new Example("<b>\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440,,</b> \u0441\u043e\u0431\u0430\u043a\u0430.", "<b>\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440,</b> \u0441\u043e\u0431\u0430\u043a\u0430."), new Example("<b>\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 ,</b> \u0441\u043e\u0431\u0430\u043a\u0430.", "<b>\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440,</b> \u0441\u043e\u0431\u0430\u043a\u0430."), new Example("\u0418\u043d\u0442\u0435\u0440\u044c\u0435\u0440, \u043b\u0438\u0448\u0435\u043d\u043d\u044b\u0439 \u0438\u0437\u043b\u0438\u0448\u043d\u0435\u0433\u043e <b>\u0437\u0430- \u0438\u0441\u043a\u0438\u0432\u0430\u043d\u0438\u044f</b>.", "\u0418\u043d\u0442\u0435\u0440\u044c\u0435\u0440, \u043b\u0438\u0448\u0435\u043d\u043d\u044b\u0439 \u0438\u0437\u043b\u0438\u0448\u043d\u0435\u0433\u043e <b>\u0437\u0430\u0438\u0441\u043a\u0438\u0432\u0430\u043d\u0438\u044f</b>.")), new Rule.PatternRule("Punctuation.HYPHEN_VS_DASH", "\u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u0442\u0438\u0440\u0435 \u0438 \u0434\u0435\u0444\u0438\u0441\u043e\u0432", "\u0412 \u0441\u043b\u043e\u0436\u043d\u044b\u0445 \u0441\u043b\u043e\u0432\u0430\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u0435\u0444\u0438\u0441, \u0430 \u043d\u0435 \u0442\u0438\u0440\u0435. \u0412\u043e\u043a\u0440\u0443\u0433 \u0442\u0438\u0440\u0435 \u043c\u0435\u0436\u0434\u0443 \u0447\u043b\u0435\u043d\u0430\u043c\u0438 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0431\u0435\u043b\u044b. \u0417\u0430\u043f\u044f\u0442\u044b\u0435 \u0441\u0442\u0430\u0432\u044f\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0434 \u0442\u0438\u0440\u0435, \u0430 \u043d\u0435 \u043f\u043e\u0441\u043b\u0435.", "https://russkiiyazyk.ru/punktuatsiya/defis-tire.html", () -> PunctuationRules.hyphenVsDash(), new Example("\u0421\u0442\u043e\u0438\u0442 \u0441\u043e\u043b\u043d\u0446\u0443 \u0437\u0430\u0439\u0442\u0438, \u0432\u043e\u0442 \u0438 \u044f \u0441\u0442\u0430\u043d\u0443 \u0432\u043c\u0438\u0433 <b>\u0444\u0438\u043e\u043b\u0435\u0442\u043e\u0432\u043e - \u0447\u0435\u0440\u043d\u044b\u043c</b>.", "\u0421\u0442\u043e\u0438\u0442 \u0441\u043e\u043b\u043d\u0446\u0443 \u0437\u0430\u0439\u0442\u0438, \u0432\u043e\u0442 \u0438 \u044f \u0441\u0442\u0430\u043d\u0443 \u0432\u043c\u0438\u0433 <b>\u0444\u0438\u043e\u043b\u0435\u0442\u043e\u0432\u043e-\u0447\u0435\u0440\u043d\u044b\u043c</b>."), new Example("<b>\u041d\u043e\u0447\u044c\u2014\u044d\u0442\u043e</b> \u043c\u0438\u0440 \u043f\u0440\u0435\u043a\u0440\u0430\u0441\u043d\u044b\u0445 \u0433\u0440\u0435\u0437.", "<b>\u041d\u043e\u0447\u044c \u2014 \u044d\u0442\u043e</b> \u043c\u0438\u0440 \u043f\u0440\u0435\u043a\u0440\u0430\u0441\u043d\u044b\u0445 \u0433\u0440\u0435\u0437."), new Example("\u00ab\u041d\u0443 \u044d\u0442\u043e \u0443\u0436\u0435 \u0441\u043e\u0432\u0441\u0435\u043c \u0430\u0434\u043e\u0432\u044b\u0439 <b>\u0444\u043e\u043d\u00bb -, \u043f\u0440\u043e\u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u043b</b> \u043e\u043d \u0438 \u0432\u0441\u0442\u0430\u043b \u043f\u0435\u0440\u0435\u0434 \u0430\u0444\u0438\u0448\u0435\u0439 \u043f\u0435\u0432\u0438\u0446\u044b.", "\u00ab\u041d\u0443 \u044d\u0442\u043e \u0443\u0436\u0435 \u0441\u043e\u0432\u0441\u0435\u043c \u0430\u0434\u043e\u0432\u044b\u0439 <b>\u0444\u043e\u043d\u00bb, \u2014 \u043f\u0440\u043e\u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u043b</b> \u043e\u043d \u0438 \u0432\u0441\u0442\u0430\u043b \u043f\u0435\u0440\u0435\u0434 \u0430\u0444\u0438\u0448\u0435\u0439 \u043f\u0435\u0432\u0438\u0446\u044b.")), PunctuationRules.quotePunctuation(), new Rule.PatternRule("Punctuation.VOCATIVE_COMMAS", "\u0417\u0430\u043f\u044f\u0442\u044b\u0435 \u0432\u043e\u043a\u0440\u0443\u0433 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f", "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u044f\u0442\u044b\u0435 \u0432\u043e\u043a\u0440\u0443\u0433 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f.", "http://gramota.ru/class/coach/punct/45_180", () -> PunctuationRules.vocativeComma(), new Example("<i>\u042d\u043b\u044c\u0437\u0430 \u0438 </i><b>\u0410\u043d\u043d\u0430</b> \u043d\u0435 \u0448\u0443\u043c\u0438\u0442\u0435!", "<i>\u042d\u043b\u044c\u0437\u0430 \u0438 </i><b>\u0410\u043d\u043d\u0430,</b> \u043d\u0435 \u0448\u0443\u043c\u0438\u0442\u0435!")).honorCrazyParses(), new Rule.PatternRule("Punctuation.PARTICIPLE_COMMAS", "\u0417\u0430\u043f\u044f\u0442\u044b\u0435 \u0432\u043e\u043a\u0440\u0443\u0433 \u043f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u044b\u0445 \u0438 \u0434\u0435\u0435\u043f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u044b\u0445 \u043e\u0431\u043e\u0440\u043e\u0442\u043e\u0432", "\u041f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u044b\u0439 \u043e\u0431\u043e\u0440\u043e\u0442 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438, \u0435\u0441\u043b\u0438 \u043e\u043d \u0441\u0442\u043e\u0438\u0442 \u043f\u043e\u0441\u043b\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u043c\u043e\u0433\u043e \u0441\u043b\u043e\u0432\u0430, \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0441\u044f \u043a \u043b\u0438\u0447\u043d\u043e\u043c\u0443 \u043c\u0435\u0441\u0442\u043e\u0438\u043c\u0435\u043d\u0438\u044e \u043b\u0438\u0431\u043e \u0438\u043c\u0435\u0435\u0442 \u0434\u043e\u0431\u0430\u0432\u043e\u0447\u043d\u044b\u0439 \u043e\u0442\u0442\u0435\u043d\u043e\u043a \u043e\u0431\u0441\u0442\u043e\u044f\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u0440\u0438\u0447\u0438\u043d\u044b, \u0443\u0441\u043b\u043e\u0432\u0438\u044f \u0438 \u0442.\u043f. \u0414\u0435\u0435\u043f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u044b\u0435 \u043e\u0431\u043e\u0440\u043e\u0442\u044b \u0432\u044b\u0434\u0435\u043b\u044f\u044e\u0442\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u0432\u0441\u0435\u0433\u0434\u0430, \u043a\u0440\u043e\u043c\u0435 \u0441\u043b\u0443\u0447\u0430\u0435\u0432, \u043a\u043e\u0433\u0434\u0430 \u043e\u043d\u0438 \u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u0444\u0440\u0430\u0437\u0435\u043e\u043b\u043e\u0433\u0438\u0437\u043c\u0430\u043c\u0438 \u043b\u0438\u0431\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u044b \u0441\u043e\u044e\u0437\u043e\u043c \u00ab\u0438\u00bb \u0441 \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u043e\u0434\u043d\u043e\u0440\u043e\u0434\u043d\u044b\u043c\u0438 \u043e\u0431\u0441\u0442\u043e\u044f\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430\u043c\u0438.", "https://russkiiyazyk.ru/chasti-rechi/glagol/prichastie/prichastnyi-deeprichastnyi-oborot.html", () -> PunctuationRules.participleComma(), new Example("<i>\u041f\u043e\u0434\u044a\u0435\u0437\u0436\u0430\u044f \u043a \u0441\u0438\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0438 \u0433\u043b\u044f\u0434\u044f \u043d\u0430 \u043f\u0440\u0438\u0440\u043e\u0434\u0443 \u0432 </i><b>\u043e\u043a\u043d\u043e</b> \u044f \u043f\u043e\u0442\u0435\u0440\u044f\u043b \u0448\u043b\u044f\u043f\u0443.", "<i>\u041f\u043e\u0434\u044a\u0435\u0437\u0436\u0430\u044f \u043a \u0441\u0438\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0438 \u0433\u043b\u044f\u0434\u044f \u043d\u0430 \u043f\u0440\u0438\u0440\u043e\u0434\u0443 \u0432 </i><b>\u043e\u043a\u043d\u043e,</b> \u044f \u043f\u043e\u0442\u0435\u0440\u044f\u043b \u0448\u043b\u044f\u043f\u0443.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.CONJUNCTION_COMMA", "\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u0441\u043e\u044e\u0437\u0430\u043c\u0438", "\u041f\u0435\u0440\u0435\u0434 \u0441\u043e\u044e\u0437\u0430\u043c\u0438 \u00ab\u0430\u00bb \u0438\u043b\u0438 \u00ab\u043d\u043e\u00bb \u043e\u0431\u044b\u0447\u043d\u043e \u0441\u0442\u0430\u0432\u0438\u0442\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f. \u041f\u0435\u0440\u0435\u0434 \u00ab\u0438\u00bb \u0438 \u00ab\u0438\u043b\u0438\u00bb \u043c\u0435\u0436\u0434\u0443 \u043e\u0434\u043d\u043e\u0440\u043e\u0434\u043d\u044b\u043c\u0438 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u043c\u0438 \u0438\u043b\u0438 \u0447\u043b\u0435\u043d\u0430\u043c\u0438 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u2014 \u043d\u0435 \u0441\u0442\u0430\u0432\u0438\u0442\u0441\u044f.", "http://n-t.ru/ac/56/pz03.htm", () -> NodePattern.or(PunctuationRules.conjunctionComma(), PunctuationRules.excessiveConjunctionComma()), new Example("\u042d\u0442\u043e <b>\u043a\u0440\u0430\u0441\u043d\u043e\u0435 \u0430</b> \u043d\u0435 \u0437\u0435\u043b\u0451\u043d\u043e\u0435.", "\u042d\u0442\u043e <b>\u043a\u0440\u0430\u0441\u043d\u043e\u0435, \u0430</b> \u043d\u0435 \u0437\u0435\u043b\u0451\u043d\u043e\u0435."), new Example("\u042f \u0440\u0435\u0448\u0438\u043b \u043d\u0430\u0447\u0430\u0442\u044c <b>\u0442\u0440\u0435\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f, \u0438</b> \u0445\u043e\u0434\u0438\u0442\u044c \u0432 \u0441\u043f\u043e\u0440\u0442\u0437\u0430\u043b.", "\u042f \u0440\u0435\u0448\u0438\u043b \u043d\u0430\u0447\u0430\u0442\u044c \u0442\u0440\u0435\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f<b> \u0438</b> \u0445\u043e\u0434\u0438\u0442\u044c \u0432 \u0441\u043f\u043e\u0440\u0442\u0437\u0430\u043b.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.EXCESSIVE_COMMA", "\u041b\u0438\u0448\u043d\u0438\u0435 \u0437\u0430\u043f\u044f\u0442\u044b\u0435", "\u041f\u043e\u0438\u0441\u043a \u043b\u0438\u0448\u043d\u0438\u0445 \u0437\u0430\u043f\u044f\u0442\u044b\u0445, \u043d\u0435 \u043e\u0431\u0443\u0441\u043b\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0438\u043a\u0430\u043a\u0438\u043c\u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u043c\u0438.", null, () -> PunctuationRules.excessiveComma(), new Example("<i>\u0414\u043e\u043a\u0442\u043e\u0440 </i><b>\u041c\u0430\u0440\u043a,</b> \u0431\u044b\u043b \u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u043c \u043e\u043d\u043a\u043e\u043b\u043e\u0433\u043e\u043c", "\u0414\u043e\u043a\u0442\u043e\u0440 <b>\u041c\u0430\u0440\u043a</b> \u0431\u044b\u043b \u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u043c \u043e\u043d\u043a\u043e\u043b\u043e\u0433\u043e\u043c"), new Example("<b>\u0422\u0430\u043a\u0436\u0435,</b> \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u0442\u0441\u044f \u0440\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u0447\u0435\u043d\u044c \u0440\u0430\u0431\u043e\u0442, \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u0443\u0435\u043c\u044b\u0445 \u0437\u0430 \u0441\u0447\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0444\u043e\u043d\u0434\u0430", "<b>\u0422\u0430\u043a\u0436\u0435</b> \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u0442\u0441\u044f \u0440\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u0447\u0435\u043d\u044c \u0440\u0430\u0431\u043e\u0442, \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u0443\u0435\u043c\u044b\u0445 \u0437\u0430 \u0441\u0447\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0444\u043e\u043d\u0434\u0430")).honorCrazyParses(), new Rule.PatternRule("Punctuation.KAK_PUNCTUATION", "\u041f\u0443\u043d\u043a\u0442\u0443\u0430\u0446\u0438\u044f \u0432 \u043e\u0431\u043e\u0440\u043e\u0442\u0430\u0445 \u0441\u043e \u0441\u043b\u043e\u0432\u043e\u043c \u00ab\u043a\u0430\u043a\u00bb", "<li>\u041e\u0431\u043e\u0440\u043e\u0442\u044b \u0441 \u00ab\u043a\u0430\u043a\u00bb \u0432\u044b\u0434\u0435\u043b\u044f\u044e\u0442\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438, \u043a\u043e\u0433\u0434\u0430 \u0432 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0438 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0443\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u043b\u043e\u0432\u0430 (\u0442\u0430\u043a, \u0442\u0430\u043a\u043e\u0439, \u0442\u0430\u043a\u0438\u0435, \u0442\u043e\u0442).<li>\u041e\u0431\u043e\u0440\u043e\u0442\u044b, \u0432\u0432\u043e\u0434\u0438\u043c\u044b\u0435 \u00ab\u043a\u0430\u043a \u0438\u00bb, \u0432\u044b\u0434\u0435\u043b\u044f\u044e\u0442\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438.<li>\u0423\u0442\u043e\u0447\u043d\u044f\u044e\u0449\u0438\u0435 \u043e\u0431\u043e\u0440\u043e\u0442\u044b \u0441\u043e \u0441\u043b\u043e\u0432\u0430\u043c\u0438 \u00ab\u0442\u0430\u043a\u0438\u0435 \u043a\u0430\u043a\u00bb \u0432\u044b\u0434\u0435\u043b\u044f\u044e\u0442\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u0441 \u043e\u0431\u0435\u0438\u0445 \u0441\u0442\u043e\u0440\u043e\u043d.<br/><br/>\u0417\u0430\u043f\u044f\u0442\u044b\u0435 \u043d\u0435 \u0441\u0442\u0430\u0432\u044f\u0442\u0441\u044f:<li>\u0412 \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f\u0445 \u0441 \u00ab\u043a\u0430\u043a\u00bb \u043c\u0435\u0436\u0434\u0443 \u043f\u043e\u0434\u043b\u0435\u0436\u0430\u0449\u0438\u043c \u0438 \u0441\u043a\u0430\u0437\u0443\u0435\u043c\u044b\u043c, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0432 \u043e\u0431\u0441\u0442\u043e\u044f\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430\u0445 \u043e\u0431\u0440\u0430\u0437\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f (\u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0447\u0435\u0433\u043e).<li>\u0412\u043e \u0444\u0440\u0430\u0437\u0435\u043e\u043b\u043e\u0433\u0438\u0437\u043c\u0430\u0445 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u00ab\u0431\u043b\u0435\u0441\u0442\u0435\u0442\u044c \u043a\u0430\u043a \u0437\u0435\u0440\u043a\u0430\u043b\u043e\u00bb).<li>\u0415\u0441\u043b\u0438 \u0441\u0440\u0430\u0432\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u043c\u0443 \u043e\u0431\u043e\u0440\u043e\u0442\u0443 \u043f\u0440\u0435\u0434\u0448\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0442\u0440\u0438\u0446\u0430\u043d\u0438\u0435 \u0438\u043b\u0438 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0447\u0430\u0441\u0442\u0438\u0446\u044b \u0432\u0440\u043e\u0434\u0435 \u00ab\u0441\u043e\u0432\u0441\u0435\u043c\u00bb.", "https://obrazovaka.ru/zapyataya/kak.html", () -> PunctuationRules.kakPunctuation(), new Example("<b>\u0411\u0440\u043e\u0432\u0438, \u043a\u0430\u043a</b> \u0434\u0443\u0433\u0438.", "<b>\u0411\u0440\u043e\u0432\u0438 \u043a\u0430\u043a</b> \u0434\u0443\u0433\u0438.", "<b>\u0411\u0440\u043e\u0432\u0438 \u2014 \u043a\u0430\u043a</b> \u0434\u0443\u0433\u0438."), new Example("\u041c\u044b \u0435\u0433\u043e <b>\u0437\u043d\u0430\u0435\u043c,</b><i> \u043a\u0430\u043a \u0445\u043e\u0440\u043e\u0448\u0435\u0433\u043e \u0447\u0435\u043b\u043e\u0432\u0435\u043a\u0430</i>.", "\u041c\u044b \u0435\u0433\u043e <b>\u0437\u043d\u0430\u0435\u043c \u043a\u0430\u043a \u0445\u043e\u0440\u043e\u0448\u0435\u0433\u043e \u0447\u0435\u043b\u043e\u0432\u0435\u043a\u0430</b>.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.INTER_CLAUSE_COMMA", "\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043c\u0435\u0436\u0434\u0443 \u0447\u0430\u0441\u0442\u044f\u043c\u0438 \u0441\u043b\u043e\u0436\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f", "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u043d\u0430\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043c\u0435\u0436\u0434\u0443 \u0447\u0430\u0441\u0442\u044f\u043c\u0438 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u043e\u0447\u0438\u043d\u0451\u043d\u043d\u043e\u0433\u043e \u0438\u043b\u0438 \u0441\u043b\u043e\u0436\u043d\u043e\u043f\u043e\u0434\u0447\u0438\u043d\u0451\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f.", "https://ru.wikipedia.org/wiki/\u0421\u043b\u043e\u0436\u043d\u043e\u0435_\u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435", () -> NodePattern.or(NodePattern.or(PunctuationRules.whSubordinationComma(), PunctuationRules.whetherSubordinationComma(), PunctuationRules.comparativeSubordinationComma()).andNot(NodePattern.N.withPhraseEnd(NodePattern.or(PairedPunctuation.smileyParen, sentenceBoundary))).andNot(NodePattern.N.withPhraseStart(CommonPatterns.capitalized.directlyAfter(CommonPatterns.closingParen))), PunctuationRules.missingCoordinationComma()).andNot(withHowMark.pos("NN.*").withHeadRelation("acl|advcl").noDependents("cop|nsubj.*|csubj.*")).withPhraseStart(NodePattern.not(splitComplexConjStart).andNot(emphasizingConj).andOptionally(NodePattern.N.directlyAfter(NodePattern.N.noPos().and((node, match) -> match.concedingToOtherGrammarCheckers())))), new Example("\u041c\u043e\u0439 \u0432\u044b\u0431\u043e\u0440 \u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u043d\u0430 \u0436\u0438\u0432\u043e\u0435 <b>\u043e\u0431\u0449\u0435\u043d\u0438\u0435</b><i> \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e \u043b\u0435\u0436\u0430\u0442\u044c \u0438 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043d\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0435 \u043f\u043b\u043e\u0445\u043e</i>.", "\u041c\u043e\u0439 \u0432\u044b\u0431\u043e\u0440 \u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u043d\u0430 \u0436\u0438\u0432\u043e\u0435 <b>\u043e\u0431\u0449\u0435\u043d\u0438\u0435,</b> \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e \u043b\u0435\u0436\u0430\u0442\u044c \u0438 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043d\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0435 \u043f\u043b\u043e\u0445\u043e."), new Example("\u0423 \u043c\u0435\u043d\u044f \u0441\u0432\u043e\u044f <b>\u043a\u043e\u043c\u043d\u0430\u0442\u0430 \u0438</b> \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u044f \u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u0430.", "\u0423 \u043c\u0435\u043d\u044f \u0441\u0432\u043e\u044f <b>\u043a\u043e\u043c\u043d\u0430\u0442\u0430, \u0438</b> \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u044f \u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u0430.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.COMPLEX_CONJUNCTION_COMMA", "\u0417\u0430\u043f\u044f\u0442\u044b\u0435 \u0441\u043e \u0441\u043b\u043e\u0436\u043d\u044b\u043c\u0438 \u0441\u043e\u044e\u0437\u0430\u043c\u0438", "\u0421\u043e\u0441\u0442\u0430\u0432\u043d\u044b\u0435 \u043f\u043e\u0434\u0447\u0438\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u043e\u044e\u0437\u044b (\u043a\u0430\u043a \u00ab\u0434\u043b\u044f \u0442\u043e\u0433\u043e \u0447\u0442\u043e\u0431\u044b\u00bb) \u043c\u043e\u0433\u0443\u0442 \u043a\u0430\u043a \u0440\u0430\u0437\u0434\u0435\u043b\u044f\u0442\u044c\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u043e\u0439, \u0442\u0430\u043a \u0438 \u043d\u0435 \u0440\u0430\u0437\u0434\u0435\u043b\u044f\u0442\u044c\u0441\u044f. \u0427\u0430\u0441\u0442\u043e \u043e\u043d\u0438 \u0440\u0430\u0437\u0434\u0435\u043b\u044f\u044e\u0442\u0441\u044f, \u0435\u0441\u043b\u0438 \u043f\u0435\u0440\u0435\u0434 \u043d\u0438\u043c\u0438 \u0435\u0441\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u043d\u0438\u0435, \u0447\u0430\u0441\u0442\u0438\u0446\u044b, \u0432\u0432\u043e\u0434\u043d\u044b\u0435 \u0441\u043b\u043e\u0432\u0430 \u0438\u043b\u0438 \u043d\u0430\u0440\u0435\u0447\u0438\u044f, \u0435\u0441\u043b\u0438 \u043e\u043d\u0438 \u0432\u0445\u043e\u0434\u044f\u0442 \u0432 \u0440\u044f\u0434 \u043e\u0434\u043d\u043e\u0440\u043e\u0434\u043d\u044b\u0445 \u0447\u043b\u0435\u043d\u043e\u0432, \u0438\u043b\u0438 \u0435\u0441\u043b\u0438 \u043d\u0430 \u043f\u0435\u0440\u0432\u0443\u044e \u0447\u0430\u0441\u0442\u044c \u0441\u043e\u044e\u0437\u0430 \u043f\u0430\u0434\u0430\u0435\u0442 \u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0443\u0434\u0430\u0440\u0435\u043d\u0438\u0435.", "http://new.gramota.ru/spravka/punctum/punctum-attach3/", () -> ComplexConjunctions.pattern(), new Example("<b>\u0414\u043b\u044f \u0442\u043e\u0433\u043e, \u0447\u0442\u043e\u0431\u044b</b> \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c, \u0438\u0437 \u0447\u0435\u0433\u043e \u0441\u0434\u0435\u043b\u0430\u043d\u0430 \u043f\u043e\u0441\u0443\u0434\u0430, \u043d\u0430\u0434\u043e \u0432\u0437\u044f\u0442\u044c \u0435\u0435 \u0432 \u0440\u0443\u043a\u0438.", "<b>\u0414\u043b\u044f \u0442\u043e\u0433\u043e \u0447\u0442\u043e\u0431\u044b</b> \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c, \u0438\u0437 \u0447\u0435\u0433\u043e \u0441\u0434\u0435\u043b\u0430\u043d\u0430 \u043f\u043e\u0441\u0443\u0434\u0430, \u043d\u0430\u0434\u043e \u0432\u0437\u044f\u0442\u044c \u0435\u0435 \u0432 \u0440\u0443\u043a\u0438."), new Example("\u042d\u0442\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e, \u0438 \u043d\u0435 <b>\u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e</b> \u043a\u0442\u043e-\u0442\u043e \u044d\u0442\u043e\u0433\u043e \u0445\u043e\u0447\u0435\u0442.", "\u042d\u0442\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e, \u0438 \u043d\u0435 <b>\u043f\u043e\u0442\u043e\u043c\u0443, \u0447\u0442\u043e</b> \u043a\u0442\u043e-\u0442\u043e \u044d\u0442\u043e\u0433\u043e \u0445\u043e\u0447\u0435\u0442."), new Example("<b>\u0422\u0430\u043a \u0447\u0442\u043e,</b> \u0442\u0435\u0441\u0442 \u043d\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0438\u0432\u043d\u044b\u0439.", "<b>\u0422\u0430\u043a \u0447\u0442\u043e</b> \u0442\u0435\u0441\u0442 \u043d\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0438\u0432\u043d\u044b\u0439.")).honorCrazyParses());
    }

    static Rule.PatternRule hyphenToDashRule() {
        return new Rule.PatternRule("Typography.HYPHEN_TO_DASH", "\u0414\u0435\u0444\u0438\u0441 \u0432\u043c\u0435\u0441\u0442\u043e \u0442\u0438\u0440\u0435", "\u0414\u043b\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0447\u043b\u0435\u043d\u043e\u0432 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0442\u0438\u0440\u0435.", "https://russkiiyazyk.ru/punktuatsiya/defis-tire.html", () -> CommonPatterns.dashLikeHyphens.andOr(NodePattern.N.spaceAround().andNot(compHyphen).andNot(NodePattern.N.directlyAfter(CommonPatterns.latin).directlyBefore(CommonPatterns.latin)).and(PunctuationRules.toSpacedDash("HyphenToDash")).message(HYPHEN_TO_DASH_MSG), separatesRange.and(toDashInRange)), new Example("\u0414\u0435\u0444\u0438\u0441 \u0438 <b>\u0442\u0438\u0440\u0435 - \u044d\u0442\u043e</b> \u0440\u0430\u0437\u043d\u044b\u0435 \u0437\u043d\u0430\u043a\u0438.", "\u0414\u0435\u0444\u0438\u0441 \u0438 <b>\u0442\u0438\u0440\u0435 \u2014 \u044d\u0442\u043e</b> \u0440\u0430\u0437\u043d\u044b\u0435 \u0437\u043d\u0430\u043a\u0438.")).honorCrazyParses().coveringLTRules("TIRE", "RU_DASH_RULE", "COMMA_DEFIS");
    }

    private static NodePattern kakPunctuation() {
        NodePattern such = NodePattern.N.lemma("\u0442\u0430\u043a\u043e\u0439").withHeadRelation("det|root").markAs("Such");
        NodePattern kakInSuch = NodePattern.N.form("\u043a\u0430\u043a").withHead("case|mark", NodePattern.N.withHead("advcl|obl", NodePattern.N.alreadyMarkedAs("Such")));
        NodePattern subjKakPredComma = CommonPatterns.comma.correct(NodeCorrector.replace("", " \u2014")).and(CommonPatterns.reportWithNext).directlyAfter(NodePattern.N.includeIntoReport());
        return NodePattern.or(NodePattern.N.inFormSequence(4, "\u0432\u0441\u0435", ",", "\u043a\u0430\u043a", "\u043d\u0430", "\u043f\u043e\u0434\u0431\u043e\u0440").and((node, match1) -> PunctuationRules.removeCommas(match1, node.neighbor(-3), node)).message("\u0424\u0440\u0430\u0437\u0435\u043e\u043b\u043e\u0433\u0438\u0437\u043c \u00ab\u0432\u0441\u0435 \u043a\u0430\u043a \u043d\u0430 \u043f\u043e\u0434\u0431\u043e\u0440\u00bb \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.pos("NN.*").and(withKakMark).andOr(NodePattern.N.afterHead().withHead("nmod|acl", NodePattern.N.pos("NN.*").withDependent("det", NodePattern.N.lemma("\u0442\u0430\u043a\u043e\u0439").markAs("Det"))).and(PunctuationRules.sameMsgSurround("\u041e\u0431\u043e\u0440\u043e\u0442\u044b \u0441 \u0441\u043e\u044e\u0437\u043e\u043c \u00ab\u043a\u0430\u043a\u00bb \u043f\u043e\u0441\u043b\u0435 \u0443\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u0432\u0430 \u00ab\u0442\u0430\u043a\u043e\u0439\u00bb \u0432\u044b\u0434\u0435\u043b\u044f\u044e\u0442\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438")).reportRangeTo("Det", ReportingKind.Hover), NodePattern.N.afterHead().withHeadRelation("acl").and(NodePattern.markedNodeMatches("Kak", NodePattern.N.directlyBefore(NodePattern.N.form("\u0438")))).and(PunctuationRules.sameMsgSurround("\u041e\u0431\u043e\u0440\u043e\u0442\u044b, \u0432\u0432\u043e\u0434\u0438\u043c\u044b\u0435 \u00ab\u043a\u0430\u043a \u0438\u00bb, \u0432\u044b\u0434\u0435\u043b\u044f\u044e\u0442\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438")), NodePattern.N.markAs("Acl").withHead("acl", NodePattern.ROOT.pos("P?NN.*").noDependents(NodePattern.N.afterHead().before("Acl"))).withPhraseStart(subjKakPredComma).message(SUBJ_KAK_PRED_MSG), NodePattern.ROOT.withDependent("nsubj", NodePattern.N.pos("P?NN.*").beforeHead()).and(NodePattern.markedNodeMatches("Kak", NodePattern.N.directlyAfter(subjKakPredComma))).message(SUBJ_KAK_PRED_MSG)), qualityKak.and(removeSurroundingCommas).message(KAK_QUALITY_MSG), kakTakI.and(removeSurroundingCommas).message("\u0417\u0430\u043f\u044f\u0442\u044b\u0435 \u0432\u043e\u043a\u0440\u0443\u0433 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u00ab\u043a\u0430\u043a \u2026, \u0442\u0430\u043a \u0438 \u2026\u00bb \u043d\u0435 \u0441\u0442\u0430\u0432\u044f\u0442\u0441\u044f"), such.andOr(NodePattern.N.directlyBefore(kakInSuch).noDependents("nsubj.*|csubj.*").and(PunctuationRules.sameMsgSurround("\u0423\u0442\u043e\u0447\u043d\u044f\u044e\u0449\u0438\u0435 \u043e\u0431\u043e\u0440\u043e\u0442\u044b \u0441\u043e \u0441\u043b\u043e\u0436\u043d\u044b\u043c \u0441\u043e\u044e\u0437\u043e\u043c \u00ab\u0442\u0430\u043a\u043e\u0439 \u043a\u0430\u043a\u00bb \u0432\u044b\u0434\u0435\u043b\u044f\u044e\u0442\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438")), NodePattern.N.includeIntoReport().directlyAfter(CommonPatterns.comma).and(CommonPatterns.beforeSkipping(NodePattern.N.form("\u0436\u0435"), CommonPatterns.comma.includeIntoReport().directlyBefore(kakInSuch.includeIntoReport()).correct(NodeCorrector.replace("")).message("\u041b\u0438\u0448\u043d\u044f\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u0432\u043d\u0443\u0442\u0440\u0438 \u0441\u043b\u043e\u0436\u043d\u043e\u0433\u043e \u0441\u043e\u044e\u0437\u0430 \u00ab$Such \u043a\u0430\u043a\u00bb?"))), NodePattern.N.includeIntoReport().directlyAfter(NodePattern.N.form("\u043d\u0435")).and(CommonPatterns.beforeSkipping(NodePattern.N.form("\u0436\u0435"), kakInSuch.includeIntoReport().correct(NodeCorrector.insertAfterPrevious(",")).message("\u041f\u0440\u0438 \u043e\u0442\u0440\u0438\u0446\u0430\u043d\u0438\u0438 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u0441\u0442\u0430\u0432\u0438\u0442\u0441\u044f \u0432\u043d\u0443\u0442\u0440\u0438 \u043e\u0431\u043e\u0440\u043e\u0442\u0430 \u00ab$Such \u043a\u0430\u043a\u00bb")))).andNot(conjAmbiguityAtEnd), modifiedKak.directlyAfter(unmandatedComma.correct(NodeCorrector.replace(""))).reportRangeTo("Prev").and((node, match) -> {
            String prev = match.getMarkedNode("Prev").lowForm();
            if (prev.equals("\u0442\u043e\u0447\u044c")) {
                prev = "\u0442\u043e\u0447\u044c-\u0432-\u0442\u043e\u0447\u044c";
            }
            return match.withMessage("\u0412 \u0441\u0440\u0430\u0432\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0431\u043e\u0440\u043e\u0442\u0430\u0445 \u0441 \u00ab" + prev + " \u043a\u0430\u043a\u00bb \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043d\u0435 \u043d\u0443\u0436\u043d\u0430");
        }), kakIdiom.withHead("obl|advcl", NodePattern.or(NodePattern.N.inFormSequence(0, ".*", ",", "\u043a\u0430\u043a"), NodePattern.N.withDependent("obj", NodePattern.N.withPhraseEnd(NodePattern.N.inFormSequence(0, ".*", ",", "\u043a\u0430\u043a"))))).and(removeSurroundingCommas).message("\u0424\u0440\u0430\u0437\u0435\u043e\u043b\u043e\u0433\u0438\u0437\u043c\u044b \u0441 \u00ab\u043a\u0430\u043a\u00bb \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u044e\u0442\u0441\u044f"));
    }

    private static NodePattern sameMsgSurround(String msg) {
        return NodePattern.custom((acl, match) -> PunctuationRules.surroundWithCommas(match, PunctuationRules.surroundingPhraseStart(acl), acl.phraseEnd(), false, msg, msg, msg));
    }

    private static NodePattern participleComma() {
        NodePattern possiblyTornNpConj = NodePattern.N.directlyBefore(andOr.withHead("cc", NodePattern.N.withHeadRelation("conj").pos("NN.*").withPrevSibling(NodePattern.N.alreadyMarkedAs("PtClause")).markAs("NP"))).inPhrase(NodePattern.N.after("PtClause").pos("NN.*").and((node, match) -> PunctuationRules.haveSameCase(node, match.getMarkedNode("NP")) ? match : null));
        NodePattern misparsedEnd = NodePattern.or(RussianTreePatterns.foreignWord.directlyBefore(NodePattern.not(NodePattern.PUNCT)), NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.withHead("case", NodePattern.or(NodePattern.ROOT, NodePattern.N.withHead("nmod|obl", NodePattern.not(NodePattern.N.after("PtClause"))))), NodePattern.N.form("\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e"))), possiblyTornNpConj);
        NodePattern withArgs = CommonPatterns.possiblySkipDown("conj", NodePattern.or(NodePattern.N.withDependent("i?obj|obl.*|xcomp|ccomp|parataxis"), NodePattern.N.withDependent("advmod", NodePattern.not(RussianValences.auxAdverb))));
        String noCommaPronouns = "\u0432\u0435\u0441\u044c|\u0432\u0441\u044f\u043a\u0438\u0439|\u0434\u0440\u0443\u0433\u043e\u0439|\u0438\u043d\u043e\u0439|\u043a\u0430\u0436\u0434\u044b\u0439|\u043b\u044e\u0431\u043e\u0439|\u043d[\u0435\u0438]\u0433\u0434\u0435|\u043d[\u0435\u0438]\u043a\u043e\u0433\u0434\u0430|\u043d[\u0435\u0438]\u043a\u043e\u0442\u043e\u0440\u044b\u0439|\u043d[\u0435\u0438]\u043a\u0442\u043e|\u043d[\u0435\u0438]\u043a\u0443\u0434\u0430|\u043d[\u0435\u0438]\u043e\u0442\u043a\u0443\u0434\u0430|\u043d[\u0435\u0438]\u0441\u043a\u043e\u043b\u044c\u043a\u043e|\u043d[\u0435\u0438]\u0447\u0442\u043e|\u043d\u0435\u0437\u0430\u0447\u0435\u043c|\u043d\u0435\u043a\u0438\u0439|\u043d\u0435\u043a\u043e\u0433\u043e|\u043d\u0435\u0447\u0435\u0433\u043e|\u043d\u0438\u043a\u0430\u043a|\u043d\u0438\u043a\u0430\u043a\u043e\u0439|\u043d\u0438\u0447\u0435\u0439|\u043e\u043d\u044b\u0439|\u0441\u0430\u043c(\u044b\u0439)?|\u0441\u0435\u0439|\u0441\u0442\u043e\u043b\u044c\u043a\u043e|\u0442\u0430\u043a\u043e[\u0439\u0432]|\u044d(\u0442\u0430)?\u043a\u0438\u0439|\u044d?\u0442\u043e\u0442|\u043c\u043d\u043e\u0433\u0438\u0439";
        NodePattern hyphenatedIndPronoun = NodePattern.or(ParticleSeparation.to.directlyAfter(CommonPatterns.HYPHEN_NODE.directlyAfter(ParticleSeparation.interrogativePronoun)), NodePattern.N.form("\u043a\u043e\u0435").directlyBefore(CommonPatterns.HYPHEN_NODE.directlyBefore(ParticleSeparation.interrogativePronoun)), ParticleSeparation.interrogativePronoun.directlyBefore(CommonPatterns.HYPHEN_NODE.directlyBefore(ParticleSeparation.to)), ParticleSeparation.interrogativePronoun.directlyAfter(CommonPatterns.HYPHEN_NODE.directlyAfter(NodePattern.N.form("\u043a\u043e\u0435"))));
        return NodePattern.or(NodePattern.N.pos("DPT:.*").withHead("advcl|parataxis", NodePattern.N).and(withArgs).andNot(NodePattern.N.withPhraseEnd(RussianTreePatterns.dashes)).andNot(noCommaDptPhrase).noForm("\u0438\u0441\u0445\u043e\u0434\u044f|\u043c\u0435\u043b\u0435\u044f|\u043a\u0430\u043a\u0430\u044f").andNot(NodePattern.N.inFormSequence(0, "\u043d\u0430\u0447\u0438\u043d\u0430\u044f", "\u0441")).andNot(NodePattern.N.withPhraseStart(emphasizingConj)).and((dpt, match) -> {
            if (AgreementSet.findRelWh(dpt) != null) {
                return null;
            }
            return PunctuationRules.surroundWithCommas(match, PunctuationRules.surroundingPhraseStart(dpt), dpt.phraseEnd(), false, "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u0434\u0435\u0435\u043f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u044b\u043c \u043e\u0431\u043e\u0440\u043e\u0442\u043e\u043c?", "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u0434\u0435\u0435\u043f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u043e\u0433\u043e \u043e\u0431\u043e\u0440\u043e\u0442\u0430?", "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u044b \u0437\u0430\u043f\u044f\u0442\u044b\u0435 \u043f\u0440\u0438 \u0434\u0435\u0435\u043f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u043e\u043c \u043e\u0431\u043e\u0440\u043e\u0442\u0435?");
        }), fixedDptPhrase.and(removeSurroundingCommas).message("\u0417\u0430\u043f\u044f\u0442\u044b\u0435 \u0432\u043e\u043a\u0440\u0443\u0433 \u0444\u0440\u0430\u0437\u0435\u043e\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0434\u0435\u0435\u043f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u043e\u0433\u043e \u043e\u0431\u043e\u0440\u043e\u0442\u0430 \u043d\u0435 \u043d\u0443\u0436\u043d\u044b"), NodePattern.N.pos("PT:.*").noPos("ADJ:.*:R|NN.*").and(withArgs).noDependents("case|mark|cop|aux.*").noDependents("punct", CommonPatterns.comma.withPrevSibling(NodePattern.N).withNextSibling(NodePattern.N)).andNot(NodePattern.N.withHead("acl", NodePattern.or(NodePattern.N.lemma(noCommaPronouns), hyphenatedIndPronoun))).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("appos"))).andNot(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.inPhrase(NodePattern.N.withHeadRelation("obl"))))).andNot(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "\u0438", "\u0442|\u0434\u0440.*|\u043c\u043d\u043e\u0433.*")))).andNot(NodePattern.N.inFormSequence(2, "\u0441\u0430\u043c\u043e", "\u0441\u043e\u0431\u043e\u0439", "\u0440\u0430\u0437\u0443\u043c\u0435\u044e\u0449\u0435\u0435\u0441\u044f")).andOr(NodePattern.or(NodePattern.N.afterHead().withHeadRelation("acl").andNot(NodePattern.N.directlyAfterHead().withHead(NodePattern.ROOT).withDependent("advmod", NodePattern.N.withDependent("advcl"))), NodePattern.N.beforeHead().withHead("acl", NodePattern.N.onlyPos("PNN.*"))).andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("det"))).and(n -> PunctuationRules.haveSameCase(n, n.head())).and((pt, match) -> PunctuationRules.surroundWithCommas(match, PunctuationRules.surroundingPhraseStart(pt), pt.phraseEnd(), false, "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u043f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u044b\u043c \u043e\u0431\u043e\u0440\u043e\u0442\u043e\u043c?", "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u043f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u043e\u0433\u043e \u043e\u0431\u043e\u0440\u043e\u0442\u0430?", "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u044b \u0437\u0430\u043f\u044f\u0442\u044b\u0435 \u043f\u0440\u0438 \u043f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u043e\u043c \u043e\u0431\u043e\u0440\u043e\u0442\u0435?")), ptPhraseNeedingNoCommas.message("\u0417\u0430\u043f\u044f\u0442\u044b\u0435 \u0432\u043e\u043a\u0440\u0443\u0433 \u043f\u0440\u0438\u0447\u0430\u0441\u0442\u043d\u043e\u0433\u043e \u043e\u0431\u043e\u0440\u043e\u0442\u0430 \u043f\u0435\u0440\u0435\u0434 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u043d\u0435 \u043d\u0443\u0436\u043d\u044b").and(removeSurroundingCommas))).andNot(NodePattern.N.markAs("PtClause").withPhraseEnd(misparsedEnd));
    }

    private static boolean haveSameCase(Node n1, Node n2) {
        return Arrays.stream(Case.values()).anyMatch(c -> c.isPresentOn(n1) && c.isPresentOn(n2));
    }

    private static NodePattern introductoryComma() {
        return NodePattern.custom((node, match) -> {
            for (CommaLicense commas : IntroductoryConstructions.analyze(node)) {
                if (!commas.obligatory) continue;
                boolean isWord = commas.start == commas.end;
                return PunctuationRules.surroundWithCommas(match, commas.start, commas.end, true, isWord ? "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u0432\u0432\u043e\u0434\u043d\u044b\u043c \u0441\u043b\u043e\u0432\u043e\u043c?" : "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u0432\u0432\u043e\u0434\u043d\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c?", isWord ? "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u0432\u0430?" : "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0433\u043e \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f?", isWord ? "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u044b \u0437\u0430\u043f\u044f\u0442\u044b\u0435 \u0432\u043e\u043a\u0440\u0443\u0433 \u0432\u0432\u043e\u0434\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u0432\u0430?" : "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u044b \u0437\u0430\u043f\u044f\u0442\u044b\u0435 \u0432\u043e\u043a\u0440\u0443\u0433 \u0432\u0432\u043e\u0434\u043d\u043e\u0433\u043e \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f?");
            }
            return null;
        });
    }

    private static NodePattern hyphenVsDash() {
        return NodePattern.or(CommonPatterns.DASH_NODE.noSpaceAround().directlyAfter(RussianTreePatterns.openingQuotations).directlyBefore(NodePattern.not(NodePattern.PUNCT)).correct(NodeCorrector.replace("-")).message("\u041f\u0435\u0440\u0435\u0434 \u0447\u0430\u0441\u0442\u044f\u043c\u0438 \u0441\u043b\u043e\u0432 \u0441\u0442\u0430\u0432\u0438\u0442\u0441\u044f \u0434\u0435\u0444\u0438\u0441"), NodePattern.or(CommonPatterns.DASH_NODE, CommonPatterns.HYPHEN_NODE).andNot(NodePattern.N.noSpaceAround()).andOr(NodePattern.N.directlyBefore(CommonPatterns.romanNumeral.noPos("PREP")).directlyAfter(CommonPatterns.romanNumeral.noPos("PREP")), NodePattern.N.directlyBefore(DateChecker.year).directlyAfter(DateChecker.year), separatesRange.and(CommonPatterns.DASH_NODE).andOr(NodePattern.N.spaceBefore(), NodePattern.N.spaceAfter()).and(NodePattern.N.directlyAfter(CommonPatterns.ascendingRange))).and(toDashInRange), CommonPatterns.DASH_NODE.andNot(NodePattern.N.spaceAround()).andNot(compHyphen).andNot(NodePattern.N.directlyBefore(numberOrCount).and(CommonPatterns.afterSkipping(uomLike, numberOrCount))).andNot(NodePattern.N.directlyAfter(RussianTreePatterns.openingQuotations).directlyBefore(RussianTreePatterns.closingQuotations)).and(PunctuationRules.toSpacedDash("AddDashSpaces")).message(DASH_SPACES), NodePattern.or(CommonPatterns.DASH_NODE, CommonPatterns.HYPHEN_NODE.andOr(NodePattern.N.spaceAfter(), NodePattern.N.spaceBefore())).directlyBefore(CommonPatterns.comma.directlyBefore(NodePattern.N.markAs("Next"))).directlyAfter(NodePattern.N.markAs("Prev")).and(CommonPatterns.reportWithPrevWord).and((dash, match) -> {
            Node next = match.getMarkedNode("Next");
            int prevEnd = match.getMarkedNode("Prev").endOffset();
            int nextStart = next.startOffset();
            return match.withReportedNodes(dash.nextNode(), next).withCorrector(NodeCorrector.rawReplace(prevEnd, nextStart, ", \u2014 ").batchCapable("CommaBeforeDash"));
        }).message(COMMA_BEFORE_DASH), NodePattern.or(CommonPatterns.DASH_NODE, CommonPatterns.HYPHEN_NODE.andOr(NodePattern.N.spaceAfter(), NodePattern.N.spaceBefore())).and(compHyphen).and((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, "-"))).includeIntoReport().directlyAfter(NodePattern.N.includeIntoReport()).directlyBefore(NodePattern.N.includeIntoReport()).andOr(CommonPatterns.DASH_NODE.message("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0434\u0435\u0444\u0438\u0441 \u0432 \u0441\u043b\u043e\u0436\u043d\u044b\u0445 \u0441\u043b\u043e\u0432\u0430\u0445"), CommonPatterns.HYPHEN_NODE.message(HYPHEN_IN_COMPOUND_MESSAGE))).andOr(NodePattern.N.spaceAround().and((node, match) -> match.withReportedRange(CommonPatterns.includeSurroundingWhitespace(node), node.tree())), NodePattern.N.includeIntoReport().directlyBefore(NodePattern.N.includeIntoReport()).directlyAfter(NodePattern.N.includeIntoReport()));
    }

    private static NodePattern toSpacedDash(String batchId) {
        NodePattern textNumber = NodePattern.N.pos("Num.*");
        return NodePattern.N.markAs("Hyphen").andOr(CommonPatterns.separatesHeadDependent(NodePattern.not(NodePattern.N.directlyAfter("Hyphen").withHead("appos", NodePattern.N.withHeadRelation("nmod")))), NodePattern.N.directlyAfter(NodePattern.not(NodePattern.N.withHeadRelation("compound")))).andNot(NodePattern.N.directlyBefore(NodePattern.or(numberOrCount, textNumber, CommonPatterns.romanNumeral.noPos("PREP"))).directlyAfter(NodePattern.or(numberOrCount, textNumber, CommonPatterns.romanNumeral.noPos("PREP")))).and(CommonPatterns.reportWithPrevWord).and(CommonPatterns.reportWithNext).and((dash, match) -> {
            Node next = dash.nextNode();
            boolean moveNextPunct = next != null && next.hasForm("[,;:]");
            String spaceBefore = FormattingIssues.properlySpacedColon.matches(dash.prevNode()) ? "\n" : " ";
            NodeCorrector corrector = CommonPatterns.replaceWithWhitespace(dash, (moveNextPunct ? next.form() : "") + spaceBefore + "\u2014 ");
            if (moveNextPunct) {
                corrector = corrector.join(CommonPatterns.replaceWithWhitespace(next, ""));
            }
            return match.withCorrector(corrector.batchCapable(batchId)).enableAutoFix();
        });
    }

    private static NodePattern formattingIssues() {
        NodePattern hyphenAbbreviation = NodePattern.N.noSpaceAround().directlyBefore(NodePattern.N.form(".{1,3}")).directlyAfter(NodePattern.N.form(".{1,4}"));
        NodePattern hyphenPattern = NodePattern.or(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("appos").withDependent("conj")), NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form("\u043f\u043e").withHeadRelation("case"), NodePattern.N.form("\u0432\u043e?"), NodePattern.N.noPos())));
        return NodePattern.or(FormattingIssues.unpairedParentheses.message("\u0412\u044b \u0438\u043c\u0435\u043b\u0438 \u0432 \u0432\u0438\u0434\u0443 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0443\u044e\u0441\u044f \u0441\u043a\u043e\u0431\u043a\u0443?"), FormattingIssues.doublePunctuation.message(DOUBLE_PUNCTUATION), FormattingIssues.punctWhitespace(m -> FIX_SPACES).andNot(CommonPatterns.colon.directlyAfter(CommonPatterns.latinOrNumber)).andNot(CommonPatterns.colon.directlyBefore(CommonPatterns.latinOrNumber)).andNot(CommonPatterns.comma.directlyAfter(CommonPatterns.latinOrNumber).directlyBefore(CommonPatterns.latinOrNumber)).andNot(CommonPatterns.colon.noSpaceAround().directlyAfter(NodePattern.N.form("\\p{L}{3,}").andNot(NodePattern.N.onlyPos("VB.*"))).directlyBefore(NodePattern.N.formCaseSensitive("[\u0432\u0440\u0442\u043c]?([\u044b\u0438\u043e\u0435]?\u0439|[\u0430\u044c]?\u044f|[\u043e\u044c\u044b]?\u0435|\u044c?\u0438|([\u043e\u0435]?\u0433)?\u043e|([\u044b\u043e\u0435\u0438]?\u043c)?\u0443|[\u044c\u0443]?\u044e|[\u044b\u0438]?\u0445|(\u044b\u0438)?\u043c\u0438?)|((\u043d\u0438)?[\u043a\u0446])?([\u0430\u0438\u044b\u0435\u0443]|\u043e\u0439|\u0435\u0439|\u0430\u043c\u0438?|\u0430\u0445)|\u043e?\u043a|\u0438?\u0446"))), FormattingIssues.endWhitespace(m -> {
            String form = m.anchor().form();
            return "\u041b\u0438\u0448\u043d\u0438\u0439 \u043f\u0440\u043e\u0431\u0435\u043b \u043f\u0435\u0440\u0435\u0434 " + (String)(form.equals(".") ? "\u0442\u043e\u0447\u043a\u043e\u0439" : "'" + form + "'");
        }), FormattingIssues.quoteWhitespace("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0440\u043e\u0431\u0435\u043b?", "\u041b\u0438\u0448\u043d\u0438\u0439 \u043f\u0440\u043e\u0431\u0435\u043b?"), RussianTreePatterns.quotes.asymmetricalRule(Set.of("\u201d", "`", "\"")).message("\u041d\u0435\u043f\u0430\u0440\u043d\u044b\u0435 \u043a\u0430\u0432\u044b\u0447\u043a\u0438?"), FormattingIssues.joinAdjacentFixes(NodePattern.or(CommonPatterns.openingParen, RussianTreePatterns.definitelyOpeningQuotations).and(PairedPunctuation.Opening.checkSpace("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0440\u043e\u0431\u0435\u043b", "\u041b\u0438\u0448\u043d\u0438\u0439 \u043f\u0440\u043e\u0431\u0435\u043b")), NodePattern.or(CommonPatterns.closingParen, RussianTreePatterns.definitelyClosingQuotations).andNot(NodePattern.N.noSpaceAfter().inFormSequence(0, "\u2019", "\\d+")).and(PairedPunctuation.Closing.checkSpace("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0440\u043e\u0431\u0435\u043b", "\u041b\u0438\u0448\u043d\u0438\u0439 \u043f\u0440\u043e\u0431\u0435\u043b"))), FormattingIssues.multiWhiteSpace("\u041f\u043e\u0432\u0442\u043e\u0440 \u043f\u0440\u043e\u0431\u0435\u043b\u0430"), FormattingIssues.trailingComma(RussianTreePatterns.clause.noLemma("\u0437\u0434\u0440\u0430\u0432\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c|\u043f\u0440\u0438\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c|\u0436\u0435\u043b\u0430\u0442\u044c|\u043f\u043e\u0437\u0434\u0440\u0430\u0432\u043b\u044f\u0442\u044c|\u0436\u0434\u0430\u0442\u044c|\u0431\u043b\u0430\u0433\u043e\u0434\u0430\u0440\u0438\u0442\u044c|\u0431\u044b\u0442\u044c|\u043e\u0436\u0438\u0434\u0430\u0442\u044c"), "\u041d\u0435\u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043d\u043e\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435?"), FormattingIssues.wordSplittingHyphen(EXTRA_HYPHEN).andNot(hyphenAbbreviation).andNot(NodePattern.N.inFormSequence(1, "\u0431\u0440\u043e\u043d\u0445\u043e", "-")), FormattingIssues.singleHyphenWhitespace("\u041b\u0438\u0448\u043d\u0438\u0439 \u043f\u0440\u043e\u0431\u0435\u043b?", "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0440\u043e\u0431\u0435\u043b?", NodePattern.or(new NodePattern[0]), NodePattern.N.directlyAfter(CommonPatterns.severalDependents("appos").withDependent("appos", NodePattern.or(NodePattern.N.withDependent("punct", NodePattern.not(CommonPatterns.HYPHEN_LIKE_NODE)), NodePattern.N.withPrevSibling(NodePattern.PUNCT.andNot(CommonPatterns.HYPHEN_LIKE_NODE))).andNot(CommonPatterns.closestDepToHead))), hyphenPattern, NodePattern.or(new NodePattern[0])).directlyBefore(NodePattern.not(NodePattern.N.pos("CONJ")).noForm("\u0434\u043e|\u043a|\u043f\u043e")), FormattingIssues.sentenceStartingPunctuation("\u041b\u0438\u0448\u043d\u0438\u0439 \u0437\u043d\u0430\u043a \u043f\u0440\u0435\u043f\u0438\u043d\u0430\u043d\u0438\u044f \u0432 \u043d\u0430\u0447\u0430\u043b\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f?"), FormattingIssues.wordInternalPunctuation("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0440\u043e\u0431\u0435\u043b?", "").andNot(FormattingIssues.capitalizedDotCapitalized), FormattingIssues.joinedNumberWord("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0440\u043e\u0431\u0435\u043b?", "NN:(Name|Fam).*", word -> word.form().length() >= 4 || word.form().length() >= 2 && word.hasPos("CONJ|PREP*")), FormattingIssues.leadingHyphen(EXTRA_HYPHEN).andNot(compHyphen).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\u0430\u044f"))), FormattingIssues.noSpaceWithBrackets("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0440\u043e\u0431\u0435\u043b?"), FormattingIssues.excessiveEllipsis("\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043b\u0438\u043d\u043d\u043e\u0435 \u043c\u043d\u043e\u0433\u043e\u0442\u043e\u0447\u0438\u0435"));
    }

    private static Rule.PatternRule quotePunctuation() {
        String plainMsg = "\u0417\u043d\u0430\u043a\u0438 \u043f\u0440\u0435\u043f\u0438\u043d\u0430\u043d\u0438\u044f \u0441\u0442\u0430\u0432\u044f\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0435 \u043a\u0430\u0432\u044b\u0447\u0435\u043a";
        String abbrDotMsg = "\u041f\u043e\u0441\u043b\u0435 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0438\u0445 \u043a\u0430\u0432\u044b\u0447\u0435\u043a \u0441\u0442\u0430\u0432\u0438\u0442\u0441\u044f \u0442\u043e\u0447\u043a\u0430, \u0435\u0441\u043b\u0438 \u043f\u0435\u0440\u0435\u0434 \u043d\u0438\u043c\u0438 \u043e\u043d\u0430 \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0430 \u043a\u0430\u043a \u0447\u0430\u0441\u0442\u044c \u0441\u043e\u043a\u0440\u0430\u0449\u0435\u043d\u0438\u044f";
        return new Rule.PatternRule("Punctuation.QUOTE_PUNCTUATION", "\u041a\u0430\u0432\u044b\u0447\u043a\u0438 \u0438 \u0434\u0440\u0443\u0433\u0438\u0435 \u0437\u043d\u0430\u043a\u0438 \u043f\u0440\u0435\u043f\u0438\u043d\u0430\u043d\u0438\u044f", "\u0422\u043e\u0447\u043a\u0430, \u0437\u0430\u043f\u044f\u0442\u0430\u044f, \u0442\u043e\u0447\u043a\u0430 \u0441 \u0437\u0430\u043f\u044f\u0442\u043e\u0439, \u0434\u0432\u043e\u0435\u0442\u043e\u0447\u0438\u0435 \u0438 \u0442\u0438\u0440\u0435 \u0441\u0442\u0430\u0432\u044f\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0438\u0445 \u043a\u0430\u0432\u044b\u0447\u0435\u043a.\n<p>\n\u0415\u0441\u043b\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439/\u0432\u043e\u0441\u043a\u043b\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u043d\u0430\u043a \u0438 \u043c\u043d\u043e\u0433\u043e\u0442\u043e\u0447\u0438\u0435 \u043e\u0442\u043d\u043e\u0441\u044f\u0442\u0441\u044f \u043a \u0441\u043b\u043e\u0432\u0430\u043c, \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u043d\u044b\u043c \u0432 \u043a\u0430\u0432\u044b\u0447\u043a\u0438, \u0442\u043e \u043e\u043d\u0438 \u0441\u0442\u0430\u0432\u044f\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0438\u043c\u0438 \u043a\u0430\u0432\u044b\u0447\u043a\u0430\u043c\u0438.\n\u0415\u0441\u043b\u0438 \u0436\u0435 \u0432\u043e\u043f\u0440\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439/\u0432\u043e\u0441\u043a\u043b\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u043d\u0430\u043a \u0438 \u043c\u043d\u043e\u0433\u043e\u0442\u043e\u0447\u0438\u0435 \u043e\u0442\u043d\u043e\u0441\u044f\u0442\u0441\u044f \u043a\u043e \u0432\u0441\u0435\u043c\u0443 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044e \u0432\u043c\u0435\u0441\u0442\u0435 \u0441\u043e \u0441\u043b\u043e\u0432\u0430\u043c\u0438, \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u043d\u044b\u043c\u0438 \u0432 \u043a\u0430\u0432\u044b\u0447\u043a\u0438, \u0442\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u043d\u044b\u0435 \u0437\u043d\u0430\u043a\u0438 \u0441\u0442\u0430\u0432\u044f\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0438\u0445 \u043a\u0430\u0432\u044b\u0447\u0435\u043a.\n<p>\n\u0415\u0441\u043b\u0438 \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0438\u043c\u0438 \u043a\u0430\u0432\u044b\u0447\u043a\u0430\u043c\u0438 \u0441\u0442\u043e\u0438\u0442 \u0432\u043e\u043f\u0440\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439/\u0432\u043e\u0441\u043a\u043b\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u043d\u0430\u043a, \u0442\u043e \u043f\u043e\u0441\u043b\u0435 \u043a\u0430\u0432\u044b\u0447\u0435\u043a \u043e\u043d \u043d\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u0435\u0442\u0441\u044f.\n\u041d\u0435\u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0435 \u0436\u0435 \u0437\u043d\u0430\u043a\u0438, \u0435\u0441\u043b\u0438 \u043e\u043d\u0438 \u0442\u0440\u0435\u0431\u0443\u044e\u0442\u0441\u044f \u043f\u043e \u0443\u0441\u043b\u043e\u0432\u0438\u044f\u043c \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430, \u0441\u0442\u0430\u0432\u044f\u0442\u0441\u044f \u0438 \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0438\u0445 \u043a\u0430\u0432\u044b\u0447\u0435\u043a\n<p>\n\u0422\u043e\u0447\u043a\u0430 \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0438\u0445 \u043a\u0430\u0432\u044b\u0447\u0435\u043a, \u0435\u0441\u043b\u0438 \u043f\u0435\u0440\u0435\u0434 \u043d\u0438\u043c\u0438 \u043e\u043d\u0430 \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0430 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0437\u043d\u0430\u043a\u0430, \u043e\u0431\u043e\u0437\u043d\u0430\u0447\u0430\u044e\u0449\u0435\u0433\u043e \u0441\u043e\u043a\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u0441\u043b\u043e\u0432\u0430.\n", "http://old-rozental.ru/punctuatio.php?sid=178", () -> {
            NodePattern moveOutside = NodePattern.or(NodePattern.N.form("[.,;:]"), RussianTreePatterns.dashes);
            return NodePattern.or(FormattingIssues.punctQuoteSentenceEnd.andOr(moveOutside.withNeighbor(2, NodePattern.N.form("[?!]").message("\u041b\u0438\u0448\u043d\u0438\u0439 \u0437\u043d\u0430\u043a \u043f\u0440\u0435\u043f\u0438\u043d\u0430\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u0434 \u00ab$_\u00bb \u0432\u043d\u0443\u0442\u0440\u0438 \u043a\u0430\u0432\u044b\u0447\u0435\u043a")).correct(NodeCorrector.replace("")), NodePattern.N.form("[?!]").withNeighbor(2, NodePattern.N.sameWordAs(-2).correct(NodeCorrector.replace(""))).message("\u0417\u043d\u0430\u043a \u00ab$_\u00bb \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u0442\u044c\u0441\u044f")), FormattingIssues.punctBeforeQuote(abbrPattern).and(CommonPatterns.dot).withNeighbor(2, NodePattern.PUNCT).correct(NodeCorrector.replace("")).message("\u041b\u0438\u0448\u043d\u044f\u044f \u0442\u043e\u0447\u043a\u0430 \u0432 \u043a\u0430\u0432\u044b\u0447\u043a\u0430\u0445?"), FormattingIssues.missingSentenceDotAfterQuotedAbbreviation(abbrPattern).message(abbrDotMsg), FormattingIssues.movePunctAfterQuote(abbrPattern).and(moveOutside).andNot(NodePattern.N.directlyAfter(CommonPatterns.latin)).message(plainMsg));
        }, new Example("\u042f \u0441\u043a\u0430\u0437\u0430\u043b \u00ab<b>\u043f\u0440\u0435\u043a\u0440\u0430\u0441\u043d\u043e.\u00bb</b>", "\u042f \u0441\u043a\u0430\u0437\u0430\u043b \u00ab<b>\u043f\u0440\u0435\u043a\u0440\u0430\u0441\u043d\u043e\u00bb.</b>"), new Example(" \u042d\u0442\u043e \u0441\u043b\u0443\u0447\u0438\u043b\u043e\u0441\u044c \u00ab\u0432 80 \u0433. \u043d. <b>\u044d.\u00bb</b>", " \u042d\u0442\u043e \u0441\u043b\u0443\u0447\u0438\u043b\u043e\u0441\u044c \u00ab\u0432 80 \u0433. \u043d. <b>\u044d.\u00bb.</b>"));
    }

    private static NodePattern excessiveConjunctionComma() {
        return nestedCoordinatedPhrase.withPhraseStart(unmandatedComma.directlyBefore(NodePattern.N.includeIntoReport()).correct(NodeCorrector.replace("")).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHead(withKakMark.withDependent("punct", CommonPatterns.comma.beforeHead())))).and(CommonPatterns.reportWithPrevWord)).andOr(RussianTreePatterns.clause.withHead(RussianTreePatterns.clause).message(EXTRA_SUBORDINATE_COORDINATION_COMMA), NodePattern.N.message("\u041b\u0438\u0448\u043d\u044f\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043c\u0435\u0436\u0434\u0443 \u043e\u0434\u043d\u043e\u0440\u043e\u0434\u043d\u044b\u043c\u0438 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f\u043c\u0438?"));
    }

    private static NodePattern missingCoordinationComma() {
        NodePattern commaLike = NodePattern.or(RussianTreePatterns.commaOrStronger, RussianTreePatterns.dashes, PairedPunctuation.smileyParen);
        NodePattern invertedSubordination = NodePattern.N.withHead(NodePattern.N.withDependent("advmod", CommonPatterns.firstChildPhrase.and(RussianTreePatterns.whWord)));
        NodePattern misparsedArgumentConj = NodePattern.N.onlyPos("P?NN.*").noDependents("aux.*|cop").withPrevSibling(NodePattern.N.withHeadRelation("i?obj|obl.*|nsubj.*").afterHead());
        NodePattern sameMarkCoordination = NodePattern.N.withDependent("mark", NodePattern.N.markAs("ClauseMark")).withHead(CommonPatterns.possiblySkipDown("conj", NodePattern.N.withDependent("mark", NodePattern.N.sameWordAs("ClauseMark"))));
        NodePattern verbCoordinationBeforeSubj = NodePattern.markedNodeMatches("Subj2", NodePattern.N.afterHead()).withDependent("cc", andOr).withPrevSibling(NodePattern.N.afterHead().pos("VB.*").withHeadRelation("conj").noDependents("nsubj.*|csubj.*").noDependents(NodePattern.N.afterHead()));
        NodePattern clause2 = RussianTreePatterns.clause.afterHead().and(NodePattern.or(NodePattern.N.withDependent("nsubj.*", NodePattern.N.markAs("Subj2")).andNot(misparsedArgumentConj), NodePattern.N.pos("PRDC"), NodePattern.N.noDependents("cc"), NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("\u0443"))).lemma("\u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c\u0441\u044f|\u0441\u043b\u0443\u0447\u0438\u0442\u044c\u0441\u044f"), NodePattern.N.withDependent("iobj", Case.D.posPattern).lemma("\u0441\u0434\u0435\u043b\u0430\u0442\u044c\u0441\u044f"))).andOr(NodePattern.not(NodePattern.N.withHeadRelation("advcl")), NodePattern.N.withDependent("mark", CommonPatterns.firstChildPhrase), invertedSubordination).andNot(sameMarkCoordination).andNot(verbCoordinationBeforeSubj).and((c2, m) -> ((StreamEx)Objects.requireNonNull(c2.head()).nextUntil(c2).filter(RussianTreePatterns.anyQuotation::matches)).count() % 2L == 0L ? m : null);
        NodePattern sharedCopulaHead = NodePattern.N.noPos("VB.*").withDependent("nsubj.*", NodePattern.N.afterHead()).andOr(NodePattern.markedNodeMatches("Clause2", NodePattern.N.noDependents("nsubj.*", Case.Nom.posPattern)), NodePattern.N.pos("ADV"));
        NodePattern question = RussianTreePatterns.whPhrase;
        NodePattern questionCoordination = NodePattern.ROOT.withDependent("punct", NodePattern.N.form(".*\\?.*")).and(question).and(NodePattern.markedNodeMatches("Clause2", question.withDependent("cc")));
        NodePattern rootClause = NodePattern.ROOT.noDependents("conj", CommonPatterns.latin).withDependent("nsubj.*", NodePattern.N.markAs("Subj")).andOr(NodePattern.N.noDependents("obj.*|obl|advcl|advmod|parataxis", NodePattern.N.before("Subj")).noDependents("cc", NodePattern.N.withDependent(".*").before("Subj")).andNot(sharedCopulaHead), NodePattern.N.noDependents("conj", NodePattern.N.withDependent("cc", andOr))).andNot(questionCoordination);
        NodePattern clause1 = NodePattern.or(rootClause, NodePattern.N.withHead("conj", rootClause).noDependents("nsubj.*|csubj.*"));
        return clause2.markAs("Clause2").andNot(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.form("\\?"))).withPhraseStart(andOr).noDependents("ccomp")).withHead("conj|ccomp|advcl|parataxis", clause1).withPhraseStart(NodePattern.not(NodePattern.PUNCT).includeIntoReport().noForm("\u043b\u0438\u0431\u043e").directlyAfter(NodePattern.not(sentenceBoundary).andNot(NodePattern.PUNCT).andNot(RussianTreePatterns.foreignWord).includeIntoReport().andNot(NodePattern.N.pos("ADV").withHeadRelation("conj").withOnlyDependents(NodePattern.N.withHeadRelation("punct|cc")).withDependent("punct", CommonPatterns.comma.beforeHead()))).and((node, match) -> {
            Node prev = ((StreamEx)node.back().skip(1L)).findFirst(n -> !allowedBeforeConj.matches((Node)n)).orElse(null);
            if (prev == null || commaLike.matches(prev)) {
                return null;
            }
            if (CommonPatterns.capitalizedMiddle.matches(node)) {
                return PairedPunctuation.smileyParen.matches(prev) || node.posReadings().isEmpty() ? null : PunctuationRules.suggestDot(match, prev);
            }
            return match.withCorrector(NodeCorrector.insertAfter(prev, ",")).withMessage(MISSING_COORDINATION_COMMA);
        })).andNot(NodePattern.N.withDependent("cop").noDependents("nsubj.*|csubj.*|cc").trace("own cop without subj"));
    }

    private static NodeMatch suggestDot(NodeMatch match, Node prev) {
        return match.withCorrector(NodeCorrector.insertAfter(prev, ".")).withMessage("\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0442\u043e\u0447\u043a\u0430 \u043c\u0435\u0436\u0434\u0443 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u043c\u0438?").withSuppressableKind(NodeMatch.SuppressableKind.UNDECORATED_SENTENCE_SEPARATION);
    }

    private static NodePattern whetherSubordinationComma() {
        return NodePattern.N.form("\u043b\u0438").withHeadRelation("advmod").directlyAfter(NodePattern.N.noDependents(NodePattern.N.beforeHead()).markAs("Start")).directlyBefore(NodePattern.N.inPhrase(NodePattern.or(NodePattern.N.pos("VB.*").andNot(NodePattern.N.before("Start")).afterHead().withHeadRelation("acl").withPhraseEnd(NodePattern.N.markAs("End")), NodePattern.N.withHead("cop", NodePattern.N.alreadyMarkedAs("Start").withPhraseEnd(NodePattern.N.markAs("End")))))).and((node, match) -> PunctuationRules.surroundWithCommas(match, match.getMarkedNode("Start"), match.getMarkedNode("End"), false, BEFORE_SUBORDINATE_MSG, AFTER_SUBORDINATE_MSG, AROUND_SUBORDINATE_MSG));
    }

    private static NodePattern comparativeSubordinationComma() {
        return comparativeSubordinateClause.and((node, match) -> PunctuationRules.surroundWithCommas(match, PunctuationRules.surroundingPhraseStart(node), node.phraseEnd(), false, BEFORE_SUBORDINATE_MSG, AFTER_SUBORDINATE_MSG, AROUND_SUBORDINATE_MSG));
    }

    private static NodePattern whSubordinationComma() {
        NodePattern afterPunctOrStart = NodePattern.or(NodePattern.N.directlyAfter(NodePattern.PUNCT), CommonPatterns.firstPhrase);
        NodePattern toIgnoreWh = NodePattern.or((NodePattern[])ComplexConjunctions.allComplexConjunctions().map(words -> NodePattern.N.inFormSequence(((String[])words).length - 1, (String)words).withNeighbor(-((String[])words).length + 1, afterPunctOrStart)).toArray(NodePattern[]::new));
        NodePattern afterAnotherConjunction = NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.pos("CONJ"), NodePattern.N.form("\u043f\u043e\u044d\u0442\u043e\u043c\u0443")));
        NodePattern notConj = NodePattern.N.withHead("fixed", NodePattern.N.form("\u043f\u043e\u043a\u0430"));
        NodePattern pairingConjunctionPart = NodePattern.N.form("\u0442\u043e|\u0442\u0430\u043a|\u0442\u043e\u0433\u0434\u0430|\u0437\u043d\u0430\u0447\u0438\u0442").andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)).markAs("ConjPart").inPhrase(RussianTreePatterns.clause.after("ConjPart"));
        NodePattern withPairingConjunctionPart = NodePattern.N.beforeHead().andOr(NodePattern.N.withHead(NodePattern.N.withDependent("mark|discourse", pairingConjunctionPart)), NodePattern.N.withPhraseEnd(pairingConjunctionPart));
        NodePattern withWhereMark = NodePattern.N.withDependent("mark|advmod", NodePattern.N.form("\u0433\u0434\u0435"));
        NodePattern mainClause = NodePattern.not(NodePattern.N.form("\u0432\u0441[\u0435\u0451]")).andNot(NodePattern.N.inPhrase(NodePattern.ROOT.pos("ABR.*"))).andOr(NodePattern.N.noMatchUntil("Subordinate", CommonPatterns.closingParen), NodePattern.N.anyMatchUntil("Subordinate", CommonPatterns.openingParen));
        NodePattern unsplittablePhrase = NodePattern.or(whatWillBeVerb2.andOr(NodePattern.N.withHead("ccomp", whatWillBeVerb1), NodePattern.N.withHead("acl", NodePattern.not(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl(:agent)?|nmod|compound"))))), NodePattern.N.inFormSequence(1, "\u043a\u0430\u043a", "\u0435\u0441\u0442\u044c|\u0441\u043b\u0435\u0434\u0443\u0435\u0442"), NodePattern.or(NodePattern.N.pos("VB:INF.*"), NodePattern.N.lemma("\u0445\u043e\u0442\u0435\u0442\u044c")).directlyAfter(RussianTreePatterns.whWord)).andOr(NodePattern.N.noDependents(NodePattern.N.afterHead()), NodePattern.N.directlyBefore(NodePattern.PUNCT));
        NodePattern ifWhen = NodePattern.N.form("\u0435\u0441\u043b\u0438|\u043a\u043e\u0433\u0434\u0430");
        NodePattern whichIf = ifWhen.directlyAfter(NodePattern.N.form("\u043a\u043e\u0442\u043e\u0440.*"));
        NodePattern possiblyMisattachedPhraseStart = NodePattern.or(NodePattern.N.withHead("cc", RussianTreePatterns.finiteVerb.markAs("Finite").withHead("conj", NodePattern.or(RussianTreePatterns.infinitive, NodePattern.N.noPos("VB.*").withDependent("advcl", RussianTreePatterns.finiteVerb.before("Finite").andNot(NodePattern.N.before("Subordinate")))))), NodePattern.ROOT.noPos().andNot(CommonPatterns.letterWord), NodePattern.N.withHead("case", RussianTreePatterns.foreignWord));
        NodePattern missingSentenceBoundary = CommonPatterns.capitalizedMiddle.noPos("NN:Name:.*").directlyAfter(NodePattern.not(NodePattern.PUNCT).andNot(sentenceBoundary));
        NodePattern coordinatedWithMisattachedNP = NodePattern.N.pos("VB.*|PRDC").withDependent("conj", NodePattern.N.pos("P?NN.*").withDependent("cc", andOr).andNot(RussianTreePatterns.clause).markAs("NP")).andOr(NodePattern.N.withDependent("mark", NodePattern.N.form("\u043a\u043e\u0433\u0434\u0430")).and(NodePattern.markedNodeMatches("NP", NodePattern.N.withDependent("case"))), NodePattern.N.withHead("acl.*", NodePattern.N.pos("P?NN.*")));
        NodePattern simpleCorrelative = NodePattern.N.beforeHead().withHead("csubj|ccomp", NodePattern.N.noDependents("nsubj.*|det|expl")).withDependent(".*", CommonPatterns.firstChildPhrase.andOr(RussianTreePatterns.whWord, RussianTreePatterns.whPhrase)).withPhraseStart(CommonPatterns.skipForward(NodePattern.PUNCT, NodePattern.N.markAs("CorStart"))).withPhraseEnd(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.N.noMatchUntil("CorStart", NodePattern.PUNCT)));
        return RussianTreePatterns.clause.markAs("Subordinate").andOr(NodePattern.N.withHead("advcl|acl(:relcl)?|ccomp|parataxis", mainClause).andNot(CommonPatterns.possiblySkipUp(".*", GrammarRules.aclAfterHead.and(GrammarRules.finiteTsa))), NodePattern.N.withHead("csubj", mainClause).withDependent("nsubj").withPhraseEnd(NodePattern.not(RussianTreePatterns.dashes).andNot(NodePattern.N.directlyBefore(RussianTreePatterns.dashes)))).andNot(NodePattern.N.withDependent("mark", CommonPatterns.capitalizedMiddle.directlyAfter(NodePattern.or(RussianTreePatterns.definitelyClosingQuotations, CommonPatterns.closingParen).directlyAfter(NodePattern.N.form("."))))).andNot(unsplittablePhrase).andNot(kakPopalo).andNot(NodePattern.N.withDependent("cc", CommonPatterns.firstChildPhrase)).andNot(coordinatedWithMisattachedNP).andNot(NodePattern.N.withDependent("mark", NodePattern.N.withDependent("punct", CommonPatterns.comma).beforeHead())).andNot(NodePattern.N.pos("VB:INF.*").withHeadRelation("acl").noDependents("mark", NodePattern.N.form("\u0447\u0442\u043e"))).andNot(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(CommonPatterns.latin.and(CommonPatterns.lastWord)))).andNot(NodePattern.N.pos("VB:INF.*").withDependent("punct", CommonPatterns.DASH_NODE.afterHead())).andNot(NodePattern.N.beforeHead().withPhraseEnd(NodePattern.or(CommonPatterns.DASH_NODE, NodePattern.N.directlyBefore(CommonPatterns.DASH_NODE))).andNot(NodePattern.N.withPhraseStart(CommonPatterns.comma.directlyAfter(NodePattern.N.form("\u0442\u043e"))))).and((node, match) -> {
            Node wh;
            Node node2 = wh = RussianTreePatterns.whWord.matches(node) ? node : RussianTreePatterns.findWh(node);
            if (notConj.matches(wh)) {
                return null;
            }
            Node mark = StreamEx.of(node.findDependents("mark")).findFirst(ifWhen::matches).orElse(null);
            if ((wh == null || toIgnoreWh.matches(wh)) && mark == null) {
                return null;
            }
            if (whichIf.matches(mark)) {
                return null;
            }
            if (toIgnoreWh.matches(mark)) {
                return null;
            }
            boolean afterConj = afterAnotherConjunction.matches(mark);
            if (afterConj && withPairingConjunctionPart.matches(node)) {
                return null;
            }
            Node start = PunctuationRules.surroundingPhraseStart(node);
            if (!NodePattern.PUNCT.matches(start) && CommonPatterns.firstWord.pos("CONJ").matches(start.prevNode())) {
                start = start.prevNode();
            }
            boolean allowDashAfter = RussianTreePatterns.dashes.matches(start) && !CommonPatterns.comma.matches(start.prevNode()) || CommonPatterns.firstWord.matches(start) || mark != null || withHowMark.matches(node) || withWhereMark.matches(node);
            Node end = node.phraseEnd();
            if (mark != null && pairingConjunctionPart.matches(end) && !RussianTreePatterns.clause.matches(end)) {
                end = Objects.requireNonNull(end.prevNode());
            }
            if (end.nextNode() != null && possiblyMisattachedPhraseStart.match(end.nextNode(), match) != null) {
                return null;
            }
            if (missingSentenceBoundary.matches(start)) {
                return PunctuationRules.suggestDot(match, start.neighbor(-1));
            }
            if (missingSentenceBoundary.matches(end.nextNode())) {
                return PunctuationRules.suggestDot(match, end);
            }
            match = match.withTouchedNodes(wh, mark);
            PhraseCommaChange change = CommaLicense.forRange(start, end, CommaLicense.NeedCommas.around).addMissingCommas(commaOrOpening, allowDashAfter ? NodePattern.or(commaOrClosing, RussianTreePatterns.dashes) : commaOrClosing);
            if (change == null) {
                return null;
            }
            match = change.highlightAndCorrect(match).withMessage(change.selectMessage(BEFORE_SUBORDINATE_MSG, AFTER_SUBORDINATE_MSG, AROUND_SUBORDINATE_MSG));
            if (afterConj && change.changeAfter() == null && NodePattern.N.beforeHead().matches(node)) {
                Node anchor = end.skipForward(NodePattern.N.directlyBefore(NodePattern.PUNCT)::matches);
                if (anchor != null) {
                    match = match.withCorrector(NodeCorrector.insertAfter(anchor, " \u0442\u043e")).withReportedRange(CommonPatterns.withPrevWord(anchor), end.tree());
                }
            }
            if (change.changeBefore() != null && NodePattern.N.inFormSequence(0, "\u0442\u0430\u043a", "\u0447\u0442\u043e").matches(start)) {
                match = match.withCorrector(NodeCorrector.insertAfter(start, ",").join(change.changeAfter())).withReportedNodes(start, start.neighbor(1));
            }
            return match;
        }).andNot(NodePattern.N.withPhraseStart(NodePattern.or(NodePattern.N.inFormSequence(3, ComplexConjunctions.nesmotryaNaToChto), NodePattern.N.directlyAfter(NodePattern.N.form("\u0441\u043c\u043e\u0442\u0440\u044f")))).trace("\u0441\u043c\u043e\u0442\u0440\u044f/\u043d\u0435\u0441\u043c\u043e\u0442\u0440\u044f")).andNot(simpleCorrelative.trace("correlative construction"));
    }

    @Nullable
    private static NodeMatch surroundWithCommas(NodeMatch match, Node start, Node end, boolean allowDashAfter, String missingBeforeMsg, String missingAfterMsg, String missingBothMsg) {
        return CommaLicense.surroundWithCommas(match, start, end, missingBeforeMsg, missingAfterMsg, missingBothMsg, commaOrOpening, allowDashAfter ? NodePattern.or(commaOrClosing, RussianTreePatterns.dashes) : commaOrClosing);
    }

    private static Node surroundingPhraseStart(Node node) {
        Node start = node.phraseStart();
        Node prev = start.prevNode();
        if (prev != null && !NodePattern.PUNCT.matches(start) && (node.hasHeadRelation("advcl|csubj") && prev.hasForm("[\u0430\u0438]") || startAdjoiningConjunction.matches(prev))) {
            start = prev;
            prev = start.prevNode();
        }
        if (prev != null && prev.hasForm("\u043d\u0443")) {
            start = prev;
        } else if (toJest.matches(prev)) {
            start = prev.prevNode();
        }
        return start;
    }

    private static NodeMatch removeCommas(NodeMatch match, @NotNull Node start, @NotNull Node end) {
        PhraseCommaChange change = PhraseCommaChange.removeSurroundingCommas(start, end, unmandatedComma);
        return change == null ? null : change.highlightAndCorrect(match);
    }

    private static NodePattern vocativeComma() {
        return NodePattern.N.withHead("vocative", NodePattern.N).pos("NN:.*").noPos("NN:Inanim.*").noDependents("appos|conj", NodePattern.N.pos("PNN.*")).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\u0432\u043e\u043d"))).withPhraseEnd(NodePattern.not(RussianTreePatterns.dashes)).and((node, match) -> PunctuationRules.surroundWithCommas(match, PunctuationRules.surroundingPhraseStart(node), node.phraseEnd(), false, BEFORE_VOCATIVE_COMMA, AFTER_VOCATIVE_COMMA, AROUND_VOCATIVE_COMMAS));
    }

    private static NodePattern conjunctionComma() {
        return RussianTreePatterns.aNo.includeIntoReport().withHead("cc", NodePattern.N.withHead("conj", NodePattern.N.pos(".*"))).directlyAfter(NodePattern.not(NodePattern.PUNCT).andNot(sentenceBoundary).andNot(allowedBeforeConj).andNot(NodePattern.N.beforeHead()).includeIntoReport()).correct(NodeCorrector.insertAfterPrevious(",")).message("\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u0441\u043e\u044e\u0437\u043e\u043c \u00ab$_\u00bb?");
    }

    private static List<CommaLicense> licensedCommas(Node node) {
        ArrayList<CommaLicense> result = new ArrayList<CommaLicense>(IntroductoryConstructions.analyze(node));
        if (licenseCommasAround.matches(node)) {
            result.add(CommaLicense.forPhrase(node, CommaLicense.NeedCommas.around));
        }
        if (licenseCommasBefore.matches(node)) {
            result.add(CommaLicense.forPhrase(node, CommaLicense.NeedCommas.before));
        }
        return result;
    }

    private static NodePattern excessiveComma() {
        NodePattern emphasizedConjComma = CommonPatterns.comma.directlyBefore(NodePattern.N.form("\u0447\u0442\u043e\u0431\u044b?|\u043a\u043e\u0433\u0434\u0430|\u0435\u0441\u043b\u0438")).directlyAfter(RussianTreePatterns.emphasis).reportEverythingTouched().message("\u041b\u0438\u0448\u043d\u044f\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043c\u0435\u0436\u0434\u0443 \u0443\u0441\u0438\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0441\u043b\u043e\u0432\u043e\u043c \u0438 \u0441\u043e\u044e\u0437\u043e\u043c?").and((comma, match) -> match.withCorrector(NodeCorrector.replace(comma, "").join(CommaLicense.addCommaBefore(comma.prevNode(), commaOrOpening))));
        NodePattern nonIntroPhrase = NodePattern.or(NodePattern.or(kakPopalo, NodePattern.N.directlyBefore(kakPopalo)).reportEverythingTouched(ReportingKind.Hover).withHeadRelation("advmod|acl.*").message("\u00ab$Wh $Head\u00bb \u2014 \u0446\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e \u0441\u043c\u044b\u0441\u043b\u0443 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u043e\u0431\u043e\u0441\u043e\u0431\u043b\u044f\u0435\u0442\u0441\u044f"), whatsNeeded.message("\u041d\u0435\u0434\u0435\u043b\u0438\u043c\u043e\u0435 \u0441\u043e\u0447\u0435\u0442\u0430\u043d\u0438\u0435 \u00ab$Wh \u043d\u0443\u0436\u043d\u043e\u00bb \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u043e\u0431\u043e\u0441\u043e\u0431\u043b\u044f\u0435\u0442\u0441\u044f"), whatWillBe.withNeighbor(-3, NodePattern.N.markAs("Verb1")).message("\u0424\u0440\u0430\u0437\u0435\u043e\u043b\u043e\u0433\u0438\u0437\u043c \u00ab$Verb1 \u0447\u0442\u043e $_\u00bb \u043d\u0435 \u043e\u0431\u043e\u0441\u043e\u0431\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.withHeadRelation("obl").withDependent("case", NodePattern.N.inFormSequence(0, "\u0432", "\u0441\u0432\u044f\u0437\u0438", "\u0441")).message("\u00ab\u0432 \u0441\u0432\u044f\u0437\u0438 \u0441...\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.or(NodePattern.N.inFormSequence(1, "\u0432", "\u043e\u0441\u043d\u043e\u0432\u043d\u043e\u043c").withHead("obl|parataxis", NodePattern.N.pos("VB.*")).message("\u00ab\u0432 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u043c\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.form("\u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435|\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438|\u0438\u0442\u043e\u0433\u0435|\u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e\u0441\u0442\u0438|\u043e\u0441\u0442\u0430\u043b\u044c\u043d\u043e\u043c").withDependent("case", NodePattern.N.form("\u0432\u043e?")).message("\u00ab\u0432 $_\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.inFormSequence(2, "\u0432\u043e?", ".*[\u043e\u0435]\u043c", "\u0441\u043b\u0443\u0447\u0430\u0435").markAs("Case").andOr(NodePattern.N.withHead("parataxis|obl", NodePattern.or(RussianTreePatterns.finiteVerb, NodePattern.N.pos("ADJ:Short.*|PT_Short.*"), NodePattern.N.withDependent("nsubj", NodePattern.N.after("Case")))), NodePattern.N.withNeighbor(-2, NodePattern.N.withHeadRelation("cc"))).withNeighbor(-2, NodePattern.N.markAs("Prep")).withNeighbor(-1, NodePattern.N.markAs("Adj")).message("\u00ab$Prep $Adj $_\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.inFormSequence(0, "\u0432\u043e?", ".*\u0443\u044e", "\u043e\u0447\u0435\u0440\u0435\u0434\u044c", ",").withNeighbor(1, NodePattern.N.markAs("Adj")).message("\u00ab$_ $Adj \u043e\u0447\u0435\u0440\u0435\u0434\u044c\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.inFormSequence(0, "\u0432\u043c\u0435\u0441\u0442\u0435", "\u0441", "\u0442\u0435\u043c").message("\u00ab\u0432\u043c\u0435\u0441\u0442\u0435 \u0441 \u0442\u0435\u043c\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.inFormSequence(1, "\u0432", "\u0431\u043e\u043b\u044c\u0448\u0438\u043d\u0441\u0442\u0432\u0435", "\u0441\u0432\u043e[\u0435\u0451]\u043c").message("\u00ab\u0432 \u0431\u043e\u043b\u044c\u0448\u0438\u043d\u0441\u0442\u0432\u0435 \u0441\u0432\u043e\u0451\u043c\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.inFormSequence(1, "\u043f\u0440\u0438", "\u044d\u0442\u043e\u043c").withHead("obl|parataxis", RussianTreePatterns.clause).message("\u00ab\u043f\u0440\u0438 \u044d\u0442\u043e\u043c\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.form("\u0432\u0440\u043e\u0434\u0435").withHeadRelation("parataxis").message("\u00ab\u0432\u0440\u043e\u0434\u0435\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0441\u043b\u043e\u0432\u043e, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.form("\u043f\u0440\u0438\u0447[\u0435\u0451]\u043c|\u0430\u043d\u0430\u043b\u043e\u0433\u0438\u0447\u043d\u043e|\u0431\u0443\u043a\u0432\u0430\u043b\u044c\u043d\u043e|\u0441\u043f\u0435\u0440\u0432\u0430|\u0441\u043d\u0430\u0447\u0430\u043b\u0430").message("\u00ab$_\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0441\u043b\u043e\u0432\u043e, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.inFormSequence(0, "\u0442\u0435\u043c", "\u043d\u0435", "\u043c\u0435\u043d\u0435\u0435").message("\u00ab\u0442\u0435\u043c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.form("\u0442\u0430\u043a\u0436\u0435|\u0432\u0434\u043e\u0431\u0430\u0432\u043e\u043a|\u0432\u0434\u0440\u0443\u0433|\u043e\u0434\u043d\u0430\u0436\u0434\u044b").withOnlyDependents(NodePattern.PUNCT).message("\u00ab$_\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0441\u043b\u043e\u0432\u043e, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.withDependent("case", NodePattern.N.form("\u043d\u0430")).andOr(NodePattern.N.form("\u0441\u043b\u0443\u0447\u0430\u0439").withHeadRelation("parataxis"), NodePattern.N.form("\u043c\u043e\u043c\u0435\u043d\u0442")).message("\u00ab\u043d\u0430 \u043a\u0430\u043a\u043e\u0439-\u043b\u0438\u0431\u043e $_\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.form("\u043e\u0434\u043d\u0430\u043a\u043e").and(odnakoStart).message("\u00ab\u043e\u0434\u043d\u0430\u043a\u043e\u00bb \u0432 \u043d\u0430\u0447\u0430\u043b\u0435 \u0444\u0440\u0430\u0437\u044b \u043e\u0431\u044b\u0447\u043d\u043e \u043d\u0435\u0441\u0451\u0442 \u0441\u043c\u044b\u0441\u043b \u00ab\u043d\u043e\u00bb \u0438 \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.inFormSequence(2, "\u043f\u043e", "-", "\u043f\u0440\u0435\u0436\u043d\u0435\u043c\u0443").message("\u00ab\u043f\u043e-\u043f\u0440\u0435\u0436\u043d\u0435\u043c\u0443\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0441\u043b\u043e\u0432\u043e, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.inFormSequence(0, "\u043f\u043e\u0447\u0435\u043c\u0443", "-", "\u0442\u043e").message("\u00ab\u043f\u043e\u0447\u0435\u043c\u0443-\u0442\u043e\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0441\u043b\u043e\u0432\u043e, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.inFormSequence(1, "\u043f\u043e", "\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0443").message("\u00ab\u043f\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0443\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), toJest.message("\u0421\u043e\u044e\u0437 \u00ab\u0442\u043e \u0435\u0441\u0442\u044c\u00bb \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.inFormSequence(3, "\u0432", "\u0442\u043e", "\u0436\u0435", "\u0432\u0440\u0435\u043c\u044f").message("\u00ab\u0432 \u0442\u043e \u0436\u0435 \u0432\u0440\u0435\u043c\u044f\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.N.inFormSequence(1, "\u0441", "\u0442\u0435\u0447\u0435\u043d\u0438\u0435\u043c", "\u0432\u0440\u0435\u043c\u0435\u043d\u0438").message("\u00ab\u0441 \u0442\u0435\u0447\u0435\u043d\u0438\u0435\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u0438\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f")).markAs("NeVvod").andNot(NodePattern.N.beforeHead().withHead(RussianTreePatterns.clause.noHeadRelation("xcomp").afterHead().andNot(NodePattern.N.directlyBefore(CommonPatterns.comma)).andNot(NodePattern.N.after(CommonPatterns.comma.after("NeVvod"))))));
        NodePattern nonIntroExact = NodePattern.N.inFormSequence(0, "\u0432\u0441[\u0435\u0451]", "-", "\u0442\u0430\u043a\u0438").message("\u00ab\u0432\u0441\u0451-\u0442\u0430\u043a\u0438\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0441\u043b\u043e\u0432\u043e, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f").and((node, match) -> PunctuationRules.removeCommas(match, node, node.neighbor(2)));
        NodePattern subjVerb = NodePattern.N.directlyBefore(NodePattern.N.inPhrase(NodePattern.N.pos("VB:(Real|Past|Fut).*").markAs("Verb"))).and(NodePattern.markedNodeMatches("Verb", NodePattern.N.after("Comma").andNot(NodePattern.N.withDependent(".*", RussianTreePatterns.whWord.before("Comma")).withDependent("punct", NodePattern.N.form(".*\\?.*")).trace("\u043f\u043e\u0435\u0437\u0434\u0430 \u043a\u0430\u043a, \u0445\u043e\u0434\u044f\u0442?")))).directlyAfter(NodePattern.N.inPhrase(NodePattern.N.before("Comma").withHead("nsubj.*", NodePattern.or(NodePattern.N.alreadyMarkedAs("Verb"), NodePattern.N.withDependent("cop|aux.*", NodePattern.N.alreadyMarkedAs("Verb")))).withPhraseEnd(NodePattern.not(NodePattern.N.after("Comma"))).reportRangeTo("Comma", ReportingKind.Hover).and((node, match) -> ((StreamEx)node.nextUntil(match.getMarkedNode("Verb")).filter(CommonPatterns.comma::matches)).count() == 1L ? match : null).noDependents("appos", CommonPatterns.phraseStartsWithComma))).and(CommonPatterns.reportWithPrevWord).message(SUBJ_PRED_COMMA_MSG);
        NodePattern objPred = NodePattern.N.directlyBefore(NodePattern.N.inPhrase(NodePattern.N.pos("PRDC").markAs("Predicate").after("Comma"))).directlyAfter(NodePattern.N.includeIntoReport().inPhrase(Case.V.posPattern.before("Comma").withHead("det|obj", NodePattern.N.alreadyMarkedAs("Predicate")))).andNot(NodePattern.N.directlyAfter(NodePattern.N.inPhrase(NodePattern.N.withDependent("punct", NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("discourse")))))).message("\u041b\u0438\u0448\u043d\u044f\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f?");
        NodePattern xcomp = NodePattern.N.directlyBefore(RussianTreePatterns.infinitive.withHead("xcomp", NodePattern.N.before("Comma").noDependents("obl", NodePattern.N.afterHead())).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\u043b[\u0438\u044c]"))).noDependents("conj", NodePattern.N.withDependent("cc", NodePattern.N.form("\u0438\u043b\u0438").beforeHead())).includeIntoReport(ReportingKind.Hover)).and(CommonPatterns.reportWithPrevWord).message("\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u0433\u043b\u0430\u0433\u043e\u043b\u043e\u043c-\u0434\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435\u043c \u043d\u0435 \u043d\u0443\u0436\u043d\u0430?");
        NodePattern xcompVerbNsubj = NodePattern.N.directlyAfter(NodePattern.N.includeIntoReport().inPhrase(xcompLike.before("Comma"))).message("\u041b\u0438\u0448\u043d\u044f\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u0433\u043b\u0430\u0433\u043e\u043b\u0430-\u0434\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f?");
        NodePattern misparsedArg = NodePattern.N.directlyBefore(NodePattern.N.withHead("case", NodePattern.N.withHead("obl", NodePattern.N.before("Comma")).includeIntoReport(ReportingKind.Hover).and(obl -> {
            Node verb = Objects.requireNonNull(obl.head());
            List<Valence> valences = RussianValences.get(verb);
            return !valences.isEmpty() && valences.stream().allMatch(as -> as.recognizesArgument((Node)obl));
        }))).and(CommonPatterns.reportWithPrevWord).message("\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u043a\u043e\u0441\u0432\u0435\u043d\u043d\u044b\u043c \u0434\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435\u043c \u043d\u0435 \u043d\u0443\u0436\u043d\u0430?");
        NodePattern numRelcl = NodePattern.N.directlyBefore(NodePattern.N.inPhrase(misparsedAdverbWh.after("Comma").withHead(NodePattern.N.directlyBefore("Comma").includeIntoReport()))).message("\u041b\u0438\u0448\u043d\u044f\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f?");
        return NodePattern.or(unmandatedComma.includeIntoReport().markAs("Comma").andOr(subjVerb, objPred, xcompVerbNsubj, xcomp, PunctuationRules.leadingOblCommas(), misparsedArg, numRelcl).andNot(NodePattern.N.directlyBefore(NodePattern.N.inPhrase(nonIntroPhrase))).correct(NodeCorrector.replace("")), emphasizedConjComma, nonIntroPhrase.and(removeSurroundingCommas), nonIntroExact);
    }

    private static NodePattern leadingOblCommas() {
        NodePattern common = NodePattern.N.pos("P?NN.*").markAs("Obl").includeIntoReport(ReportingKind.Hover).withHead("obl", NodePattern.N.after("Comma").noDependents("nsubj(:pass)?|i?obj|obl(:agent)?|nmod|compound", NodePattern.N.before("Obl")).noDependents("advmod", NodePattern.N.form("\u0432\u043e\u0442")).noDependents("parataxis|discourse", NodePattern.N.form("\u043e"))).noDependents("cop|mark").andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("mark")));
        NodePattern arg = NodePattern.or(NodePattern.N.withHead(NodePattern.N.withDependent("nsubj.*", NodePattern.N.form("\u044d\u0442\u043e"))), NodePattern.N.noDependents("case").andNot(NodePattern.N.withHead("obl", NodePattern.N.withHeadRelation("conj").noDependents("punct", NodePattern.N.before("Comma")))), NodePattern.custom(obl -> {
            Node verb = Objects.requireNonNull(obl.head());
            List<Valence> valences = RussianValences.get(verb);
            return !valences.isEmpty() && valences.stream().allMatch(s -> s.recognizesArgument((Node)obl));
        }));
        NodePattern adjunct = NodePattern.N.withDependent("case", NodePattern.N.form("\u0432\u043c\u0435\u0441\u0442\u043e"));
        return NodePattern.or(NodePattern.N.includeIntoReport().directlyBefore(NodePattern.N.inPhrase(common.after("Comma").andOr(arg.message("\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u0434\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435\u043c \u043d\u0435 \u043d\u0443\u0436\u043d\u0430?"), adjunct.message("\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u043e\u0431\u0441\u0442\u043e\u044f\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u043e\u043c \u043d\u0435 \u043d\u0443\u0436\u043d\u0430?")))).directlyAfter(NodePattern.N.pos("CONJ|PARTICLE").includeIntoReport().andNot(NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Obl")))), NodePattern.N.directlyAfter(PunctuationRules.possiblyEndQuoted(NodePattern.N.inPhrase(common.before("Comma").andOr(arg.message("\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043d\u0435 \u043d\u0443\u0436\u043d\u0430?"), adjunct.message("\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u043e\u0431\u0441\u0442\u043e\u044f\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043d\u0435 \u043d\u0443\u0436\u043d\u0430?"))))).and(CommonPatterns.reportWithPrevWord).andNot(NodePattern.N.directlyBefore(NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Obl")))).andNot(NodePattern.N.directlyAfter(NodePattern.N.inPhrase(NodePattern.N.withHeadRelation("appos")))));
    }

    static NodePattern possiblyStartQuoted(NodePattern pattern) {
        return NodePattern.or(NodePattern.not(RussianTreePatterns.openingQuotations).and(pattern), RussianTreePatterns.openingQuotations.directlyBefore(pattern));
    }

    static NodePattern possiblyEndQuoted(NodePattern pattern) {
        return NodePattern.or(NodePattern.not(RussianTreePatterns.closingQuotations).and(pattern), RussianTreePatterns.closingQuotations.directlyAfter(pattern));
    }
}

