/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.OptionAccessor;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionOptionsPanel
extends JPanel {
    @Nullable
    private final OptionAccessor myOptionAccessor;
    private final GridBag myConstraints;
    private boolean myHasGrowing;

    @Deprecated
    public InspectionOptionsPanel() {
        this((OptionAccessor)null);
    }

    @Deprecated
    public InspectionOptionsPanel(@NotNull InspectionProfileEntry owner) {
        if (owner == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(0);
        }
        this((OptionAccessor)new OptionAccessor.Default(owner));
    }

    @Deprecated
    public InspectionOptionsPanel(@Nullable OptionAccessor optionAccessor) {
        super(new GridBagLayout());
        this.myConstraints = new GridBag();
        this.myHasGrowing = false;
        this.myConstraints.setDefaultAnchor(18).setDefaultFill(3).setDefaultInsets(0, 0, 8, 0);
        this.myOptionAccessor = optionAccessor;
    }

    public static InspectionOptionsPanel singleCheckBox(@NotNull InspectionProfileEntry owner, @NlsContexts.Checkbox @NotNull String label, @Language(value="jvm-field-name") @NonNls String property) {
        if (owner == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(1);
        }
        if (label == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(2);
        }
        InspectionOptionsPanel panel = new InspectionOptionsPanel(owner);
        panel.addCheckbox(label, property);
        return panel;
    }

    @Override
    public Component add(Component comp) {
        super.add(comp, this.myConstraints.nextLine());
        return comp;
    }

    public void addComponent(JComponent component) {
        this.add((Component)component, this.myConstraints.nextLine().coverLine());
    }

    public void addGrowing(Component component) {
        this.add(component, this.myConstraints.nextLine().weightx(1.0).weighty(1.0).fillCell());
        this.myHasGrowing = true;
    }

    public void addGrowingX(Component component) {
        this.add(component, this.myConstraints.nextLine().weightx(1.0).coverLine().fillCell());
    }

    public void addRow(Component label, Component component) {
        this.add(label, this.myConstraints.nextLine().next());
        this.add(component, this.myConstraints.next().insets(0, 10, 8, 0));
    }

    public void addLabeledRow(@NlsContexts.Label String labelText, Component component) {
        JLabel label = new JLabel(labelText);
        label.setLabelFor(component);
        this.addRow(label, component);
    }

    public void addCheckbox(@NlsContexts.Checkbox @NotNull String label, @Language(value="jvm-field-name") @NotNull @NonNls String property) {
        if (label == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(3);
        }
        if (property == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(4);
        }
        this.addCheckboxEx(label, property);
    }

    public JCheckBox addCheckboxEx(@NlsContexts.Checkbox @NotNull String label, @Language(value="jvm-field-name") @NotNull @NonNls String property) {
        if (label == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(5);
        }
        if (property == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(6);
        }
        if (this.myOptionAccessor == null) {
            throw new IllegalStateException("No option accessor or owner specified in constructor call");
        }
        boolean selected = this.myOptionAccessor.getOption(property);
        JCheckBox checkBox = new JCheckBox(label, selected);
        checkBox.addItemListener(e -> this.myOptionAccessor.setOption(property, e.getStateChange() == 1));
        this.addComponent(checkBox);
        return checkBox;
    }

    public JCheckBox addDependentCheckBox(@NlsContexts.Checkbox @NotNull String label, @Language(value="jvm-field-name") @NotNull @NonNls String property, @NotNull JCheckBox controller) {
        if (label == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(7);
        }
        if (property == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(8);
        }
        if (controller == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(9);
        }
        JCheckBox checkBox = this.addCheckboxEx(label, property);
        checkBox.setBorder(new EmptyBorder((Insets)new JBInsets(0, 20, 0, 0)));
        controller.addItemListener(e -> checkBox.setEnabled(((JCheckBox)e.getSource()).isEnabled() && e.getStateChange() == 1));
        checkBox.setEnabled(controller.isEnabled() && controller.isSelected());
        return checkBox;
    }

    @IntellijInternalApi
    public void addGlueIfNeeded() {
        if (!this.myHasGrowing) {
            this.myHasGrowing = true;
            this.add((Component)new Spacer(), this.myConstraints.nextLine().weightx(1.0).weighty(1.0).fillCell().coverLine().insets(0, 0, 0, 0));
        }
    }

    @NotNull
    public static Dimension getMinimumListSize() {
        JBDimension jBDimension = JBUI.size((int)150, (int)100);
        if (jBDimension == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(10);
        }
        return jBDimension;
    }

    @NotNull
    public static Dimension getMinimumLongListSize() {
        JBDimension jBDimension = JBUI.size((int)150, (int)120);
        if (jBDimension == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(11);
        }
        return jBDimension;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionOptionsPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumListSize";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumLongListSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "singleCheckBox";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCheckbox";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCheckboxEx";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDependentCheckBox";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }
}

