/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.actions.ConsolePropertiesProvider;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.AbstractProperty;
import com.intellij.xdebugger.impl.ui.SplitDebuggerUIUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class AbstractRerunFailedTestsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(AbstractRerunFailedTestsAction.class);
    private TestFrameworkRunningModel myModel;
    private Supplier<? extends TestFrameworkRunningModel> myModelProvider;
    protected TestConsoleProperties myConsoleProperties;

    protected AbstractRerunFailedTestsAction(@NotNull ComponentContainer componentContainer) {
        if (componentContainer == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(0);
        }
        ActionUtil.copyFrom((AnAction)this, (String)"RerunFailedTests");
        this.registerCustomShortcutSet(this.getShortcutSet(), componentContainer.getComponent());
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void init(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void setModel(TestFrameworkRunningModel model2) {
        this.myModel = model2;
    }

    public void setModelProvider(Getter<? extends TestFrameworkRunningModel> modelProvider) {
        this.myModelProvider = modelProvider;
    }

    @Override
    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(this.isActive(e));
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return false;
        }
        TestFrameworkRunningModel model2 = this.getModel();
        if (model2 == null || model2.getRoot() == null) {
            return false;
        }
        RunProfile profile = model2.getProperties().getConfiguration();
        if (profile instanceof RunConfiguration && !((RunConfiguration)profile).getType().isDumbAware() && DumbService.isDumb((Project)project)) {
            return false;
        }
        Filter<?> filter = this.getFailuresFilter();
        for (AbstractTestProxy abstractTestProxy : model2.getRoot().getAllTests()) {
            if (!filter.shouldAccept(abstractTestProxy)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<AbstractTestProxy> getFailedTests(@NotNull Project project) {
        TestFrameworkRunningModel model2;
        if (project == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(4);
        }
        if ((model2 = this.getModel()) == null) {
            List<AbstractTestProxy> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractRerunFailedTestsAction.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List<AbstractTestProxy> list3 = this.getFilter(project, model2.getProperties().getScope()).select(model2.getRoot().getAllTests());
        if (list3 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(6);
        }
        return list3;
    }

    @NotNull
    protected Filter getFilter(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(7);
        }
        if (searchScope == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(8);
        }
        Filter<?> filter = this.getFailuresFilter();
        if (filter == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(9);
        }
        return filter;
    }

    protected Filter<?> getFailuresFilter() {
        return AbstractRerunFailedTestsAction.getFailuresFilter(this.myConsoleProperties);
    }

    @TestOnly
    public static Filter<?> getFailuresFilter(TestConsoleProperties consoleProperties) {
        if (TestConsoleProperties.INCLUDE_NON_STARTED_IN_RERUN_FAILED.value((AbstractProperty.AbstractPropertyContainer)consoleProperties)) {
            return Filter.NOT_PASSED.or(Filter.FAILED_OR_INTERRUPTED).and(Filter.IGNORED.not());
        }
        return Filter.FAILED_OR_INTERRUPTED.and(Filter.IGNORED.not());
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        ExecutionEnvironment environment;
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(10);
        }
        if ((environment = SplitDebuggerUIUtil.getExecutionEnvironment((DataContext)e.getDataContext())) == null) {
            return;
        }
        this.execute(e, environment);
    }

    void execute(@NotNull AnActionEvent e, @NotNull ExecutionEnvironment environment) {
        MyRunProfile profile;
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(11);
        }
        if (environment == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(12);
        }
        if ((profile = this.getRunProfile(environment)) == null) {
            return;
        }
        ExecutionEnvironmentBuilder environmentBuilder = new ExecutionEnvironmentBuilder(environment).runProfile(profile);
        InputEvent event = e.getInputEvent();
        if (!(event instanceof MouseEvent) || !event.isShiftDown()) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder);
            return;
        }
        LinkedHashMap<Executor, ProgramRunner<RunnerSettings>> availableRunners = new LinkedHashMap<Executor, ProgramRunner<RunnerSettings>>();
        for (Executor ex : new Executor[]{DefaultRunExecutor.getRunExecutorInstance(), DefaultDebugExecutor.getDebugExecutorInstance()}) {
            ProgramRunner<RunnerSettings> runner = ProgramRunner.getRunner(ex.getId(), profile.getPeer());
            if (runner == null) continue;
            availableRunners.put(ex, runner);
        }
        if (availableRunners.isEmpty()) {
            LOG.error(environment.getExecutor().getActionName() + " is not available now");
        } else if (availableRunners.size() == 1) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(environment.getExecutor())));
        } else {
            ArrayList model2 = new ArrayList(availableRunners.keySet());
            JBPopupFactory.getInstance().createPopupChooserBuilder(model2).setSelectionMode(0).setSelectedValue((Object)environment.getExecutor(), true).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Component component = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                    if (value instanceof Executor) {
                        this.setText(((Executor)value).getActionName());
                        this.setIcon(((Executor)value).getIcon());
                    }
                    Component component2 = component;
                    if (component2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return component2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            }).setTitle(TestRunnerBundle.message("popup.title.restart.failed.tests", new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(value -> AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(value)).executor((Executor)value))).createPopup().showUnderneathOf(event.getComponent());
        }
    }

    private static void performAction(@NotNull ExecutionEnvironmentBuilder builder) {
        if (builder == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(13);
        }
        ExecutionEnvironment environment = builder.build();
        try {
            environment.getRunner().execute(environment);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        finally {
            ((MyRunProfile)environment.getRunProfile()).clear();
        }
    }

    @Nullable
    protected MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(14);
        }
        return null;
    }

    @TestOnly
    @ApiStatus.Internal
    @Nullable
    public RunConfiguration getRunProfileTestAccessor(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(15);
        }
        return this.getRunProfile(environment);
    }

    @Nullable
    public TestFrameworkRunningModel getModel() {
        if (this.myModel != null) {
            return this.myModel;
        }
        if (this.myModelProvider != null) {
            return this.myModelProvider.get();
        }
        return null;
    }

    @Override
    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentContainer";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailedTests";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFailedTests";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFilter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRunProfile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRunProfileTestAccessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 9 -> new IllegalStateException(string);
        };
    }

    protected static abstract class MyRunProfile
    extends RunConfigurationBase<Element>
    implements ModuleRunProfile,
    WrappingRunConfiguration<RunConfigurationBase<?>>,
    ConsolePropertiesProvider {
        private final RunConfigurationBase<?> myConfiguration;

        @Override
        @NotNull
        public RunConfigurationBase<?> getPeer() {
            RunConfigurationBase<?> runConfigurationBase = this.myConfiguration;
            if (runConfigurationBase == null) {
                MyRunProfile.$$$reportNull$$$0(0);
            }
            return runConfigurationBase;
        }

        public MyRunProfile(@NotNull RunConfigurationBase<?> configuration) {
            if (configuration == null) {
                MyRunProfile.$$$reportNull$$$0(1);
            }
            super(configuration.getProject(), configuration.getFactory(), ActionsBundle.message((String)"action.RerunFailedTests.text", (Object[])new Object[0]));
            this.myConfiguration = configuration;
        }

        public void clear() {
        }

        @Override
        @Nullable
        public TestConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
            if (executor == null) {
                MyRunProfile.$$$reportNull$$$0(2);
            }
            return this.myConfiguration instanceof ConsolePropertiesProvider ? ((ConsolePropertiesProvider)((Object)this.myConfiguration)).createTestConsoleProperties(executor) : null;
        }

        @Override
        public void readExternal(@NotNull Element element) throws InvalidDataException {
            if (element == null) {
                MyRunProfile.$$$reportNull$$$0(3);
            }
            this.myConfiguration.readExternal(element);
        }

        @Override
        public void writeExternal(@NotNull Element element) throws WriteExternalException {
            if (element == null) {
                MyRunProfile.$$$reportNull$$$0(4);
            }
            this.myConfiguration.writeExternal(element);
        }

        @Override
        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            SettingsEditor settingsEditor = this.myConfiguration.getConfigurationEditor();
            if (settingsEditor == null) {
                MyRunProfile.$$$reportNull$$$0(5);
            }
            return settingsEditor;
        }

        @Override
        public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
            return this.myConfiguration.createRunnerSettings(provider);
        }

        @Override
        public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
            return this.myConfiguration.getRunnerSettingsEditor(runner);
        }

        @Override
        public RunConfiguration clone() {
            return this.myConfiguration.clone();
        }

        @Override
        public int getUniqueID() {
            return this.myConfiguration.getUniqueID();
        }

        @Override
        public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
            return this.myConfiguration.getOptionsForPredefinedLogFile(predefinedLogFile);
        }

        @Override
        @NotNull
        public List<PredefinedLogFile> getPredefinedLogFiles() {
            List<PredefinedLogFile> list2 = this.myConfiguration.getPredefinedLogFiles();
            if (list2 == null) {
                MyRunProfile.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @Override
        @NotNull
        public ArrayList<LogFileOptions> getAllLogFiles() {
            ArrayList<LogFileOptions> arrayList = this.myConfiguration.getAllLogFiles();
            if (arrayList == null) {
                MyRunProfile.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        @Override
        @NotNull
        public List<LogFileOptions> getLogFiles() {
            List<LogFileOptions> list2 = this.myConfiguration.getLogFiles();
            if (list2 == null) {
                MyRunProfile.$$$reportNull$$$0(8);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPeer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPredefinedLogFiles";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllLogFiles";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createTestConsoleProperties";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "readExternal";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "writeExternal";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

