/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/bookmark/actions/NextBookmarkInEditor;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "forward", "", "<init>", "(Z)V", "getForward", "()Z", "isEnabledForCaret", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "doExecute", "", "getNextBookmark", "Lcom/intellij/ide/bookmark/LineBookmark;", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nNextBookmarkInEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextBookmarkInEditor.kt\ncom/intellij/ide/bookmark/actions/NextBookmarkInEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1#2:62\n1#2:65\n1651#3:63\n1915#3:64\n1916#3:66\n1652#3:67\n1021#3,2:68\n1033#3,2:70\n*S KotlinDebug\n*F\n+ 1 NextBookmarkInEditor.kt\ncom/intellij/ide/bookmark/actions/NextBookmarkInEditor\n*L\n36#1:65\n36#1:63\n36#1:64\n36#1:66\n36#1:67\n41#1:68,2\n48#1:70,2\n*E\n"})
final class NextBookmarkInEditor
extends EditorActionHandler {
    private final boolean forward;

    public NextBookmarkInEditor(boolean forward) {
        this.forward = forward;
    }

    public final boolean getForward() {
        return this.forward;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getNextBookmark(editor, context) != null;
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LineBookmark lineBookmark = this.getNextBookmark(editor, context);
        if (lineBookmark == null) {
            return;
        }
        LineBookmark bookmark = lineBookmark;
        int it = bookmark.getLine();
        boolean bl = false;
        if (0 > it || it >= editor.getDocument().getLineCount()) {
            return;
        }
        LogicalPosition pos = new LogicalPosition(it, 0);
        editor.getSelectionModel().removeSelection();
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(pos);
        editor.getScrollingModel().scrollTo(pos, ScrollType.CENTER);
    }

    /*
     * WARNING - void declaration
     */
    private final LineBookmark getNextBookmark(Editor editor, DataContext context) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        if (editor.isOneLineMode()) {
            return null;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        Project project = editor.getProject();
        if (project == null) {
            project = (Project)CommonDataKeys.PROJECT.getData(context);
        }
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)project);
        if (bookmarksManager == null) {
            return null;
        }
        BookmarksManager manager = bookmarksManager;
        List list2 = manager.getBookmarks();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBookmarks(...)");
        Iterable iterable = list2;
        Collection collection = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            LineBookmark it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Bookmark it = (Bookmark)element$iv;
            boolean bl2 = false;
            if ((it instanceof LineBookmark && Intrinsics.areEqual((Object)((LineBookmark)it).getFile(), (Object)file) ? (LineBookmark)it : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        List bookmarks = (List)destination$iv;
        if (!((Collection)bookmarks).isEmpty()) {
            LineBookmark bookmark;
            int line = editor.getCaretModel().getLogicalPosition().line;
            if (this.forward) {
                List $this$sortBy$iv = bookmarks;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            LineBookmark it = (LineBookmark)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(it.getLine());
                            it = (LineBookmark)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getLine()));
                        }
                    });
                }
                for (LineBookmark bookmark2 : bookmarks) {
                    if (bookmark2.getLine() <= line) continue;
                    return bookmark2;
                }
            } else {
                List $this$sortByDescending$iv = bookmarks;
                boolean $i$f$sortByDescending = false;
                if ($this$sortByDescending$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            LineBookmark it = (LineBookmark)b;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(it.getLine());
                            it = (LineBookmark)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getLine()));
                        }
                    });
                }
                for (LineBookmark bookmark3 : bookmarks) {
                    if (bookmark3.getLine() >= line) continue;
                    return bookmark3;
                }
            }
            if (BookmarkOccurrence.Companion.getCyclic() && (bookmark = (LineBookmark)bookmarks.get(0)).getLine() != line) {
                return bookmark;
            }
        }
        return null;
    }
}

