/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.SystemProperties;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class AppFontOptions<F extends AppEditorFontOptions.PersistentFontPreferences>
implements PersistentStateComponentWithModificationTracker<F> {
    private static final Logger LOG = Logger.getInstance(AppFontOptions.class);
    @ApiStatus.Internal
    public static final boolean APP_CONSOLE_FONT_ENABLED = SystemProperties.getBooleanProperty((String)"app.console.font.enabled", (boolean)false);
    private final FontPreferencesImpl myFontPreferences = new FontPreferencesImpl();
    protected final SimpleModificationTracker myTracker = new SimpleModificationTracker();
    protected static final int CURR_FONT_PREF_VERSION = 1;
    private int myFontPrefVersion;

    public AppFontOptions() {
        Application app = ApplicationManager.getApplication();
        if (!app.isHeadlessEnvironment() || app.isUnitTestMode()) {
            this.myFontPreferences.register(FontPreferences.DEFAULT_FONT_NAME, UISettings.restoreFontSize(FontPreferences.DEFAULT_FONT_SIZE, Float.valueOf(1.0f)));
            if (FontFamilyService.isServiceSupported()) {
                String regular = FontFamilyService.getRecommendedSubFamily(FontPreferences.DEFAULT_FONT_NAME);
                this.myFontPreferences.setRegularSubFamily(regular);
                this.myFontPreferences.setBoldSubFamily(FontFamilyService.getRecommendedBoldSubFamily(FontPreferences.DEFAULT_FONT_NAME, regular));
            }
        }
    }

    public long getStateModificationCount() {
        if (this.myFontPrefVersion < 1) {
            this.myTracker.incModificationCount();
        }
        return this.myTracker.getModificationCount();
    }

    @NotNull
    public F getState() {
        F preferences = this.createFontState(this.myFontPreferences);
        ((AppEditorFontOptions.PersistentFontPreferences)preferences).VERSION = 1;
        F f = preferences;
        if (f == null) {
            AppFontOptions.$$$reportNull$$$0(0);
        }
        return f;
    }

    public void loadState(@NotNull F state) {
        if (state == null) {
            AppFontOptions.$$$reportNull$$$0(1);
        }
        AppFontOptions.copyState(state, this.myFontPreferences);
        this.myFontPrefVersion = ((AppEditorFontOptions.PersistentFontPreferences)state).VERSION;
        this.myFontPreferences.addChangeListener(source -> EditorFontCache.getInstance().reset());
    }

    protected abstract F createFontState(@NotNull FontPreferences var1);

    private static void copyState(AppEditorFontOptions.PersistentFontPreferences state, @NotNull ModifiableFontPreferences fontPreferences) {
        if (fontPreferences == null) {
            AppFontOptions.$$$reportNull$$$0(2);
        }
        fontPreferences.clear();
        float stateFontSize = state.FONT_SIZE_2D != (float)FontPreferences.DEFAULT_FONT_SIZE ? state.FONT_SIZE_2D : (float)state.FONT_SIZE;
        float fontSize = UISettings.restoreFontSize(stateFontSize, Float.valueOf(state.FONT_SCALE));
        String[] names = AppFontOptions.migrateFamilyNameIfNeeded(state.FONT_FAMILY, state.FONT_REGULAR_SUB_FAMILY, state.FONT_BOLD_SUB_FAMILY);
        fontPreferences.register(names[0], fontSize);
        fontPreferences.setRegularSubFamily(names[1]);
        fontPreferences.setBoldSubFamily(names[2]);
        fontPreferences.setLineSpacing(state.LINE_SPACING);
        fontPreferences.setUseLigatures(state.USE_LIGATURES);
        fontPreferences.setCharacterVariants(state.CHARACTER_VARIANTS);
        if (state.SECONDARY_FONT_FAMILY != null) {
            fontPreferences.register(state.SECONDARY_FONT_FAMILY, fontSize);
        }
    }

    private static String[] migrateFamilyNameIfNeeded(String family, String regularSubFamily, String boldSubFamily) {
        if (regularSubFamily == null && boldSubFamily == null && FontFamilyService.isServiceSupported()) {
            Object[] result2 = FontFamilyService.migrateFontSetting(family);
            LOG.info("Font setting migration: " + family + " -> " + Arrays.toString(result2));
            return result2;
        }
        return new String[]{family, regularSubFamily, boldSubFamily};
    }

    public static void initDefaults(@NotNull ModifiableFontPreferences fontPreferences) {
        if (fontPreferences == null) {
            AppFontOptions.$$$reportNull$$$0(3);
        }
        AppFontOptions.copyState(AppEditorFontOptions.PersistentFontPreferences.getDefaultState(), fontPreferences);
    }

    public void update(@NotNull FontPreferences newPreferences) {
        if (newPreferences == null) {
            AppFontOptions.$$$reportNull$$$0(4);
        }
        newPreferences.copyTo(this.myFontPreferences);
        this.myTracker.incModificationCount();
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferencesImpl fontPreferencesImpl = this.myFontPreferences;
        if (fontPreferencesImpl == null) {
            AppFontOptions.$$$reportNull$$$0(5);
        }
        return fontPreferencesImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/AppFontOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontPreferences";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/AppFontOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initDefaults";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

